// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directconnect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteBGPPeerInput struct {
	_ struct{} `type:"structure"`

	// The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	Asn *int64 `locationName:"asn" type:"integer"`

	// The ID of the BGP peer.
	BgpPeerId *string `locationName:"bgpPeerId" type:"string"`

	// The IP address assigned to the customer interface.
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// The ID of the virtual interface.
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string"`
}

// String returns the string representation
func (s DeleteBGPPeerInput) String() string {
	return awsutil.Prettify(s)
}

type DeleteBGPPeerOutput struct {
	_ struct{} `type:"structure"`

	// The virtual interface.
	VirtualInterface *VirtualInterface `locationName:"virtualInterface" type:"structure"`
}

// String returns the string representation
func (s DeleteBGPPeerOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteBGPPeer = "DeleteBGPPeer"

// DeleteBGPPeerRequest returns a request value for making API operation for
// AWS Direct Connect.
//
// Deletes the specified BGP peer on the specified virtual interface with the
// specified customer address and ASN.
//
// You cannot delete the last BGP peer from a virtual interface.
//
//    // Example sending a request using DeleteBGPPeerRequest.
//    req := client.DeleteBGPPeerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteBGPPeer
func (c *Client) DeleteBGPPeerRequest(input *DeleteBGPPeerInput) DeleteBGPPeerRequest {
	op := &aws.Operation{
		Name:       opDeleteBGPPeer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteBGPPeerInput{}
	}

	req := c.newRequest(op, input, &DeleteBGPPeerOutput{})
	return DeleteBGPPeerRequest{Request: req, Input: input, Copy: c.DeleteBGPPeerRequest}
}

// DeleteBGPPeerRequest is the request type for the
// DeleteBGPPeer API operation.
type DeleteBGPPeerRequest struct {
	*aws.Request
	Input *DeleteBGPPeerInput
	Copy  func(*DeleteBGPPeerInput) DeleteBGPPeerRequest
}

// Send marshals and sends the DeleteBGPPeer API request.
func (r DeleteBGPPeerRequest) Send(ctx context.Context) (*DeleteBGPPeerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteBGPPeerResponse{
		DeleteBGPPeerOutput: r.Request.Data.(*DeleteBGPPeerOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteBGPPeerResponse is the response type for the
// DeleteBGPPeer API operation.
type DeleteBGPPeerResponse struct {
	*DeleteBGPPeerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteBGPPeer request.
func (r *DeleteBGPPeerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
