// DO NOT EDIT: This file is autogenerated via the builtin command.

package pagerduty

import (
	flux "github.com/influxdata/flux"
	ast "github.com/influxdata/flux/ast"
)

func init() {
	flux.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Errors: nil,
		Loc:    nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 15,
					Line:   109,
				},
				File:   "pagerduty.flux",
				Source: "package pagerduty\n\nimport \"http\"\nimport \"json\"\nimport \"strings\"\n\n// `dedupKey` - adds a newline concatinated value of the sorted group key that is then sha256-hashed and hex-encoded to a column with the key `_pagerdutyDedupKey`.\nbuiltin dedupKey\n\noption defaultURL = \"https://events.pagerduty.com/v2/enqueue\"\n\n\n// severity levels on status objects can be one of the following: ok,info,warn,crit,unknown\n// but pagerduty only accepts critical, error, warning or info.\n// severityFromLevel turns a level from the status object into a pagerduty severity\nseverityFromLevel = (level) => {\n    lvl = strings.toLower(v:level)\n    sev = if lvl == \"warn\" then \"warning\" \n        else if lvl == \"crit\" then \"critical\" \n        else if lvl == \"info\" then \"info\" \n        else if lvl == \"ok\" then \"info\" \n        else \"error\"\n    return sev\n}\n\n// `actionFromLevel` converts a monitoring level to an action; \"ok\" becomes \"resolve\" everything else converts to \"trigger\".\nactionFromLevel = (level)=> if strings.toLower(v:level) == \"ok\" then \"resolve\" else \"trigger\"\n\n// `sendEvent` sends an event to PagerDuty, the description of some of these parameters taken from the pagerduty documentation at https://v2.developer.pagerduty.com/docs/send-an-event-events-api-v2\n// `pagerdutyURL` - sring - URL of the pagerduty endpoint.  Defaults to: `option defaultURL = \"https://events.pagerduty.com/v2/enqueue\"`\n// `routingKey` - string - routingKey.\n// `client` - string - name of the client sending the alert.\n// `clientURL` - string - url of the client sending the alert.\n// `dedupkey` - string - a per alert ID. It acts as deduplication key, that allows you to ack or change the severity of previous messages. Supports a maximum of 255 characters.\n// `class` - string - The class/type of the event, for example ping failure or cpu load.\n// `group` - string - Logical grouping of components of a service, for example app-stack.\n// `severity` - string - The perceived severity of the status the event is describing with respect to the affected system. This can be critical, error, warning or info.\n// `eventAction` - string - The type of event to send to PagerDuty (ex. trigger, resolve, acknowledge)\n// `component` - string - Component of the source machine that is responsible for the event, for example mysql or eth0.\n// `source` - string - The unique location of the affected system, preferably a hostname or FQDN.\n// `summary` - string - A brief text summary of the event, used to generate the summaries/titles of any associated alerts. The maximum permitted length of this property is 1024 characters.\n// `timestamp` - string - The time at which the emitting tool detected or generated the event, in RFC 3339 nano format.\nsendEvent = (pagerdutyURL=defaultURL,\n    routingKey,\n    client,\n    clientURL,\n    dedupKey,\n    class,\n    group,\n    severity,\n    eventAction,\n    component,\n    source,\n    summary,\n    timestamp) => {\n\n    payload = {\n            summary: summary,\n            timestamp: timestamp,\n            source: source,\n            severity: severity,\n            component: component,\n            group: group,\n            class: class,\n    }\n    data = {\n        payload: payload,\n        routing_key: routingKey,\n        dedup_key: dedupKey,\n        event_action: eventAction,\n        client: client,\n        client_url: clientURL,\n    }\n\n    headers = {\n        \"Accept\": \"application/vnd.pagerduty+json;version=2\",\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v: data)\n    return http.post(headers: headers, url: pagerdutyURL, data: enc)\n}\n\n// `endpoint` creates the endpoint for the PagerDuty external service.\n// `url` - string - URL of the Pagerduty endpoint. Defaults to: \"https://events.pagerduty.com/v2/enqueue\".\n// The returned factory function accepts a `mapFn` parameter.\n// The `mapFn` parameter must be a function that returns an object with `routingKey`, `client`, `client_url`, `class`, `group`, `severity`, `eventAction`, `component`, `source`, `summary`, and `timestamp` as defined in the sendEvent function.\n// Note that while sendEvent accepts a dedup key, endpoint gets the dedupkey from the groupkey of the input table instead of it being handled by the `mapFn`.\nendpoint = (url=defaultURL) =>\n    (mapFn) =>\n        (tables=<-) => tables\n            |> dedupKey()\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                \n                return {r with _sent: string(v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    component: obj.component,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100))}\n            })",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   8,
					},
					File:   "pagerduty.flux",
					Source: "builtin dedupKey",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   8,
						},
						File:   "pagerduty.flux",
						Source: "dedupKey",
						Start: ast.Position{
							Column: 9,
							Line:   8,
						},
					},
				},
				Name: "dedupKey",
			},
		}, &ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 62,
							Line:   10,
						},
						File:   "pagerduty.flux",
						Source: "defaultURL = \"https://events.pagerduty.com/v2/enqueue\"",
						Start: ast.Position{
							Column: 8,
							Line:   10,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   10,
							},
							File:   "pagerduty.flux",
							Source: "defaultURL",
							Start: ast.Position{
								Column: 8,
								Line:   10,
							},
						},
					},
					Name: "defaultURL",
				},
				Init: &ast.StringLiteral{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 62,
								Line:   10,
							},
							File:   "pagerduty.flux",
							Source: "\"https://events.pagerduty.com/v2/enqueue\"",
							Start: ast.Position{
								Column: 21,
								Line:   10,
							},
						},
					},
					Value: "https://events.pagerduty.com/v2/enqueue",
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 62,
						Line:   10,
					},
					File:   "pagerduty.flux",
					Source: "option defaultURL = \"https://events.pagerduty.com/v2/enqueue\"",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   24,
					},
					File:   "pagerduty.flux",
					Source: "severityFromLevel = (level) => {\n    lvl = strings.toLower(v:level)\n    sev = if lvl == \"warn\" then \"warning\" \n        else if lvl == \"crit\" then \"critical\" \n        else if lvl == \"info\" then \"info\" \n        else if lvl == \"ok\" then \"info\" \n        else \"error\"\n    return sev\n}",
					Start: ast.Position{
						Column: 1,
						Line:   16,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   16,
						},
						File:   "pagerduty.flux",
						Source: "severityFromLevel",
						Start: ast.Position{
							Column: 1,
							Line:   16,
						},
					},
				},
				Name: "severityFromLevel",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   24,
						},
						File:   "pagerduty.flux",
						Source: "(level) => {\n    lvl = strings.toLower(v:level)\n    sev = if lvl == \"warn\" then \"warning\" \n        else if lvl == \"crit\" then \"critical\" \n        else if lvl == \"info\" then \"info\" \n        else if lvl == \"ok\" then \"info\" \n        else \"error\"\n    return sev\n}",
						Start: ast.Position{
							Column: 21,
							Line:   16,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   24,
							},
							File:   "pagerduty.flux",
							Source: "{\n    lvl = strings.toLower(v:level)\n    sev = if lvl == \"warn\" then \"warning\" \n        else if lvl == \"crit\" then \"critical\" \n        else if lvl == \"info\" then \"info\" \n        else if lvl == \"ok\" then \"info\" \n        else \"error\"\n    return sev\n}",
							Start: ast.Position{
								Column: 32,
								Line:   16,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   17,
								},
								File:   "pagerduty.flux",
								Source: "lvl = strings.toLower(v:level)",
								Start: ast.Position{
									Column: 5,
									Line:   17,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   17,
									},
									File:   "pagerduty.flux",
									Source: "lvl",
									Start: ast.Position{
										Column: 5,
										Line:   17,
									},
								},
							},
							Name: "lvl",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   17,
										},
										File:   "pagerduty.flux",
										Source: "v:level",
										Start: ast.Position{
											Column: 27,
											Line:   17,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   17,
											},
											File:   "pagerduty.flux",
											Source: "v:level",
											Start: ast.Position{
												Column: 27,
												Line:   17,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   17,
												},
												File:   "pagerduty.flux",
												Source: "v",
												Start: ast.Position{
													Column: 27,
													Line:   17,
												},
											},
										},
										Name: "v",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 34,
													Line:   17,
												},
												File:   "pagerduty.flux",
												Source: "level",
												Start: ast.Position{
													Column: 29,
													Line:   17,
												},
											},
										},
										Name: "level",
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   17,
									},
									File:   "pagerduty.flux",
									Source: "strings.toLower(v:level)",
									Start: ast.Position{
										Column: 11,
										Line:   17,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   17,
										},
										File:   "pagerduty.flux",
										Source: "strings.toLower",
										Start: ast.Position{
											Column: 11,
											Line:   17,
										},
									},
								},
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   17,
											},
											File:   "pagerduty.flux",
											Source: "strings",
											Start: ast.Position{
												Column: 11,
												Line:   17,
											},
										},
									},
									Name: "strings",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   17,
											},
											File:   "pagerduty.flux",
											Source: "toLower",
											Start: ast.Position{
												Column: 19,
												Line:   17,
											},
										},
									},
									Name: "toLower",
								},
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   22,
								},
								File:   "pagerduty.flux",
								Source: "sev = if lvl == \"warn\" then \"warning\" \n        else if lvl == \"crit\" then \"critical\" \n        else if lvl == \"info\" then \"info\" \n        else if lvl == \"ok\" then \"info\" \n        else \"error\"",
								Start: ast.Position{
									Column: 5,
									Line:   18,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   18,
									},
									File:   "pagerduty.flux",
									Source: "sev",
									Start: ast.Position{
										Column: 5,
										Line:   18,
									},
								},
							},
							Name: "sev",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.ConditionalExpression{
								Alternate: &ast.ConditionalExpression{
									Alternate: &ast.ConditionalExpression{
										Alternate: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   22,
													},
													File:   "pagerduty.flux",
													Source: "\"error\"",
													Start: ast.Position{
														Column: 14,
														Line:   22,
													},
												},
											},
											Value: "error",
										},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   22,
												},
												File:   "pagerduty.flux",
												Source: "if lvl == \"ok\" then \"info\" \n        else \"error\"",
												Start: ast.Position{
													Column: 14,
													Line:   21,
												},
											},
										},
										Consequent: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   21,
													},
													File:   "pagerduty.flux",
													Source: "\"info\"",
													Start: ast.Position{
														Column: 34,
														Line:   21,
													},
												},
											},
											Value: "info",
										},
										Test: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   21,
													},
													File:   "pagerduty.flux",
													Source: "lvl == \"ok\"",
													Start: ast.Position{
														Column: 17,
														Line:   21,
													},
												},
											},
											Left: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 20,
															Line:   21,
														},
														File:   "pagerduty.flux",
														Source: "lvl",
														Start: ast.Position{
															Column: 17,
															Line:   21,
														},
													},
												},
												Name: "lvl",
											},
											Operator: 17,
											Right: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   21,
														},
														File:   "pagerduty.flux",
														Source: "\"ok\"",
														Start: ast.Position{
															Column: 24,
															Line:   21,
														},
													},
												},
												Value: "ok",
											},
										},
									},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   22,
											},
											File:   "pagerduty.flux",
											Source: "if lvl == \"info\" then \"info\" \n        else if lvl == \"ok\" then \"info\" \n        else \"error\"",
											Start: ast.Position{
												Column: 14,
												Line:   20,
											},
										},
									},
									Consequent: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   20,
												},
												File:   "pagerduty.flux",
												Source: "\"info\"",
												Start: ast.Position{
													Column: 36,
													Line:   20,
												},
											},
										},
										Value: "info",
									},
									Test: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   20,
												},
												File:   "pagerduty.flux",
												Source: "lvl == \"info\"",
												Start: ast.Position{
													Column: 17,
													Line:   20,
												},
											},
										},
										Left: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   20,
													},
													File:   "pagerduty.flux",
													Source: "lvl",
													Start: ast.Position{
														Column: 17,
														Line:   20,
													},
												},
											},
											Name: "lvl",
										},
										Operator: 17,
										Right: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   20,
													},
													File:   "pagerduty.flux",
													Source: "\"info\"",
													Start: ast.Position{
														Column: 24,
														Line:   20,
													},
												},
											},
											Value: "info",
										},
									},
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   22,
										},
										File:   "pagerduty.flux",
										Source: "if lvl == \"crit\" then \"critical\" \n        else if lvl == \"info\" then \"info\" \n        else if lvl == \"ok\" then \"info\" \n        else \"error\"",
										Start: ast.Position{
											Column: 14,
											Line:   19,
										},
									},
								},
								Consequent: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   19,
											},
											File:   "pagerduty.flux",
											Source: "\"critical\"",
											Start: ast.Position{
												Column: 36,
												Line:   19,
											},
										},
									},
									Value: "critical",
								},
								Test: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   19,
											},
											File:   "pagerduty.flux",
											Source: "lvl == \"crit\"",
											Start: ast.Position{
												Column: 17,
												Line:   19,
											},
										},
									},
									Left: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   19,
												},
												File:   "pagerduty.flux",
												Source: "lvl",
												Start: ast.Position{
													Column: 17,
													Line:   19,
												},
											},
										},
										Name: "lvl",
									},
									Operator: 17,
									Right: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   19,
												},
												File:   "pagerduty.flux",
												Source: "\"crit\"",
												Start: ast.Position{
													Column: 24,
													Line:   19,
												},
											},
										},
										Value: "crit",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   22,
									},
									File:   "pagerduty.flux",
									Source: "if lvl == \"warn\" then \"warning\" \n        else if lvl == \"crit\" then \"critical\" \n        else if lvl == \"info\" then \"info\" \n        else if lvl == \"ok\" then \"info\" \n        else \"error\"",
									Start: ast.Position{
										Column: 11,
										Line:   18,
									},
								},
							},
							Consequent: &ast.StringLiteral{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   18,
										},
										File:   "pagerduty.flux",
										Source: "\"warning\"",
										Start: ast.Position{
											Column: 33,
											Line:   18,
										},
									},
								},
								Value: "warning",
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   18,
										},
										File:   "pagerduty.flux",
										Source: "lvl == \"warn\"",
										Start: ast.Position{
											Column: 14,
											Line:   18,
										},
									},
								},
								Left: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   18,
											},
											File:   "pagerduty.flux",
											Source: "lvl",
											Start: ast.Position{
												Column: 14,
												Line:   18,
											},
										},
									},
									Name: "lvl",
								},
								Operator: 17,
								Right: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   18,
											},
											File:   "pagerduty.flux",
											Source: "\"warn\"",
											Start: ast.Position{
												Column: 21,
												Line:   18,
											},
										},
									},
									Value: "warn",
								},
							},
						},
					}, &ast.ReturnStatement{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   23,
									},
									File:   "pagerduty.flux",
									Source: "sev",
									Start: ast.Position{
										Column: 12,
										Line:   23,
									},
								},
							},
							Name: "sev",
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   23,
								},
								File:   "pagerduty.flux",
								Source: "return sev",
								Start: ast.Position{
									Column: 5,
									Line:   23,
								},
							},
						},
					}},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   16,
							},
							File:   "pagerduty.flux",
							Source: "level",
							Start: ast.Position{
								Column: 22,
								Line:   16,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   16,
								},
								File:   "pagerduty.flux",
								Source: "level",
								Start: ast.Position{
									Column: 22,
									Line:   16,
								},
							},
						},
						Name: "level",
					},
					Value: nil,
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 94,
						Line:   27,
					},
					File:   "pagerduty.flux",
					Source: "actionFromLevel = (level)=> if strings.toLower(v:level) == \"ok\" then \"resolve\" else \"trigger\"",
					Start: ast.Position{
						Column: 1,
						Line:   27,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   27,
						},
						File:   "pagerduty.flux",
						Source: "actionFromLevel",
						Start: ast.Position{
							Column: 1,
							Line:   27,
						},
					},
				},
				Name: "actionFromLevel",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 94,
							Line:   27,
						},
						File:   "pagerduty.flux",
						Source: "(level)=> if strings.toLower(v:level) == \"ok\" then \"resolve\" else \"trigger\"",
						Start: ast.Position{
							Column: 19,
							Line:   27,
						},
					},
				},
				Body: &ast.ConditionalExpression{
					Alternate: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 94,
									Line:   27,
								},
								File:   "pagerduty.flux",
								Source: "\"trigger\"",
								Start: ast.Position{
									Column: 85,
									Line:   27,
								},
							},
						},
						Value: "trigger",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 94,
								Line:   27,
							},
							File:   "pagerduty.flux",
							Source: "if strings.toLower(v:level) == \"ok\" then \"resolve\" else \"trigger\"",
							Start: ast.Position{
								Column: 29,
								Line:   27,
							},
						},
					},
					Consequent: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 79,
									Line:   27,
								},
								File:   "pagerduty.flux",
								Source: "\"resolve\"",
								Start: ast.Position{
									Column: 70,
									Line:   27,
								},
							},
						},
						Value: "resolve",
					},
					Test: &ast.BinaryExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   27,
								},
								File:   "pagerduty.flux",
								Source: "strings.toLower(v:level) == \"ok\"",
								Start: ast.Position{
									Column: 32,
									Line:   27,
								},
							},
						},
						Left: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   27,
										},
										File:   "pagerduty.flux",
										Source: "v:level",
										Start: ast.Position{
											Column: 48,
											Line:   27,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 55,
												Line:   27,
											},
											File:   "pagerduty.flux",
											Source: "v:level",
											Start: ast.Position{
												Column: 48,
												Line:   27,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   27,
												},
												File:   "pagerduty.flux",
												Source: "v",
												Start: ast.Position{
													Column: 48,
													Line:   27,
												},
											},
										},
										Name: "v",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 55,
													Line:   27,
												},
												File:   "pagerduty.flux",
												Source: "level",
												Start: ast.Position{
													Column: 50,
													Line:   27,
												},
											},
										},
										Name: "level",
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   27,
									},
									File:   "pagerduty.flux",
									Source: "strings.toLower(v:level)",
									Start: ast.Position{
										Column: 32,
										Line:   27,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   27,
										},
										File:   "pagerduty.flux",
										Source: "strings.toLower",
										Start: ast.Position{
											Column: 32,
											Line:   27,
										},
									},
								},
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   27,
											},
											File:   "pagerduty.flux",
											Source: "strings",
											Start: ast.Position{
												Column: 32,
												Line:   27,
											},
										},
									},
									Name: "strings",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   27,
											},
											File:   "pagerduty.flux",
											Source: "toLower",
											Start: ast.Position{
												Column: 40,
												Line:   27,
											},
										},
									},
									Name: "toLower",
								},
							},
						},
						Operator: 17,
						Right: &ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   27,
									},
									File:   "pagerduty.flux",
									Source: "\"ok\"",
									Start: ast.Position{
										Column: 60,
										Line:   27,
									},
								},
							},
							Value: "ok",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   27,
							},
							File:   "pagerduty.flux",
							Source: "level",
							Start: ast.Position{
								Column: 20,
								Line:   27,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   27,
								},
								File:   "pagerduty.flux",
								Source: "level",
								Start: ast.Position{
									Column: 20,
									Line:   27,
								},
							},
						},
						Name: "level",
					},
					Value: nil,
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   81,
					},
					File:   "pagerduty.flux",
					Source: "sendEvent = (pagerdutyURL=defaultURL,\n    routingKey,\n    client,\n    clientURL,\n    dedupKey,\n    class,\n    group,\n    severity,\n    eventAction,\n    component,\n    source,\n    summary,\n    timestamp) => {\n\n    payload = {\n            summary: summary,\n            timestamp: timestamp,\n            source: source,\n            severity: severity,\n            component: component,\n            group: group,\n            class: class,\n    }\n    data = {\n        payload: payload,\n        routing_key: routingKey,\n        dedup_key: dedupKey,\n        event_action: eventAction,\n        client: client,\n        client_url: clientURL,\n    }\n\n    headers = {\n        \"Accept\": \"application/vnd.pagerduty+json;version=2\",\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v: data)\n    return http.post(headers: headers, url: pagerdutyURL, data: enc)\n}",
					Start: ast.Position{
						Column: 1,
						Line:   43,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   43,
						},
						File:   "pagerduty.flux",
						Source: "sendEvent",
						Start: ast.Position{
							Column: 1,
							Line:   43,
						},
					},
				},
				Name: "sendEvent",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   81,
						},
						File:   "pagerduty.flux",
						Source: "(pagerdutyURL=defaultURL,\n    routingKey,\n    client,\n    clientURL,\n    dedupKey,\n    class,\n    group,\n    severity,\n    eventAction,\n    component,\n    source,\n    summary,\n    timestamp) => {\n\n    payload = {\n            summary: summary,\n            timestamp: timestamp,\n            source: source,\n            severity: severity,\n            component: component,\n            group: group,\n            class: class,\n    }\n    data = {\n        payload: payload,\n        routing_key: routingKey,\n        dedup_key: dedupKey,\n        event_action: eventAction,\n        client: client,\n        client_url: clientURL,\n    }\n\n    headers = {\n        \"Accept\": \"application/vnd.pagerduty+json;version=2\",\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v: data)\n    return http.post(headers: headers, url: pagerdutyURL, data: enc)\n}",
						Start: ast.Position{
							Column: 13,
							Line:   43,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   81,
							},
							File:   "pagerduty.flux",
							Source: "{\n\n    payload = {\n            summary: summary,\n            timestamp: timestamp,\n            source: source,\n            severity: severity,\n            component: component,\n            group: group,\n            class: class,\n    }\n    data = {\n        payload: payload,\n        routing_key: routingKey,\n        dedup_key: dedupKey,\n        event_action: eventAction,\n        client: client,\n        client_url: clientURL,\n    }\n\n    headers = {\n        \"Accept\": \"application/vnd.pagerduty+json;version=2\",\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v: data)\n    return http.post(headers: headers, url: pagerdutyURL, data: enc)\n}",
							Start: ast.Position{
								Column: 19,
								Line:   55,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   65,
								},
								File:   "pagerduty.flux",
								Source: "payload = {\n            summary: summary,\n            timestamp: timestamp,\n            source: source,\n            severity: severity,\n            component: component,\n            group: group,\n            class: class,\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   57,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   57,
									},
									File:   "pagerduty.flux",
									Source: "payload",
									Start: ast.Position{
										Column: 5,
										Line:   57,
									},
								},
							},
							Name: "payload",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   65,
									},
									File:   "pagerduty.flux",
									Source: "{\n            summary: summary,\n            timestamp: timestamp,\n            source: source,\n            severity: severity,\n            component: component,\n            group: group,\n            class: class,\n    }",
									Start: ast.Position{
										Column: 15,
										Line:   57,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   58,
										},
										File:   "pagerduty.flux",
										Source: "summary: summary",
										Start: ast.Position{
											Column: 13,
											Line:   58,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   58,
											},
											File:   "pagerduty.flux",
											Source: "summary",
											Start: ast.Position{
												Column: 13,
												Line:   58,
											},
										},
									},
									Name: "summary",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   58,
											},
											File:   "pagerduty.flux",
											Source: "summary",
											Start: ast.Position{
												Column: 22,
												Line:   58,
											},
										},
									},
									Name: "summary",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   59,
										},
										File:   "pagerduty.flux",
										Source: "timestamp: timestamp",
										Start: ast.Position{
											Column: 13,
											Line:   59,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   59,
											},
											File:   "pagerduty.flux",
											Source: "timestamp",
											Start: ast.Position{
												Column: 13,
												Line:   59,
											},
										},
									},
									Name: "timestamp",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   59,
											},
											File:   "pagerduty.flux",
											Source: "timestamp",
											Start: ast.Position{
												Column: 24,
												Line:   59,
											},
										},
									},
									Name: "timestamp",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   60,
										},
										File:   "pagerduty.flux",
										Source: "source: source",
										Start: ast.Position{
											Column: 13,
											Line:   60,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   60,
											},
											File:   "pagerduty.flux",
											Source: "source",
											Start: ast.Position{
												Column: 13,
												Line:   60,
											},
										},
									},
									Name: "source",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   60,
											},
											File:   "pagerduty.flux",
											Source: "source",
											Start: ast.Position{
												Column: 21,
												Line:   60,
											},
										},
									},
									Name: "source",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   61,
										},
										File:   "pagerduty.flux",
										Source: "severity: severity",
										Start: ast.Position{
											Column: 13,
											Line:   61,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   61,
											},
											File:   "pagerduty.flux",
											Source: "severity",
											Start: ast.Position{
												Column: 13,
												Line:   61,
											},
										},
									},
									Name: "severity",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   61,
											},
											File:   "pagerduty.flux",
											Source: "severity",
											Start: ast.Position{
												Column: 23,
												Line:   61,
											},
										},
									},
									Name: "severity",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   62,
										},
										File:   "pagerduty.flux",
										Source: "component: component",
										Start: ast.Position{
											Column: 13,
											Line:   62,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   62,
											},
											File:   "pagerduty.flux",
											Source: "component",
											Start: ast.Position{
												Column: 13,
												Line:   62,
											},
										},
									},
									Name: "component",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   62,
											},
											File:   "pagerduty.flux",
											Source: "component",
											Start: ast.Position{
												Column: 24,
												Line:   62,
											},
										},
									},
									Name: "component",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   63,
										},
										File:   "pagerduty.flux",
										Source: "group: group",
										Start: ast.Position{
											Column: 13,
											Line:   63,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   63,
											},
											File:   "pagerduty.flux",
											Source: "group",
											Start: ast.Position{
												Column: 13,
												Line:   63,
											},
										},
									},
									Name: "group",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   63,
											},
											File:   "pagerduty.flux",
											Source: "group",
											Start: ast.Position{
												Column: 20,
												Line:   63,
											},
										},
									},
									Name: "group",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   64,
										},
										File:   "pagerduty.flux",
										Source: "class: class",
										Start: ast.Position{
											Column: 13,
											Line:   64,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   64,
											},
											File:   "pagerduty.flux",
											Source: "class",
											Start: ast.Position{
												Column: 13,
												Line:   64,
											},
										},
									},
									Name: "class",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   64,
											},
											File:   "pagerduty.flux",
											Source: "class",
											Start: ast.Position{
												Column: 20,
												Line:   64,
											},
										},
									},
									Name: "class",
								},
							}},
							With: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   73,
								},
								File:   "pagerduty.flux",
								Source: "data = {\n        payload: payload,\n        routing_key: routingKey,\n        dedup_key: dedupKey,\n        event_action: eventAction,\n        client: client,\n        client_url: clientURL,\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   66,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   66,
									},
									File:   "pagerduty.flux",
									Source: "data",
									Start: ast.Position{
										Column: 5,
										Line:   66,
									},
								},
							},
							Name: "data",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   73,
									},
									File:   "pagerduty.flux",
									Source: "{\n        payload: payload,\n        routing_key: routingKey,\n        dedup_key: dedupKey,\n        event_action: eventAction,\n        client: client,\n        client_url: clientURL,\n    }",
									Start: ast.Position{
										Column: 12,
										Line:   66,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   67,
										},
										File:   "pagerduty.flux",
										Source: "payload: payload",
										Start: ast.Position{
											Column: 9,
											Line:   67,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   67,
											},
											File:   "pagerduty.flux",
											Source: "payload",
											Start: ast.Position{
												Column: 9,
												Line:   67,
											},
										},
									},
									Name: "payload",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   67,
											},
											File:   "pagerduty.flux",
											Source: "payload",
											Start: ast.Position{
												Column: 18,
												Line:   67,
											},
										},
									},
									Name: "payload",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   68,
										},
										File:   "pagerduty.flux",
										Source: "routing_key: routingKey",
										Start: ast.Position{
											Column: 9,
											Line:   68,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   68,
											},
											File:   "pagerduty.flux",
											Source: "routing_key",
											Start: ast.Position{
												Column: 9,
												Line:   68,
											},
										},
									},
									Name: "routing_key",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   68,
											},
											File:   "pagerduty.flux",
											Source: "routingKey",
											Start: ast.Position{
												Column: 22,
												Line:   68,
											},
										},
									},
									Name: "routingKey",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   69,
										},
										File:   "pagerduty.flux",
										Source: "dedup_key: dedupKey",
										Start: ast.Position{
											Column: 9,
											Line:   69,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   69,
											},
											File:   "pagerduty.flux",
											Source: "dedup_key",
											Start: ast.Position{
												Column: 9,
												Line:   69,
											},
										},
									},
									Name: "dedup_key",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   69,
											},
											File:   "pagerduty.flux",
											Source: "dedupKey",
											Start: ast.Position{
												Column: 20,
												Line:   69,
											},
										},
									},
									Name: "dedupKey",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   70,
										},
										File:   "pagerduty.flux",
										Source: "event_action: eventAction",
										Start: ast.Position{
											Column: 9,
											Line:   70,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   70,
											},
											File:   "pagerduty.flux",
											Source: "event_action",
											Start: ast.Position{
												Column: 9,
												Line:   70,
											},
										},
									},
									Name: "event_action",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   70,
											},
											File:   "pagerduty.flux",
											Source: "eventAction",
											Start: ast.Position{
												Column: 23,
												Line:   70,
											},
										},
									},
									Name: "eventAction",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   71,
										},
										File:   "pagerduty.flux",
										Source: "client: client",
										Start: ast.Position{
											Column: 9,
											Line:   71,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   71,
											},
											File:   "pagerduty.flux",
											Source: "client",
											Start: ast.Position{
												Column: 9,
												Line:   71,
											},
										},
									},
									Name: "client",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   71,
											},
											File:   "pagerduty.flux",
											Source: "client",
											Start: ast.Position{
												Column: 17,
												Line:   71,
											},
										},
									},
									Name: "client",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   72,
										},
										File:   "pagerduty.flux",
										Source: "client_url: clientURL",
										Start: ast.Position{
											Column: 9,
											Line:   72,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   72,
											},
											File:   "pagerduty.flux",
											Source: "client_url",
											Start: ast.Position{
												Column: 9,
												Line:   72,
											},
										},
									},
									Name: "client_url",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   72,
											},
											File:   "pagerduty.flux",
											Source: "clientURL",
											Start: ast.Position{
												Column: 21,
												Line:   72,
											},
										},
									},
									Name: "clientURL",
								},
							}},
							With: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   78,
								},
								File:   "pagerduty.flux",
								Source: "headers = {\n        \"Accept\": \"application/vnd.pagerduty+json;version=2\",\n        \"Content-Type\": \"application/json\",\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   75,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   75,
									},
									File:   "pagerduty.flux",
									Source: "headers",
									Start: ast.Position{
										Column: 5,
										Line:   75,
									},
								},
							},
							Name: "headers",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   78,
									},
									File:   "pagerduty.flux",
									Source: "{\n        \"Accept\": \"application/vnd.pagerduty+json;version=2\",\n        \"Content-Type\": \"application/json\",\n    }",
									Start: ast.Position{
										Column: 15,
										Line:   75,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 61,
											Line:   76,
										},
										File:   "pagerduty.flux",
										Source: "\"Accept\": \"application/vnd.pagerduty+json;version=2\"",
										Start: ast.Position{
											Column: 9,
											Line:   76,
										},
									},
								},
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   76,
											},
											File:   "pagerduty.flux",
											Source: "\"Accept\"",
											Start: ast.Position{
												Column: 9,
												Line:   76,
											},
										},
									},
									Value: "Accept",
								},
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 61,
												Line:   76,
											},
											File:   "pagerduty.flux",
											Source: "\"application/vnd.pagerduty+json;version=2\"",
											Start: ast.Position{
												Column: 19,
												Line:   76,
											},
										},
									},
									Value: "application/vnd.pagerduty+json;version=2",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   77,
										},
										File:   "pagerduty.flux",
										Source: "\"Content-Type\": \"application/json\"",
										Start: ast.Position{
											Column: 9,
											Line:   77,
										},
									},
								},
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   77,
											},
											File:   "pagerduty.flux",
											Source: "\"Content-Type\"",
											Start: ast.Position{
												Column: 9,
												Line:   77,
											},
										},
									},
									Value: "Content-Type",
								},
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   77,
											},
											File:   "pagerduty.flux",
											Source: "\"application/json\"",
											Start: ast.Position{
												Column: 25,
												Line:   77,
											},
										},
									},
									Value: "application/json",
								},
							}},
							With: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   79,
								},
								File:   "pagerduty.flux",
								Source: "enc = json.encode(v: data)",
								Start: ast.Position{
									Column: 5,
									Line:   79,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   79,
									},
									File:   "pagerduty.flux",
									Source: "enc",
									Start: ast.Position{
										Column: 5,
										Line:   79,
									},
								},
							},
							Name: "enc",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   79,
										},
										File:   "pagerduty.flux",
										Source: "v: data",
										Start: ast.Position{
											Column: 23,
											Line:   79,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   79,
											},
											File:   "pagerduty.flux",
											Source: "v: data",
											Start: ast.Position{
												Column: 23,
												Line:   79,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   79,
												},
												File:   "pagerduty.flux",
												Source: "v",
												Start: ast.Position{
													Column: 23,
													Line:   79,
												},
											},
										},
										Name: "v",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   79,
												},
												File:   "pagerduty.flux",
												Source: "data",
												Start: ast.Position{
													Column: 26,
													Line:   79,
												},
											},
										},
										Name: "data",
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   79,
									},
									File:   "pagerduty.flux",
									Source: "json.encode(v: data)",
									Start: ast.Position{
										Column: 11,
										Line:   79,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   79,
										},
										File:   "pagerduty.flux",
										Source: "json.encode",
										Start: ast.Position{
											Column: 11,
											Line:   79,
										},
									},
								},
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   79,
											},
											File:   "pagerduty.flux",
											Source: "json",
											Start: ast.Position{
												Column: 11,
												Line:   79,
											},
										},
									},
									Name: "json",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   79,
											},
											File:   "pagerduty.flux",
											Source: "encode",
											Start: ast.Position{
												Column: 16,
												Line:   79,
											},
										},
									},
									Name: "encode",
								},
							},
						},
					}, &ast.ReturnStatement{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 68,
											Line:   80,
										},
										File:   "pagerduty.flux",
										Source: "headers: headers, url: pagerdutyURL, data: enc",
										Start: ast.Position{
											Column: 22,
											Line:   80,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   80,
											},
											File:   "pagerduty.flux",
											Source: "headers: headers",
											Start: ast.Position{
												Column: 22,
												Line:   80,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   80,
												},
												File:   "pagerduty.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 22,
													Line:   80,
												},
											},
										},
										Name: "headers",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   80,
												},
												File:   "pagerduty.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 31,
													Line:   80,
												},
											},
										},
										Name: "headers",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   80,
											},
											File:   "pagerduty.flux",
											Source: "url: pagerdutyURL",
											Start: ast.Position{
												Column: 40,
												Line:   80,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   80,
												},
												File:   "pagerduty.flux",
												Source: "url",
												Start: ast.Position{
													Column: 40,
													Line:   80,
												},
											},
										},
										Name: "url",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 57,
													Line:   80,
												},
												File:   "pagerduty.flux",
												Source: "pagerdutyURL",
												Start: ast.Position{
													Column: 45,
													Line:   80,
												},
											},
										},
										Name: "pagerdutyURL",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 68,
												Line:   80,
											},
											File:   "pagerduty.flux",
											Source: "data: enc",
											Start: ast.Position{
												Column: 59,
												Line:   80,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 63,
													Line:   80,
												},
												File:   "pagerduty.flux",
												Source: "data",
												Start: ast.Position{
													Column: 59,
													Line:   80,
												},
											},
										},
										Name: "data",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   80,
												},
												File:   "pagerduty.flux",
												Source: "enc",
												Start: ast.Position{
													Column: 65,
													Line:   80,
												},
											},
										},
										Name: "enc",
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 69,
										Line:   80,
									},
									File:   "pagerduty.flux",
									Source: "http.post(headers: headers, url: pagerdutyURL, data: enc)",
									Start: ast.Position{
										Column: 12,
										Line:   80,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   80,
										},
										File:   "pagerduty.flux",
										Source: "http.post",
										Start: ast.Position{
											Column: 12,
											Line:   80,
										},
									},
								},
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   80,
											},
											File:   "pagerduty.flux",
											Source: "http",
											Start: ast.Position{
												Column: 12,
												Line:   80,
											},
										},
									},
									Name: "http",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   80,
											},
											File:   "pagerduty.flux",
											Source: "post",
											Start: ast.Position{
												Column: 17,
												Line:   80,
											},
										},
									},
									Name: "post",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 69,
									Line:   80,
								},
								File:   "pagerduty.flux",
								Source: "return http.post(headers: headers, url: pagerdutyURL, data: enc)",
								Start: ast.Position{
									Column: 5,
									Line:   80,
								},
							},
						},
					}},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   43,
							},
							File:   "pagerduty.flux",
							Source: "pagerdutyURL=defaultURL",
							Start: ast.Position{
								Column: 14,
								Line:   43,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   43,
								},
								File:   "pagerduty.flux",
								Source: "pagerdutyURL",
								Start: ast.Position{
									Column: 14,
									Line:   43,
								},
							},
						},
						Name: "pagerdutyURL",
					},
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   43,
								},
								File:   "pagerduty.flux",
								Source: "defaultURL",
								Start: ast.Position{
									Column: 27,
									Line:   43,
								},
							},
						},
						Name: "defaultURL",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   44,
							},
							File:   "pagerduty.flux",
							Source: "routingKey",
							Start: ast.Position{
								Column: 5,
								Line:   44,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   44,
								},
								File:   "pagerduty.flux",
								Source: "routingKey",
								Start: ast.Position{
									Column: 5,
									Line:   44,
								},
							},
						},
						Name: "routingKey",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   45,
							},
							File:   "pagerduty.flux",
							Source: "client",
							Start: ast.Position{
								Column: 5,
								Line:   45,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   45,
								},
								File:   "pagerduty.flux",
								Source: "client",
								Start: ast.Position{
									Column: 5,
									Line:   45,
								},
							},
						},
						Name: "client",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   46,
							},
							File:   "pagerduty.flux",
							Source: "clientURL",
							Start: ast.Position{
								Column: 5,
								Line:   46,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   46,
								},
								File:   "pagerduty.flux",
								Source: "clientURL",
								Start: ast.Position{
									Column: 5,
									Line:   46,
								},
							},
						},
						Name: "clientURL",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   47,
							},
							File:   "pagerduty.flux",
							Source: "dedupKey",
							Start: ast.Position{
								Column: 5,
								Line:   47,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   47,
								},
								File:   "pagerduty.flux",
								Source: "dedupKey",
								Start: ast.Position{
									Column: 5,
									Line:   47,
								},
							},
						},
						Name: "dedupKey",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 10,
								Line:   48,
							},
							File:   "pagerduty.flux",
							Source: "class",
							Start: ast.Position{
								Column: 5,
								Line:   48,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 10,
									Line:   48,
								},
								File:   "pagerduty.flux",
								Source: "class",
								Start: ast.Position{
									Column: 5,
									Line:   48,
								},
							},
						},
						Name: "class",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 10,
								Line:   49,
							},
							File:   "pagerduty.flux",
							Source: "group",
							Start: ast.Position{
								Column: 5,
								Line:   49,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 10,
									Line:   49,
								},
								File:   "pagerduty.flux",
								Source: "group",
								Start: ast.Position{
									Column: 5,
									Line:   49,
								},
							},
						},
						Name: "group",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   50,
							},
							File:   "pagerduty.flux",
							Source: "severity",
							Start: ast.Position{
								Column: 5,
								Line:   50,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   50,
								},
								File:   "pagerduty.flux",
								Source: "severity",
								Start: ast.Position{
									Column: 5,
									Line:   50,
								},
							},
						},
						Name: "severity",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   51,
							},
							File:   "pagerduty.flux",
							Source: "eventAction",
							Start: ast.Position{
								Column: 5,
								Line:   51,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   51,
								},
								File:   "pagerduty.flux",
								Source: "eventAction",
								Start: ast.Position{
									Column: 5,
									Line:   51,
								},
							},
						},
						Name: "eventAction",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   52,
							},
							File:   "pagerduty.flux",
							Source: "component",
							Start: ast.Position{
								Column: 5,
								Line:   52,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   52,
								},
								File:   "pagerduty.flux",
								Source: "component",
								Start: ast.Position{
									Column: 5,
									Line:   52,
								},
							},
						},
						Name: "component",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   53,
							},
							File:   "pagerduty.flux",
							Source: "source",
							Start: ast.Position{
								Column: 5,
								Line:   53,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   53,
								},
								File:   "pagerduty.flux",
								Source: "source",
								Start: ast.Position{
									Column: 5,
									Line:   53,
								},
							},
						},
						Name: "source",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 12,
								Line:   54,
							},
							File:   "pagerduty.flux",
							Source: "summary",
							Start: ast.Position{
								Column: 5,
								Line:   54,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   54,
								},
								File:   "pagerduty.flux",
								Source: "summary",
								Start: ast.Position{
									Column: 5,
									Line:   54,
								},
							},
						},
						Name: "summary",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   55,
							},
							File:   "pagerduty.flux",
							Source: "timestamp",
							Start: ast.Position{
								Column: 5,
								Line:   55,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   55,
								},
								File:   "pagerduty.flux",
								Source: "timestamp",
								Start: ast.Position{
									Column: 5,
									Line:   55,
								},
							},
						},
						Name: "timestamp",
					},
					Value: nil,
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   109,
					},
					File:   "pagerduty.flux",
					Source: "endpoint = (url=defaultURL) =>\n    (mapFn) =>\n        (tables=<-) => tables\n            |> dedupKey()\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                \n                return {r with _sent: string(v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    component: obj.component,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100))}\n            })",
					Start: ast.Position{
						Column: 1,
						Line:   88,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   88,
						},
						File:   "pagerduty.flux",
						Source: "endpoint",
						Start: ast.Position{
							Column: 1,
							Line:   88,
						},
					},
				},
				Name: "endpoint",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   109,
						},
						File:   "pagerduty.flux",
						Source: "(url=defaultURL) =>\n    (mapFn) =>\n        (tables=<-) => tables\n            |> dedupKey()\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                \n                return {r with _sent: string(v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    component: obj.component,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100))}\n            })",
						Start: ast.Position{
							Column: 12,
							Line:   88,
						},
					},
				},
				Body: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   109,
							},
							File:   "pagerduty.flux",
							Source: "(mapFn) =>\n        (tables=<-) => tables\n            |> dedupKey()\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                \n                return {r with _sent: string(v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    component: obj.component,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100))}\n            })",
							Start: ast.Position{
								Column: 5,
								Line:   89,
							},
						},
					},
					Body: &ast.FunctionExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   109,
								},
								File:   "pagerduty.flux",
								Source: "(tables=<-) => tables\n            |> dedupKey()\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                \n                return {r with _sent: string(v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    component: obj.component,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100))}\n            })",
								Start: ast.Position{
									Column: 9,
									Line:   90,
								},
							},
						},
						Body: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   90,
											},
											File:   "pagerduty.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 24,
												Line:   90,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   91,
										},
										File:   "pagerduty.flux",
										Source: "tables\n            |> dedupKey()",
										Start: ast.Position{
											Column: 24,
											Line:   90,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: nil,
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   91,
											},
											File:   "pagerduty.flux",
											Source: "dedupKey()",
											Start: ast.Position{
												Column: 16,
												Line:   91,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   91,
												},
												File:   "pagerduty.flux",
												Source: "dedupKey",
												Start: ast.Position{
													Column: 16,
													Line:   91,
												},
											},
										},
										Name: "dedupKey",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   109,
									},
									File:   "pagerduty.flux",
									Source: "tables\n            |> dedupKey()\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                \n                return {r with _sent: string(v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    component: obj.component,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100))}\n            })",
									Start: ast.Position{
										Column: 24,
										Line:   90,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   109,
											},
											File:   "pagerduty.flux",
											Source: "fn: (r) => {\n                obj = mapFn(r: r)\n                \n                return {r with _sent: string(v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    component: obj.component,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100))}\n            }",
											Start: ast.Position{
												Column: 20,
												Line:   92,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   109,
												},
												File:   "pagerduty.flux",
												Source: "fn: (r) => {\n                obj = mapFn(r: r)\n                \n                return {r with _sent: string(v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    component: obj.component,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100))}\n            }",
												Start: ast.Position{
													Column: 20,
													Line:   92,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 22,
														Line:   92,
													},
													File:   "pagerduty.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 20,
														Line:   92,
													},
												},
											},
											Name: "fn",
										},
										Value: &ast.FunctionExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   109,
													},
													File:   "pagerduty.flux",
													Source: "(r) => {\n                obj = mapFn(r: r)\n                \n                return {r with _sent: string(v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    component: obj.component,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100))}\n            }",
													Start: ast.Position{
														Column: 24,
														Line:   92,
													},
												},
											},
											Body: &ast.Block{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   109,
														},
														File:   "pagerduty.flux",
														Source: "{\n                obj = mapFn(r: r)\n                \n                return {r with _sent: string(v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    component: obj.component,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100))}\n            }",
														Start: ast.Position{
															Column: 31,
															Line:   92,
														},
													},
												},
												Body: []ast.Statement{&ast.VariableAssignment{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 34,
																Line:   93,
															},
															File:   "pagerduty.flux",
															Source: "obj = mapFn(r: r)",
															Start: ast.Position{
																Column: 17,
																Line:   93,
															},
														},
													},
													ID: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 20,
																	Line:   93,
																},
																File:   "pagerduty.flux",
																Source: "obj",
																Start: ast.Position{
																	Column: 17,
																	Line:   93,
																},
															},
														},
														Name: "obj",
													},
													Init: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 33,
																		Line:   93,
																	},
																	File:   "pagerduty.flux",
																	Source: "r: r",
																	Start: ast.Position{
																		Column: 29,
																		Line:   93,
																	},
																},
															},
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 33,
																			Line:   93,
																		},
																		File:   "pagerduty.flux",
																		Source: "r: r",
																		Start: ast.Position{
																			Column: 29,
																			Line:   93,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 30,
																				Line:   93,
																			},
																			File:   "pagerduty.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 29,
																				Line:   93,
																			},
																		},
																	},
																	Name: "r",
																},
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 33,
																				Line:   93,
																			},
																			File:   "pagerduty.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 32,
																				Line:   93,
																			},
																		},
																	},
																	Name: "r",
																},
															}},
															With: nil,
														}},
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 34,
																	Line:   93,
																},
																File:   "pagerduty.flux",
																Source: "mapFn(r: r)",
																Start: ast.Position{
																	Column: 23,
																	Line:   93,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 28,
																		Line:   93,
																	},
																	File:   "pagerduty.flux",
																	Source: "mapFn",
																	Start: ast.Position{
																		Column: 23,
																		Line:   93,
																	},
																},
															},
															Name: "mapFn",
														},
													},
												}, &ast.ReturnStatement{
													Argument: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 27,
																	Line:   108,
																},
																File:   "pagerduty.flux",
																Source: "{r with _sent: string(v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    component: obj.component,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100))}",
																Start: ast.Position{
																	Column: 24,
																	Line:   95,
																},
															},
														},
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 26,
																		Line:   108,
																	},
																	File:   "pagerduty.flux",
																	Source: "_sent: string(v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    component: obj.component,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100))",
																	Start: ast.Position{
																		Column: 32,
																		Line:   95,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 37,
																			Line:   95,
																		},
																		File:   "pagerduty.flux",
																		Source: "_sent",
																		Start: ast.Position{
																			Column: 32,
																			Line:   95,
																		},
																	},
																},
																Name: "_sent",
															},
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 25,
																				Line:   108,
																			},
																			File:   "pagerduty.flux",
																			Source: "v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    component: obj.component,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100)",
																			Start: ast.Position{
																				Column: 46,
																				Line:   95,
																			},
																		},
																	},
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 25,
																					Line:   108,
																				},
																				File:   "pagerduty.flux",
																				Source: "v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    component: obj.component,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100)",
																				Start: ast.Position{
																					Column: 46,
																					Line:   95,
																				},
																			},
																		},
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 47,
																						Line:   95,
																					},
																					File:   "pagerduty.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 46,
																						Line:   95,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Value: &ast.BinaryExpression{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 25,
																						Line:   108,
																					},
																					File:   "pagerduty.flux",
																					Source: "2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    component: obj.component,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100)",
																					Start: ast.Position{
																						Column: 49,
																						Line:   95,
																					},
																				},
																			},
																			Left: &ast.IntegerLiteral{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 50,
																							Line:   95,
																						},
																						File:   "pagerduty.flux",
																						Source: "2",
																						Start: ast.Position{
																							Column: 49,
																							Line:   95,
																						},
																					},
																				},
																				Value: int64(2),
																			},
																			Operator: 17,
																			Right: &ast.ParenExpression{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 25,
																							Line:   108,
																						},
																						File:   "pagerduty.flux",
																						Source: "(sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    component: obj.component,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100)",
																						Start: ast.Position{
																							Column: 54,
																							Line:   95,
																						},
																					},
																				},
																				Expression: &ast.BinaryExpression{
																					BaseNode: ast.BaseNode{
																						Errors: nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 24,
																								Line:   108,
																							},
																							File:   "pagerduty.flux",
																							Source: "sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    component: obj.component,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100",
																							Start: ast.Position{
																								Column: 55,
																								Line:   95,
																							},
																						},
																					},
																					Left: &ast.CallExpression{
																						Arguments: []ast.Expression{&ast.ObjectExpression{
																							BaseNode: ast.BaseNode{
																								Errors: nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 45,
																										Line:   107,
																									},
																									File:   "pagerduty.flux",
																									Source: "pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    component: obj.component,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp",
																									Start: ast.Position{
																										Column: 65,
																										Line:   95,
																									},
																								},
																							},
																							Properties: []*ast.Property{&ast.Property{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 82,
																											Line:   95,
																										},
																										File:   "pagerduty.flux",
																										Source: "pagerdutyURL: url",
																										Start: ast.Position{
																											Column: 65,
																											Line:   95,
																										},
																									},
																								},
																								Key: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 77,
																												Line:   95,
																											},
																											File:   "pagerduty.flux",
																											Source: "pagerdutyURL",
																											Start: ast.Position{
																												Column: 65,
																												Line:   95,
																											},
																										},
																									},
																									Name: "pagerdutyURL",
																								},
																								Value: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 82,
																												Line:   95,
																											},
																											File:   "pagerduty.flux",
																											Source: "url",
																											Start: ast.Position{
																												Column: 79,
																												Line:   95,
																											},
																										},
																									},
																									Name: "url",
																								},
																							}, &ast.Property{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 47,
																											Line:   96,
																										},
																										File:   "pagerduty.flux",
																										Source: "routingKey: obj.routingKey",
																										Start: ast.Position{
																											Column: 21,
																											Line:   96,
																										},
																									},
																								},
																								Key: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 31,
																												Line:   96,
																											},
																											File:   "pagerduty.flux",
																											Source: "routingKey",
																											Start: ast.Position{
																												Column: 21,
																												Line:   96,
																											},
																										},
																									},
																									Name: "routingKey",
																								},
																								Value: &ast.MemberExpression{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 47,
																												Line:   96,
																											},
																											File:   "pagerduty.flux",
																											Source: "obj.routingKey",
																											Start: ast.Position{
																												Column: 33,
																												Line:   96,
																											},
																										},
																									},
																									Object: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 36,
																													Line:   96,
																												},
																												File:   "pagerduty.flux",
																												Source: "obj",
																												Start: ast.Position{
																													Column: 33,
																													Line:   96,
																												},
																											},
																										},
																										Name: "obj",
																									},
																									Property: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 47,
																													Line:   96,
																												},
																												File:   "pagerduty.flux",
																												Source: "routingKey",
																												Start: ast.Position{
																													Column: 37,
																													Line:   96,
																												},
																											},
																										},
																										Name: "routingKey",
																									},
																								},
																							}, &ast.Property{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 39,
																											Line:   97,
																										},
																										File:   "pagerduty.flux",
																										Source: "client: obj.client",
																										Start: ast.Position{
																											Column: 21,
																											Line:   97,
																										},
																									},
																								},
																								Key: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 27,
																												Line:   97,
																											},
																											File:   "pagerduty.flux",
																											Source: "client",
																											Start: ast.Position{
																												Column: 21,
																												Line:   97,
																											},
																										},
																									},
																									Name: "client",
																								},
																								Value: &ast.MemberExpression{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 39,
																												Line:   97,
																											},
																											File:   "pagerduty.flux",
																											Source: "obj.client",
																											Start: ast.Position{
																												Column: 29,
																												Line:   97,
																											},
																										},
																									},
																									Object: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 32,
																													Line:   97,
																												},
																												File:   "pagerduty.flux",
																												Source: "obj",
																												Start: ast.Position{
																													Column: 29,
																													Line:   97,
																												},
																											},
																										},
																										Name: "obj",
																									},
																									Property: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 39,
																													Line:   97,
																												},
																												File:   "pagerduty.flux",
																												Source: "client",
																												Start: ast.Position{
																													Column: 33,
																													Line:   97,
																												},
																											},
																										},
																										Name: "client",
																									},
																								},
																							}, &ast.Property{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 45,
																											Line:   98,
																										},
																										File:   "pagerduty.flux",
																										Source: "clientURL: obj.clientURL",
																										Start: ast.Position{
																											Column: 21,
																											Line:   98,
																										},
																									},
																								},
																								Key: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 30,
																												Line:   98,
																											},
																											File:   "pagerduty.flux",
																											Source: "clientURL",
																											Start: ast.Position{
																												Column: 21,
																												Line:   98,
																											},
																										},
																									},
																									Name: "clientURL",
																								},
																								Value: &ast.MemberExpression{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 45,
																												Line:   98,
																											},
																											File:   "pagerduty.flux",
																											Source: "obj.clientURL",
																											Start: ast.Position{
																												Column: 32,
																												Line:   98,
																											},
																										},
																									},
																									Object: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 35,
																													Line:   98,
																												},
																												File:   "pagerduty.flux",
																												Source: "obj",
																												Start: ast.Position{
																													Column: 32,
																													Line:   98,
																												},
																											},
																										},
																										Name: "obj",
																									},
																									Property: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 45,
																													Line:   98,
																												},
																												File:   "pagerduty.flux",
																												Source: "clientURL",
																												Start: ast.Position{
																													Column: 36,
																													Line:   98,
																												},
																											},
																										},
																										Name: "clientURL",
																									},
																								},
																							}, &ast.Property{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 51,
																											Line:   99,
																										},
																										File:   "pagerduty.flux",
																										Source: "dedupKey: r._pagerdutyDedupKey",
																										Start: ast.Position{
																											Column: 21,
																											Line:   99,
																										},
																									},
																								},
																								Key: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 29,
																												Line:   99,
																											},
																											File:   "pagerduty.flux",
																											Source: "dedupKey",
																											Start: ast.Position{
																												Column: 21,
																												Line:   99,
																											},
																										},
																									},
																									Name: "dedupKey",
																								},
																								Value: &ast.MemberExpression{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 51,
																												Line:   99,
																											},
																											File:   "pagerduty.flux",
																											Source: "r._pagerdutyDedupKey",
																											Start: ast.Position{
																												Column: 31,
																												Line:   99,
																											},
																										},
																									},
																									Object: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 32,
																													Line:   99,
																												},
																												File:   "pagerduty.flux",
																												Source: "r",
																												Start: ast.Position{
																													Column: 31,
																													Line:   99,
																												},
																											},
																										},
																										Name: "r",
																									},
																									Property: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 51,
																													Line:   99,
																												},
																												File:   "pagerduty.flux",
																												Source: "_pagerdutyDedupKey",
																												Start: ast.Position{
																													Column: 33,
																													Line:   99,
																												},
																											},
																										},
																										Name: "_pagerdutyDedupKey",
																									},
																								},
																							}, &ast.Property{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 37,
																											Line:   100,
																										},
																										File:   "pagerduty.flux",
																										Source: "class: obj.class",
																										Start: ast.Position{
																											Column: 21,
																											Line:   100,
																										},
																									},
																								},
																								Key: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 26,
																												Line:   100,
																											},
																											File:   "pagerduty.flux",
																											Source: "class",
																											Start: ast.Position{
																												Column: 21,
																												Line:   100,
																											},
																										},
																									},
																									Name: "class",
																								},
																								Value: &ast.MemberExpression{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 37,
																												Line:   100,
																											},
																											File:   "pagerduty.flux",
																											Source: "obj.class",
																											Start: ast.Position{
																												Column: 28,
																												Line:   100,
																											},
																										},
																									},
																									Object: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 31,
																													Line:   100,
																												},
																												File:   "pagerduty.flux",
																												Source: "obj",
																												Start: ast.Position{
																													Column: 28,
																													Line:   100,
																												},
																											},
																										},
																										Name: "obj",
																									},
																									Property: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 37,
																													Line:   100,
																												},
																												File:   "pagerduty.flux",
																												Source: "class",
																												Start: ast.Position{
																													Column: 32,
																													Line:   100,
																												},
																											},
																										},
																										Name: "class",
																									},
																								},
																							}, &ast.Property{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 37,
																											Line:   101,
																										},
																										File:   "pagerduty.flux",
																										Source: "group: obj.group",
																										Start: ast.Position{
																											Column: 21,
																											Line:   101,
																										},
																									},
																								},
																								Key: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 26,
																												Line:   101,
																											},
																											File:   "pagerduty.flux",
																											Source: "group",
																											Start: ast.Position{
																												Column: 21,
																												Line:   101,
																											},
																										},
																									},
																									Name: "group",
																								},
																								Value: &ast.MemberExpression{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 37,
																												Line:   101,
																											},
																											File:   "pagerduty.flux",
																											Source: "obj.group",
																											Start: ast.Position{
																												Column: 28,
																												Line:   101,
																											},
																										},
																									},
																									Object: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 31,
																													Line:   101,
																												},
																												File:   "pagerduty.flux",
																												Source: "obj",
																												Start: ast.Position{
																													Column: 28,
																													Line:   101,
																												},
																											},
																										},
																										Name: "obj",
																									},
																									Property: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 37,
																													Line:   101,
																												},
																												File:   "pagerduty.flux",
																												Source: "group",
																												Start: ast.Position{
																													Column: 32,
																													Line:   101,
																												},
																											},
																										},
																										Name: "group",
																									},
																								},
																							}, &ast.Property{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 43,
																											Line:   102,
																										},
																										File:   "pagerduty.flux",
																										Source: "severity: obj.severity",
																										Start: ast.Position{
																											Column: 21,
																											Line:   102,
																										},
																									},
																								},
																								Key: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 29,
																												Line:   102,
																											},
																											File:   "pagerduty.flux",
																											Source: "severity",
																											Start: ast.Position{
																												Column: 21,
																												Line:   102,
																											},
																										},
																									},
																									Name: "severity",
																								},
																								Value: &ast.MemberExpression{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 43,
																												Line:   102,
																											},
																											File:   "pagerduty.flux",
																											Source: "obj.severity",
																											Start: ast.Position{
																												Column: 31,
																												Line:   102,
																											},
																										},
																									},
																									Object: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 34,
																													Line:   102,
																												},
																												File:   "pagerduty.flux",
																												Source: "obj",
																												Start: ast.Position{
																													Column: 31,
																													Line:   102,
																												},
																											},
																										},
																										Name: "obj",
																									},
																									Property: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 43,
																													Line:   102,
																												},
																												File:   "pagerduty.flux",
																												Source: "severity",
																												Start: ast.Position{
																													Column: 35,
																													Line:   102,
																												},
																											},
																										},
																										Name: "severity",
																									},
																								},
																							}, &ast.Property{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 49,
																											Line:   103,
																										},
																										File:   "pagerduty.flux",
																										Source: "eventAction: obj.eventAction",
																										Start: ast.Position{
																											Column: 21,
																											Line:   103,
																										},
																									},
																								},
																								Key: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 32,
																												Line:   103,
																											},
																											File:   "pagerduty.flux",
																											Source: "eventAction",
																											Start: ast.Position{
																												Column: 21,
																												Line:   103,
																											},
																										},
																									},
																									Name: "eventAction",
																								},
																								Value: &ast.MemberExpression{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 49,
																												Line:   103,
																											},
																											File:   "pagerduty.flux",
																											Source: "obj.eventAction",
																											Start: ast.Position{
																												Column: 34,
																												Line:   103,
																											},
																										},
																									},
																									Object: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 37,
																													Line:   103,
																												},
																												File:   "pagerduty.flux",
																												Source: "obj",
																												Start: ast.Position{
																													Column: 34,
																													Line:   103,
																												},
																											},
																										},
																										Name: "obj",
																									},
																									Property: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 49,
																													Line:   103,
																												},
																												File:   "pagerduty.flux",
																												Source: "eventAction",
																												Start: ast.Position{
																													Column: 38,
																													Line:   103,
																												},
																											},
																										},
																										Name: "eventAction",
																									},
																								},
																							}, &ast.Property{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 45,
																											Line:   104,
																										},
																										File:   "pagerduty.flux",
																										Source: "component: obj.component",
																										Start: ast.Position{
																											Column: 21,
																											Line:   104,
																										},
																									},
																								},
																								Key: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 30,
																												Line:   104,
																											},
																											File:   "pagerduty.flux",
																											Source: "component",
																											Start: ast.Position{
																												Column: 21,
																												Line:   104,
																											},
																										},
																									},
																									Name: "component",
																								},
																								Value: &ast.MemberExpression{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 45,
																												Line:   104,
																											},
																											File:   "pagerduty.flux",
																											Source: "obj.component",
																											Start: ast.Position{
																												Column: 32,
																												Line:   104,
																											},
																										},
																									},
																									Object: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 35,
																													Line:   104,
																												},
																												File:   "pagerduty.flux",
																												Source: "obj",
																												Start: ast.Position{
																													Column: 32,
																													Line:   104,
																												},
																											},
																										},
																										Name: "obj",
																									},
																									Property: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 45,
																													Line:   104,
																												},
																												File:   "pagerduty.flux",
																												Source: "component",
																												Start: ast.Position{
																													Column: 36,
																													Line:   104,
																												},
																											},
																										},
																										Name: "component",
																									},
																								},
																							}, &ast.Property{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 39,
																											Line:   105,
																										},
																										File:   "pagerduty.flux",
																										Source: "source: obj.source",
																										Start: ast.Position{
																											Column: 21,
																											Line:   105,
																										},
																									},
																								},
																								Key: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 27,
																												Line:   105,
																											},
																											File:   "pagerduty.flux",
																											Source: "source",
																											Start: ast.Position{
																												Column: 21,
																												Line:   105,
																											},
																										},
																									},
																									Name: "source",
																								},
																								Value: &ast.MemberExpression{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 39,
																												Line:   105,
																											},
																											File:   "pagerduty.flux",
																											Source: "obj.source",
																											Start: ast.Position{
																												Column: 29,
																												Line:   105,
																											},
																										},
																									},
																									Object: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 32,
																													Line:   105,
																												},
																												File:   "pagerduty.flux",
																												Source: "obj",
																												Start: ast.Position{
																													Column: 29,
																													Line:   105,
																												},
																											},
																										},
																										Name: "obj",
																									},
																									Property: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 39,
																													Line:   105,
																												},
																												File:   "pagerduty.flux",
																												Source: "source",
																												Start: ast.Position{
																													Column: 33,
																													Line:   105,
																												},
																											},
																										},
																										Name: "source",
																									},
																								},
																							}, &ast.Property{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 41,
																											Line:   106,
																										},
																										File:   "pagerduty.flux",
																										Source: "summary: obj.summary",
																										Start: ast.Position{
																											Column: 21,
																											Line:   106,
																										},
																									},
																								},
																								Key: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 28,
																												Line:   106,
																											},
																											File:   "pagerduty.flux",
																											Source: "summary",
																											Start: ast.Position{
																												Column: 21,
																												Line:   106,
																											},
																										},
																									},
																									Name: "summary",
																								},
																								Value: &ast.MemberExpression{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 41,
																												Line:   106,
																											},
																											File:   "pagerduty.flux",
																											Source: "obj.summary",
																											Start: ast.Position{
																												Column: 30,
																												Line:   106,
																											},
																										},
																									},
																									Object: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 33,
																													Line:   106,
																												},
																												File:   "pagerduty.flux",
																												Source: "obj",
																												Start: ast.Position{
																													Column: 30,
																													Line:   106,
																												},
																											},
																										},
																										Name: "obj",
																									},
																									Property: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 41,
																													Line:   106,
																												},
																												File:   "pagerduty.flux",
																												Source: "summary",
																												Start: ast.Position{
																													Column: 34,
																													Line:   106,
																												},
																											},
																										},
																										Name: "summary",
																									},
																								},
																							}, &ast.Property{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 45,
																											Line:   107,
																										},
																										File:   "pagerduty.flux",
																										Source: "timestamp: obj.timestamp",
																										Start: ast.Position{
																											Column: 21,
																											Line:   107,
																										},
																									},
																								},
																								Key: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 30,
																												Line:   107,
																											},
																											File:   "pagerduty.flux",
																											Source: "timestamp",
																											Start: ast.Position{
																												Column: 21,
																												Line:   107,
																											},
																										},
																									},
																									Name: "timestamp",
																								},
																								Value: &ast.MemberExpression{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 45,
																												Line:   107,
																											},
																											File:   "pagerduty.flux",
																											Source: "obj.timestamp",
																											Start: ast.Position{
																												Column: 32,
																												Line:   107,
																											},
																										},
																									},
																									Object: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 35,
																													Line:   107,
																												},
																												File:   "pagerduty.flux",
																												Source: "obj",
																												Start: ast.Position{
																													Column: 32,
																													Line:   107,
																												},
																											},
																										},
																										Name: "obj",
																									},
																									Property: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 45,
																													Line:   107,
																												},
																												File:   "pagerduty.flux",
																												Source: "timestamp",
																												Start: ast.Position{
																													Column: 36,
																													Line:   107,
																												},
																											},
																										},
																										Name: "timestamp",
																									},
																								},
																							}},
																							With: nil,
																						}},
																						BaseNode: ast.BaseNode{
																							Errors: nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 18,
																									Line:   108,
																								},
																								File:   "pagerduty.flux",
																								Source: "sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    component: obj.component,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                )",
																								Start: ast.Position{
																									Column: 55,
																									Line:   95,
																								},
																							},
																						},
																						Callee: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Errors: nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 64,
																										Line:   95,
																									},
																									File:   "pagerduty.flux",
																									Source: "sendEvent",
																									Start: ast.Position{
																										Column: 55,
																										Line:   95,
																									},
																								},
																							},
																							Name: "sendEvent",
																						},
																					},
																					Operator: 2,
																					Right: &ast.IntegerLiteral{
																						BaseNode: ast.BaseNode{
																							Errors: nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 24,
																									Line:   108,
																								},
																								File:   "pagerduty.flux",
																								Source: "100",
																								Start: ast.Position{
																									Column: 21,
																									Line:   108,
																								},
																							},
																						},
																						Value: int64(100),
																					},
																				},
																			},
																		},
																	}},
																	With: nil,
																}},
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 26,
																			Line:   108,
																		},
																		File:   "pagerduty.flux",
																		Source: "string(v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    component: obj.component,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100))",
																		Start: ast.Position{
																			Column: 39,
																			Line:   95,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 45,
																				Line:   95,
																			},
																			File:   "pagerduty.flux",
																			Source: "string",
																			Start: ast.Position{
																				Column: 39,
																				Line:   95,
																			},
																		},
																	},
																	Name: "string",
																},
															},
														}},
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 26,
																		Line:   95,
																	},
																	File:   "pagerduty.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 25,
																		Line:   95,
																	},
																},
															},
															Name: "r",
														},
													},
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 27,
																Line:   108,
															},
															File:   "pagerduty.flux",
															Source: "return {r with _sent: string(v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    component: obj.component,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100))}",
															Start: ast.Position{
																Column: 17,
																Line:   95,
															},
														},
													},
												}},
											},
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   92,
														},
														File:   "pagerduty.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   92,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 26,
																Line:   92,
															},
															File:   "pagerduty.flux",
															Source: "r",
															Start: ast.Position{
																Column: 25,
																Line:   92,
															},
														},
													},
													Name: "r",
												},
												Value: nil,
											}},
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   109,
										},
										File:   "pagerduty.flux",
										Source: "map(fn: (r) => {\n                obj = mapFn(r: r)\n                \n                return {r with _sent: string(v: 2 == (sendEvent(pagerdutyURL: url,\n                    routingKey: obj.routingKey,\n                    client: obj.client,\n                    clientURL: obj.clientURL,\n                    dedupKey: r._pagerdutyDedupKey,\n                    class: obj.class,\n                    group: obj.group,\n                    severity: obj.severity,\n                    eventAction: obj.eventAction,\n                    component: obj.component,\n                    source: obj.source,\n                    summary: obj.summary,\n                    timestamp: obj.timestamp,\n                ) / 100))}\n            })",
										Start: ast.Position{
											Column: 16,
											Line:   92,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   92,
											},
											File:   "pagerduty.flux",
											Source: "map",
											Start: ast.Position{
												Column: 16,
												Line:   92,
											},
										},
									},
									Name: "map",
								},
							},
						},
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   90,
									},
									File:   "pagerduty.flux",
									Source: "tables=<-",
									Start: ast.Position{
										Column: 10,
										Line:   90,
									},
								},
							},
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   90,
										},
										File:   "pagerduty.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 10,
											Line:   90,
										},
									},
								},
								Name: "tables",
							},
							Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   90,
									},
									File:   "pagerduty.flux",
									Source: "<-",
									Start: ast.Position{
										Column: 17,
										Line:   90,
									},
								},
							}},
						}},
					},
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   89,
								},
								File:   "pagerduty.flux",
								Source: "mapFn",
								Start: ast.Position{
									Column: 6,
									Line:   89,
								},
							},
						},
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   89,
									},
									File:   "pagerduty.flux",
									Source: "mapFn",
									Start: ast.Position{
										Column: 6,
										Line:   89,
									},
								},
							},
							Name: "mapFn",
						},
						Value: nil,
					}},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   88,
							},
							File:   "pagerduty.flux",
							Source: "url=defaultURL",
							Start: ast.Position{
								Column: 13,
								Line:   88,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   88,
								},
								File:   "pagerduty.flux",
								Source: "url",
								Start: ast.Position{
									Column: 13,
									Line:   88,
								},
							},
						},
						Name: "url",
					},
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   88,
								},
								File:   "pagerduty.flux",
								Source: "defaultURL",
								Start: ast.Position{
									Column: 17,
									Line:   88,
								},
							},
						},
						Name: "defaultURL",
					},
				}},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   3,
					},
					File:   "pagerduty.flux",
					Source: "import \"http\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   3,
						},
						File:   "pagerduty.flux",
						Source: "\"http\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "http",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "pagerduty.flux",
					Source: "import \"json\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "pagerduty.flux",
						Source: "\"json\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "json",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   5,
					},
					File:   "pagerduty.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   5,
						},
						File:   "pagerduty.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "strings",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "pagerduty.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "pagerduty.flux",
					Source: "package pagerduty",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "pagerduty.flux",
						Source: "pagerduty",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pagerduty",
			},
		},
	}},
	Package: "pagerduty",
	Path:    "pagerduty",
}
