package enterpriseknowledgegraphservice

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/enterpriseknowledgegraphservice/2018-12-03/enterpriseknowledgegraphservice"

// EnterpriseKnowledgeGraph enterpriseKnowledgeGraph resource definition
type EnterpriseKnowledgeGraph struct {
	autorest.Response `json:"-"`
	// Properties - The set of properties specific to EnterpriseKnowledgeGraph resource
	Properties *EnterpriseKnowledgeGraphProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Specifies the name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Specifies the type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - Specifies the location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags"`
	// Sku - Gets or sets the SKU of the resource.
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for EnterpriseKnowledgeGraph.
func (ekg EnterpriseKnowledgeGraph) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ekg.Properties != nil {
		objectMap["properties"] = ekg.Properties
	}
	if ekg.Location != nil {
		objectMap["location"] = ekg.Location
	}
	if ekg.Tags != nil {
		objectMap["tags"] = ekg.Tags
	}
	if ekg.Sku != nil {
		objectMap["sku"] = ekg.Sku
	}
	return json.Marshal(objectMap)
}

// EnterpriseKnowledgeGraphProperties the parameters to provide for the EnterpriseKnowledgeGraph.
type EnterpriseKnowledgeGraphProperties struct {
	// Description - The description of the EnterpriseKnowledgeGraph
	Description *string `json:"description,omitempty"`
	// Metadata - Specifies the metadata  of the resource.
	Metadata interface{} `json:"metadata,omitempty"`
	// ProvisioningState - The state of EnterpriseKnowledgeGraph provisioning. Possible values include: 'Creating', 'Deleting', 'Failed', 'Succeeded'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// EnterpriseKnowledgeGraphResponseList the list of  EnterpriseKnowledgeGraph service operation response.
type EnterpriseKnowledgeGraphResponseList struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of EnterpriseKnowledgeGraph service resources.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - READ-ONLY; Gets the list of EnterpriseKnowledgeGraph service results and their properties.
	Value *[]EnterpriseKnowledgeGraph `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for EnterpriseKnowledgeGraphResponseList.
func (ekgrl EnterpriseKnowledgeGraphResponseList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ekgrl.NextLink != nil {
		objectMap["nextLink"] = ekgrl.NextLink
	}
	return json.Marshal(objectMap)
}

// EnterpriseKnowledgeGraphResponseListIterator provides access to a complete listing of
// EnterpriseKnowledgeGraph values.
type EnterpriseKnowledgeGraphResponseListIterator struct {
	i    int
	page EnterpriseKnowledgeGraphResponseListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EnterpriseKnowledgeGraphResponseListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EnterpriseKnowledgeGraphResponseListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EnterpriseKnowledgeGraphResponseListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EnterpriseKnowledgeGraphResponseListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EnterpriseKnowledgeGraphResponseListIterator) Response() EnterpriseKnowledgeGraphResponseList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EnterpriseKnowledgeGraphResponseListIterator) Value() EnterpriseKnowledgeGraph {
	if !iter.page.NotDone() {
		return EnterpriseKnowledgeGraph{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EnterpriseKnowledgeGraphResponseListIterator type.
func NewEnterpriseKnowledgeGraphResponseListIterator(page EnterpriseKnowledgeGraphResponseListPage) EnterpriseKnowledgeGraphResponseListIterator {
	return EnterpriseKnowledgeGraphResponseListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ekgrl EnterpriseKnowledgeGraphResponseList) IsEmpty() bool {
	return ekgrl.Value == nil || len(*ekgrl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ekgrl EnterpriseKnowledgeGraphResponseList) hasNextLink() bool {
	return ekgrl.NextLink != nil && len(*ekgrl.NextLink) != 0
}

// enterpriseKnowledgeGraphResponseListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ekgrl EnterpriseKnowledgeGraphResponseList) enterpriseKnowledgeGraphResponseListPreparer(ctx context.Context) (*http.Request, error) {
	if !ekgrl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ekgrl.NextLink)))
}

// EnterpriseKnowledgeGraphResponseListPage contains a page of EnterpriseKnowledgeGraph values.
type EnterpriseKnowledgeGraphResponseListPage struct {
	fn    func(context.Context, EnterpriseKnowledgeGraphResponseList) (EnterpriseKnowledgeGraphResponseList, error)
	ekgrl EnterpriseKnowledgeGraphResponseList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EnterpriseKnowledgeGraphResponseListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EnterpriseKnowledgeGraphResponseListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ekgrl)
		if err != nil {
			return err
		}
		page.ekgrl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EnterpriseKnowledgeGraphResponseListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EnterpriseKnowledgeGraphResponseListPage) NotDone() bool {
	return !page.ekgrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EnterpriseKnowledgeGraphResponseListPage) Response() EnterpriseKnowledgeGraphResponseList {
	return page.ekgrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EnterpriseKnowledgeGraphResponseListPage) Values() []EnterpriseKnowledgeGraph {
	if page.ekgrl.IsEmpty() {
		return nil
	}
	return *page.ekgrl.Value
}

// Creates a new instance of the EnterpriseKnowledgeGraphResponseListPage type.
func NewEnterpriseKnowledgeGraphResponseListPage(cur EnterpriseKnowledgeGraphResponseList, getNextPage func(context.Context, EnterpriseKnowledgeGraphResponseList) (EnterpriseKnowledgeGraphResponseList, error)) EnterpriseKnowledgeGraphResponseListPage {
	return EnterpriseKnowledgeGraphResponseListPage{
		fn:    getNextPage,
		ekgrl: cur,
	}
}

// Error enterpriseKnowledgeGraph Service error object.
type Error struct {
	// Error - The error body.
	Error *ErrorBody `json:"error,omitempty"`
}

// ErrorBody enterpriseKnowledgeGraph Service error body.
type ErrorBody struct {
	// Code - error code
	Code *string `json:"code,omitempty"`
	// Message - error message
	Message *string `json:"message,omitempty"`
}

// OperationDisplayInfo the operation supported by EnterpriseKnowledgeGraph Service Management.
type OperationDisplayInfo struct {
	// Description - The description of the operation.
	Description *string `json:"description,omitempty"`
	// Operation - The action that users can perform, based on their permission level.
	Operation *string `json:"operation,omitempty"`
	// Provider - Service provider: Microsoft EnterpriseKnowledgeGraph Service.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// OperationEntity the operations supported by EnterpriseKnowledgeGraph Service Management.
type OperationEntity struct {
	// Name - Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`
	// Display - The operation supported by EnterpriseKnowledgeGraph Service Management.
	Display *OperationDisplayInfo `json:"display,omitempty"`
	// Origin - The origin of the operation.
	Origin *string `json:"origin,omitempty"`
	// Properties - Additional properties.
	Properties interface{} `json:"properties,omitempty"`
}

// OperationEntityListResult the list of EnterpriseKnowledgeGraph service operation response.
type OperationEntityListResult struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of operations.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - The list of operations.
	Value *[]OperationEntity `json:"value,omitempty"`
}

// OperationEntityListResultIterator provides access to a complete listing of OperationEntity values.
type OperationEntityListResultIterator struct {
	i    int
	page OperationEntityListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationEntityListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationEntityListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationEntityListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationEntityListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationEntityListResultIterator) Response() OperationEntityListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationEntityListResultIterator) Value() OperationEntity {
	if !iter.page.NotDone() {
		return OperationEntity{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationEntityListResultIterator type.
func NewOperationEntityListResultIterator(page OperationEntityListResultPage) OperationEntityListResultIterator {
	return OperationEntityListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (oelr OperationEntityListResult) IsEmpty() bool {
	return oelr.Value == nil || len(*oelr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (oelr OperationEntityListResult) hasNextLink() bool {
	return oelr.NextLink != nil && len(*oelr.NextLink) != 0
}

// operationEntityListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (oelr OperationEntityListResult) operationEntityListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !oelr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(oelr.NextLink)))
}

// OperationEntityListResultPage contains a page of OperationEntity values.
type OperationEntityListResultPage struct {
	fn   func(context.Context, OperationEntityListResult) (OperationEntityListResult, error)
	oelr OperationEntityListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationEntityListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationEntityListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.oelr)
		if err != nil {
			return err
		}
		page.oelr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationEntityListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationEntityListResultPage) NotDone() bool {
	return !page.oelr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationEntityListResultPage) Response() OperationEntityListResult {
	return page.oelr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationEntityListResultPage) Values() []OperationEntity {
	if page.oelr.IsEmpty() {
		return nil
	}
	return *page.oelr.Value
}

// Creates a new instance of the OperationEntityListResultPage type.
func NewOperationEntityListResultPage(cur OperationEntityListResult, getNextPage func(context.Context, OperationEntityListResult) (OperationEntityListResult, error)) OperationEntityListResultPage {
	return OperationEntityListResultPage{
		fn:   getNextPage,
		oelr: cur,
	}
}

// Resource azure resource
type Resource struct {
	// ID - READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Specifies the name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Specifies the type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - Specifies the location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags"`
	// Sku - Gets or sets the SKU of the resource.
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	if r.Sku != nil {
		objectMap["sku"] = r.Sku
	}
	return json.Marshal(objectMap)
}

// Sku the SKU of the EnterpriseKnowledgeGraph service account.
type Sku struct {
	// Name - The sku name. Possible values include: 'F0', 'S1'
	Name SkuName `json:"name,omitempty"`
}
