package localsearch

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// EntityScenario enumerates the values for entity scenario.
type EntityScenario string

const (
	// DisambiguationItem ...
	DisambiguationItem EntityScenario = "DisambiguationItem"
	// DominantEntity ...
	DominantEntity EntityScenario = "DominantEntity"
	// ListItem ...
	ListItem EntityScenario = "ListItem"
)

// PossibleEntityScenarioValues returns an array of possible values for the EntityScenario const type.
func PossibleEntityScenarioValues() []EntityScenario {
	return []EntityScenario{DisambiguationItem, DominantEntity, ListItem}
}

// EntityType enumerates the values for entity type.
type EntityType string

const (
	// EntityTypeHotel ...
	EntityTypeHotel EntityType = "Hotel"
	// EntityTypeLocalBusiness ...
	EntityTypeLocalBusiness EntityType = "LocalBusiness"
	// EntityTypePlace ...
	EntityTypePlace EntityType = "Place"
	// EntityTypeRestaurant ...
	EntityTypeRestaurant EntityType = "Restaurant"
)

// PossibleEntityTypeValues returns an array of possible values for the EntityType const type.
func PossibleEntityTypeValues() []EntityType {
	return []EntityType{EntityTypeHotel, EntityTypeLocalBusiness, EntityTypePlace, EntityTypeRestaurant}
}

// ErrorCode enumerates the values for error code.
type ErrorCode string

const (
	// InsufficientAuthorization ...
	InsufficientAuthorization ErrorCode = "InsufficientAuthorization"
	// InvalidAuthorization ...
	InvalidAuthorization ErrorCode = "InvalidAuthorization"
	// InvalidRequest ...
	InvalidRequest ErrorCode = "InvalidRequest"
	// None ...
	None ErrorCode = "None"
	// RateLimitExceeded ...
	RateLimitExceeded ErrorCode = "RateLimitExceeded"
	// ServerError ...
	ServerError ErrorCode = "ServerError"
)

// PossibleErrorCodeValues returns an array of possible values for the ErrorCode const type.
func PossibleErrorCodeValues() []ErrorCode {
	return []ErrorCode{InsufficientAuthorization, InvalidAuthorization, InvalidRequest, None, RateLimitExceeded, ServerError}
}

// ErrorSubCode enumerates the values for error sub code.
type ErrorSubCode string

const (
	// AuthorizationDisabled ...
	AuthorizationDisabled ErrorSubCode = "AuthorizationDisabled"
	// AuthorizationExpired ...
	AuthorizationExpired ErrorSubCode = "AuthorizationExpired"
	// AuthorizationMissing ...
	AuthorizationMissing ErrorSubCode = "AuthorizationMissing"
	// AuthorizationRedundancy ...
	AuthorizationRedundancy ErrorSubCode = "AuthorizationRedundancy"
	// Blocked ...
	Blocked ErrorSubCode = "Blocked"
	// HTTPNotAllowed ...
	HTTPNotAllowed ErrorSubCode = "HttpNotAllowed"
	// NotImplemented ...
	NotImplemented ErrorSubCode = "NotImplemented"
	// ParameterInvalidValue ...
	ParameterInvalidValue ErrorSubCode = "ParameterInvalidValue"
	// ParameterMissing ...
	ParameterMissing ErrorSubCode = "ParameterMissing"
	// ResourceError ...
	ResourceError ErrorSubCode = "ResourceError"
	// UnexpectedError ...
	UnexpectedError ErrorSubCode = "UnexpectedError"
)

// PossibleErrorSubCodeValues returns an array of possible values for the ErrorSubCode const type.
func PossibleErrorSubCodeValues() []ErrorSubCode {
	return []ErrorSubCode{AuthorizationDisabled, AuthorizationExpired, AuthorizationMissing, AuthorizationRedundancy, Blocked, HTTPNotAllowed, NotImplemented, ParameterInvalidValue, ParameterMissing, ResourceError, UnexpectedError}
}

// ResponseFormat enumerates the values for response format.
type ResponseFormat string

const (
	// JSON ...
	JSON ResponseFormat = "Json"
	// JSONLd ...
	JSONLd ResponseFormat = "JsonLd"
)

// PossibleResponseFormatValues returns an array of possible values for the ResponseFormat const type.
func PossibleResponseFormatValues() []ResponseFormat {
	return []ResponseFormat{JSON, JSONLd}
}

// SafeSearch enumerates the values for safe search.
type SafeSearch string

const (
	// Moderate ...
	Moderate SafeSearch = "Moderate"
	// Off ...
	Off SafeSearch = "Off"
	// Strict ...
	Strict SafeSearch = "Strict"
)

// PossibleSafeSearchValues returns an array of possible values for the SafeSearch const type.
func PossibleSafeSearchValues() []SafeSearch {
	return []SafeSearch{Moderate, Off, Strict}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeQueryContext ...
	TypeQueryContext Type = "QueryContext"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeQueryContext}
}

// TypeBasicEntitiesEntityPresentationInfo enumerates the values for type basic entities entity presentation
// info.
type TypeBasicEntitiesEntityPresentationInfo string

const (
	// TypeEntitiesEntityPresentationInfo ...
	TypeEntitiesEntityPresentationInfo TypeBasicEntitiesEntityPresentationInfo = "Entities/EntityPresentationInfo"
)

// PossibleTypeBasicEntitiesEntityPresentationInfoValues returns an array of possible values for the TypeBasicEntitiesEntityPresentationInfo const type.
func PossibleTypeBasicEntitiesEntityPresentationInfoValues() []TypeBasicEntitiesEntityPresentationInfo {
	return []TypeBasicEntitiesEntityPresentationInfo{TypeEntitiesEntityPresentationInfo}
}

// TypeBasicError enumerates the values for type basic error.
type TypeBasicError string

const (
	// TypeError ...
	TypeError TypeBasicError = "Error"
)

// PossibleTypeBasicErrorValues returns an array of possible values for the TypeBasicError const type.
func PossibleTypeBasicErrorValues() []TypeBasicError {
	return []TypeBasicError{TypeError}
}

// TypeBasicGeoCoordinates enumerates the values for type basic geo coordinates.
type TypeBasicGeoCoordinates string

const (
	// TypeGeoCoordinates ...
	TypeGeoCoordinates TypeBasicGeoCoordinates = "GeoCoordinates"
)

// PossibleTypeBasicGeoCoordinatesValues returns an array of possible values for the TypeBasicGeoCoordinates const type.
func PossibleTypeBasicGeoCoordinatesValues() []TypeBasicGeoCoordinates {
	return []TypeBasicGeoCoordinates{TypeGeoCoordinates}
}

// TypeBasicResponseBase enumerates the values for type basic response base.
type TypeBasicResponseBase string

const (
	// TypeAction ...
	TypeAction TypeBasicResponseBase = "Action"
	// TypeAnswer ...
	TypeAnswer TypeBasicResponseBase = "Answer"
	// TypeCreativeWork ...
	TypeCreativeWork TypeBasicResponseBase = "CreativeWork"
	// TypeErrorResponse ...
	TypeErrorResponse TypeBasicResponseBase = "ErrorResponse"
	// TypeIdentifiable ...
	TypeIdentifiable TypeBasicResponseBase = "Identifiable"
	// TypeIntangible ...
	TypeIntangible TypeBasicResponseBase = "Intangible"
	// TypePlace ...
	TypePlace TypeBasicResponseBase = "Place"
	// TypePlaces ...
	TypePlaces TypeBasicResponseBase = "Places"
	// TypePostalAddress ...
	TypePostalAddress TypeBasicResponseBase = "PostalAddress"
	// TypeResponse ...
	TypeResponse TypeBasicResponseBase = "Response"
	// TypeResponseBase ...
	TypeResponseBase TypeBasicResponseBase = "ResponseBase"
	// TypeSearchAction ...
	TypeSearchAction TypeBasicResponseBase = "SearchAction"
	// TypeSearchResponse ...
	TypeSearchResponse TypeBasicResponseBase = "SearchResponse"
	// TypeSearchResultsAnswer ...
	TypeSearchResultsAnswer TypeBasicResponseBase = "SearchResultsAnswer"
	// TypeStructuredValue ...
	TypeStructuredValue TypeBasicResponseBase = "StructuredValue"
	// TypeThing ...
	TypeThing TypeBasicResponseBase = "Thing"
)

// PossibleTypeBasicResponseBaseValues returns an array of possible values for the TypeBasicResponseBase const type.
func PossibleTypeBasicResponseBaseValues() []TypeBasicResponseBase {
	return []TypeBasicResponseBase{TypeAction, TypeAnswer, TypeCreativeWork, TypeErrorResponse, TypeIdentifiable, TypeIntangible, TypePlace, TypePlaces, TypePostalAddress, TypeResponse, TypeResponseBase, TypeSearchAction, TypeSearchResponse, TypeSearchResultsAnswer, TypeStructuredValue, TypeThing}
}
