package apimanagement

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/apimanagement/mgmt/2016-07-07/apimanagement"

// AccessInformationContract tenant access information contract of the API Management service.
type AccessInformationContract struct {
	autorest.Response `json:"-"`
	// ID - Identifier.
	ID *string `json:"id,omitempty"`
	// PrimaryKey - Primary access key.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - Secondary access key.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// Enabled - Tenant access information of the API Management service.
	Enabled *bool `json:"enabled,omitempty"`
}

// AccessInformationUpdateParameters tenant access information update parameters of the API Management
// service.
type AccessInformationUpdateParameters struct {
	// Enabled - Tenant access information of the API Management service.
	Enabled *bool `json:"enabled,omitempty"`
}

// AdditionalRegion description of an additional API Management resource location.
type AdditionalRegion struct {
	// Location - The location name of the additional region among Azure Data center regions.
	Location *string `json:"location,omitempty"`
	// SkuType - The SKU type in the location. Possible values include: 'Developer', 'Standard', 'Premium'
	SkuType SkuType `json:"skuType,omitempty"`
	// SkuUnitCount - The SKU Unit count at the location. The maximum SKU Unit count depends on the SkuType. Maximum allowed for Developer SKU is 1, for Standard SKU is 4, and for Premium SKU is 10, at a location.
	SkuUnitCount *int32 `json:"skuUnitCount,omitempty"`
	// StaticIPs - READ-ONLY; Static IP addresses of the location's virtual machines.
	StaticIPs *[]string `json:"staticIPs,omitempty"`
	// Vpnconfiguration - Virtual network configuration for the location.
	Vpnconfiguration *VirtualNetworkConfiguration `json:"vpnconfiguration,omitempty"`
}

// MarshalJSON is the custom marshaler for AdditionalRegion.
func (ar AdditionalRegion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ar.Location != nil {
		objectMap["location"] = ar.Location
	}
	if ar.SkuType != "" {
		objectMap["skuType"] = ar.SkuType
	}
	if ar.SkuUnitCount != nil {
		objectMap["skuUnitCount"] = ar.SkuUnitCount
	}
	if ar.Vpnconfiguration != nil {
		objectMap["vpnconfiguration"] = ar.Vpnconfiguration
	}
	return json.Marshal(objectMap)
}

// APICollection paged Api list representation.
type APICollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]APIContract `json:"value,omitempty"`
	// Count - Total records count number.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// APICollectionIterator provides access to a complete listing of APIContract values.
type APICollectionIterator struct {
	i    int
	page APICollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *APICollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/APICollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *APICollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter APICollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter APICollectionIterator) Response() APICollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter APICollectionIterator) Value() APIContract {
	if !iter.page.NotDone() {
		return APIContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the APICollectionIterator type.
func NewAPICollectionIterator(page APICollectionPage) APICollectionIterator {
	return APICollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ac APICollection) IsEmpty() bool {
	return ac.Value == nil || len(*ac.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ac APICollection) hasNextLink() bool {
	return ac.NextLink != nil && len(*ac.NextLink) != 0
}

// aPICollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ac APICollection) aPICollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !ac.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ac.NextLink)))
}

// APICollectionPage contains a page of APIContract values.
type APICollectionPage struct {
	fn func(context.Context, APICollection) (APICollection, error)
	ac APICollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *APICollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/APICollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ac)
		if err != nil {
			return err
		}
		page.ac = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *APICollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page APICollectionPage) NotDone() bool {
	return !page.ac.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page APICollectionPage) Response() APICollection {
	return page.ac
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page APICollectionPage) Values() []APIContract {
	if page.ac.IsEmpty() {
		return nil
	}
	return *page.ac.Value
}

// Creates a new instance of the APICollectionPage type.
func NewAPICollectionPage(cur APICollection, getNextPage func(context.Context, APICollection) (APICollection, error)) APICollectionPage {
	return APICollectionPage{
		fn: getNextPage,
		ac: cur,
	}
}

// APIContract API details.
type APIContract struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; API identifier path: /apis/{apiId}
	ID *string `json:"id,omitempty"`
	// Name - API name.
	Name *string `json:"name,omitempty"`
	// Description - Description of the API. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// ServiceURL - Absolute URL of the backend service implementing this API.
	ServiceURL *string `json:"serviceUrl,omitempty"`
	// Path - Relative URL uniquely identifying this API and all of its resource paths within the API Management service instance. It is appended to the API endpoint base URL specified during the service instance creation to form a public URL for this API.
	Path *string `json:"path,omitempty"`
	// Protocols - Describes on which protocols the operations in this API can be invoked.
	Protocols *[]APIProtocolContract `json:"protocols,omitempty"`
	// AuthenticationSettings - Collection of authentication settings included into this API.
	AuthenticationSettings *AuthenticationSettingsContract `json:"authenticationSettings,omitempty"`
	// SubscriptionKeyParameterNames - Protocols over which API is made available.
	SubscriptionKeyParameterNames *SubscriptionKeyParameterNamesContract `json:"subscriptionKeyParameterNames,omitempty"`
	// Type - Type of API. Possible values include: 'APITypeContractHTTP', 'APITypeContractSoap'
	Type APITypeContract `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for APIContract.
func (ac APIContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ac.Name != nil {
		objectMap["name"] = ac.Name
	}
	if ac.Description != nil {
		objectMap["description"] = ac.Description
	}
	if ac.ServiceURL != nil {
		objectMap["serviceUrl"] = ac.ServiceURL
	}
	if ac.Path != nil {
		objectMap["path"] = ac.Path
	}
	if ac.Protocols != nil {
		objectMap["protocols"] = ac.Protocols
	}
	if ac.AuthenticationSettings != nil {
		objectMap["authenticationSettings"] = ac.AuthenticationSettings
	}
	if ac.SubscriptionKeyParameterNames != nil {
		objectMap["subscriptionKeyParameterNames"] = ac.SubscriptionKeyParameterNames
	}
	if ac.Type != "" {
		objectMap["type"] = ac.Type
	}
	return json.Marshal(objectMap)
}

// APIExportResult the response model for the export API output operation.
type APIExportResult struct {
	autorest.Response `json:"-"`
	// Content - Response content bytes.
	Content *[]byte `json:"content,omitempty"`
	// StatusCode - Possible values include: 'Continue', 'OK', 'Created', 'Accepted', 'NotFound', 'Conflict'
	StatusCode HTTPStatusCode `json:"statusCode,omitempty"`
	RequestID  *string        `json:"requestId,omitempty"`
}

// AuthenticationSettingsContract API Authentication Settings.
type AuthenticationSettingsContract struct {
	OAuth2 *OAuth2AuthenticationSettingsContract `json:"oAuth2,omitempty"`
}

// AuthorizationServerCollection paged OAuth2 Authorization Servers list representation.
type AuthorizationServerCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]OAuth2AuthorizationServerContract `json:"value,omitempty"`
	// Count - Total records count number.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// AuthorizationServerCollectionIterator provides access to a complete listing of
// OAuth2AuthorizationServerContract values.
type AuthorizationServerCollectionIterator struct {
	i    int
	page AuthorizationServerCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AuthorizationServerCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AuthorizationServerCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AuthorizationServerCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AuthorizationServerCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AuthorizationServerCollectionIterator) Response() AuthorizationServerCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AuthorizationServerCollectionIterator) Value() OAuth2AuthorizationServerContract {
	if !iter.page.NotDone() {
		return OAuth2AuthorizationServerContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AuthorizationServerCollectionIterator type.
func NewAuthorizationServerCollectionIterator(page AuthorizationServerCollectionPage) AuthorizationServerCollectionIterator {
	return AuthorizationServerCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (asc AuthorizationServerCollection) IsEmpty() bool {
	return asc.Value == nil || len(*asc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (asc AuthorizationServerCollection) hasNextLink() bool {
	return asc.NextLink != nil && len(*asc.NextLink) != 0
}

// authorizationServerCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (asc AuthorizationServerCollection) authorizationServerCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !asc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(asc.NextLink)))
}

// AuthorizationServerCollectionPage contains a page of OAuth2AuthorizationServerContract values.
type AuthorizationServerCollectionPage struct {
	fn  func(context.Context, AuthorizationServerCollection) (AuthorizationServerCollection, error)
	asc AuthorizationServerCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AuthorizationServerCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AuthorizationServerCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.asc)
		if err != nil {
			return err
		}
		page.asc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AuthorizationServerCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AuthorizationServerCollectionPage) NotDone() bool {
	return !page.asc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AuthorizationServerCollectionPage) Response() AuthorizationServerCollection {
	return page.asc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AuthorizationServerCollectionPage) Values() []OAuth2AuthorizationServerContract {
	if page.asc.IsEmpty() {
		return nil
	}
	return *page.asc.Value
}

// Creates a new instance of the AuthorizationServerCollectionPage type.
func NewAuthorizationServerCollectionPage(cur AuthorizationServerCollection, getNextPage func(context.Context, AuthorizationServerCollection) (AuthorizationServerCollection, error)) AuthorizationServerCollectionPage {
	return AuthorizationServerCollectionPage{
		fn:  getNextPage,
		asc: cur,
	}
}

// BackendCollection paged Backend list representation.
type BackendCollection struct {
	autorest.Response `json:"-"`
	// Value - Backend values.
	Value *[]BackendResponse `json:"value,omitempty"`
	// Count - Total records count number.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// BackendCollectionIterator provides access to a complete listing of BackendResponse values.
type BackendCollectionIterator struct {
	i    int
	page BackendCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BackendCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BackendCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BackendCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BackendCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BackendCollectionIterator) Response() BackendCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BackendCollectionIterator) Value() BackendResponse {
	if !iter.page.NotDone() {
		return BackendResponse{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BackendCollectionIterator type.
func NewBackendCollectionIterator(page BackendCollectionPage) BackendCollectionIterator {
	return BackendCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bc BackendCollection) IsEmpty() bool {
	return bc.Value == nil || len(*bc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (bc BackendCollection) hasNextLink() bool {
	return bc.NextLink != nil && len(*bc.NextLink) != 0
}

// backendCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bc BackendCollection) backendCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !bc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bc.NextLink)))
}

// BackendCollectionPage contains a page of BackendResponse values.
type BackendCollectionPage struct {
	fn func(context.Context, BackendCollection) (BackendCollection, error)
	bc BackendCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BackendCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BackendCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.bc)
		if err != nil {
			return err
		}
		page.bc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BackendCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BackendCollectionPage) NotDone() bool {
	return !page.bc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BackendCollectionPage) Response() BackendCollection {
	return page.bc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BackendCollectionPage) Values() []BackendResponse {
	if page.bc.IsEmpty() {
		return nil
	}
	return *page.bc.Value
}

// Creates a new instance of the BackendCollectionPage type.
func NewBackendCollectionPage(cur BackendCollection, getNextPage func(context.Context, BackendCollection) (BackendCollection, error)) BackendCollectionPage {
	return BackendCollectionPage{
		fn: getNextPage,
		bc: cur,
	}
}

// BackendContract parameters supplied to the Create Backend operation.
type BackendContract struct {
	// Host - Host attribute of the backend. Host is a pure hostname without a port or suffix, for example backend.contoso.com. Must not be empty.
	Host *string `json:"host,omitempty"`
	// SkipCertificateChainValidation - Flag indicating whether SSL certificate chain validation should be skipped when using self-signed certificates for this backend host.
	SkipCertificateChainValidation *bool `json:"skipCertificateChainValidation,omitempty"`
}

// BackendResponse the Backend entity in API Management represents a backend service that is configured to
// skip certification chain validation when using a self-signed certificate to test mutual certificate
// authentication.
type BackendResponse struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Uniquely identifies the backend within the current API Management service instance. The value is a valid relative URL in the format of /backends/{backendId} where {backendId} is a backend identifier.
	ID *string `json:"id,omitempty"`
	// Host - Host attribute of the backend. Host is a pure hostname without a port or suffix, for example backend.contoso.com. Must not be empty.
	Host *string `json:"host,omitempty"`
	// SkipCertificateChainValidation - Flag indicating whether SSL certificate chain validation should be skipped when using self-signed certificates for this backend host.
	SkipCertificateChainValidation *bool `json:"skipCertificateChainValidation,omitempty"`
}

// MarshalJSON is the custom marshaler for BackendResponse.
func (br BackendResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if br.Host != nil {
		objectMap["host"] = br.Host
	}
	if br.SkipCertificateChainValidation != nil {
		objectMap["skipCertificateChainValidation"] = br.SkipCertificateChainValidation
	}
	return json.Marshal(objectMap)
}

// BackendUpdateParameters parameters supplied to the Update Backend operation.
type BackendUpdateParameters struct {
	// Host - Host attribute of the backend. Host is a pure hostname without a port or suffix, for example backend.contoso.com. Must not be empty.
	Host *string `json:"host,omitempty"`
	// SkipCertificateChainValidation - Flag indicating whether SSL certificate chain validation should be skipped when using self-signed certificates for this backend host.
	SkipCertificateChainValidation *bool `json:"skipCertificateChainValidation,omitempty"`
}

// CertificateCollection paged Certificates list representation.
type CertificateCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]CertificateContract `json:"value,omitempty"`
	// Count - Total records count number.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// CertificateCollectionIterator provides access to a complete listing of CertificateContract values.
type CertificateCollectionIterator struct {
	i    int
	page CertificateCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CertificateCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CertificateCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CertificateCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CertificateCollectionIterator) Response() CertificateCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CertificateCollectionIterator) Value() CertificateContract {
	if !iter.page.NotDone() {
		return CertificateContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CertificateCollectionIterator type.
func NewCertificateCollectionIterator(page CertificateCollectionPage) CertificateCollectionIterator {
	return CertificateCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cc CertificateCollection) IsEmpty() bool {
	return cc.Value == nil || len(*cc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cc CertificateCollection) hasNextLink() bool {
	return cc.NextLink != nil && len(*cc.NextLink) != 0
}

// certificateCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cc CertificateCollection) certificateCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !cc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cc.NextLink)))
}

// CertificateCollectionPage contains a page of CertificateContract values.
type CertificateCollectionPage struct {
	fn func(context.Context, CertificateCollection) (CertificateCollection, error)
	cc CertificateCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CertificateCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cc)
		if err != nil {
			return err
		}
		page.cc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CertificateCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CertificateCollectionPage) NotDone() bool {
	return !page.cc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CertificateCollectionPage) Response() CertificateCollection {
	return page.cc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CertificateCollectionPage) Values() []CertificateContract {
	if page.cc.IsEmpty() {
		return nil
	}
	return *page.cc.Value
}

// Creates a new instance of the CertificateCollectionPage type.
func NewCertificateCollectionPage(cur CertificateCollection, getNextPage func(context.Context, CertificateCollection) (CertificateCollection, error)) CertificateCollectionPage {
	return CertificateCollectionPage{
		fn: getNextPage,
		cc: cur,
	}
}

// CertificateContract certificate details.
type CertificateContract struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Certificate identifier path: /certificates/{certificateId}
	ID *string `json:"id,omitempty"`
	// Subject - Subject attribute of the certificate.
	Subject *string `json:"subject,omitempty"`
	// Thumbprint - Thumbprint of the certificate.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// ExpirationDate - Expiration date of the certificate. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificateContract.
func (cc CertificateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cc.Subject != nil {
		objectMap["subject"] = cc.Subject
	}
	if cc.Thumbprint != nil {
		objectMap["thumbprint"] = cc.Thumbprint
	}
	if cc.ExpirationDate != nil {
		objectMap["expirationDate"] = cc.ExpirationDate
	}
	return json.Marshal(objectMap)
}

// CertificateCreateOrUpdateParameters parameters supplied to the CreateOrUpdate certificate operation.
type CertificateCreateOrUpdateParameters struct {
	// Data - Base 64 encoded certificate using the application/x-pkcs12 representation.
	Data *string `json:"data,omitempty"`
	// Password - Password for the Certificate
	Password *string `json:"password,omitempty"`
}

// CertificateInformation SSL certificate information.
type CertificateInformation struct {
	autorest.Response `json:"-"`
	// Expiry - Expiration date of the certificate. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	Expiry *date.Time `json:"expiry,omitempty"`
	// Thumbprint - Thumbprint of the certificate.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// Subject - Subject of the certificate.
	Subject *string `json:"subject,omitempty"`
}

// DeployConfigurationParameters parameters supplied to the Deploy Configuration operation.
type DeployConfigurationParameters struct {
	// Branch - The name of the Git branch from which the configuration is to be deployed to the configuration database.
	Branch *string `json:"branch,omitempty"`
	// Force - The value enforcing deleting subscriptions to products that are deleted in this update.
	Force *bool `json:"force,omitempty"`
}

// ErrorBodyContract error Body contract.
type ErrorBodyContract struct {
	autorest.Response `json:"-"`
	// Code - Service-defined error code. This code serves as a sub-status for the HTTP error code specified in the response.
	Code *string `json:"code,omitempty"`
	// Message - Human-readable representation of the error.
	Message *string `json:"message,omitempty"`
	// Details - The list of invalid fields send in request, in case of validation error.
	Details *[]ErrorFieldContract `json:"details,omitempty"`
}

// ErrorFieldContract error Field contract.
type ErrorFieldContract struct {
	// Code - Property level error code.
	Code *string `json:"code,omitempty"`
	// Message - Human-readable representation of property-level error.
	Message *string `json:"message,omitempty"`
	// Target - Property name.
	Target *string `json:"target,omitempty"`
}

// ErrorResponse error Response.
type ErrorResponse struct {
	autorest.Response `json:"-"`
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// GenerateSsoURLResult generate SSO Url operations response details.
type GenerateSsoURLResult struct {
	autorest.Response `json:"-"`
	// Value - Redirect Url containing the SSO URL value.
	Value *string `json:"value,omitempty"`
}

// GroupCollection paged Group list representation.
type GroupCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]GroupContract `json:"value,omitempty"`
	// Count - Total records count number.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// GroupCollectionIterator provides access to a complete listing of GroupContract values.
type GroupCollectionIterator struct {
	i    int
	page GroupCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GroupCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GroupCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *GroupCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GroupCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GroupCollectionIterator) Response() GroupCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GroupCollectionIterator) Value() GroupContract {
	if !iter.page.NotDone() {
		return GroupContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the GroupCollectionIterator type.
func NewGroupCollectionIterator(page GroupCollectionPage) GroupCollectionIterator {
	return GroupCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (gc GroupCollection) IsEmpty() bool {
	return gc.Value == nil || len(*gc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (gc GroupCollection) hasNextLink() bool {
	return gc.NextLink != nil && len(*gc.NextLink) != 0
}

// groupCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (gc GroupCollection) groupCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !gc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(gc.NextLink)))
}

// GroupCollectionPage contains a page of GroupContract values.
type GroupCollectionPage struct {
	fn func(context.Context, GroupCollection) (GroupCollection, error)
	gc GroupCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GroupCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GroupCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.gc)
		if err != nil {
			return err
		}
		page.gc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *GroupCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GroupCollectionPage) NotDone() bool {
	return !page.gc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GroupCollectionPage) Response() GroupCollection {
	return page.gc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GroupCollectionPage) Values() []GroupContract {
	if page.gc.IsEmpty() {
		return nil
	}
	return *page.gc.Value
}

// Creates a new instance of the GroupCollectionPage type.
func NewGroupCollectionPage(cur GroupCollection, getNextPage func(context.Context, GroupCollection) (GroupCollection, error)) GroupCollectionPage {
	return GroupCollectionPage{
		fn: getNextPage,
		gc: cur,
	}
}

// GroupContract developer group.
type GroupContract struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Uniquely identifies the group within the current API Management service instance. The value is a valid relative URL in the format of /groups/{groupId} where {groupId} is a group identifier.
	ID *string `json:"id,omitempty"`
	// Name - Group name.
	Name *string `json:"name,omitempty"`
	// Description - Group description. Can contain HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// BuiltIn - READ-ONLY; true if the group is one of the three system groups (Administrators, Developers, or Guests); otherwise false.
	BuiltIn *bool `json:"builtIn,omitempty"`
	// Type - READ-ONLY; Group type. Possible values include: 'Custom', 'System', 'External'
	Type GroupTypeContract `json:"type,omitempty"`
	// ExternalID - READ-ONLY; For external groups, this property contains the id of the group from the external identity provider, e.g. Azure Active Directory; otherwise the value is null.
	ExternalID *string `json:"externalId,omitempty"`
}

// MarshalJSON is the custom marshaler for GroupContract.
func (gc GroupContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gc.Name != nil {
		objectMap["name"] = gc.Name
	}
	if gc.Description != nil {
		objectMap["description"] = gc.Description
	}
	return json.Marshal(objectMap)
}

// GroupCreateParameters parameters supplied to the Create Group operation.
type GroupCreateParameters struct {
	// Name - Group name.
	Name *string `json:"name,omitempty"`
	// Description - Group description.
	Description *string `json:"description,omitempty"`
	// Type - Group type. Possible values include: 'Custom', 'System', 'External'
	Type GroupTypeContract `json:"type,omitempty"`
	// ExternalID - Identifier for an external group.
	ExternalID *string `json:"externalId,omitempty"`
}

// GroupUpdateParameters parameters supplied to the Update Group operation.
type GroupUpdateParameters struct {
	// Name - Group name.
	Name *string `json:"name,omitempty"`
	// Description - Group description.
	Description *string `json:"description,omitempty"`
	// Type - Group type. Possible values include: 'Custom', 'System', 'External'
	Type GroupTypeContract `json:"type,omitempty"`
	// ExternalID - Identifier for an external group.
	ExternalID *string `json:"externalId,omitempty"`
}

// HostnameConfiguration custom hostname configuration.
type HostnameConfiguration struct {
	// Type - Hostname type. Possible values include: 'Proxy', 'Portal', 'Management', 'Scm'
	Type HostnameType `json:"type,omitempty"`
	// Hostname - Hostname.
	Hostname *string `json:"hostname,omitempty"`
	// Certificate - Certificate information.
	Certificate *CertificateInformation `json:"certificate,omitempty"`
}

// IdentityProviderContract the external Identity Providers like Facebook, Google, Microsoft, Twitter or
// Azure Active Directory which can be used to enable access to the API Management service developer portal
// for all users.
type IdentityProviderContract struct {
	autorest.Response `json:"-"`
	// ClientID - Client Id of the Application in the external Identity Provider. It is App ID for Facebook login, Client ID for Google login, App ID for Microsoft.
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - Client secret of the Application in external Identity Provider, used to authenticate login request. For example, it is App Secret for Facebook login, API Key for Google login, Public Key for Microsoft.
	ClientSecret *string `json:"clientSecret,omitempty"`
	// Type - Identity Provider Type identifier. Possible values include: 'Facebook', 'Google', 'Microsoft', 'Twitter', 'Aad'
	Type IdentityProviderNameType `json:"type,omitempty"`
	// AllowedTenants - List of Allowed Tenants when configuring Azure Active Directory login.
	AllowedTenants *[]string `json:"allowedTenants,omitempty"`
}

// IdentityProviderList list of all the Identity Providers configured on the service instance.
type IdentityProviderList struct {
	autorest.Response `json:"-"`
	// Value - Identity Provider configuration values.
	Value *[]IdentityProviderContract `json:"value,omitempty"`
}

// IdentityProviderUpdateParameters parameters supplied to the Update Identity Provider operation.
type IdentityProviderUpdateParameters struct {
	// ClientID - Client Id of the Application in the external Identity Provider. It is App ID for Facebook login, Client ID for Google login, App ID for Microsoft.
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - Client secret of the Application in external Identity Provider, used to authenticate login request. For example, it is App Secret for Facebook login, API Key for Google login, Public Key for Microsoft.
	ClientSecret *string `json:"clientSecret,omitempty"`
	// AllowedTenants - List of Allowed Tenants when configuring Azure Active Directory login.
	AllowedTenants *[]string `json:"allowedTenants,omitempty"`
}

// ListPolicySnippetContract ...
type ListPolicySnippetContract struct {
	autorest.Response `json:"-"`
	Value             *[]PolicySnippetContract `json:"value,omitempty"`
}

// ListUserIdentityContract ...
type ListUserIdentityContract struct {
	autorest.Response `json:"-"`
	Value             *[]UserIdentityContract `json:"value,omitempty"`
}

// LoggerCollection paged Logger list representation.
type LoggerCollection struct {
	autorest.Response `json:"-"`
	// Value - Logger values.
	Value *[]LoggerResponse `json:"value,omitempty"`
	// Count - Total records count number.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// LoggerCollectionIterator provides access to a complete listing of LoggerResponse values.
type LoggerCollectionIterator struct {
	i    int
	page LoggerCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LoggerCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LoggerCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LoggerCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LoggerCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LoggerCollectionIterator) Response() LoggerCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LoggerCollectionIterator) Value() LoggerResponse {
	if !iter.page.NotDone() {
		return LoggerResponse{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LoggerCollectionIterator type.
func NewLoggerCollectionIterator(page LoggerCollectionPage) LoggerCollectionIterator {
	return LoggerCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lc LoggerCollection) IsEmpty() bool {
	return lc.Value == nil || len(*lc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lc LoggerCollection) hasNextLink() bool {
	return lc.NextLink != nil && len(*lc.NextLink) != 0
}

// loggerCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lc LoggerCollection) loggerCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !lc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lc.NextLink)))
}

// LoggerCollectionPage contains a page of LoggerResponse values.
type LoggerCollectionPage struct {
	fn func(context.Context, LoggerCollection) (LoggerCollection, error)
	lc LoggerCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LoggerCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LoggerCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lc)
		if err != nil {
			return err
		}
		page.lc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LoggerCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LoggerCollectionPage) NotDone() bool {
	return !page.lc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LoggerCollectionPage) Response() LoggerCollection {
	return page.lc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LoggerCollectionPage) Values() []LoggerResponse {
	if page.lc.IsEmpty() {
		return nil
	}
	return *page.lc.Value
}

// Creates a new instance of the LoggerCollectionPage type.
func NewLoggerCollectionPage(cur LoggerCollection, getNextPage func(context.Context, LoggerCollection) (LoggerCollection, error)) LoggerCollectionPage {
	return LoggerCollectionPage{
		fn: getNextPage,
		lc: cur,
	}
}

// LoggerCreateParameters parameters supplied to the Create Logger operation.
type LoggerCreateParameters struct {
	// Type - Logger type.
	Type *string `json:"type,omitempty"`
	// Description - Logger description.
	Description *string `json:"description,omitempty"`
	// Credentials - The name and SendRule connection string of the event hub.
	Credentials map[string]*string `json:"credentials"`
	// IsBuffered - Whether records are buffered in the logger before publishing. Default is assumed to be true.
	IsBuffered *bool `json:"isBuffered,omitempty"`
}

// MarshalJSON is the custom marshaler for LoggerCreateParameters.
func (lcp LoggerCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lcp.Type != nil {
		objectMap["type"] = lcp.Type
	}
	if lcp.Description != nil {
		objectMap["description"] = lcp.Description
	}
	if lcp.Credentials != nil {
		objectMap["credentials"] = lcp.Credentials
	}
	if lcp.IsBuffered != nil {
		objectMap["isBuffered"] = lcp.IsBuffered
	}
	return json.Marshal(objectMap)
}

// LoggerResponse the Logger entity in API Management represents an event sink that you can use to log API
// Management events. Currently the Logger entity supports logging API Management events to Azure Event
// Hubs.
type LoggerResponse struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Uniquely identifies the logger within the current API Management service instance. The value is a valid relative URL in the format of /loggers/{loggerId} where {loggerId} is a logger identifier.
	ID *string `json:"id,omitempty"`
	// Type - Logger type.
	Type *string `json:"type,omitempty"`
	// Description - Logger description.
	Description *string `json:"description,omitempty"`
	// Credentials - The name and SendRule connection string of the event hub.
	Credentials map[string]*string `json:"credentials"`
	// IsBuffered - Whether records are buffered in the logger before publishing. Default is assumed to be true.
	IsBuffered *bool `json:"isBuffered,omitempty"`
}

// MarshalJSON is the custom marshaler for LoggerResponse.
func (lr LoggerResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lr.Type != nil {
		objectMap["type"] = lr.Type
	}
	if lr.Description != nil {
		objectMap["description"] = lr.Description
	}
	if lr.Credentials != nil {
		objectMap["credentials"] = lr.Credentials
	}
	if lr.IsBuffered != nil {
		objectMap["isBuffered"] = lr.IsBuffered
	}
	return json.Marshal(objectMap)
}

// LoggerUpdateParameters parameters supplied to the Update Logger operation.
type LoggerUpdateParameters struct {
	// Type - Logger type.
	Type *string `json:"type,omitempty"`
	// Description - Logger description.
	Description *string `json:"description,omitempty"`
	// Credentials - Logger credentials.
	Credentials map[string]*string `json:"credentials"`
	// IsBuffered - whether records are buffered in the logger before publishing. Default is assumed to be true.
	IsBuffered *bool `json:"isBuffered,omitempty"`
}

// MarshalJSON is the custom marshaler for LoggerUpdateParameters.
func (lup LoggerUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lup.Type != nil {
		objectMap["type"] = lup.Type
	}
	if lup.Description != nil {
		objectMap["description"] = lup.Description
	}
	if lup.Credentials != nil {
		objectMap["credentials"] = lup.Credentials
	}
	if lup.IsBuffered != nil {
		objectMap["isBuffered"] = lup.IsBuffered
	}
	return json.Marshal(objectMap)
}

// OAuth2AuthenticationSettingsContract API OAuth2 Authentication settings details.
type OAuth2AuthenticationSettingsContract struct {
	// AuthorizationServerID - OAuth authorization server identifier.
	AuthorizationServerID *string `json:"authorizationServerId,omitempty"`
	// Scope - operations scope.
	Scope *string `json:"scope,omitempty"`
}

// OAuth2AuthorizationServerContract external OAuth authorization server settings.
type OAuth2AuthorizationServerContract struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Uniquely identifies the authorization server within the current API Management service instance. The value is a valid relative URL in the format of /authorizationServers/{authsid} where {authsid} is an authorization server identifier.
	ID *string `json:"id,omitempty"`
	// Name - User-friendly authorization server name.
	Name *string `json:"name,omitempty"`
	// Description - Description of the authorization server. Can contain HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// ClientRegistrationEndpoint - Optional reference to a page where client or app registration for this authorization server is performed. Contains absolute URL to entity being referenced.
	ClientRegistrationEndpoint *string `json:"clientRegistrationEndpoint,omitempty"`
	// AuthorizationEndpoint - OAuth authorization endpoint. See http://tools.ietf.org/html/rfc6749#section-3.2.
	AuthorizationEndpoint *string `json:"authorizationEndpoint,omitempty"`
	// AuthorizationMethods - HTTP verbs supported by the authorization endpoint. GET must be always present. POST is optional.
	AuthorizationMethods *[]MethodContract `json:"authorizationMethods,omitempty"`
	// ClientAuthenticationMethod - Method of authentication supported by the token endpoint of this authorization server. Possible values are Basic and/or Body. When Body is specified, client credentials and other parameters are passed within the request body in the application/x-www-form-urlencoded format.
	ClientAuthenticationMethod *[]ClientAuthenticationMethodContract `json:"clientAuthenticationMethod,omitempty"`
	// TokenBodyParameters - Additional parameters required by the token endpoint of this authorization server represented as an array of JSON objects with name and value string properties, i.e. {"name" : "name value", "value": "a value"}.
	TokenBodyParameters *[]TokenBodyParameterContract `json:"tokenBodyParameters,omitempty"`
	// TokenEndpoint - OAuth token endpoint. Contains absolute URI to entity being referenced.
	TokenEndpoint *string `json:"tokenEndpoint,omitempty"`
	// SupportState - If true, authorization server will include state parameter from the authorization request to its response. Client may use state parameter to raise protocol security.
	SupportState *bool `json:"supportState,omitempty"`
	// DefaultScope - Access token scope that is going to be requested by default. Can be overridden at the API level. Should be provided in the form of a string containing space-delimited values.
	DefaultScope *string `json:"defaultScope,omitempty"`
	// GrantTypes - Form of an authorization grant, which the client uses to request the access token.
	GrantTypes *[]GrantTypesContract `json:"grantTypes,omitempty"`
	// BearerTokenSendingMethods - Specifies the mechanism by which access token is passed to the API.
	BearerTokenSendingMethods *[]BearerTokenSendingMethodsContract `json:"bearerTokenSendingMethods,omitempty"`
	// ClientID - Client or app id registered with this authorization server.
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - Client or app secret registered with this authorization server.
	ClientSecret *string `json:"clientSecret,omitempty"`
	// ResourceOwnerUsername - Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner username.
	ResourceOwnerUsername *string `json:"resourceOwnerUsername,omitempty"`
	// ResourceOwnerPassword - Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner password.
	ResourceOwnerPassword *string `json:"resourceOwnerPassword,omitempty"`
}

// MarshalJSON is the custom marshaler for OAuth2AuthorizationServerContract.
func (oa2asc OAuth2AuthorizationServerContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if oa2asc.Name != nil {
		objectMap["name"] = oa2asc.Name
	}
	if oa2asc.Description != nil {
		objectMap["description"] = oa2asc.Description
	}
	if oa2asc.ClientRegistrationEndpoint != nil {
		objectMap["clientRegistrationEndpoint"] = oa2asc.ClientRegistrationEndpoint
	}
	if oa2asc.AuthorizationEndpoint != nil {
		objectMap["authorizationEndpoint"] = oa2asc.AuthorizationEndpoint
	}
	if oa2asc.AuthorizationMethods != nil {
		objectMap["authorizationMethods"] = oa2asc.AuthorizationMethods
	}
	if oa2asc.ClientAuthenticationMethod != nil {
		objectMap["clientAuthenticationMethod"] = oa2asc.ClientAuthenticationMethod
	}
	if oa2asc.TokenBodyParameters != nil {
		objectMap["tokenBodyParameters"] = oa2asc.TokenBodyParameters
	}
	if oa2asc.TokenEndpoint != nil {
		objectMap["tokenEndpoint"] = oa2asc.TokenEndpoint
	}
	if oa2asc.SupportState != nil {
		objectMap["supportState"] = oa2asc.SupportState
	}
	if oa2asc.DefaultScope != nil {
		objectMap["defaultScope"] = oa2asc.DefaultScope
	}
	if oa2asc.GrantTypes != nil {
		objectMap["grantTypes"] = oa2asc.GrantTypes
	}
	if oa2asc.BearerTokenSendingMethods != nil {
		objectMap["bearerTokenSendingMethods"] = oa2asc.BearerTokenSendingMethods
	}
	if oa2asc.ClientID != nil {
		objectMap["clientId"] = oa2asc.ClientID
	}
	if oa2asc.ClientSecret != nil {
		objectMap["clientSecret"] = oa2asc.ClientSecret
	}
	if oa2asc.ResourceOwnerUsername != nil {
		objectMap["resourceOwnerUsername"] = oa2asc.ResourceOwnerUsername
	}
	if oa2asc.ResourceOwnerPassword != nil {
		objectMap["resourceOwnerPassword"] = oa2asc.ResourceOwnerPassword
	}
	return json.Marshal(objectMap)
}

// OAuth2AuthorizationServerUpdateContract external OAuth authorization server Update settings contract.
type OAuth2AuthorizationServerUpdateContract struct {
	// Name - User-friendly authorization server name.
	Name *string `json:"name,omitempty"`
	// Description - Description of the authorization server. Can contain HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// ClientRegistrationEndpoint - Optional reference to a page where client or app registration for this authorization server is performed. Contains absolute URL to entity being referenced.
	ClientRegistrationEndpoint *string `json:"clientRegistrationEndpoint,omitempty"`
	// AuthorizationEndpoint - OAuth authorization endpoint. See http://tools.ietf.org/html/rfc6749#section-3.2.
	AuthorizationEndpoint *string `json:"authorizationEndpoint,omitempty"`
	// AuthorizationMethods - HTTP verbs supported by the authorization endpoint. GET must be always present. POST is optional.
	AuthorizationMethods *[]MethodContract `json:"authorizationMethods,omitempty"`
	// ClientAuthenticationMethod - Method of authentication supported by the token endpoint of this authorization server. Possible values are Basic and/or Body. When Body is specified, client credentials and other parameters are passed within the request body in the application/x-www-form-urlencoded format.
	ClientAuthenticationMethod *[]ClientAuthenticationMethodContract `json:"clientAuthenticationMethod,omitempty"`
	// TokenBodyParameters - Additional parameters required by the token endpoint of this authorization server represented as an array of JSON objects with name and value string properties, i.e. {"name" : "name value", "value": "a value"}.
	TokenBodyParameters *[]TokenBodyParameterContract `json:"tokenBodyParameters,omitempty"`
	// TokenEndpoint - OAuth token endpoint. Contains absolute URI to entity being referenced.
	TokenEndpoint *string `json:"tokenEndpoint,omitempty"`
	// SupportState - If true, authorization server will include state parameter from the authorization request to its response. Client may use state parameter to raise protocol security.
	SupportState *bool `json:"supportState,omitempty"`
	// DefaultScope - Access token scope that is going to be requested by default. Can be overridden at the API level. Should be provided in the form of a string containing space-delimited values.
	DefaultScope *string `json:"defaultScope,omitempty"`
	// GrantTypes - Form of an authorization grant, which the client uses to request the access token.
	GrantTypes *[]GrantTypesContract `json:"grantTypes,omitempty"`
	// BearerTokenSendingMethods - Specifies the mechanism by which access token is passed to the API.
	BearerTokenSendingMethods *[]BearerTokenSendingMethodsContract `json:"bearerTokenSendingMethods,omitempty"`
	// ClientID - Client or app id registered with this authorization server.
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - Client or app secret registered with this authorization server.
	ClientSecret *string `json:"clientSecret,omitempty"`
	// ResourceOwnerUsername - Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner username.
	ResourceOwnerUsername *string `json:"resourceOwnerUsername,omitempty"`
	// ResourceOwnerPassword - Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner password.
	ResourceOwnerPassword *string `json:"resourceOwnerPassword,omitempty"`
}

// OpenIDConnectProviderCollection paged OpenIdProviders list representation.
type OpenIDConnectProviderCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]OpenidConnectProviderContract `json:"value,omitempty"`
	// Count - Total records count number.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OpenIDConnectProviderCollectionIterator provides access to a complete listing of
// OpenidConnectProviderContract values.
type OpenIDConnectProviderCollectionIterator struct {
	i    int
	page OpenIDConnectProviderCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OpenIDConnectProviderCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OpenIDConnectProviderCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OpenIDConnectProviderCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OpenIDConnectProviderCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OpenIDConnectProviderCollectionIterator) Response() OpenIDConnectProviderCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OpenIDConnectProviderCollectionIterator) Value() OpenidConnectProviderContract {
	if !iter.page.NotDone() {
		return OpenidConnectProviderContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OpenIDConnectProviderCollectionIterator type.
func NewOpenIDConnectProviderCollectionIterator(page OpenIDConnectProviderCollectionPage) OpenIDConnectProviderCollectionIterator {
	return OpenIDConnectProviderCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (oicpc OpenIDConnectProviderCollection) IsEmpty() bool {
	return oicpc.Value == nil || len(*oicpc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (oicpc OpenIDConnectProviderCollection) hasNextLink() bool {
	return oicpc.NextLink != nil && len(*oicpc.NextLink) != 0
}

// openIDConnectProviderCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (oicpc OpenIDConnectProviderCollection) openIDConnectProviderCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !oicpc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(oicpc.NextLink)))
}

// OpenIDConnectProviderCollectionPage contains a page of OpenidConnectProviderContract values.
type OpenIDConnectProviderCollectionPage struct {
	fn    func(context.Context, OpenIDConnectProviderCollection) (OpenIDConnectProviderCollection, error)
	oicpc OpenIDConnectProviderCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OpenIDConnectProviderCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OpenIDConnectProviderCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.oicpc)
		if err != nil {
			return err
		}
		page.oicpc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OpenIDConnectProviderCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OpenIDConnectProviderCollectionPage) NotDone() bool {
	return !page.oicpc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OpenIDConnectProviderCollectionPage) Response() OpenIDConnectProviderCollection {
	return page.oicpc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OpenIDConnectProviderCollectionPage) Values() []OpenidConnectProviderContract {
	if page.oicpc.IsEmpty() {
		return nil
	}
	return *page.oicpc.Value
}

// Creates a new instance of the OpenIDConnectProviderCollectionPage type.
func NewOpenIDConnectProviderCollectionPage(cur OpenIDConnectProviderCollection, getNextPage func(context.Context, OpenIDConnectProviderCollection) (OpenIDConnectProviderCollection, error)) OpenIDConnectProviderCollectionPage {
	return OpenIDConnectProviderCollectionPage{
		fn:    getNextPage,
		oicpc: cur,
	}
}

// OpenidConnectProviderContract openID Connect Providers Contract.
type OpenidConnectProviderContract struct {
	autorest.Response `json:"-"`
	// ID - OpenID Connect Provider identifier.
	ID *string `json:"id,omitempty"`
	// Name - User-friendly OpenID Connect Provider name.
	Name *string `json:"name,omitempty"`
	// Description - User-friendly description of OpenID Connect Provider.
	Description *string `json:"description,omitempty"`
	// MetadataEndpoint - Metadata endpoint URI.
	MetadataEndpoint *string `json:"metadataEndpoint,omitempty"`
	// ClientID - Client ID of developer console which is the client application.
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - Client Secret of developer console which is the client application.
	ClientSecret *string `json:"clientSecret,omitempty"`
}

// OpenidConnectProviderCreateContract parameters supplied to the Create OpenID Connect Provider operation.
type OpenidConnectProviderCreateContract struct {
	// Name - User-friendly OpenID Connect Provider name.
	Name *string `json:"name,omitempty"`
	// Description - User-friendly description of OpenID Connect Provider.
	Description *string `json:"description,omitempty"`
	// MetadataEndpoint - Metadata endpoint URI.
	MetadataEndpoint *string `json:"metadataEndpoint,omitempty"`
	// ClientID - Client ID of developer console which is the client application.
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - Client Secret of developer console which is the client application.
	ClientSecret *string `json:"clientSecret,omitempty"`
}

// OpenidConnectProviderUpdateContract parameters supplied to the Update OpenID Connect Provider operation.
type OpenidConnectProviderUpdateContract struct {
	// Name - User-friendly OpenID Connect Provider name.
	Name *string `json:"name,omitempty"`
	// Description - User-friendly description of OpenID Connect Provider.
	Description *string `json:"description,omitempty"`
	// MetadataEndpoint - Metadata endpoint URI.
	MetadataEndpoint *string `json:"metadataEndpoint,omitempty"`
	// ClientID - Client ID of developer console which is the client application.
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - Client Secret of developer console which is the client application.
	ClientSecret *string `json:"clientSecret,omitempty"`
}

// OperationCollection paged Operation list representation.
type OperationCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]OperationContract `json:"value,omitempty"`
	// Count - Total records count number.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationCollectionIterator provides access to a complete listing of OperationContract values.
type OperationCollectionIterator struct {
	i    int
	page OperationCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationCollectionIterator) Response() OperationCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationCollectionIterator) Value() OperationContract {
	if !iter.page.NotDone() {
		return OperationContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationCollectionIterator type.
func NewOperationCollectionIterator(page OperationCollectionPage) OperationCollectionIterator {
	return OperationCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (oc OperationCollection) IsEmpty() bool {
	return oc.Value == nil || len(*oc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (oc OperationCollection) hasNextLink() bool {
	return oc.NextLink != nil && len(*oc.NextLink) != 0
}

// operationCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (oc OperationCollection) operationCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !oc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(oc.NextLink)))
}

// OperationCollectionPage contains a page of OperationContract values.
type OperationCollectionPage struct {
	fn func(context.Context, OperationCollection) (OperationCollection, error)
	oc OperationCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.oc)
		if err != nil {
			return err
		}
		page.oc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationCollectionPage) NotDone() bool {
	return !page.oc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationCollectionPage) Response() OperationCollection {
	return page.oc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationCollectionPage) Values() []OperationContract {
	if page.oc.IsEmpty() {
		return nil
	}
	return *page.oc.Value
}

// Creates a new instance of the OperationCollectionPage type.
func NewOperationCollectionPage(cur OperationCollection, getNextPage func(context.Context, OperationCollection) (OperationCollection, error)) OperationCollectionPage {
	return OperationCollectionPage{
		fn: getNextPage,
		oc: cur,
	}
}

// OperationContract api Operation details.
type OperationContract struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Uniquely identifies the operation within the current API Management service instance. The value is a valid relative URL in the format of /apis/{aid}/operations/{id} where {aid} is an API identifier and {id} is an operation identifier.
	ID *string `json:"id,omitempty"`
	// Name - Operation Name.
	Name *string `json:"name,omitempty"`
	// Method - A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but not limited by only them.
	Method *string `json:"method,omitempty"`
	// URLTemplate - Relative URL template identifying the target resource for this operation. May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}
	URLTemplate *string `json:"urlTemplate,omitempty"`
	// TemplateParameters - Collection of URL template parameters.
	TemplateParameters *[]ParameterContract `json:"templateParameters,omitempty"`
	// Description - Description of the operation. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// Request - An entity containing request details.
	Request *RequestContract `json:"request,omitempty"`
	// Responses - Array of Operation responses.
	Responses *[]ResultContract `json:"responses,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationContract.
func (oc OperationContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if oc.Name != nil {
		objectMap["name"] = oc.Name
	}
	if oc.Method != nil {
		objectMap["method"] = oc.Method
	}
	if oc.URLTemplate != nil {
		objectMap["urlTemplate"] = oc.URLTemplate
	}
	if oc.TemplateParameters != nil {
		objectMap["templateParameters"] = oc.TemplateParameters
	}
	if oc.Description != nil {
		objectMap["description"] = oc.Description
	}
	if oc.Request != nil {
		objectMap["request"] = oc.Request
	}
	if oc.Responses != nil {
		objectMap["responses"] = oc.Responses
	}
	return json.Marshal(objectMap)
}

// OperationResultContract operation Result.
type OperationResultContract struct {
	autorest.Response `json:"-"`
	// ID - Operation result identifier.
	ID *string `json:"id,omitempty"`
	// Status - Status of an async operation. Possible values include: 'Started', 'InProgress', 'Succeeded', 'Failed'
	Status AsyncOperationState `json:"status,omitempty"`
	// Started - Start time of an async operation. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	Started *date.Time `json:"started,omitempty"`
	// Updated - Last update time of an async operation. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	Updated *date.Time `json:"updated,omitempty"`
	// ResultInfo - Optional result info.
	ResultInfo *string            `json:"resultInfo,omitempty"`
	Error      *ErrorBodyContract `json:"error,omitempty"`
}

// ParameterContract operation parameters details.
type ParameterContract struct {
	// Name - Parameter name.
	Name *string `json:"name,omitempty"`
	// Description - Parameter description.
	Description *string `json:"description,omitempty"`
	// Type - Parameter type.
	Type *string `json:"type,omitempty"`
	// DefaultValue - Default parameter value.
	DefaultValue *string `json:"defaultValue,omitempty"`
	// Required - whether parameter is required or not.
	Required *bool `json:"required,omitempty"`
	// Values - Parameter values.
	Values *[]string `json:"values,omitempty"`
}

// PatchParameters parameters supplied to the Patch operations.
type PatchParameters struct {
	// RawJSON - json value.
	RawJSON interface{} `json:"RawJson,omitempty"`
}

// PolicySnippetContract policy snippet.
type PolicySnippetContract struct {
	// Name - READ-ONLY; Snippet name.
	Name *string `json:"name,omitempty"`
	// Content - READ-ONLY; Snippet content.
	Content *string `json:"content,omitempty"`
	// ToolTip - READ-ONLY; Snippet toolTip.
	ToolTip *string `json:"toolTip,omitempty"`
	// Scope - READ-ONLY; Snippet scope. Possible values include: 'Tenant', 'Product', 'API', 'Operation', 'All'
	Scope PolicyScopeContract `json:"scope,omitempty"`
}

// ProductCollection paged Products list representation.
type ProductCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]ProductContract `json:"value,omitempty"`
	// Count - Total records count number.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProductCollectionIterator provides access to a complete listing of ProductContract values.
type ProductCollectionIterator struct {
	i    int
	page ProductCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProductCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProductCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProductCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProductCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProductCollectionIterator) Response() ProductCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProductCollectionIterator) Value() ProductContract {
	if !iter.page.NotDone() {
		return ProductContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProductCollectionIterator type.
func NewProductCollectionIterator(page ProductCollectionPage) ProductCollectionIterator {
	return ProductCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pc ProductCollection) IsEmpty() bool {
	return pc.Value == nil || len(*pc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pc ProductCollection) hasNextLink() bool {
	return pc.NextLink != nil && len(*pc.NextLink) != 0
}

// productCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pc ProductCollection) productCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !pc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pc.NextLink)))
}

// ProductCollectionPage contains a page of ProductContract values.
type ProductCollectionPage struct {
	fn func(context.Context, ProductCollection) (ProductCollection, error)
	pc ProductCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProductCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProductCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pc)
		if err != nil {
			return err
		}
		page.pc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProductCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProductCollectionPage) NotDone() bool {
	return !page.pc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProductCollectionPage) Response() ProductCollection {
	return page.pc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProductCollectionPage) Values() []ProductContract {
	if page.pc.IsEmpty() {
		return nil
	}
	return *page.pc.Value
}

// Creates a new instance of the ProductCollectionPage type.
func NewProductCollectionPage(cur ProductCollection, getNextPage func(context.Context, ProductCollection) (ProductCollection, error)) ProductCollectionPage {
	return ProductCollectionPage{
		fn: getNextPage,
		pc: cur,
	}
}

// ProductContract product profile.
type ProductContract struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Uniquely identifies the product within the current API Management service instance. The value is a valid relative URL in the format of /products/{productId} where {productId} is a product identifier.
	ID *string `json:"id,omitempty"`
	// Name - Product name.
	Name *string `json:"name,omitempty"`
	// Description - Product description. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// Terms - Product terms of use. Developers trying to subscribe to the product will be presented and required to accept these terms before they can complete the subscription process.
	Terms *string `json:"terms,omitempty"`
	// SubscriptionRequired - Whether a product subscription is required for accessing APIs included in this product. If true, the product is referred to as "protected" and a valid subscription key is required for a request to an API included in the product to succeed. If false, the product is referred to as "open" and requests to an API included in the product can be made without a subscription key. If property is omitted when creating a new product it's value is assumed to be true.
	SubscriptionRequired *bool `json:"subscriptionRequired,omitempty"`
	// ApprovalRequired - whether subscription approval is required. If false, new subscriptions will be approved automatically enabling developers to call the product’s APIs immediately after subscribing. If true, administrators must manually approve the subscription before the developer can any of the product’s APIs. Can be present only if subscriptionRequired property is present and has a value of true.
	ApprovalRequired *bool `json:"approvalRequired,omitempty"`
	// SubscriptionsLimit - Whether the number of subscriptions a user can have to this product at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be present only if subscriptionRequired property is present and has a value of true.
	SubscriptionsLimit *int32 `json:"subscriptionsLimit,omitempty"`
	// State - whether product is published or not. Published products are discoverable by users of developer portal. Non published products are visible only to administrators. Default state of Product is NotPublished. Possible values include: 'NotPublished', 'Published'
	State ProductStateContract `json:"state,omitempty"`
}

// MarshalJSON is the custom marshaler for ProductContract.
func (pc ProductContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pc.Name != nil {
		objectMap["name"] = pc.Name
	}
	if pc.Description != nil {
		objectMap["description"] = pc.Description
	}
	if pc.Terms != nil {
		objectMap["terms"] = pc.Terms
	}
	if pc.SubscriptionRequired != nil {
		objectMap["subscriptionRequired"] = pc.SubscriptionRequired
	}
	if pc.ApprovalRequired != nil {
		objectMap["approvalRequired"] = pc.ApprovalRequired
	}
	if pc.SubscriptionsLimit != nil {
		objectMap["subscriptionsLimit"] = pc.SubscriptionsLimit
	}
	if pc.State != "" {
		objectMap["state"] = pc.State
	}
	return json.Marshal(objectMap)
}

// ProductUpdateParameters parameters supplied to the CreateOrUpdate Product operation.
type ProductUpdateParameters struct {
	// Name - Product name.
	Name *string `json:"name,omitempty"`
	// Description - Product description.
	Description *string `json:"description,omitempty"`
	// Terms - Product terms and conditions. Developer will have to accept these terms before he's allowed to call product API.
	Terms *string `json:"terms,omitempty"`
	// SubscriptionRequired - whether a product subscription is required for accessing APIs included in this product. If true, the product is referred to as "protected" and a valid subscription key is required for a request to an API included in the product to succeed. If false, the product is referred to as "open" and requests to an API included in the product can be made without a subscription key. If property is omitted when creating a new product it's value is assumed to be true.
	SubscriptionRequired *bool `json:"subscriptionRequired,omitempty"`
	// ApprovalRequired - whether subscription approval is required. If false, new subscriptions will be approved automatically enabling developers to call the product’s APIs immediately after subscribing. If true, administrators must manually approve the subscription before the developer can any of the product’s APIs. Can be present only if subscriptionRequired property is present and has a value of true.
	ApprovalRequired *bool `json:"approvalRequired,omitempty"`
	// SubscriptionsLimit - whether the number of subscriptions a user can have to this product at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be present only if subscriptionRequired property is present and has a value of true.
	SubscriptionsLimit *int32 `json:"subscriptionsLimit,omitempty"`
	// State - whether product is published or not. Published products are discoverable by users of developer portal. Non published products are visible only to administrators. Possible values include: 'NotPublished', 'Published'
	State ProductStateContract `json:"state,omitempty"`
}

// PropertyCollection paged Property list representation.
type PropertyCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]PropertyContract `json:"value,omitempty"`
	// Count - Total records count number.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// PropertyCollectionIterator provides access to a complete listing of PropertyContract values.
type PropertyCollectionIterator struct {
	i    int
	page PropertyCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PropertyCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PropertyCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PropertyCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PropertyCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PropertyCollectionIterator) Response() PropertyCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PropertyCollectionIterator) Value() PropertyContract {
	if !iter.page.NotDone() {
		return PropertyContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PropertyCollectionIterator type.
func NewPropertyCollectionIterator(page PropertyCollectionPage) PropertyCollectionIterator {
	return PropertyCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pc PropertyCollection) IsEmpty() bool {
	return pc.Value == nil || len(*pc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pc PropertyCollection) hasNextLink() bool {
	return pc.NextLink != nil && len(*pc.NextLink) != 0
}

// propertyCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pc PropertyCollection) propertyCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !pc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pc.NextLink)))
}

// PropertyCollectionPage contains a page of PropertyContract values.
type PropertyCollectionPage struct {
	fn func(context.Context, PropertyCollection) (PropertyCollection, error)
	pc PropertyCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PropertyCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PropertyCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pc)
		if err != nil {
			return err
		}
		page.pc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PropertyCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PropertyCollectionPage) NotDone() bool {
	return !page.pc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PropertyCollectionPage) Response() PropertyCollection {
	return page.pc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PropertyCollectionPage) Values() []PropertyContract {
	if page.pc.IsEmpty() {
		return nil
	}
	return *page.pc.Value
}

// Creates a new instance of the PropertyCollectionPage type.
func NewPropertyCollectionPage(cur PropertyCollection, getNextPage func(context.Context, PropertyCollection) (PropertyCollection, error)) PropertyCollectionPage {
	return PropertyCollectionPage{
		fn: getNextPage,
		pc: cur,
	}
}

// PropertyContract property details.
type PropertyContract struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Uniquely identifies the property within the current API Management service instance. The value is a valid relative URL in the format of /properties/{propId} where {propId} is a property identifier.
	ID *string `json:"id,omitempty"`
	// Name - Unique name of Property. It may contain only letters, digits, period, dash, and underscore characters.
	Name *string `json:"name,omitempty"`
	// Value - Value of the property. Can contain policy expressions. It may not be empty or consist only of whitespace.
	Value *string `json:"value,omitempty"`
	// Tags - Optional tags that when provided can be used to filter the property list.
	Tags *[]string `json:"tags,omitempty"`
	// Secret - Determines whether the value is a secret and should be encrypted or not. Default value is false.
	Secret *bool `json:"secret,omitempty"`
}

// MarshalJSON is the custom marshaler for PropertyContract.
func (pc PropertyContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pc.Name != nil {
		objectMap["name"] = pc.Name
	}
	if pc.Value != nil {
		objectMap["value"] = pc.Value
	}
	if pc.Tags != nil {
		objectMap["tags"] = pc.Tags
	}
	if pc.Secret != nil {
		objectMap["secret"] = pc.Secret
	}
	return json.Marshal(objectMap)
}

// PropertyCreateParameters parameters supplied to the Create Property operation.
type PropertyCreateParameters struct {
	// Name - Unique name of Property. It may contain only letters, digits, period, dash, and underscore characters.
	Name *string `json:"name,omitempty"`
	// Value - Value of the property. Can contain policy expressions. It may not be empty or consist only of whitespace.
	Value *string `json:"value,omitempty"`
	// Tags - Optional tags that when provided can be used to filter the property list.
	Tags *[]string `json:"tags,omitempty"`
	// Secret - Determines whether the value is a secret and should be encrypted or not. Default value is false.
	Secret *bool `json:"secret,omitempty"`
}

// PropertyUpdateParameters parameters supplied to the Update Property operation.
type PropertyUpdateParameters struct {
	// Name - Unique name of Property. It may contain only letters, digits, period, dash, and underscore characters.
	Name *string `json:"name,omitempty"`
	// Value - Value of the property. Can contain policy expressions. It may not be empty or consist only of whitespace.
	Value *string `json:"value,omitempty"`
	// Tags - Optional tags that when provided can be used to filter the property list.
	Tags *[]string `json:"tags,omitempty"`
	// Secret - Determines whether the value is a secret and should be encrypted or not. Default value is false.
	Secret *bool `json:"secret,omitempty"`
}

// QuotaCounterCollection paged Quota Counter list representation.
type QuotaCounterCollection struct {
	autorest.Response `json:"-"`
	// Value - Quota counter values.
	Value *[]QuotaCounterContract `json:"value,omitempty"`
	// Count - Total records count number.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// QuotaCounterContract quota counter details.
type QuotaCounterContract struct {
	autorest.Response `json:"-"`
	// CounterKey - The Key value of the Counter. Must not be empty.
	CounterKey *string `json:"counterKey,omitempty"`
	// PeriodKey - Identifier of the Period for which the counter was collected. Must not be empty.
	PeriodKey *string `json:"periodKey,omitempty"`
	// PeriodStartTime - The date of the start of Counter Period. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	PeriodStartTime *date.Time `json:"periodStartTime,omitempty"`
	// PeriodEndTime - The date of the end of Counter Period. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	PeriodEndTime *date.Time `json:"periodEndTime,omitempty"`
	// CallsCount - Number of times Counter was called.
	CallsCount *int32 `json:"callsCount,omitempty"`
	// KbTransferred - Data Transferred in KiloBytes.
	KbTransferred *float64 `json:"kbTransferred,omitempty"`
}

// QuotaCounterValueContract quota counter value details.
type QuotaCounterValueContract struct {
	// CallsCount - Number of times Counter was called.
	CallsCount *int32 `json:"callsCount,omitempty"`
	// KbTransferred - Data Transferred in KiloBytes.
	KbTransferred *float64 `json:"kbTransferred,omitempty"`
}

// RegionContract region profile.
type RegionContract struct {
	// Name - Region name.
	Name *string `json:"name,omitempty"`
	// IsMasterRegion - whether Region is the master region.
	IsMasterRegion *bool `json:"isMasterRegion,omitempty"`
}

// RegionListResult lists Regions operation response details.
type RegionListResult struct {
	autorest.Response `json:"-"`
	// Value - Lists of Regions.
	Value *[]RegionContract `json:"value,omitempty"`
}

// ReportCollection paged Report records list representation.
type ReportCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]ReportRecordContract `json:"value,omitempty"`
	// Count - Total records count number.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ReportCollectionIterator provides access to a complete listing of ReportRecordContract values.
type ReportCollectionIterator struct {
	i    int
	page ReportCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ReportCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ReportCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ReportCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ReportCollectionIterator) Response() ReportCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ReportCollectionIterator) Value() ReportRecordContract {
	if !iter.page.NotDone() {
		return ReportRecordContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ReportCollectionIterator type.
func NewReportCollectionIterator(page ReportCollectionPage) ReportCollectionIterator {
	return ReportCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rc ReportCollection) IsEmpty() bool {
	return rc.Value == nil || len(*rc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rc ReportCollection) hasNextLink() bool {
	return rc.NextLink != nil && len(*rc.NextLink) != 0
}

// reportCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rc ReportCollection) reportCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !rc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rc.NextLink)))
}

// ReportCollectionPage contains a page of ReportRecordContract values.
type ReportCollectionPage struct {
	fn func(context.Context, ReportCollection) (ReportCollection, error)
	rc ReportCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ReportCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rc)
		if err != nil {
			return err
		}
		page.rc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ReportCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ReportCollectionPage) NotDone() bool {
	return !page.rc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ReportCollectionPage) Response() ReportCollection {
	return page.rc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ReportCollectionPage) Values() []ReportRecordContract {
	if page.rc.IsEmpty() {
		return nil
	}
	return *page.rc.Value
}

// Creates a new instance of the ReportCollectionPage type.
func NewReportCollectionPage(cur ReportCollection, getNextPage func(context.Context, ReportCollection) (ReportCollection, error)) ReportCollectionPage {
	return ReportCollectionPage{
		fn: getNextPage,
		rc: cur,
	}
}

// ReportRecordContract report data.
type ReportRecordContract struct {
	// Name - Name depending on report endpoint specifies product, API, operation or developer name.
	Name *string `json:"name,omitempty"`
	// Timestamp - Start of aggregation period. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Interval - Length of aggregation period.
	Interval *int64 `json:"interval,omitempty"`
	// Country - Country to which this record data is related.
	Country *string `json:"country,omitempty"`
	// Region - Country region to which this record data is related.
	Region *string `json:"region,omitempty"`
	// Zip - Zip code to which this record data is related.
	Zip *string `json:"zip,omitempty"`
	// UserID - READ-ONLY; User identifier path. /users/{userId}
	UserID *string `json:"userId,omitempty"`
	// ProductID - READ-ONLY; Product identifier path. /products/{productId}
	ProductID *string `json:"productId,omitempty"`
	// APIID - API identifier path. /apis/{apiId}
	APIID *string `json:"apiId,omitempty"`
	// OperationID - Operation identifier path. /apis/{apiId}/operations/{operationId}
	OperationID *string `json:"operationId,omitempty"`
	// APIRegion - API region identifier.
	APIRegion *string `json:"apiRegion,omitempty"`
	// SubscriptionID - Subscription identifier path. /subscriptions/{subscriptionId}
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// CallCountSuccess - Number of successful calls.
	CallCountSuccess *int32 `json:"callCountSuccess,omitempty"`
	// CallCountBlocked - Number of calls blocked due to invalid credentials.
	CallCountBlocked *int32 `json:"callCountBlocked,omitempty"`
	// CallCountFailed - Number of calls failed due to proxy or backend errors.
	CallCountFailed *int32 `json:"callCountFailed,omitempty"`
	// CallCountOther - Number of other calls.
	CallCountOther *int32 `json:"callCountOther,omitempty"`
	// CallCountTotal - Total number of calls.
	CallCountTotal *int32 `json:"callCountTotal,omitempty"`
	// Bandwidth - Bandwidth consumed.
	Bandwidth *int64 `json:"bandwidth,omitempty"`
	// CacheHitCount - Number of times when content was served from cache policy.
	CacheHitCount *int32 `json:"cacheHitCount,omitempty"`
	// CacheMissCount - Number of times content was fetched from backend.
	CacheMissCount *int32 `json:"cacheMissCount,omitempty"`
	// APITimeAvg - Average time it took to process request.
	APITimeAvg *float64 `json:"apiTimeAvg,omitempty"`
	// APITimeMin - Minimum time it took to process request.
	APITimeMin *float64 `json:"apiTimeMin,omitempty"`
	// APITimeMax - Maximum time it took to process request.
	APITimeMax *float64 `json:"apiTimeMax,omitempty"`
	// ServiceTimeAvg - Average time it took to process request on backend.
	ServiceTimeAvg *float64 `json:"serviceTimeAvg,omitempty"`
	// ServiceTimeMin - Minimum time it took to process request on backend.
	ServiceTimeMin *float64 `json:"serviceTimeMin,omitempty"`
	// ServiceTimeMax - Maximum time it took to process request on backend.
	ServiceTimeMax *float64 `json:"serviceTimeMax,omitempty"`
}

// MarshalJSON is the custom marshaler for ReportRecordContract.
func (rrc ReportRecordContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rrc.Name != nil {
		objectMap["name"] = rrc.Name
	}
	if rrc.Timestamp != nil {
		objectMap["timestamp"] = rrc.Timestamp
	}
	if rrc.Interval != nil {
		objectMap["interval"] = rrc.Interval
	}
	if rrc.Country != nil {
		objectMap["country"] = rrc.Country
	}
	if rrc.Region != nil {
		objectMap["region"] = rrc.Region
	}
	if rrc.Zip != nil {
		objectMap["zip"] = rrc.Zip
	}
	if rrc.APIID != nil {
		objectMap["apiId"] = rrc.APIID
	}
	if rrc.OperationID != nil {
		objectMap["operationId"] = rrc.OperationID
	}
	if rrc.APIRegion != nil {
		objectMap["apiRegion"] = rrc.APIRegion
	}
	if rrc.SubscriptionID != nil {
		objectMap["subscriptionId"] = rrc.SubscriptionID
	}
	if rrc.CallCountSuccess != nil {
		objectMap["callCountSuccess"] = rrc.CallCountSuccess
	}
	if rrc.CallCountBlocked != nil {
		objectMap["callCountBlocked"] = rrc.CallCountBlocked
	}
	if rrc.CallCountFailed != nil {
		objectMap["callCountFailed"] = rrc.CallCountFailed
	}
	if rrc.CallCountOther != nil {
		objectMap["callCountOther"] = rrc.CallCountOther
	}
	if rrc.CallCountTotal != nil {
		objectMap["callCountTotal"] = rrc.CallCountTotal
	}
	if rrc.Bandwidth != nil {
		objectMap["bandwidth"] = rrc.Bandwidth
	}
	if rrc.CacheHitCount != nil {
		objectMap["cacheHitCount"] = rrc.CacheHitCount
	}
	if rrc.CacheMissCount != nil {
		objectMap["cacheMissCount"] = rrc.CacheMissCount
	}
	if rrc.APITimeAvg != nil {
		objectMap["apiTimeAvg"] = rrc.APITimeAvg
	}
	if rrc.APITimeMin != nil {
		objectMap["apiTimeMin"] = rrc.APITimeMin
	}
	if rrc.APITimeMax != nil {
		objectMap["apiTimeMax"] = rrc.APITimeMax
	}
	if rrc.ServiceTimeAvg != nil {
		objectMap["serviceTimeAvg"] = rrc.ServiceTimeAvg
	}
	if rrc.ServiceTimeMin != nil {
		objectMap["serviceTimeMin"] = rrc.ServiceTimeMin
	}
	if rrc.ServiceTimeMax != nil {
		objectMap["serviceTimeMax"] = rrc.ServiceTimeMax
	}
	return json.Marshal(objectMap)
}

// RepresentationContract operation request/response representation details.
type RepresentationContract struct {
	// ContentType - Specifies a registered or custom content type for this representation, e.g. application/xml.
	ContentType *string `json:"contentType,omitempty"`
	// Sample - An example of the representation.
	Sample *string `json:"sample,omitempty"`
}

// RequestContract operation request details.
type RequestContract struct {
	// Description - Operation request description.
	Description *string `json:"description,omitempty"`
	// QueryParameters - Collection of operation request query parameters.
	QueryParameters *[]ParameterContract `json:"queryParameters,omitempty"`
	// Headers - Collection of operation request headers.
	Headers *[]ParameterContract `json:"headers,omitempty"`
	// Representations - Collection of operation request representations.
	Representations *[]RepresentationContract `json:"representations,omitempty"`
}

// ResultContract operation response details.
type ResultContract struct {
	// StatusCode - Operation response HTTP status code.
	StatusCode *int32 `json:"statusCode,omitempty"`
	// Description - Operation response description.
	Description *string `json:"description,omitempty"`
	// Representations - Collection of operation response representations.
	Representations *[]RepresentationContract `json:"representations,omitempty"`
}

// SaveConfigurationParameter parameters supplied to the Save Tenant Configuration operation.
type SaveConfigurationParameter struct {
	// Branch - The name of the Git branch in which to commit the current configuration snapshot.
	Branch *string `json:"branch,omitempty"`
	// Force - The value if true, the current configuration database is committed to the Git repository, even if the Git repository has newer changes that would be overwritten.
	Force *bool `json:"force,omitempty"`
}

// ServiceBackupRestoreParameters parameters supplied to the Backup/Restore of an API Management service
// operation.
type ServiceBackupRestoreParameters struct {
	// StorageAccount - Azure Cloud Storage account (used to place/retrieve the backup) name.
	StorageAccount *string `json:"storageAccount,omitempty"`
	// AccessKey - Azure Cloud Storage account (used to place/retrieve the backup) access key.
	AccessKey *string `json:"accessKey,omitempty"`
	// ContainerName - Azure Cloud Storage blob container name used to place/retrieve the backup.
	ContainerName *string `json:"containerName,omitempty"`
	// BackupName - The name of the backup file to create.
	BackupName *string `json:"backupName,omitempty"`
}

// ServiceBaseParameters parameters supplied to the Update API Management service operation.
type ServiceBaseParameters struct {
	// Tags - API Management service tags. A maximum of 10 tags can be provided for a resource, and each tag must have a key no greater than 128 characters (and a value no greater than 256 characters).
	Tags map[string]*string `json:"tags"`
	// ServiceProperties - Properties of the API Management service.
	*ServiceProperties `json:"properties,omitempty"`
	// Sku - SKU properties of the API Management service.
	Sku *ServiceSkuProperties `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceBaseParameters.
func (sbp ServiceBaseParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sbp.Tags != nil {
		objectMap["tags"] = sbp.Tags
	}
	if sbp.ServiceProperties != nil {
		objectMap["properties"] = sbp.ServiceProperties
	}
	if sbp.Sku != nil {
		objectMap["sku"] = sbp.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceBaseParameters struct.
func (sbp *ServiceBaseParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sbp.Tags = tags
			}
		case "properties":
			if v != nil {
				var serviceProperties ServiceProperties
				err = json.Unmarshal(*v, &serviceProperties)
				if err != nil {
					return err
				}
				sbp.ServiceProperties = &serviceProperties
			}
		case "sku":
			if v != nil {
				var sku ServiceSkuProperties
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				sbp.Sku = &sku
			}
		}
	}

	return nil
}

// ServiceCheckNameAvailabilityParameters parameters supplied to the CheckNameAvailability operation.
type ServiceCheckNameAvailabilityParameters struct {
	// Name - The name to check for availability.
	Name *string `json:"name,omitempty"`
}

// ServiceGetSsoTokenResult the response of the GetSsoToken operation.
type ServiceGetSsoTokenResult struct {
	autorest.Response `json:"-"`
	// RedirectURI - Redirect URL containing the SSO token.
	RedirectURI *string `json:"redirect_uri,omitempty"`
}

// ServiceListResult the response of the List API Management services operation.
type ServiceListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List API Management services operation.
	Value *[]ServiceResource `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of API Management services.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServiceListResultIterator provides access to a complete listing of ServiceResource values.
type ServiceListResultIterator struct {
	i    int
	page ServiceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServiceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceListResultIterator) Response() ServiceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceListResultIterator) Value() ServiceResource {
	if !iter.page.NotDone() {
		return ServiceResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServiceListResultIterator type.
func NewServiceListResultIterator(page ServiceListResultPage) ServiceListResultIterator {
	return ServiceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (slr ServiceListResult) IsEmpty() bool {
	return slr.Value == nil || len(*slr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (slr ServiceListResult) hasNextLink() bool {
	return slr.NextLink != nil && len(*slr.NextLink) != 0
}

// serviceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slr ServiceListResult) serviceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !slr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slr.NextLink)))
}

// ServiceListResultPage contains a page of ServiceResource values.
type ServiceListResultPage struct {
	fn  func(context.Context, ServiceListResult) (ServiceListResult, error)
	slr ServiceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.slr)
		if err != nil {
			return err
		}
		page.slr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServiceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceListResultPage) NotDone() bool {
	return !page.slr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceListResultPage) Response() ServiceListResult {
	return page.slr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceListResultPage) Values() []ServiceResource {
	if page.slr.IsEmpty() {
		return nil
	}
	return *page.slr.Value
}

// Creates a new instance of the ServiceListResultPage type.
func NewServiceListResultPage(cur ServiceListResult, getNextPage func(context.Context, ServiceListResult) (ServiceListResult, error)) ServiceListResultPage {
	return ServiceListResultPage{
		fn:  getNextPage,
		slr: cur,
	}
}

// ServiceManageDeploymentsParameters parameters supplied to the ManageDeployments operation.
type ServiceManageDeploymentsParameters struct {
	// Location - Location of the API Management service Azure data center.
	Location *string `json:"location,omitempty"`
	// SkuType - SKU type of the API Management service. Possible values include: 'Developer', 'Standard', 'Premium'
	SkuType SkuType `json:"skuType,omitempty"`
	// SkuUnitCount - SKU Unit count of the API Management service. Default value is 1.
	SkuUnitCount *int32 `json:"skuUnitCount,omitempty"`
	// AdditionalLocations - Additional data center locations for the API Management service.
	AdditionalLocations *[]AdditionalRegion `json:"additionalLocations,omitempty"`
	// VpnConfiguration - Virtual network configuration.
	VpnConfiguration *VirtualNetworkConfiguration `json:"vpnConfiguration,omitempty"`
	// VpnType - The type of VPN in which API Management service needs to be configured in. None (Default Value) means the API Management service is not part of any Virtual Network, External means the API Management deployment is set up inside a Virtual Network having an Internet Facing Endpoint, and Internal means that the API Management service deployment is set up inside a Virtual Network having an Intranet Facing Endpoint only. When vpnConfiguration is specified, vpnType must be specified. Possible values include: 'VirtualNetworkTypeNone', 'VirtualNetworkTypeExternal', 'VirtualNetworkTypeInternal'
	VpnType VirtualNetworkType `json:"vpnType,omitempty"`
}

// ServiceNameAvailabilityResult response of the CheckNameAvailability operation.
type ServiceNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	// NameAvailable - True if the name is available and can be used to create a new API Management service; otherwise false.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Message - If reason == invalid, provide the user with the reason why the given name is invalid, and provide the resource naming requirements so that the user can select a valid name. If reason == AlreadyExists, explain that <resourceName> is already in use, and direct them to select a different name.
	Message *string `json:"message,omitempty"`
	// Reason - Invalid indicates the name provided does not match the resource provider’s naming requirements (incorrect length, unsupported characters, etc.)  AlreadyExists indicates that the name is already in use and is therefore unavailable. Possible values include: 'Valid', 'Invalid', 'AlreadyExists'
	Reason NameAvailabilityReason `json:"reason,omitempty"`
}

// ServiceProperties properties of an API Management service resource description.
type ServiceProperties struct {
	// PublisherEmail - Publisher email.
	PublisherEmail *string `json:"publisherEmail,omitempty"`
	// PublisherName - Publisher name.
	PublisherName *string `json:"publisherName,omitempty"`
	// ProvisioningState - READ-ONLY; The current provisioning state of the API Management service which can be one of the following: Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// TargetProvisioningState - READ-ONLY; The provisioning state of the API Management service, which is targeted by the long running operation started on the service.
	TargetProvisioningState *string `json:"targetProvisioningState,omitempty"`
	// CreatedAtUtc - READ-ONLY; Creation UTC date of the API Management service.The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	CreatedAtUtc *date.Time `json:"createdAtUtc,omitempty"`
	// RuntimeURL - READ-ONLY; Proxy endpoint URL of the API Management service.
	RuntimeURL *string `json:"runtimeUrl,omitempty"`
	// PortalURL - READ-ONLY; Publisher portal endpoint Url of the API Management service.
	PortalURL *string `json:"portalUrl,omitempty"`
	// ManagementAPIURL - READ-ONLY; Management API endpoint URL of the API Management service.
	ManagementAPIURL *string `json:"managementApiUrl,omitempty"`
	// ScmURL - READ-ONLY; SCM endpoint URL of the API Management service.
	ScmURL *string `json:"scmUrl,omitempty"`
	// AddresserEmail - Addresser email.
	AddresserEmail *string `json:"addresserEmail,omitempty"`
	// HostnameConfigurations - Custom hostname configuration of the API Management service.
	HostnameConfigurations *[]HostnameConfiguration `json:"hostnameConfigurations,omitempty"`
	// StaticIPs - READ-ONLY; Static IP addresses of the API Management service virtual machines. Available only for Standard and Premium SKU.
	StaticIPs *[]string `json:"staticIPs,omitempty"`
	// Vpnconfiguration - Virtual network configuration of the API Management service.
	Vpnconfiguration *VirtualNetworkConfiguration `json:"vpnconfiguration,omitempty"`
	// AdditionalLocations - Additional datacenter locations of the API Management service.
	AdditionalLocations *[]AdditionalRegion `json:"additionalLocations,omitempty"`
	// CustomProperties - Custom properties of the API Management service, like disabling TLS 1.0.
	CustomProperties map[string]*string `json:"customProperties"`
	// VpnType - The type of VPN in which API Management service needs to be configured in. None (Default Value) means the API Management service is not part of any Virtual Network, External means the API Management deployment is set up inside a Virtual Network having an Internet Facing Endpoint, and Internal means that API Management deployment is setup inside a Virtual Network having an Intranet Facing Endpoint only. Possible values include: 'VirtualNetworkTypeNone', 'VirtualNetworkTypeExternal', 'VirtualNetworkTypeInternal'
	VpnType VirtualNetworkType `json:"vpnType,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceProperties.
func (sp ServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.PublisherEmail != nil {
		objectMap["publisherEmail"] = sp.PublisherEmail
	}
	if sp.PublisherName != nil {
		objectMap["publisherName"] = sp.PublisherName
	}
	if sp.AddresserEmail != nil {
		objectMap["addresserEmail"] = sp.AddresserEmail
	}
	if sp.HostnameConfigurations != nil {
		objectMap["hostnameConfigurations"] = sp.HostnameConfigurations
	}
	if sp.Vpnconfiguration != nil {
		objectMap["vpnconfiguration"] = sp.Vpnconfiguration
	}
	if sp.AdditionalLocations != nil {
		objectMap["additionalLocations"] = sp.AdditionalLocations
	}
	if sp.CustomProperties != nil {
		objectMap["customProperties"] = sp.CustomProperties
	}
	if sp.VpnType != "" {
		objectMap["vpnType"] = sp.VpnType
	}
	return json.Marshal(objectMap)
}

// ServiceResource description of an API Management service resource.
type ServiceResource struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The ID of the created API Management service.
	ID *string `json:"id,omitempty"`
	// Location - Datacenter location of the API Management service.
	Location *string `json:"location,omitempty"`
	// Name - READ-ONLY; Name of the API Management service.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type of the API Management service.
	Type *string `json:"type,omitempty"`
	// Etag - ETag of the resource.
	Etag *string `json:"etag,omitempty"`
	// Tags - API Management service tags. A maximum of 10 tags can be provided for a resource, and each tag must have a key no greater than 128 characters (and a value no greater than 256 characters).
	Tags map[string]*string `json:"tags"`
	// ServiceProperties - Properties of the API Management service.
	*ServiceProperties `json:"properties,omitempty"`
	// Sku - SKU properties of the API Management service.
	Sku *ServiceSkuProperties `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceResource.
func (sr ServiceResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.Location != nil {
		objectMap["location"] = sr.Location
	}
	if sr.Etag != nil {
		objectMap["etag"] = sr.Etag
	}
	if sr.Tags != nil {
		objectMap["tags"] = sr.Tags
	}
	if sr.ServiceProperties != nil {
		objectMap["properties"] = sr.ServiceProperties
	}
	if sr.Sku != nil {
		objectMap["sku"] = sr.Sku
	}
	return json.Marshal(objectMap)
}

// ServicesBackupFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServicesBackupFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServicesClient) (ServiceResource, error)
}

// ServiceSkuProperties API Management service resource SKU properties.
type ServiceSkuProperties struct {
	// Name - Name of the Sku. Possible values include: 'Developer', 'Standard', 'Premium'
	Name SkuType `json:"name,omitempty"`
	// Capacity - Capacity of the SKU (number of deployed units of the SKU). The default value is 1.
	Capacity *int32 `json:"capacity,omitempty"`
}

// ServicesManageDeploymentsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ServicesManageDeploymentsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServicesClient) (ServiceResource, error)
}

// ServicesRestoreFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServicesRestoreFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServicesClient) (ServiceResource, error)
}

// ServicesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServicesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServicesClient) (ServiceResource, error)
}

// ServicesUpdateHostnameFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServicesUpdateHostnameFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServicesClient) (ServiceResource, error)
}

// ServiceUpdateHostnameParameters parameters supplied to the UpdateHostname operation.
type ServiceUpdateHostnameParameters struct {
	// Update - Hostnames to create or update.
	Update *[]HostnameConfiguration `json:"update,omitempty"`
	// Delete - Hostnames types to delete.
	Delete *[]HostnameType `json:"delete,omitempty"`
}

// ServiceUploadCertificateParameters parameters supplied to the Upload SSL certificate for an API
// Management service operation.
type ServiceUploadCertificateParameters struct {
	// Type - Hostname type. Possible values include: 'Proxy', 'Portal', 'Management', 'Scm'
	Type HostnameType `json:"type,omitempty"`
	// Certificate - Base64 Encoded certificate.
	Certificate *string `json:"certificate,omitempty"`
	// CertificatePassword - Certificate password.
	CertificatePassword *string `json:"certificate_password,omitempty"`
}

// SetObject ...
type SetObject struct {
	autorest.Response `json:"-"`
	Value             interface{} `json:"value,omitempty"`
}

// SubscriptionCollection paged Subscriptions list representation.
type SubscriptionCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]SubscriptionContract `json:"value,omitempty"`
	// Count - Total records count number.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// SubscriptionCollectionIterator provides access to a complete listing of SubscriptionContract values.
type SubscriptionCollectionIterator struct {
	i    int
	page SubscriptionCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SubscriptionCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubscriptionCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SubscriptionCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SubscriptionCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SubscriptionCollectionIterator) Response() SubscriptionCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SubscriptionCollectionIterator) Value() SubscriptionContract {
	if !iter.page.NotDone() {
		return SubscriptionContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SubscriptionCollectionIterator type.
func NewSubscriptionCollectionIterator(page SubscriptionCollectionPage) SubscriptionCollectionIterator {
	return SubscriptionCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sc SubscriptionCollection) IsEmpty() bool {
	return sc.Value == nil || len(*sc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sc SubscriptionCollection) hasNextLink() bool {
	return sc.NextLink != nil && len(*sc.NextLink) != 0
}

// subscriptionCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sc SubscriptionCollection) subscriptionCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !sc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sc.NextLink)))
}

// SubscriptionCollectionPage contains a page of SubscriptionContract values.
type SubscriptionCollectionPage struct {
	fn func(context.Context, SubscriptionCollection) (SubscriptionCollection, error)
	sc SubscriptionCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SubscriptionCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubscriptionCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sc)
		if err != nil {
			return err
		}
		page.sc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SubscriptionCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SubscriptionCollectionPage) NotDone() bool {
	return !page.sc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SubscriptionCollectionPage) Response() SubscriptionCollection {
	return page.sc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SubscriptionCollectionPage) Values() []SubscriptionContract {
	if page.sc.IsEmpty() {
		return nil
	}
	return *page.sc.Value
}

// Creates a new instance of the SubscriptionCollectionPage type.
func NewSubscriptionCollectionPage(cur SubscriptionCollection, getNextPage func(context.Context, SubscriptionCollection) (SubscriptionCollection, error)) SubscriptionCollectionPage {
	return SubscriptionCollectionPage{
		fn: getNextPage,
		sc: cur,
	}
}

// SubscriptionContract subscription details.
type SubscriptionContract struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Uniquely identifies the subscription within the current API Management service instance. The value is a valid relative URL in the format of /subscriptions/{sid} where {sid} is a subscription identifier.
	ID *string `json:"id,omitempty"`
	// UserID - The user resource identifier of the subscription owner. The value is a valid relative URL in the format of /users/{uid} where {uid} is a user identifier.
	UserID *string `json:"userId,omitempty"`
	// ProductID - The product resource identifier of the subscribed product. The value is a valid relative URL in the format of /products/{productId} where {productId} is a product identifier.
	ProductID *string `json:"productId,omitempty"`
	// Name - The name of the subscription, or null if the subscription has no name.
	Name *string `json:"name,omitempty"`
	// State - Subscription state. Possible states are * active – the subscription is active, * suspended – the subscription is blocked, and the subscriber cannot call any APIs of the product, * submitted – the subscription request has been made by the developer, but has not yet been approved or rejected, * rejected – the subscription request has been denied by an administrator, * cancelled – the subscription has been cancelled by the developer or administrator, * expired – the subscription reached its expiration date and was deactivated. Possible values include: 'Suspended', 'Active', 'Expired', 'Submitted', 'Rejected', 'Cancelled'
	State SubscriptionStateContract `json:"state,omitempty"`
	// CreatedDate - READ-ONLY; Subscription creation date. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// StartDate - Subscription activation date. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	StartDate *date.Time `json:"startDate,omitempty"`
	// ExpirationDate - Subscription expiration date. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
	// EndDate - Date when subscription was cancelled or expired. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	EndDate *date.Time `json:"endDate,omitempty"`
	// NotificationDate - Upcoming subscription expiration notification date. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	NotificationDate *date.Time `json:"notificationDate,omitempty"`
	// PrimaryKey - Subscription primary key.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - Subscription secondary key.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// StateComment - Optional subscription comment added by an administrator.
	StateComment *string `json:"stateComment,omitempty"`
}

// MarshalJSON is the custom marshaler for SubscriptionContract.
func (sc SubscriptionContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sc.UserID != nil {
		objectMap["userId"] = sc.UserID
	}
	if sc.ProductID != nil {
		objectMap["productId"] = sc.ProductID
	}
	if sc.Name != nil {
		objectMap["name"] = sc.Name
	}
	if sc.State != "" {
		objectMap["state"] = sc.State
	}
	if sc.StartDate != nil {
		objectMap["startDate"] = sc.StartDate
	}
	if sc.ExpirationDate != nil {
		objectMap["expirationDate"] = sc.ExpirationDate
	}
	if sc.EndDate != nil {
		objectMap["endDate"] = sc.EndDate
	}
	if sc.NotificationDate != nil {
		objectMap["notificationDate"] = sc.NotificationDate
	}
	if sc.PrimaryKey != nil {
		objectMap["primaryKey"] = sc.PrimaryKey
	}
	if sc.SecondaryKey != nil {
		objectMap["secondaryKey"] = sc.SecondaryKey
	}
	if sc.StateComment != nil {
		objectMap["stateComment"] = sc.StateComment
	}
	return json.Marshal(objectMap)
}

// SubscriptionCreateParameters parameters supplied to the Create subscription operation.
type SubscriptionCreateParameters struct {
	// UserID - User (user id path) for whom subscription is being created in form /users/{uid}
	UserID *string `json:"userId,omitempty"`
	// ProductID - Product (product id path) for which subscription is being created in form /products/{productId}
	ProductID *string `json:"productId,omitempty"`
	// Name - Subscription name.
	Name *string `json:"name,omitempty"`
	// PrimaryKey - Primary subscription key. If not specified during request key will be generated automatically.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - Secondary subscription key. If not specified during request key will be generated automatically.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// State - Initial subscription state. If no value is specified, subscription is created with Submitted state. Possible states are * active – the subscription is active, * suspended – the subscription is blocked, and the subscriber cannot call any APIs of the product, * submitted – the subscription request has been made by the developer, but has not yet been approved or rejected, * rejected – the subscription request has been denied by an administrator, * cancelled – the subscription has been cancelled by the developer or administrator, * expired – the subscription reached its expiration date and was deactivated. Possible values include: 'Suspended', 'Active', 'Expired', 'Submitted', 'Rejected', 'Cancelled'
	State SubscriptionStateContract `json:"state,omitempty"`
}

// SubscriptionKeyParameterNamesContract subscription key parameter names details.
type SubscriptionKeyParameterNamesContract struct {
	// Header - Subscription key header name.
	Header *string `json:"header,omitempty"`
	// Query - Subscription key query string parameter name.
	Query *string `json:"query,omitempty"`
}

// SubscriptionUpdateParameters parameters supplied to the Update subscription operation.
type SubscriptionUpdateParameters struct {
	// UserID - User identifier path: /users/{uid}
	UserID *string `json:"userId,omitempty"`
	// ProductID - Product identifier path: /products/{productId}
	ProductID *string `json:"productId,omitempty"`
	// ExpirationDate - New subscription expiration date.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
	// Name - Subscription name.
	Name *string `json:"name,omitempty"`
	// PrimaryKey - Primary subscription key.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - Secondary subscription key.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// State - Subscription state. Possible states are * active – the subscription is active, * suspended – the subscription is blocked, and the subscriber cannot call any APIs of the product, * submitted – the subscription request has been made by the developer, but has not yet been approved or rejected, * rejected – the subscription request has been denied by an administrator, * cancelled – the subscription has been cancelled by the developer or administrator, * expired – the subscription reached its expiration date and was deactivated. Possible values include: 'Suspended', 'Active', 'Expired', 'Submitted', 'Rejected', 'Cancelled'
	State SubscriptionStateContract `json:"state,omitempty"`
	// StateComment - Comments describing subscription state change by the administrator.
	StateComment *string `json:"stateComment,omitempty"`
}

// TenantConfigurationDeployFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type TenantConfigurationDeployFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TenantConfigurationClient) (OperationResultContract, error)
}

// TenantConfigurationSaveFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type TenantConfigurationSaveFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TenantConfigurationClient) (OperationResultContract, error)
}

// TenantConfigurationSyncStateContract tenant Configuration Synchronization State.
type TenantConfigurationSyncStateContract struct {
	autorest.Response `json:"-"`
	// Branch - The name of Git branch.
	Branch *string `json:"branch,omitempty"`
	// CommitID - The latest commit Id.
	CommitID *string `json:"commitId,omitempty"`
	// IsExport - value indicating if last sync was save (true) or deploy (false) operation.
	IsExport *bool `json:"isExport,omitempty"`
	// IsSynced - value indicating if last synchronization was later than the configuration change.
	IsSynced *bool `json:"isSynced,omitempty"`
	// IsGitEnabled - value indicating whether Git configuration access is enabled.
	IsGitEnabled *bool `json:"isGitEnabled,omitempty"`
	// SyncDate - The date of the latest synchronization. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	SyncDate *date.Time `json:"syncDate,omitempty"`
	// ConfigurationChangeDate - The date of the latest configuration change. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	ConfigurationChangeDate *date.Time `json:"configurationChangeDate,omitempty"`
}

// TenantConfigurationValidateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type TenantConfigurationValidateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TenantConfigurationClient) (OperationResultContract, error)
}

// TenantLongRunningOperationResult a standard service response for long running tenant operations.
type TenantLongRunningOperationResult struct {
	// OperationStatusLink - operation status link.
	OperationStatusLink *string `json:"operationStatusLink,omitempty"`
	// RetryAfter - The number of minutes to retry the operation after.
	RetryAfter *int32 `json:"retryAfter,omitempty"`
	// Status - Current status of the operation. Possible values include: 'OperationStatusInProgress', 'OperationStatusSucceeded', 'OperationStatusFailed'
	Status OperationStatus `json:"status,omitempty"`
	// StatusCode - Possible values include: 'Continue', 'OK', 'Created', 'Accepted', 'NotFound', 'Conflict'
	StatusCode HTTPStatusCode `json:"statusCode,omitempty"`
	RequestID  *string        `json:"requestId,omitempty"`
}

// TokenBodyParameterContract oAuth acquire token request body parameter (www-url-form-encoded).
type TokenBodyParameterContract struct {
	// Name - body parameter name.
	Name *string `json:"name,omitempty"`
	// Value - body parameter value.
	Value *string `json:"value,omitempty"`
}

// UserCollection paged Users list representation.
type UserCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]UserContract `json:"value,omitempty"`
	// Count - Total records count number.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// UserCollectionIterator provides access to a complete listing of UserContract values.
type UserCollectionIterator struct {
	i    int
	page UserCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *UserCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UserCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *UserCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter UserCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter UserCollectionIterator) Response() UserCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter UserCollectionIterator) Value() UserContract {
	if !iter.page.NotDone() {
		return UserContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the UserCollectionIterator type.
func NewUserCollectionIterator(page UserCollectionPage) UserCollectionIterator {
	return UserCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (uc UserCollection) IsEmpty() bool {
	return uc.Value == nil || len(*uc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (uc UserCollection) hasNextLink() bool {
	return uc.NextLink != nil && len(*uc.NextLink) != 0
}

// userCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (uc UserCollection) userCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !uc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(uc.NextLink)))
}

// UserCollectionPage contains a page of UserContract values.
type UserCollectionPage struct {
	fn func(context.Context, UserCollection) (UserCollection, error)
	uc UserCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *UserCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UserCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.uc)
		if err != nil {
			return err
		}
		page.uc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *UserCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page UserCollectionPage) NotDone() bool {
	return !page.uc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page UserCollectionPage) Response() UserCollection {
	return page.uc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page UserCollectionPage) Values() []UserContract {
	if page.uc.IsEmpty() {
		return nil
	}
	return *page.uc.Value
}

// Creates a new instance of the UserCollectionPage type.
func NewUserCollectionPage(cur UserCollection, getNextPage func(context.Context, UserCollection) (UserCollection, error)) UserCollectionPage {
	return UserCollectionPage{
		fn: getNextPage,
		uc: cur,
	}
}

// UserContract user profile.
type UserContract struct {
	autorest.Response `json:"-"`
	// ID - User identifier path.
	ID *string `json:"id,omitempty"`
	// FirstName - First name.
	FirstName *string `json:"firstName,omitempty"`
	// LastName - Last name.
	LastName *string `json:"lastName,omitempty"`
	// Email - Email address.
	Email *string `json:"email,omitempty"`
	// State - User state. Possible values include: 'UserStateContractActive', 'UserStateContractBlocked'
	State UserStateContract `json:"state,omitempty"`
	// RegistrationDate - Date of user registration. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	RegistrationDate *date.Time `json:"registrationDate,omitempty"`
	// Note - Administrator's note about given user.
	Note *string `json:"note,omitempty"`
	// Identities - READ-ONLY; Collection of user identities.
	Identities *[]UserIdentityContract `json:"identities,omitempty"`
}

// MarshalJSON is the custom marshaler for UserContract.
func (uc UserContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if uc.ID != nil {
		objectMap["id"] = uc.ID
	}
	if uc.FirstName != nil {
		objectMap["firstName"] = uc.FirstName
	}
	if uc.LastName != nil {
		objectMap["lastName"] = uc.LastName
	}
	if uc.Email != nil {
		objectMap["email"] = uc.Email
	}
	if uc.State != "" {
		objectMap["state"] = uc.State
	}
	if uc.RegistrationDate != nil {
		objectMap["registrationDate"] = uc.RegistrationDate
	}
	if uc.Note != nil {
		objectMap["note"] = uc.Note
	}
	return json.Marshal(objectMap)
}

// UserCreateParameters parameters supplied to the Create User operation.
type UserCreateParameters struct {
	// Email - Email address. Must not be empty and must be unique within the service instance.
	Email *string `json:"email,omitempty"`
	// Password - User Password.
	Password *string `json:"password,omitempty"`
	// FirstName - First name.
	FirstName *string `json:"firstName,omitempty"`
	// LastName - Last name.
	LastName *string `json:"lastName,omitempty"`
	// State - Account state. Specifies whether the user is active or not. Blocked users are unable to sign into the developer portal or call any APIs of subscribed products. Default state is Active. Possible values include: 'UserStateContractActive', 'UserStateContractBlocked'
	State UserStateContract `json:"state,omitempty"`
	// Note - Optional note about a user set by the administrator.
	Note *string `json:"note,omitempty"`
}

// UserIdentityContract user identity details.
type UserIdentityContract struct {
	// Provider - Identity provider name.
	Provider *string `json:"provider,omitempty"`
	// ID - Identifier value within provider.
	ID *string `json:"id,omitempty"`
}

// UserUpdateParameters parameters supplied to the Update User operation.
type UserUpdateParameters struct {
	// Email - Email address.
	Email *string `json:"email,omitempty"`
	// Password - Password.
	Password *string `json:"password,omitempty"`
	// FirstName - First name.
	FirstName *string `json:"firstName,omitempty"`
	// LastName - Last name.
	LastName *string `json:"lastName,omitempty"`
	// State - Account state. Possible values include: 'UserStateContractActive', 'UserStateContractBlocked'
	State UserStateContract `json:"state,omitempty"`
	// Note - Note about user.
	Note *string `json:"note,omitempty"`
}

// VirtualNetworkConfiguration configuration of a virtual network to which API Management service is
// deployed.
type VirtualNetworkConfiguration struct {
	// Vnetid - READ-ONLY; The virtual network ID. This is typically a GUID. Expect a null GUID by default.
	Vnetid *string `json:"vnetid,omitempty"`
	// Subnetname - READ-ONLY; The name of the subnet.
	Subnetname *string `json:"subnetname,omitempty"`
	// SubnetResourceID - The name of the subnet Resource ID. This has format /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/{virtual network name}/subnets/{subnet name}.
	SubnetResourceID *string `json:"subnetResourceId,omitempty"`
	// Location - The location of the virtual network.
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkConfiguration.
func (vnc VirtualNetworkConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vnc.SubnetResourceID != nil {
		objectMap["subnetResourceId"] = vnc.SubnetResourceID
	}
	if vnc.Location != nil {
		objectMap["location"] = vnc.Location
	}
	return json.Marshal(objectMap)
}
