// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dynamodb

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateContributorInsightsInput struct {
	_ struct{} `type:"structure"`

	// Represents the contributor insights action.
	//
	// ContributorInsightsAction is a required field
	ContributorInsightsAction ContributorInsightsAction `type:"string" required:"true" enum:"true"`

	// The global secondary index name, if applicable.
	IndexName *string `min:"3" type:"string"`

	// The name of the table.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateContributorInsightsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateContributorInsightsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateContributorInsightsInput"}
	if len(s.ContributorInsightsAction) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ContributorInsightsAction"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("IndexName", 3))
	}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateContributorInsightsOutput struct {
	_ struct{} `type:"structure"`

	// The status of contributor insights
	ContributorInsightsStatus ContributorInsightsStatus `type:"string" enum:"true"`

	// The name of the global secondary index, if applicable.
	IndexName *string `min:"3" type:"string"`

	// The name of the table.
	TableName *string `min:"3" type:"string"`
}

// String returns the string representation
func (s UpdateContributorInsightsOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateContributorInsights = "UpdateContributorInsights"

// UpdateContributorInsightsRequest returns a request value for making API operation for
// Amazon DynamoDB.
//
// Updates the status for contributor insights for a specific table or index.
//
//    // Example sending a request using UpdateContributorInsightsRequest.
//    req := client.UpdateContributorInsightsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateContributorInsights
func (c *Client) UpdateContributorInsightsRequest(input *UpdateContributorInsightsInput) UpdateContributorInsightsRequest {
	op := &aws.Operation{
		Name:       opUpdateContributorInsights,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateContributorInsightsInput{}
	}

	req := c.newRequest(op, input, &UpdateContributorInsightsOutput{})
	return UpdateContributorInsightsRequest{Request: req, Input: input, Copy: c.UpdateContributorInsightsRequest}
}

// UpdateContributorInsightsRequest is the request type for the
// UpdateContributorInsights API operation.
type UpdateContributorInsightsRequest struct {
	*aws.Request
	Input *UpdateContributorInsightsInput
	Copy  func(*UpdateContributorInsightsInput) UpdateContributorInsightsRequest
}

// Send marshals and sends the UpdateContributorInsights API request.
func (r UpdateContributorInsightsRequest) Send(ctx context.Context) (*UpdateContributorInsightsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateContributorInsightsResponse{
		UpdateContributorInsightsOutput: r.Request.Data.(*UpdateContributorInsightsOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateContributorInsightsResponse is the response type for the
// UpdateContributorInsights API operation.
type UpdateContributorInsightsResponse struct {
	*UpdateContributorInsightsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateContributorInsights request.
func (r *UpdateContributorInsightsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
