// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudsearch

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Container for the parameters to the DeleteDomain operation. Specifies the
// name of the domain you want to delete.
type DeleteDomainInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain you want to permanently delete.
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDomainInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDomainInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteDomainInput"}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DeleteDomain request. Contains the status of a newly deleted
// domain, or no status if the domain has already been completely deleted.
type DeleteDomainOutput struct {
	_ struct{} `type:"structure"`

	// The current status of the search domain.
	DomainStatus *DomainStatus `type:"structure"`
}

// String returns the string representation
func (s DeleteDomainOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteDomain = "DeleteDomain"

// DeleteDomainRequest returns a request value for making API operation for
// Amazon CloudSearch.
//
// Permanently deletes a search domain and all of its data. Once a domain has
// been deleted, it cannot be recovered. For more information, see Deleting
// a Search Domain (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/deleting-domains.html)
// in the Amazon CloudSearch Developer Guide.
//
//    // Example sending a request using DeleteDomainRequest.
//    req := client.DeleteDomainRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DeleteDomainRequest(input *DeleteDomainInput) DeleteDomainRequest {
	op := &aws.Operation{
		Name:       opDeleteDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDomainInput{}
	}

	req := c.newRequest(op, input, &DeleteDomainOutput{})
	return DeleteDomainRequest{Request: req, Input: input, Copy: c.DeleteDomainRequest}
}

// DeleteDomainRequest is the request type for the
// DeleteDomain API operation.
type DeleteDomainRequest struct {
	*aws.Request
	Input *DeleteDomainInput
	Copy  func(*DeleteDomainInput) DeleteDomainRequest
}

// Send marshals and sends the DeleteDomain API request.
func (r DeleteDomainRequest) Send(ctx context.Context) (*DeleteDomainResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteDomainResponse{
		DeleteDomainOutput: r.Request.Data.(*DeleteDomainOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteDomainResponse is the response type for the
// DeleteDomain API operation.
type DeleteDomainResponse struct {
	*DeleteDomainOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteDomain request.
func (r *DeleteDomainResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
