// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationinsights

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteLogPatternInput struct {
	_ struct{} `type:"structure"`

	// The name of the log pattern.
	//
	// PatternName is a required field
	PatternName *string `min:"1" type:"string" required:"true"`

	// The name of the log pattern set.
	//
	// PatternSetName is a required field
	PatternSetName *string `min:"1" type:"string" required:"true"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLogPatternInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLogPatternInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteLogPatternInput"}

	if s.PatternName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PatternName"))
	}
	if s.PatternName != nil && len(*s.PatternName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PatternName", 1))
	}

	if s.PatternSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PatternSetName"))
	}
	if s.PatternSetName != nil && len(*s.PatternSetName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PatternSetName", 1))
	}

	if s.ResourceGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceGroupName"))
	}
	if s.ResourceGroupName != nil && len(*s.ResourceGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteLogPatternOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLogPatternOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteLogPattern = "DeleteLogPattern"

// DeleteLogPatternRequest returns a request value for making API operation for
// Amazon CloudWatch Application Insights.
//
// Removes the specified log pattern from a LogPatternSet.
//
//    // Example sending a request using DeleteLogPatternRequest.
//    req := client.DeleteLogPatternRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DeleteLogPattern
func (c *Client) DeleteLogPatternRequest(input *DeleteLogPatternInput) DeleteLogPatternRequest {
	op := &aws.Operation{
		Name:       opDeleteLogPattern,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLogPatternInput{}
	}

	req := c.newRequest(op, input, &DeleteLogPatternOutput{})
	return DeleteLogPatternRequest{Request: req, Input: input, Copy: c.DeleteLogPatternRequest}
}

// DeleteLogPatternRequest is the request type for the
// DeleteLogPattern API operation.
type DeleteLogPatternRequest struct {
	*aws.Request
	Input *DeleteLogPatternInput
	Copy  func(*DeleteLogPatternInput) DeleteLogPatternRequest
}

// Send marshals and sends the DeleteLogPattern API request.
func (r DeleteLogPatternRequest) Send(ctx context.Context) (*DeleteLogPatternResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteLogPatternResponse{
		DeleteLogPatternOutput: r.Request.Data.(*DeleteLogPatternOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteLogPatternResponse is the response type for the
// DeleteLogPattern API operation.
type DeleteLogPatternResponse struct {
	*DeleteLogPatternOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteLogPattern request.
func (r *DeleteLogPatternResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
