// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package accessanalyzer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Retrieves a finding.
type GetFindingInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the analyzer that generated the finding.
	//
	// AnalyzerArn is a required field
	AnalyzerArn *string `location:"querystring" locationName:"analyzerArn" type:"string" required:"true"`

	// The ID of the finding to retrieve.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetFindingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFindingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetFindingInput"}

	if s.AnalyzerArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("AnalyzerArn"))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetFindingInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AnalyzerArn != nil {
		v := *s.AnalyzerArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "analyzerArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The response to the request.
type GetFindingOutput struct {
	_ struct{} `type:"structure"`

	// A finding object that contains finding details.
	Finding *Finding `locationName:"finding" type:"structure"`
}

// String returns the string representation
func (s GetFindingOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetFindingOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Finding != nil {
		v := s.Finding

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "finding", v, metadata)
	}
	return nil
}

const opGetFinding = "GetFinding"

// GetFindingRequest returns a request value for making API operation for
// Access Analyzer.
//
// Retrieves information about the specified finding.
//
//    // Example sending a request using GetFindingRequest.
//    req := client.GetFindingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetFinding
func (c *Client) GetFindingRequest(input *GetFindingInput) GetFindingRequest {
	op := &aws.Operation{
		Name:       opGetFinding,
		HTTPMethod: "GET",
		HTTPPath:   "/finding/{id}",
	}

	if input == nil {
		input = &GetFindingInput{}
	}

	req := c.newRequest(op, input, &GetFindingOutput{})
	return GetFindingRequest{Request: req, Input: input, Copy: c.GetFindingRequest}
}

// GetFindingRequest is the request type for the
// GetFinding API operation.
type GetFindingRequest struct {
	*aws.Request
	Input *GetFindingInput
	Copy  func(*GetFindingInput) GetFindingRequest
}

// Send marshals and sends the GetFinding API request.
func (r GetFindingRequest) Send(ctx context.Context) (*GetFindingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetFindingResponse{
		GetFindingOutput: r.Request.Data.(*GetFindingOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetFindingResponse is the response type for the
// GetFinding API operation.
type GetFindingResponse struct {
	*GetFindingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetFinding request.
func (r *GetFindingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
