// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/cloud/mediatranslation/v1alpha1/media_translation.proto

package mediatranslation

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Indicates the type of speech event.
type StreamingTranslateSpeechResponse_SpeechEventType int32

const (
	// No speech event specified.
	StreamingTranslateSpeechResponse_SPEECH_EVENT_TYPE_UNSPECIFIED StreamingTranslateSpeechResponse_SpeechEventType = 0
	// This event indicates that the server has detected the end of the user's
	// speech utterance and expects no additional speech. Therefore, the server
	// will not process additional audio (although it may subsequently return
	// additional results). When the client receives `END_OF_SINGLE_UTTERANCE`
	// event, the client should stop sending the requests. However, clients
	// should keep receiving remaining responses until the stream is terminated.
	// To construct the complete sentence in a streaming way, one should
	// override (if `is_final` of previous response is `false`), or append (if
	// `is_final` of previous response is `true`). This event is only sent if
	// `single_utterance` was set to `true`, and is not used otherwise.
	StreamingTranslateSpeechResponse_END_OF_SINGLE_UTTERANCE StreamingTranslateSpeechResponse_SpeechEventType = 1
)

// Enum value maps for StreamingTranslateSpeechResponse_SpeechEventType.
var (
	StreamingTranslateSpeechResponse_SpeechEventType_name = map[int32]string{
		0: "SPEECH_EVENT_TYPE_UNSPECIFIED",
		1: "END_OF_SINGLE_UTTERANCE",
	}
	StreamingTranslateSpeechResponse_SpeechEventType_value = map[string]int32{
		"SPEECH_EVENT_TYPE_UNSPECIFIED": 0,
		"END_OF_SINGLE_UTTERANCE":       1,
	}
)

func (x StreamingTranslateSpeechResponse_SpeechEventType) Enum() *StreamingTranslateSpeechResponse_SpeechEventType {
	p := new(StreamingTranslateSpeechResponse_SpeechEventType)
	*p = x
	return p
}

func (x StreamingTranslateSpeechResponse_SpeechEventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StreamingTranslateSpeechResponse_SpeechEventType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_enumTypes[0].Descriptor()
}

func (StreamingTranslateSpeechResponse_SpeechEventType) Type() protoreflect.EnumType {
	return &file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_enumTypes[0]
}

func (x StreamingTranslateSpeechResponse_SpeechEventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StreamingTranslateSpeechResponse_SpeechEventType.Descriptor instead.
func (StreamingTranslateSpeechResponse_SpeechEventType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_rawDescGZIP(), []int{4, 0}
}

// Provides information to the speech translation that specifies how to process
// the request.
type TranslateSpeechConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Encoding of audio data.
	// Supported formats:
	//
	// - `linear16`
	//
	//   Uncompressed 16-bit signed little-endian samples (Linear PCM).
	//
	// - `flac`
	//
	//   `flac` (Free Lossless Audio Codec) is the recommended encoding
	//   because it is lossless--therefore recognition is not compromised--and
	//   requires only about half the bandwidth of `linear16`.
	//
	// - `mulaw`
	//
	//   8-bit samples that compand 14-bit audio samples using G.711 PCMU/mu-law.
	//
	// - `amr`
	//
	//   Adaptive Multi-Rate Narrowband codec. `sample_rate_hertz` must be 8000.
	//
	// - `amr-wb`
	//
	//   Adaptive Multi-Rate Wideband codec. `sample_rate_hertz` must be 16000.
	//
	// - `ogg-opus`
	//
	//   Opus encoded audio frames in Ogg container
	//   ([OggOpus](https://wiki.xiph.org/OggOpus)).
	//   `sample_rate_hertz` must be one of 8000, 12000, 16000, 24000, or 48000.
	//
	// - `mp3`
	//
	//   MP3 audio. Support all standard MP3 bitrates (which range from 32-320
	//   kbps). When using this encoding, `sample_rate_hertz` has to match the
	//   sample rate of the file being used.
	//
	//
	AudioEncoding string `protobuf:"bytes,1,opt,name=audio_encoding,json=audioEncoding,proto3" json:"audio_encoding,omitempty"`
	// Required. Source language code (BCP-47) of the input audio.
	SourceLanguageCode string `protobuf:"bytes,2,opt,name=source_language_code,json=sourceLanguageCode,proto3" json:"source_language_code,omitempty"`
	// Required. Target language code (BCP-47) of the output.
	TargetLanguageCode string `protobuf:"bytes,3,opt,name=target_language_code,json=targetLanguageCode,proto3" json:"target_language_code,omitempty"`
	// Optional. A list of up to 3 additional language codes (BCP-47), listing possible
	// alternative languages of the supplied audio. If alternative source
	// languages are listed, speech translation result will translate in the most
	// likely language detected including the main source_language_code. The
	// translated result will include the language code of the language detected
	// in the audio.
	// Note:
	// 1. If the provided alternative_source_language_code is not supported
	// by current API version, we will skip that language code.
	// 2. If user only provided one eligible alternative_source_language_codes,
	// the translation will happen between source_language_code and
	// alternative_source_language_codes. The target_language_code will be
	// ignored. It will be useful in conversation mode.
	AlternativeSourceLanguageCodes []string `protobuf:"bytes,6,rep,name=alternative_source_language_codes,json=alternativeSourceLanguageCodes,proto3" json:"alternative_source_language_codes,omitempty"`
	// Optional. Sample rate in Hertz of the audio data. Valid values are:
	// 8000-48000. 16000 is optimal. For best results, set the sampling rate of
	// the audio source to 16000 Hz. If that's not possible, use the native sample
	// rate of the audio source (instead of re-sampling).
	//
	SampleRateHertz int32 `protobuf:"varint,4,opt,name=sample_rate_hertz,json=sampleRateHertz,proto3" json:"sample_rate_hertz,omitempty"`
	// Optional.
	Model string `protobuf:"bytes,5,opt,name=model,proto3" json:"model,omitempty"`
}

func (x *TranslateSpeechConfig) Reset() {
	*x = TranslateSpeechConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TranslateSpeechConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TranslateSpeechConfig) ProtoMessage() {}

func (x *TranslateSpeechConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TranslateSpeechConfig.ProtoReflect.Descriptor instead.
func (*TranslateSpeechConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_rawDescGZIP(), []int{0}
}

func (x *TranslateSpeechConfig) GetAudioEncoding() string {
	if x != nil {
		return x.AudioEncoding
	}
	return ""
}

func (x *TranslateSpeechConfig) GetSourceLanguageCode() string {
	if x != nil {
		return x.SourceLanguageCode
	}
	return ""
}

func (x *TranslateSpeechConfig) GetTargetLanguageCode() string {
	if x != nil {
		return x.TargetLanguageCode
	}
	return ""
}

func (x *TranslateSpeechConfig) GetAlternativeSourceLanguageCodes() []string {
	if x != nil {
		return x.AlternativeSourceLanguageCodes
	}
	return nil
}

func (x *TranslateSpeechConfig) GetSampleRateHertz() int32 {
	if x != nil {
		return x.SampleRateHertz
	}
	return 0
}

func (x *TranslateSpeechConfig) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

// Config used for streaming translation.
type StreamingTranslateSpeechConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The common config for all the following audio contents.
	AudioConfig *TranslateSpeechConfig `protobuf:"bytes,1,opt,name=audio_config,json=audioConfig,proto3" json:"audio_config,omitempty"`
	// Optional. If `false` or omitted, the system performs
	// continuous translation (continuing to wait for and process audio even if
	// the user pauses speaking) until the client closes the input stream (gRPC
	// API) or until the maximum time limit has been reached. May return multiple
	// `StreamingTranslateSpeechResult`s with the `is_final` flag set to `true`.
	//
	// If `true`, the speech translator will detect a single spoken utterance.
	// When it detects that the user has paused or stopped speaking, it will
	// return an `END_OF_SINGLE_UTTERANCE` event and cease translation.
	// When the client receives `END_OF_SINGLE_UTTERANCE` event, the client should
	// stop sending the requests. However, clients should keep receiving remaining
	// responses until the stream is terminated. To construct the complete
	// sentence in a streaming way, one should override (if `is_final` of previous
	// response is false), or append (if 'is_final' of previous response is true).
	SingleUtterance bool `protobuf:"varint,2,opt,name=single_utterance,json=singleUtterance,proto3" json:"single_utterance,omitempty"`
	// Optional. Stability control for the media translation text. The value should be
	// "LOW", "MEDIUM", "HIGH". It applies to text/text_and_audio translation
	// only.
	// For audio translation mode, we only support HIGH stability mode,
	// low/medium stability mode will throw argument error.
	// Default empty string will be treated as "HIGH" in audio translation mode;
	// will be treated as "LOW" in other translation mode.
	// Note that stability and speed would be trade off.
	// 1. "LOW": In low mode, translation service will start to do translation
	// right after getting recognition response. The speed will be faster.
	// 2. "MEDIUM": In medium mode, translation service will
	// check if the recognition response is stable enough or not, and only
	// translate recognition response which is not likely to be changed later.
	// 3. "HIGH": In high mode, translation service will wait for more stable
	// recognition responses, and then start to do translation. Also, the
	// following recognition responses cannot modify previous recognition
	// responses. Thus it may impact quality in some situation. "HIGH" stability
	// will generate "final" responses more frequently.
	//
	Stability string `protobuf:"bytes,3,opt,name=stability,proto3" json:"stability,omitempty"`
	// Optional. Translation mode, the value should be "text", "audio", "text_and_audio".
	// Default empty string will be treated as "text".
	// 1. "text": The response will be text translation. Text translation has a
	// field "is_final". Detailed definition can be found in
	// `TextTranslationResult`.
	// 2. "audio": The response will be audio translation. Audio translation does
	// not have "is_final" field, which means each audio translation response is
	// stable and will not be changed by later response.
	// Translation mode "audio" can only be used with "high" stability mode,
	// 3. "text_and_audio": The response will have a text translation, when
	// "is_final" is true, we will also output its corresponding audio
	// translation. When "is_final" is false, audio_translation field will be
	// empty.
	TranslationMode string `protobuf:"bytes,4,opt,name=translation_mode,json=translationMode,proto3" json:"translation_mode,omitempty"`
	// Optional. If disable_interim_results is true, we will only return "final" responses.
	// Otherwise, we will return all the responses. Default value will be false.
	// User can only set disable_interim_results to be true with "high" stability
	// mode.
	DisableInterimResults bool `protobuf:"varint,5,opt,name=disable_interim_results,json=disableInterimResults,proto3" json:"disable_interim_results,omitempty"`
}

func (x *StreamingTranslateSpeechConfig) Reset() {
	*x = StreamingTranslateSpeechConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamingTranslateSpeechConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingTranslateSpeechConfig) ProtoMessage() {}

func (x *StreamingTranslateSpeechConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingTranslateSpeechConfig.ProtoReflect.Descriptor instead.
func (*StreamingTranslateSpeechConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_rawDescGZIP(), []int{1}
}

func (x *StreamingTranslateSpeechConfig) GetAudioConfig() *TranslateSpeechConfig {
	if x != nil {
		return x.AudioConfig
	}
	return nil
}

func (x *StreamingTranslateSpeechConfig) GetSingleUtterance() bool {
	if x != nil {
		return x.SingleUtterance
	}
	return false
}

func (x *StreamingTranslateSpeechConfig) GetStability() string {
	if x != nil {
		return x.Stability
	}
	return ""
}

func (x *StreamingTranslateSpeechConfig) GetTranslationMode() string {
	if x != nil {
		return x.TranslationMode
	}
	return ""
}

func (x *StreamingTranslateSpeechConfig) GetDisableInterimResults() bool {
	if x != nil {
		return x.DisableInterimResults
	}
	return false
}

// The top-level message sent by the client for the `StreamingTranslateSpeech`
// method. Multiple `StreamingTranslateSpeechRequest` messages are sent. The
// first message must contain a `streaming_config` message and must not contain
// `audio_content` data. All subsequent messages must contain `audio_content`
// data and must not contain a `streaming_config` message.
type StreamingTranslateSpeechRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The streaming request, which is either a streaming config or content.
	//
	// Types that are assignable to StreamingRequest:
	//	*StreamingTranslateSpeechRequest_StreamingConfig
	//	*StreamingTranslateSpeechRequest_AudioContent
	StreamingRequest isStreamingTranslateSpeechRequest_StreamingRequest `protobuf_oneof:"streaming_request"`
}

func (x *StreamingTranslateSpeechRequest) Reset() {
	*x = StreamingTranslateSpeechRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamingTranslateSpeechRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingTranslateSpeechRequest) ProtoMessage() {}

func (x *StreamingTranslateSpeechRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingTranslateSpeechRequest.ProtoReflect.Descriptor instead.
func (*StreamingTranslateSpeechRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_rawDescGZIP(), []int{2}
}

func (m *StreamingTranslateSpeechRequest) GetStreamingRequest() isStreamingTranslateSpeechRequest_StreamingRequest {
	if m != nil {
		return m.StreamingRequest
	}
	return nil
}

func (x *StreamingTranslateSpeechRequest) GetStreamingConfig() *StreamingTranslateSpeechConfig {
	if x, ok := x.GetStreamingRequest().(*StreamingTranslateSpeechRequest_StreamingConfig); ok {
		return x.StreamingConfig
	}
	return nil
}

func (x *StreamingTranslateSpeechRequest) GetAudioContent() []byte {
	if x, ok := x.GetStreamingRequest().(*StreamingTranslateSpeechRequest_AudioContent); ok {
		return x.AudioContent
	}
	return nil
}

type isStreamingTranslateSpeechRequest_StreamingRequest interface {
	isStreamingTranslateSpeechRequest_StreamingRequest()
}

type StreamingTranslateSpeechRequest_StreamingConfig struct {
	// Provides information to the recognizer that specifies how to process the
	// request. The first `StreamingTranslateSpeechRequest` message must contain
	// a `streaming_config` message.
	StreamingConfig *StreamingTranslateSpeechConfig `protobuf:"bytes,1,opt,name=streaming_config,json=streamingConfig,proto3,oneof"`
}

type StreamingTranslateSpeechRequest_AudioContent struct {
	// The audio data to be translated. Sequential chunks of audio data are sent
	// in sequential `StreamingTranslateSpeechRequest` messages. The first
	// `StreamingTranslateSpeechRequest` message must not contain
	// `audio_content` data and all subsequent `StreamingTranslateSpeechRequest`
	// messages must contain `audio_content` data. The audio bytes must be
	// encoded as specified in `StreamingTranslateSpeechConfig`. Note: as with
	// all bytes fields, protobuffers use a pure binary representation (not
	// base64).
	AudioContent []byte `protobuf:"bytes,2,opt,name=audio_content,json=audioContent,proto3,oneof"`
}

func (*StreamingTranslateSpeechRequest_StreamingConfig) isStreamingTranslateSpeechRequest_StreamingRequest() {
}

func (*StreamingTranslateSpeechRequest_AudioContent) isStreamingTranslateSpeechRequest_StreamingRequest() {
}

// A streaming speech translation result corresponding to a portion of the audio
// that is currently being processed.
type StreamingTranslateSpeechResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Text translation result.
	TextTranslationResult *StreamingTranslateSpeechResult_TextTranslationResult `protobuf:"bytes,1,opt,name=text_translation_result,json=textTranslationResult,proto3" json:"text_translation_result,omitempty"`
	// Audio translation result.
	AudioTranslationResult *StreamingTranslateSpeechResult_AudioTranslationResult `protobuf:"bytes,2,opt,name=audio_translation_result,json=audioTranslationResult,proto3" json:"audio_translation_result,omitempty"`
	// Output only. The debug only recognition result in original language. This field is debug
	// only and will be set to empty string if not available.
	// This is implementation detail and will not be backward compatible.
	RecognitionResult string `protobuf:"bytes,3,opt,name=recognition_result,json=recognitionResult,proto3" json:"recognition_result,omitempty"`
	// Output only.
	DetectedSourceLanguageCode string `protobuf:"bytes,4,opt,name=detected_source_language_code,json=detectedSourceLanguageCode,proto3" json:"detected_source_language_code,omitempty"`
}

func (x *StreamingTranslateSpeechResult) Reset() {
	*x = StreamingTranslateSpeechResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamingTranslateSpeechResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingTranslateSpeechResult) ProtoMessage() {}

func (x *StreamingTranslateSpeechResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingTranslateSpeechResult.ProtoReflect.Descriptor instead.
func (*StreamingTranslateSpeechResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_rawDescGZIP(), []int{3}
}

func (x *StreamingTranslateSpeechResult) GetTextTranslationResult() *StreamingTranslateSpeechResult_TextTranslationResult {
	if x != nil {
		return x.TextTranslationResult
	}
	return nil
}

func (x *StreamingTranslateSpeechResult) GetAudioTranslationResult() *StreamingTranslateSpeechResult_AudioTranslationResult {
	if x != nil {
		return x.AudioTranslationResult
	}
	return nil
}

func (x *StreamingTranslateSpeechResult) GetRecognitionResult() string {
	if x != nil {
		return x.RecognitionResult
	}
	return ""
}

func (x *StreamingTranslateSpeechResult) GetDetectedSourceLanguageCode() string {
	if x != nil {
		return x.DetectedSourceLanguageCode
	}
	return ""
}

// A streaming speech translation response corresponding to a portion of
// the audio currently processed.
type StreamingTranslateSpeechResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. If set, returns a [google.rpc.Status][google.rpc.Status] message that
	// specifies the error for the operation.
	Error *status.Status `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	// Output only. The translation result that is currently being processed (For text
	// translation, `is_final` could be `true` or `false`.
	// For audio translation, we do not have is_final field, which means each
	// audio response is stable and will not get changed later. For
	// text_and_audio, we still have `is_final` field in text translation, but we
	// only output corresponsding audio when `is_final` is true.).
	Result *StreamingTranslateSpeechResult `protobuf:"bytes,2,opt,name=result,proto3" json:"result,omitempty"`
	// Output only. Indicates the type of speech event.
	SpeechEventType StreamingTranslateSpeechResponse_SpeechEventType `protobuf:"varint,3,opt,name=speech_event_type,json=speechEventType,proto3,enum=google.cloud.mediatranslation.v1alpha1.StreamingTranslateSpeechResponse_SpeechEventType" json:"speech_event_type,omitempty"`
}

func (x *StreamingTranslateSpeechResponse) Reset() {
	*x = StreamingTranslateSpeechResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamingTranslateSpeechResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingTranslateSpeechResponse) ProtoMessage() {}

func (x *StreamingTranslateSpeechResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingTranslateSpeechResponse.ProtoReflect.Descriptor instead.
func (*StreamingTranslateSpeechResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_rawDescGZIP(), []int{4}
}

func (x *StreamingTranslateSpeechResponse) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *StreamingTranslateSpeechResponse) GetResult() *StreamingTranslateSpeechResult {
	if x != nil {
		return x.Result
	}
	return nil
}

func (x *StreamingTranslateSpeechResponse) GetSpeechEventType() StreamingTranslateSpeechResponse_SpeechEventType {
	if x != nil {
		return x.SpeechEventType
	}
	return StreamingTranslateSpeechResponse_SPEECH_EVENT_TYPE_UNSPECIFIED
}

// Text translation result.
type StreamingTranslateSpeechResult_TextTranslationResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The translated sentence.
	Translation string `protobuf:"bytes,1,opt,name=translation,proto3" json:"translation,omitempty"`
	// Output only. If `false`, this `StreamingTranslateSpeechResult` represents
	// an interim result that may change. If `true`, this is the final time the
	// translation service will return this particular
	// `StreamingTranslateSpeechResult`, the streaming translator will not
	// return any further hypotheses for this portion of the transcript and
	// corresponding audio.
	IsFinal bool `protobuf:"varint,2,opt,name=is_final,json=isFinal,proto3" json:"is_final,omitempty"`
}

func (x *StreamingTranslateSpeechResult_TextTranslationResult) Reset() {
	*x = StreamingTranslateSpeechResult_TextTranslationResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamingTranslateSpeechResult_TextTranslationResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingTranslateSpeechResult_TextTranslationResult) ProtoMessage() {}

func (x *StreamingTranslateSpeechResult_TextTranslationResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingTranslateSpeechResult_TextTranslationResult.ProtoReflect.Descriptor instead.
func (*StreamingTranslateSpeechResult_TextTranslationResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_rawDescGZIP(), []int{3, 0}
}

func (x *StreamingTranslateSpeechResult_TextTranslationResult) GetTranslation() string {
	if x != nil {
		return x.Translation
	}
	return ""
}

func (x *StreamingTranslateSpeechResult_TextTranslationResult) GetIsFinal() bool {
	if x != nil {
		return x.IsFinal
	}
	return false
}

// Audio translation result.
type StreamingTranslateSpeechResult_AudioTranslationResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The translated audio.
	AudioTranslation []byte `protobuf:"bytes,1,opt,name=audio_translation,json=audioTranslation,proto3" json:"audio_translation,omitempty"`
}

func (x *StreamingTranslateSpeechResult_AudioTranslationResult) Reset() {
	*x = StreamingTranslateSpeechResult_AudioTranslationResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamingTranslateSpeechResult_AudioTranslationResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingTranslateSpeechResult_AudioTranslationResult) ProtoMessage() {}

func (x *StreamingTranslateSpeechResult_AudioTranslationResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingTranslateSpeechResult_AudioTranslationResult.ProtoReflect.Descriptor instead.
func (*StreamingTranslateSpeechResult_AudioTranslationResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_rawDescGZIP(), []int{3, 1}
}

func (x *StreamingTranslateSpeechResult_AudioTranslationResult) GetAudioTranslation() []byte {
	if x != nil {
		return x.AudioTranslation
	}
	return nil
}

var File_google_cloud_mediatranslation_v1alpha1_media_translation_proto protoreflect.FileDescriptor

var file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_rawDesc = []byte{
	0x0a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d,
	0x65, 0x64, 0x69, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x5f, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x65, 0x64, 0x69, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xcd, 0x02, 0x0a, 0x15,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2a, 0x0a, 0x0e, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x65,
	0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0d, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e,
	0x67, 0x12, 0x35, 0x0a, 0x14, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x35, 0x0a, 0x14, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12,
	0x4e, 0x0a, 0x21, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x1e, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x73, 0x12,
	0x2f, 0x0a, 0x11, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x68,
	0x65, 0x72, 0x74, 0x7a, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x61, 0x74, 0x65, 0x48, 0x65, 0x72, 0x74, 0x7a,
	0x12, 0x19, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x22, 0xc7, 0x02, 0x0a, 0x1e,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x65, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x65,
	0x0a, 0x0c, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2e, 0x0a, 0x10, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f,
	0x75, 0x74, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x55, 0x74, 0x74, 0x65,
	0x72, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x21, 0x0a, 0x09, 0x73, 0x74, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x73,
	0x74, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x2e, 0x0a, 0x10, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x3b, 0x0a, 0x17, 0x64, 0x69, 0x73, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6d, 0x5f, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15,
	0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6d, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x22, 0xd2, 0x01, 0x0a, 0x1f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x69, 0x6e, 0x67, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x65,
	0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x73, 0x0a, 0x10, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x53,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0f, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x25,
	0x0a, 0x0d, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x0c, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x13, 0x0a, 0x11, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69,
	0x6e, 0x67, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0xf9, 0x04, 0x0a, 0x1e, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
	0x65, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x94, 0x01,
	0x0a, 0x17, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x5c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x65, 0x64, 0x69, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69,
	0x6e, 0x67, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x15, 0x74,
	0x65, 0x78, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x12, 0x97, 0x01, 0x0a, 0x18, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c,
	0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e,
	0x41, 0x75, 0x64, 0x69, 0x6f, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x16, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x32,
	0x0a, 0x12, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x11, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x46, 0x0a, 0x1d, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1a,
	0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x1a, 0x5e, 0x0a, 0x15, 0x54, 0x65,
	0x78, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x25, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x08, 0x69, 0x73,
	0x5f, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x07, 0x69, 0x73, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x1a, 0x4a, 0x0a, 0x16, 0x41, 0x75,
	0x64, 0x69, 0x6f, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x12, 0x30, 0x0a, 0x11, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x95, 0x03, 0x0a, 0x20, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x69, 0x6e, 0x67, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2d, 0x0a, 0x05, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x63, 0x0a, 0x06, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12,
	0x89, 0x01, 0x0a, 0x11, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x58, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x64, 0x69, 0x61,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x73, 0x70, 0x65, 0x65,
	0x63, 0x68, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x22, 0x51, 0x0a, 0x0f, 0x53,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x21,
	0x0a, 0x1d, 0x53, 0x50, 0x45, 0x45, 0x43, 0x48, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x1b, 0x0a, 0x17, 0x45, 0x4e, 0x44, 0x5f, 0x4f, 0x46, 0x5f, 0x53, 0x49, 0x4e, 0x47,
	0x4c, 0x45, 0x5f, 0x55, 0x54, 0x54, 0x45, 0x52, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x01, 0x32, 0xa5,
	0x02, 0x0a, 0x18, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xb3, 0x01, 0x0a, 0x18,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x65, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x12, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x6c, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x69, 0x6e, 0x67, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x28, 0x01, 0x30,
	0x01, 0x1a, 0x53, 0xca, 0x41, 0x1f, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x87, 0x01, 0x0a, 0x2a, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x64, 0x69,
	0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x5a, 0x56, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f,
	0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x3b, 0x6d, 0x65, 0x64,
	0x69, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0xf8, 0x01, 0x01,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_rawDescOnce sync.Once
	file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_rawDescData = file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_rawDesc
)

func file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_rawDescGZIP() []byte {
	file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_rawDescOnce.Do(func() {
		file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_rawDescData)
	})
	return file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_rawDescData
}

var file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_goTypes = []interface{}{
	(StreamingTranslateSpeechResponse_SpeechEventType)(0),         // 0: google.cloud.mediatranslation.v1alpha1.StreamingTranslateSpeechResponse.SpeechEventType
	(*TranslateSpeechConfig)(nil),                                 // 1: google.cloud.mediatranslation.v1alpha1.TranslateSpeechConfig
	(*StreamingTranslateSpeechConfig)(nil),                        // 2: google.cloud.mediatranslation.v1alpha1.StreamingTranslateSpeechConfig
	(*StreamingTranslateSpeechRequest)(nil),                       // 3: google.cloud.mediatranslation.v1alpha1.StreamingTranslateSpeechRequest
	(*StreamingTranslateSpeechResult)(nil),                        // 4: google.cloud.mediatranslation.v1alpha1.StreamingTranslateSpeechResult
	(*StreamingTranslateSpeechResponse)(nil),                      // 5: google.cloud.mediatranslation.v1alpha1.StreamingTranslateSpeechResponse
	(*StreamingTranslateSpeechResult_TextTranslationResult)(nil),  // 6: google.cloud.mediatranslation.v1alpha1.StreamingTranslateSpeechResult.TextTranslationResult
	(*StreamingTranslateSpeechResult_AudioTranslationResult)(nil), // 7: google.cloud.mediatranslation.v1alpha1.StreamingTranslateSpeechResult.AudioTranslationResult
	(*status.Status)(nil),                                         // 8: google.rpc.Status
}
var file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_depIdxs = []int32{
	1, // 0: google.cloud.mediatranslation.v1alpha1.StreamingTranslateSpeechConfig.audio_config:type_name -> google.cloud.mediatranslation.v1alpha1.TranslateSpeechConfig
	2, // 1: google.cloud.mediatranslation.v1alpha1.StreamingTranslateSpeechRequest.streaming_config:type_name -> google.cloud.mediatranslation.v1alpha1.StreamingTranslateSpeechConfig
	6, // 2: google.cloud.mediatranslation.v1alpha1.StreamingTranslateSpeechResult.text_translation_result:type_name -> google.cloud.mediatranslation.v1alpha1.StreamingTranslateSpeechResult.TextTranslationResult
	7, // 3: google.cloud.mediatranslation.v1alpha1.StreamingTranslateSpeechResult.audio_translation_result:type_name -> google.cloud.mediatranslation.v1alpha1.StreamingTranslateSpeechResult.AudioTranslationResult
	8, // 4: google.cloud.mediatranslation.v1alpha1.StreamingTranslateSpeechResponse.error:type_name -> google.rpc.Status
	4, // 5: google.cloud.mediatranslation.v1alpha1.StreamingTranslateSpeechResponse.result:type_name -> google.cloud.mediatranslation.v1alpha1.StreamingTranslateSpeechResult
	0, // 6: google.cloud.mediatranslation.v1alpha1.StreamingTranslateSpeechResponse.speech_event_type:type_name -> google.cloud.mediatranslation.v1alpha1.StreamingTranslateSpeechResponse.SpeechEventType
	3, // 7: google.cloud.mediatranslation.v1alpha1.SpeechTranslationService.StreamingTranslateSpeech:input_type -> google.cloud.mediatranslation.v1alpha1.StreamingTranslateSpeechRequest
	5, // 8: google.cloud.mediatranslation.v1alpha1.SpeechTranslationService.StreamingTranslateSpeech:output_type -> google.cloud.mediatranslation.v1alpha1.StreamingTranslateSpeechResponse
	8, // [8:9] is the sub-list for method output_type
	7, // [7:8] is the sub-list for method input_type
	7, // [7:7] is the sub-list for extension type_name
	7, // [7:7] is the sub-list for extension extendee
	0, // [0:7] is the sub-list for field type_name
}

func init() { file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_init() }
func file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_init() {
	if File_google_cloud_mediatranslation_v1alpha1_media_translation_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TranslateSpeechConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamingTranslateSpeechConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamingTranslateSpeechRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamingTranslateSpeechResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamingTranslateSpeechResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamingTranslateSpeechResult_TextTranslationResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamingTranslateSpeechResult_AudioTranslationResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*StreamingTranslateSpeechRequest_StreamingConfig)(nil),
		(*StreamingTranslateSpeechRequest_AudioContent)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_goTypes,
		DependencyIndexes: file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_depIdxs,
		EnumInfos:         file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_enumTypes,
		MessageInfos:      file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_msgTypes,
	}.Build()
	File_google_cloud_mediatranslation_v1alpha1_media_translation_proto = out.File
	file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_rawDesc = nil
	file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_goTypes = nil
	file_google_cloud_mediatranslation_v1alpha1_media_translation_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SpeechTranslationServiceClient is the client API for SpeechTranslationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SpeechTranslationServiceClient interface {
	// Performs bidirectional streaming speech translation: receive results while
	// sending audio. This method is only available via the gRPC API (not REST).
	StreamingTranslateSpeech(ctx context.Context, opts ...grpc.CallOption) (SpeechTranslationService_StreamingTranslateSpeechClient, error)
}

type speechTranslationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSpeechTranslationServiceClient(cc grpc.ClientConnInterface) SpeechTranslationServiceClient {
	return &speechTranslationServiceClient{cc}
}

func (c *speechTranslationServiceClient) StreamingTranslateSpeech(ctx context.Context, opts ...grpc.CallOption) (SpeechTranslationService_StreamingTranslateSpeechClient, error) {
	stream, err := c.cc.NewStream(ctx, &_SpeechTranslationService_serviceDesc.Streams[0], "/google.cloud.mediatranslation.v1alpha1.SpeechTranslationService/StreamingTranslateSpeech", opts...)
	if err != nil {
		return nil, err
	}
	x := &speechTranslationServiceStreamingTranslateSpeechClient{stream}
	return x, nil
}

type SpeechTranslationService_StreamingTranslateSpeechClient interface {
	Send(*StreamingTranslateSpeechRequest) error
	Recv() (*StreamingTranslateSpeechResponse, error)
	grpc.ClientStream
}

type speechTranslationServiceStreamingTranslateSpeechClient struct {
	grpc.ClientStream
}

func (x *speechTranslationServiceStreamingTranslateSpeechClient) Send(m *StreamingTranslateSpeechRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *speechTranslationServiceStreamingTranslateSpeechClient) Recv() (*StreamingTranslateSpeechResponse, error) {
	m := new(StreamingTranslateSpeechResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// SpeechTranslationServiceServer is the server API for SpeechTranslationService service.
type SpeechTranslationServiceServer interface {
	// Performs bidirectional streaming speech translation: receive results while
	// sending audio. This method is only available via the gRPC API (not REST).
	StreamingTranslateSpeech(SpeechTranslationService_StreamingTranslateSpeechServer) error
}

// UnimplementedSpeechTranslationServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSpeechTranslationServiceServer struct {
}

func (*UnimplementedSpeechTranslationServiceServer) StreamingTranslateSpeech(SpeechTranslationService_StreamingTranslateSpeechServer) error {
	return status1.Errorf(codes.Unimplemented, "method StreamingTranslateSpeech not implemented")
}

func RegisterSpeechTranslationServiceServer(s *grpc.Server, srv SpeechTranslationServiceServer) {
	s.RegisterService(&_SpeechTranslationService_serviceDesc, srv)
}

func _SpeechTranslationService_StreamingTranslateSpeech_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SpeechTranslationServiceServer).StreamingTranslateSpeech(&speechTranslationServiceStreamingTranslateSpeechServer{stream})
}

type SpeechTranslationService_StreamingTranslateSpeechServer interface {
	Send(*StreamingTranslateSpeechResponse) error
	Recv() (*StreamingTranslateSpeechRequest, error)
	grpc.ServerStream
}

type speechTranslationServiceStreamingTranslateSpeechServer struct {
	grpc.ServerStream
}

func (x *speechTranslationServiceStreamingTranslateSpeechServer) Send(m *StreamingTranslateSpeechResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *speechTranslationServiceStreamingTranslateSpeechServer) Recv() (*StreamingTranslateSpeechRequest, error) {
	m := new(StreamingTranslateSpeechRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _SpeechTranslationService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.mediatranslation.v1alpha1.SpeechTranslationService",
	HandlerType: (*SpeechTranslationServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamingTranslateSpeech",
			Handler:       _SpeechTranslationService_StreamingTranslateSpeech_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/mediatranslation/v1alpha1/media_translation.proto",
}
