// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3control

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restxml"
)

type CreateAccessPointInput struct {
	_ struct{} `locationName:"CreateAccessPointRequest" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// The AWS account ID for the owner of the bucket for which you want to create
	// an access point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the bucket that you want to associate this access point with.
	//
	// Bucket is a required field
	Bucket *string `min:"3" type:"string" required:"true"`

	// The name you want to assign to this access point.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`

	// The PublicAccessBlock configuration that you want to apply to this Amazon
	// S3 bucket. You can enable the configuration options in any combination. For
	// more information about when Amazon S3 considers a bucket or object public,
	// see The Meaning of "Public" (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status)
	// in the Amazon Simple Storage Service Developer Guide.
	PublicAccessBlockConfiguration *PublicAccessBlockConfiguration `type:"structure"`

	// If you include this field, Amazon S3 restricts access to this access point
	// to requests from the specified Virtual Private Cloud (VPC).
	VpcConfiguration *VpcConfiguration `type:"structure"`
}

// String returns the string representation
func (s CreateAccessPointInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAccessPointInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateAccessPointInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("Bucket", 3))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 3))
	}
	if s.VpcConfiguration != nil {
		if err := s.VpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VpcConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateAccessPointInput) MarshalFields(e protocol.FieldEncoder) error {

	e.SetFields(protocol.BodyTarget, "CreateAccessPointRequest", protocol.FieldMarshalerFunc(func(e protocol.FieldEncoder) error {
		if s.Bucket != nil {
			v := *s.Bucket

			metadata := protocol.Metadata{}
			e.SetValue(protocol.BodyTarget, "Bucket", protocol.StringValue(v), metadata)
		}
		if s.PublicAccessBlockConfiguration != nil {
			v := s.PublicAccessBlockConfiguration

			metadata := protocol.Metadata{}
			e.SetFields(protocol.BodyTarget, "PublicAccessBlockConfiguration", v, metadata)
		}
		if s.VpcConfiguration != nil {
			v := s.VpcConfiguration

			metadata := protocol.Metadata{}
			e.SetFields(protocol.BodyTarget, "VpcConfiguration", v, metadata)
		}
		return nil
	}), protocol.Metadata{XMLNamespaceURI: "http://awss3control.amazonaws.com/doc/2018-08-20/"})
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-account-id", protocol.StringValue(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "name", protocol.StringValue(v), metadata)
	}
	return nil
}

type CreateAccessPointOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateAccessPointOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateAccessPointOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opCreateAccessPoint = "CreateAccessPoint"

// CreateAccessPointRequest returns a request value for making API operation for
// AWS S3 Control.
//
// Creates an access point and associates it with the specified bucket.
//
//    // Example sending a request using CreateAccessPointRequest.
//    req := client.CreateAccessPointRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateAccessPoint
func (c *Client) CreateAccessPointRequest(input *CreateAccessPointInput) CreateAccessPointRequest {
	op := &aws.Operation{
		Name:       opCreateAccessPoint,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/accesspoint/{name}",
	}

	if input == nil {
		input = &CreateAccessPointInput{}
	}

	req := c.newRequest(op, input, &CreateAccessPointOutput{})
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(buildPrefixHostHandler("AccountID", aws.StringValue(input.AccountId)))
	req.Handlers.Build.PushBackNamed(buildRemoveHeaderHandler("X-Amz-Account-Id"))
	return CreateAccessPointRequest{Request: req, Input: input, Copy: c.CreateAccessPointRequest}
}

// CreateAccessPointRequest is the request type for the
// CreateAccessPoint API operation.
type CreateAccessPointRequest struct {
	*aws.Request
	Input *CreateAccessPointInput
	Copy  func(*CreateAccessPointInput) CreateAccessPointRequest
}

// Send marshals and sends the CreateAccessPoint API request.
func (r CreateAccessPointRequest) Send(ctx context.Context) (*CreateAccessPointResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateAccessPointResponse{
		CreateAccessPointOutput: r.Request.Data.(*CreateAccessPointOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateAccessPointResponse is the response type for the
// CreateAccessPoint API operation.
type CreateAccessPointResponse struct {
	*CreateAccessPointOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateAccessPoint request.
func (r *CreateAccessPointResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
