// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package clouddirectory

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type PutSchemaFromJsonInput struct {
	_ struct{} `type:"structure"`

	// The replacement JSON schema.
	//
	// Document is a required field
	Document *string `type:"string" required:"true"`

	// The ARN of the schema to update.
	//
	// SchemaArn is a required field
	SchemaArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`
}

// String returns the string representation
func (s PutSchemaFromJsonInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutSchemaFromJsonInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutSchemaFromJsonInput"}

	if s.Document == nil {
		invalidParams.Add(aws.NewErrParamRequired("Document"))
	}

	if s.SchemaArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SchemaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutSchemaFromJsonInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Document != nil {
		v := *s.Document

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Document", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SchemaArn != nil {
		v := *s.SchemaArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-data-partition", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type PutSchemaFromJsonOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the schema to update.
	Arn *string `type:"string"`
}

// String returns the string representation
func (s PutSchemaFromJsonOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutSchemaFromJsonOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opPutSchemaFromJson = "PutSchemaFromJson"

// PutSchemaFromJsonRequest returns a request value for making API operation for
// Amazon CloudDirectory.
//
// Allows a schema to be updated using JSON upload. Only available for development
// schemas. See JSON Schema Format (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_jsonformat.html#schemas_json)
// for more information.
//
//    // Example sending a request using PutSchemaFromJsonRequest.
//    req := client.PutSchemaFromJsonRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/PutSchemaFromJson
func (c *Client) PutSchemaFromJsonRequest(input *PutSchemaFromJsonInput) PutSchemaFromJsonRequest {
	op := &aws.Operation{
		Name:       opPutSchemaFromJson,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/schema/json",
	}

	if input == nil {
		input = &PutSchemaFromJsonInput{}
	}

	req := c.newRequest(op, input, &PutSchemaFromJsonOutput{})
	return PutSchemaFromJsonRequest{Request: req, Input: input, Copy: c.PutSchemaFromJsonRequest}
}

// PutSchemaFromJsonRequest is the request type for the
// PutSchemaFromJson API operation.
type PutSchemaFromJsonRequest struct {
	*aws.Request
	Input *PutSchemaFromJsonInput
	Copy  func(*PutSchemaFromJsonInput) PutSchemaFromJsonRequest
}

// Send marshals and sends the PutSchemaFromJson API request.
func (r PutSchemaFromJsonRequest) Send(ctx context.Context) (*PutSchemaFromJsonResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutSchemaFromJsonResponse{
		PutSchemaFromJsonOutput: r.Request.Data.(*PutSchemaFromJsonOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutSchemaFromJsonResponse is the response type for the
// PutSchemaFromJson API operation.
type PutSchemaFromJsonResponse struct {
	*PutSchemaFromJsonOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutSchemaFromJson request.
func (r *PutSchemaFromJsonResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
