package iothub

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// IotDpsResourceClient is the API for using the Azure IoT Hub Device Provisioning Service features.
type IotDpsResourceClient struct {
	BaseClient
}

// NewIotDpsResourceClient creates an instance of the IotDpsResourceClient client.
func NewIotDpsResourceClient(subscriptionID string) IotDpsResourceClient {
	return NewIotDpsResourceClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewIotDpsResourceClientWithBaseURI creates an instance of the IotDpsResourceClient client using a custom endpoint.
// Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewIotDpsResourceClientWithBaseURI(baseURI string, subscriptionID string) IotDpsResourceClient {
	return IotDpsResourceClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CheckProvisioningServiceNameAvailability check if a provisioning service name is available. This will validate if
// the name is syntactically valid and if the name is usable
// Parameters:
// arguments - set the name parameter in the OperationInputs structure to the name of the provisioning service
// to check.
func (client IotDpsResourceClient) CheckProvisioningServiceNameAvailability(ctx context.Context, arguments OperationInputs) (result NameAvailabilityInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotDpsResourceClient.CheckProvisioningServiceNameAvailability")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: arguments,
			Constraints: []validation.Constraint{{Target: "arguments.Name", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("iothub.IotDpsResourceClient", "CheckProvisioningServiceNameAvailability", err.Error())
	}

	req, err := client.CheckProvisioningServiceNameAvailabilityPreparer(ctx, arguments)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "CheckProvisioningServiceNameAvailability", nil, "Failure preparing request")
		return
	}

	resp, err := client.CheckProvisioningServiceNameAvailabilitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "CheckProvisioningServiceNameAvailability", resp, "Failure sending request")
		return
	}

	result, err = client.CheckProvisioningServiceNameAvailabilityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "CheckProvisioningServiceNameAvailability", resp, "Failure responding to request")
	}

	return
}

// CheckProvisioningServiceNameAvailabilityPreparer prepares the CheckProvisioningServiceNameAvailability request.
func (client IotDpsResourceClient) CheckProvisioningServiceNameAvailabilityPreparer(ctx context.Context, arguments OperationInputs) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-22"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Devices/checkProvisioningServiceNameAvailability", pathParameters),
		autorest.WithJSON(arguments),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CheckProvisioningServiceNameAvailabilitySender sends the CheckProvisioningServiceNameAvailability request. The method will close the
// http.Response Body if it receives an error.
func (client IotDpsResourceClient) CheckProvisioningServiceNameAvailabilitySender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// CheckProvisioningServiceNameAvailabilityResponder handles the response to the CheckProvisioningServiceNameAvailability request. The method always
// closes the http.Response Body.
func (client IotDpsResourceClient) CheckProvisioningServiceNameAvailabilityResponder(resp *http.Response) (result NameAvailabilityInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdate create or update the metadata of the provisioning service. The usual pattern to modify a property is
// to retrieve the provisioning service metadata and security metadata, and then combine them with the modified values
// in a new body to update the provisioning service.
// Parameters:
// resourceGroupName - resource group identifier.
// provisioningServiceName - name of provisioning service to create or update.
// iotDpsDescription - description of the provisioning service to create or update.
func (client IotDpsResourceClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, provisioningServiceName string, iotDpsDescription ProvisioningServiceDescription) (result IotDpsResourceCreateOrUpdateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotDpsResourceClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: iotDpsDescription,
			Constraints: []validation.Constraint{{Target: "iotDpsDescription.Properties", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "iotDpsDescription.Sku", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("iothub.IotDpsResourceClient", "CreateOrUpdate", err.Error())
	}

	req, err := client.CreateOrUpdatePreparer(ctx, resourceGroupName, provisioningServiceName, iotDpsDescription)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "CreateOrUpdate", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client IotDpsResourceClient) CreateOrUpdatePreparer(ctx context.Context, resourceGroupName string, provisioningServiceName string, iotDpsDescription ProvisioningServiceDescription) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"provisioningServiceName": autorest.Encode("path", provisioningServiceName),
		"resourceGroupName":       autorest.Encode("path", resourceGroupName),
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-22"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}", pathParameters),
		autorest.WithJSON(iotDpsDescription),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client IotDpsResourceClient) CreateOrUpdateSender(req *http.Request) (future IotDpsResourceCreateOrUpdateFuture, err error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, req, sd...)
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client IotDpsResourceClient) CreateOrUpdateResponder(resp *http.Response) (result ProvisioningServiceDescription, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes the Provisioning Service.
// Parameters:
// provisioningServiceName - name of provisioning service to delete.
// resourceGroupName - resource group identifier.
func (client IotDpsResourceClient) Delete(ctx context.Context, provisioningServiceName string, resourceGroupName string) (result IotDpsResourceDeleteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotDpsResourceClient.Delete")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, provisioningServiceName, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "Delete", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "Delete", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client IotDpsResourceClient) DeletePreparer(ctx context.Context, provisioningServiceName string, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"provisioningServiceName": autorest.Encode("path", provisioningServiceName),
		"resourceGroupName":       autorest.Encode("path", resourceGroupName),
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-22"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client IotDpsResourceClient) DeleteSender(req *http.Request) (future IotDpsResourceDeleteFuture, err error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, req, sd...)
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client IotDpsResourceClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get get the metadata of the provisioning service without SAS keys.
// Parameters:
// provisioningServiceName - name of the provisioning service to retrieve.
// resourceGroupName - resource group name.
func (client IotDpsResourceClient) Get(ctx context.Context, provisioningServiceName string, resourceGroupName string) (result ProvisioningServiceDescription, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotDpsResourceClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, provisioningServiceName, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client IotDpsResourceClient) GetPreparer(ctx context.Context, provisioningServiceName string, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"provisioningServiceName": autorest.Encode("path", provisioningServiceName),
		"resourceGroupName":       autorest.Encode("path", resourceGroupName),
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-22"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client IotDpsResourceClient) GetSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client IotDpsResourceClient) GetResponder(resp *http.Response) (result ProvisioningServiceDescription, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetOperationResult gets the status of a long running operation, such as create, update or delete a provisioning
// service.
// Parameters:
// operationID - operation id corresponding to long running operation. Use this to poll for the status.
// resourceGroupName - resource group identifier.
// provisioningServiceName - name of provisioning service that the operation is running on.
// asyncinfo - async header used to poll on the status of the operation, obtained while creating the long
// running operation.
func (client IotDpsResourceClient) GetOperationResult(ctx context.Context, operationID string, resourceGroupName string, provisioningServiceName string, asyncinfo string) (result AsyncOperationResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotDpsResourceClient.GetOperationResult")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetOperationResultPreparer(ctx, operationID, resourceGroupName, provisioningServiceName, asyncinfo)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "GetOperationResult", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetOperationResultSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "GetOperationResult", resp, "Failure sending request")
		return
	}

	result, err = client.GetOperationResultResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "GetOperationResult", resp, "Failure responding to request")
	}

	return
}

// GetOperationResultPreparer prepares the GetOperationResult request.
func (client IotDpsResourceClient) GetOperationResultPreparer(ctx context.Context, operationID string, resourceGroupName string, provisioningServiceName string, asyncinfo string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"operationId":             autorest.Encode("path", operationID),
		"provisioningServiceName": autorest.Encode("path", provisioningServiceName),
		"resourceGroupName":       autorest.Encode("path", resourceGroupName),
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-22"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"asyncinfo":   autorest.Encode("query", asyncinfo),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}/operationresults/{operationId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetOperationResultSender sends the GetOperationResult request. The method will close the
// http.Response Body if it receives an error.
func (client IotDpsResourceClient) GetOperationResultSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// GetOperationResultResponder handles the response to the GetOperationResult request. The method always
// closes the http.Response Body.
func (client IotDpsResourceClient) GetOperationResultResponder(resp *http.Response) (result AsyncOperationResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByResourceGroup get a list of all provisioning services in the given resource group.
// Parameters:
// resourceGroupName - resource group identifier.
func (client IotDpsResourceClient) ListByResourceGroup(ctx context.Context, resourceGroupName string) (result ProvisioningServiceDescriptionListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotDpsResourceClient.ListByResourceGroup")
		defer func() {
			sc := -1
			if result.psdlr.Response.Response != nil {
				sc = result.psdlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByResourceGroupNextResults
	req, err := client.ListByResourceGroupPreparer(ctx, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "ListByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.psdlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "ListByResourceGroup", resp, "Failure sending request")
		return
	}

	result.psdlr, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "ListByResourceGroup", resp, "Failure responding to request")
	}

	return
}

// ListByResourceGroupPreparer prepares the ListByResourceGroup request.
func (client IotDpsResourceClient) ListByResourceGroupPreparer(ctx context.Context, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-22"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByResourceGroupSender sends the ListByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client IotDpsResourceClient) ListByResourceGroupSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// ListByResourceGroupResponder handles the response to the ListByResourceGroup request. The method always
// closes the http.Response Body.
func (client IotDpsResourceClient) ListByResourceGroupResponder(resp *http.Response) (result ProvisioningServiceDescriptionListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByResourceGroupNextResults retrieves the next set of results, if any.
func (client IotDpsResourceClient) listByResourceGroupNextResults(ctx context.Context, lastResults ProvisioningServiceDescriptionListResult) (result ProvisioningServiceDescriptionListResult, err error) {
	req, err := lastResults.provisioningServiceDescriptionListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "listByResourceGroupNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "listByResourceGroupNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "listByResourceGroupNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByResourceGroupComplete enumerates all values, automatically crossing page boundaries as required.
func (client IotDpsResourceClient) ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result ProvisioningServiceDescriptionListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotDpsResourceClient.ListByResourceGroup")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByResourceGroup(ctx, resourceGroupName)
	return
}

// ListBySubscription list all the provisioning services for a given subscription id.
func (client IotDpsResourceClient) ListBySubscription(ctx context.Context) (result ProvisioningServiceDescriptionListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotDpsResourceClient.ListBySubscription")
		defer func() {
			sc := -1
			if result.psdlr.Response.Response != nil {
				sc = result.psdlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listBySubscriptionNextResults
	req, err := client.ListBySubscriptionPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "ListBySubscription", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListBySubscriptionSender(req)
	if err != nil {
		result.psdlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "ListBySubscription", resp, "Failure sending request")
		return
	}

	result.psdlr, err = client.ListBySubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "ListBySubscription", resp, "Failure responding to request")
	}

	return
}

// ListBySubscriptionPreparer prepares the ListBySubscription request.
func (client IotDpsResourceClient) ListBySubscriptionPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-22"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Devices/provisioningServices", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListBySubscriptionSender sends the ListBySubscription request. The method will close the
// http.Response Body if it receives an error.
func (client IotDpsResourceClient) ListBySubscriptionSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// ListBySubscriptionResponder handles the response to the ListBySubscription request. The method always
// closes the http.Response Body.
func (client IotDpsResourceClient) ListBySubscriptionResponder(resp *http.Response) (result ProvisioningServiceDescriptionListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listBySubscriptionNextResults retrieves the next set of results, if any.
func (client IotDpsResourceClient) listBySubscriptionNextResults(ctx context.Context, lastResults ProvisioningServiceDescriptionListResult) (result ProvisioningServiceDescriptionListResult, err error) {
	req, err := lastResults.provisioningServiceDescriptionListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "listBySubscriptionNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListBySubscriptionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "listBySubscriptionNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListBySubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "listBySubscriptionNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListBySubscriptionComplete enumerates all values, automatically crossing page boundaries as required.
func (client IotDpsResourceClient) ListBySubscriptionComplete(ctx context.Context) (result ProvisioningServiceDescriptionListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotDpsResourceClient.ListBySubscription")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListBySubscription(ctx)
	return
}

// ListKeys list the primary and secondary keys for a provisioning service.
// Parameters:
// provisioningServiceName - the provisioning service name to get the shared access keys for.
// resourceGroupName - resource group name
func (client IotDpsResourceClient) ListKeys(ctx context.Context, provisioningServiceName string, resourceGroupName string) (result SharedAccessSignatureAuthorizationRuleListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotDpsResourceClient.ListKeys")
		defer func() {
			sc := -1
			if result.sasarlr.Response.Response != nil {
				sc = result.sasarlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listKeysNextResults
	req, err := client.ListKeysPreparer(ctx, provisioningServiceName, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "ListKeys", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListKeysSender(req)
	if err != nil {
		result.sasarlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "ListKeys", resp, "Failure sending request")
		return
	}

	result.sasarlr, err = client.ListKeysResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "ListKeys", resp, "Failure responding to request")
	}

	return
}

// ListKeysPreparer prepares the ListKeys request.
func (client IotDpsResourceClient) ListKeysPreparer(ctx context.Context, provisioningServiceName string, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"provisioningServiceName": autorest.Encode("path", provisioningServiceName),
		"resourceGroupName":       autorest.Encode("path", resourceGroupName),
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-22"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}/listkeys", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListKeysSender sends the ListKeys request. The method will close the
// http.Response Body if it receives an error.
func (client IotDpsResourceClient) ListKeysSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// ListKeysResponder handles the response to the ListKeys request. The method always
// closes the http.Response Body.
func (client IotDpsResourceClient) ListKeysResponder(resp *http.Response) (result SharedAccessSignatureAuthorizationRuleListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listKeysNextResults retrieves the next set of results, if any.
func (client IotDpsResourceClient) listKeysNextResults(ctx context.Context, lastResults SharedAccessSignatureAuthorizationRuleListResult) (result SharedAccessSignatureAuthorizationRuleListResult, err error) {
	req, err := lastResults.sharedAccessSignatureAuthorizationRuleListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "listKeysNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListKeysSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "listKeysNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListKeysResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "listKeysNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListKeysComplete enumerates all values, automatically crossing page boundaries as required.
func (client IotDpsResourceClient) ListKeysComplete(ctx context.Context, provisioningServiceName string, resourceGroupName string) (result SharedAccessSignatureAuthorizationRuleListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotDpsResourceClient.ListKeys")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListKeys(ctx, provisioningServiceName, resourceGroupName)
	return
}

// ListKeysForKeyName list primary and secondary keys for a specific key name
// Parameters:
// provisioningServiceName - name of the provisioning service.
// keyName - logical key name to get key-values for.
// resourceGroupName - the name of the resource group that contains the provisioning service.
func (client IotDpsResourceClient) ListKeysForKeyName(ctx context.Context, provisioningServiceName string, keyName string, resourceGroupName string) (result SharedAccessSignatureAuthorizationRuleAccessRightsDescription, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotDpsResourceClient.ListKeysForKeyName")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListKeysForKeyNamePreparer(ctx, provisioningServiceName, keyName, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "ListKeysForKeyName", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListKeysForKeyNameSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "ListKeysForKeyName", resp, "Failure sending request")
		return
	}

	result, err = client.ListKeysForKeyNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "ListKeysForKeyName", resp, "Failure responding to request")
	}

	return
}

// ListKeysForKeyNamePreparer prepares the ListKeysForKeyName request.
func (client IotDpsResourceClient) ListKeysForKeyNamePreparer(ctx context.Context, provisioningServiceName string, keyName string, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"keyName":                 autorest.Encode("path", keyName),
		"provisioningServiceName": autorest.Encode("path", provisioningServiceName),
		"resourceGroupName":       autorest.Encode("path", resourceGroupName),
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-22"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}/keys/{keyName}/listkeys", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListKeysForKeyNameSender sends the ListKeysForKeyName request. The method will close the
// http.Response Body if it receives an error.
func (client IotDpsResourceClient) ListKeysForKeyNameSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// ListKeysForKeyNameResponder handles the response to the ListKeysForKeyName request. The method always
// closes the http.Response Body.
func (client IotDpsResourceClient) ListKeysForKeyNameResponder(resp *http.Response) (result SharedAccessSignatureAuthorizationRuleAccessRightsDescription, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListValidSkus gets the list of valid SKUs and tiers for a provisioning service.
// Parameters:
// provisioningServiceName - name of provisioning service.
// resourceGroupName - name of resource group.
func (client IotDpsResourceClient) ListValidSkus(ctx context.Context, provisioningServiceName string, resourceGroupName string) (result IotDpsSkuDefinitionListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotDpsResourceClient.ListValidSkus")
		defer func() {
			sc := -1
			if result.idsdlr.Response.Response != nil {
				sc = result.idsdlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listValidSkusNextResults
	req, err := client.ListValidSkusPreparer(ctx, provisioningServiceName, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "ListValidSkus", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListValidSkusSender(req)
	if err != nil {
		result.idsdlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "ListValidSkus", resp, "Failure sending request")
		return
	}

	result.idsdlr, err = client.ListValidSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "ListValidSkus", resp, "Failure responding to request")
	}

	return
}

// ListValidSkusPreparer prepares the ListValidSkus request.
func (client IotDpsResourceClient) ListValidSkusPreparer(ctx context.Context, provisioningServiceName string, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"provisioningServiceName": autorest.Encode("path", provisioningServiceName),
		"resourceGroupName":       autorest.Encode("path", resourceGroupName),
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-22"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}/skus", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListValidSkusSender sends the ListValidSkus request. The method will close the
// http.Response Body if it receives an error.
func (client IotDpsResourceClient) ListValidSkusSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// ListValidSkusResponder handles the response to the ListValidSkus request. The method always
// closes the http.Response Body.
func (client IotDpsResourceClient) ListValidSkusResponder(resp *http.Response) (result IotDpsSkuDefinitionListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listValidSkusNextResults retrieves the next set of results, if any.
func (client IotDpsResourceClient) listValidSkusNextResults(ctx context.Context, lastResults IotDpsSkuDefinitionListResult) (result IotDpsSkuDefinitionListResult, err error) {
	req, err := lastResults.iotDpsSkuDefinitionListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "listValidSkusNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListValidSkusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "listValidSkusNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListValidSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "listValidSkusNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListValidSkusComplete enumerates all values, automatically crossing page boundaries as required.
func (client IotDpsResourceClient) ListValidSkusComplete(ctx context.Context, provisioningServiceName string, resourceGroupName string) (result IotDpsSkuDefinitionListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotDpsResourceClient.ListValidSkus")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListValidSkus(ctx, provisioningServiceName, resourceGroupName)
	return
}

// Update update an existing provisioning service's tags. to update other fields use the CreateOrUpdate method
// Parameters:
// resourceGroupName - resource group identifier.
// provisioningServiceName - name of provisioning service to create or update.
// provisioningServiceTags - updated tag information to set into the provisioning service instance.
func (client IotDpsResourceClient) Update(ctx context.Context, resourceGroupName string, provisioningServiceName string, provisioningServiceTags TagsResource) (result IotDpsResourceUpdateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotDpsResourceClient.Update")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdatePreparer(ctx, resourceGroupName, provisioningServiceName, provisioningServiceTags)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "Update", nil, "Failure preparing request")
		return
	}

	result, err = client.UpdateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceClient", "Update", result.Response(), "Failure sending request")
		return
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client IotDpsResourceClient) UpdatePreparer(ctx context.Context, resourceGroupName string, provisioningServiceName string, provisioningServiceTags TagsResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"provisioningServiceName": autorest.Encode("path", provisioningServiceName),
		"resourceGroupName":       autorest.Encode("path", resourceGroupName),
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-22"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}", pathParameters),
		autorest.WithJSON(provisioningServiceTags),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client IotDpsResourceClient) UpdateSender(req *http.Request) (future IotDpsResourceUpdateFuture, err error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, req, sd...)
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client IotDpsResourceClient) UpdateResponder(resp *http.Response) (result ProvisioningServiceDescription, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
