package labservices

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// GlobalUsersClient is the the Managed Labs Client.
type GlobalUsersClient struct {
	BaseClient
}

// NewGlobalUsersClient creates an instance of the GlobalUsersClient client.
func NewGlobalUsersClient(subscriptionID string) GlobalUsersClient {
	return NewGlobalUsersClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewGlobalUsersClientWithBaseURI creates an instance of the GlobalUsersClient client using a custom endpoint.  Use
// this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewGlobalUsersClientWithBaseURI(baseURI string, subscriptionID string) GlobalUsersClient {
	return GlobalUsersClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// GetEnvironment gets the virtual machine details
// Parameters:
// userName - the name of the user.
// environmentOperationsPayload - represents payload for any Environment operations like get, start, stop,
// connect
// expand - specify the $expand query. Example: 'properties($expand=environment)'
func (client GlobalUsersClient) GetEnvironment(ctx context.Context, userName string, environmentOperationsPayload EnvironmentOperationsPayload, expand string) (result GetEnvironmentResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalUsersClient.GetEnvironment")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: environmentOperationsPayload,
			Constraints: []validation.Constraint{{Target: "environmentOperationsPayload.EnvironmentID", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("labservices.GlobalUsersClient", "GetEnvironment", err.Error())
	}

	req, err := client.GetEnvironmentPreparer(ctx, userName, environmentOperationsPayload, expand)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.GlobalUsersClient", "GetEnvironment", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetEnvironmentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "labservices.GlobalUsersClient", "GetEnvironment", resp, "Failure sending request")
		return
	}

	result, err = client.GetEnvironmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.GlobalUsersClient", "GetEnvironment", resp, "Failure responding to request")
	}

	return
}

// GetEnvironmentPreparer prepares the GetEnvironment request.
func (client GlobalUsersClient) GetEnvironmentPreparer(ctx context.Context, userName string, environmentOperationsPayload EnvironmentOperationsPayload, expand string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"userName": autorest.Encode("path", userName),
	}

	const APIVersion = "2018-10-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(expand) > 0 {
		queryParameters["$expand"] = autorest.Encode("query", expand)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.LabServices/users/{userName}/getEnvironment", pathParameters),
		autorest.WithJSON(environmentOperationsPayload),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetEnvironmentSender sends the GetEnvironment request. The method will close the
// http.Response Body if it receives an error.
func (client GlobalUsersClient) GetEnvironmentSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetEnvironmentResponder handles the response to the GetEnvironment request. The method always
// closes the http.Response Body.
func (client GlobalUsersClient) GetEnvironmentResponder(resp *http.Response) (result GetEnvironmentResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetOperationBatchStatus get batch operation status
// Parameters:
// userName - the name of the user.
// operationBatchStatusPayload - payload to get the status of an operation
func (client GlobalUsersClient) GetOperationBatchStatus(ctx context.Context, userName string, operationBatchStatusPayload OperationBatchStatusPayload) (result OperationBatchStatusResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalUsersClient.GetOperationBatchStatus")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: operationBatchStatusPayload,
			Constraints: []validation.Constraint{{Target: "operationBatchStatusPayload.Urls", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("labservices.GlobalUsersClient", "GetOperationBatchStatus", err.Error())
	}

	req, err := client.GetOperationBatchStatusPreparer(ctx, userName, operationBatchStatusPayload)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.GlobalUsersClient", "GetOperationBatchStatus", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetOperationBatchStatusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "labservices.GlobalUsersClient", "GetOperationBatchStatus", resp, "Failure sending request")
		return
	}

	result, err = client.GetOperationBatchStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.GlobalUsersClient", "GetOperationBatchStatus", resp, "Failure responding to request")
	}

	return
}

// GetOperationBatchStatusPreparer prepares the GetOperationBatchStatus request.
func (client GlobalUsersClient) GetOperationBatchStatusPreparer(ctx context.Context, userName string, operationBatchStatusPayload OperationBatchStatusPayload) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"userName": autorest.Encode("path", userName),
	}

	const APIVersion = "2018-10-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.LabServices/users/{userName}/getOperationBatchStatus", pathParameters),
		autorest.WithJSON(operationBatchStatusPayload),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetOperationBatchStatusSender sends the GetOperationBatchStatus request. The method will close the
// http.Response Body if it receives an error.
func (client GlobalUsersClient) GetOperationBatchStatusSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetOperationBatchStatusResponder handles the response to the GetOperationBatchStatus request. The method always
// closes the http.Response Body.
func (client GlobalUsersClient) GetOperationBatchStatusResponder(resp *http.Response) (result OperationBatchStatusResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetOperationStatus gets the status of long running operation
// Parameters:
// userName - the name of the user.
// operationStatusPayload - payload to get the status of an operation
func (client GlobalUsersClient) GetOperationStatus(ctx context.Context, userName string, operationStatusPayload OperationStatusPayload) (result OperationStatusResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalUsersClient.GetOperationStatus")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: operationStatusPayload,
			Constraints: []validation.Constraint{{Target: "operationStatusPayload.OperationURL", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("labservices.GlobalUsersClient", "GetOperationStatus", err.Error())
	}

	req, err := client.GetOperationStatusPreparer(ctx, userName, operationStatusPayload)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.GlobalUsersClient", "GetOperationStatus", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetOperationStatusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "labservices.GlobalUsersClient", "GetOperationStatus", resp, "Failure sending request")
		return
	}

	result, err = client.GetOperationStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.GlobalUsersClient", "GetOperationStatus", resp, "Failure responding to request")
	}

	return
}

// GetOperationStatusPreparer prepares the GetOperationStatus request.
func (client GlobalUsersClient) GetOperationStatusPreparer(ctx context.Context, userName string, operationStatusPayload OperationStatusPayload) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"userName": autorest.Encode("path", userName),
	}

	const APIVersion = "2018-10-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.LabServices/users/{userName}/getOperationStatus", pathParameters),
		autorest.WithJSON(operationStatusPayload),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetOperationStatusSender sends the GetOperationStatus request. The method will close the
// http.Response Body if it receives an error.
func (client GlobalUsersClient) GetOperationStatusSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetOperationStatusResponder handles the response to the GetOperationStatus request. The method always
// closes the http.Response Body.
func (client GlobalUsersClient) GetOperationStatusResponder(resp *http.Response) (result OperationStatusResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPersonalPreferences get personal preferences for a user
// Parameters:
// userName - the name of the user.
// personalPreferencesOperationsPayload - represents payload for any Environment operations like get, start,
// stop, connect
func (client GlobalUsersClient) GetPersonalPreferences(ctx context.Context, userName string, personalPreferencesOperationsPayload PersonalPreferencesOperationsPayload) (result GetPersonalPreferencesResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalUsersClient.GetPersonalPreferences")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPersonalPreferencesPreparer(ctx, userName, personalPreferencesOperationsPayload)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.GlobalUsersClient", "GetPersonalPreferences", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPersonalPreferencesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "labservices.GlobalUsersClient", "GetPersonalPreferences", resp, "Failure sending request")
		return
	}

	result, err = client.GetPersonalPreferencesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.GlobalUsersClient", "GetPersonalPreferences", resp, "Failure responding to request")
	}

	return
}

// GetPersonalPreferencesPreparer prepares the GetPersonalPreferences request.
func (client GlobalUsersClient) GetPersonalPreferencesPreparer(ctx context.Context, userName string, personalPreferencesOperationsPayload PersonalPreferencesOperationsPayload) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"userName": autorest.Encode("path", userName),
	}

	const APIVersion = "2018-10-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.LabServices/users/{userName}/getPersonalPreferences", pathParameters),
		autorest.WithJSON(personalPreferencesOperationsPayload),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetPersonalPreferencesSender sends the GetPersonalPreferences request. The method will close the
// http.Response Body if it receives an error.
func (client GlobalUsersClient) GetPersonalPreferencesSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetPersonalPreferencesResponder handles the response to the GetPersonalPreferences request. The method always
// closes the http.Response Body.
func (client GlobalUsersClient) GetPersonalPreferencesResponder(resp *http.Response) (result GetPersonalPreferencesResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListEnvironments list Environments for the user
// Parameters:
// userName - the name of the user.
// listEnvironmentsPayload - represents the payload to list environments owned by a user
func (client GlobalUsersClient) ListEnvironments(ctx context.Context, userName string, listEnvironmentsPayload ListEnvironmentsPayload) (result ListEnvironmentsResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalUsersClient.ListEnvironments")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListEnvironmentsPreparer(ctx, userName, listEnvironmentsPayload)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.GlobalUsersClient", "ListEnvironments", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListEnvironmentsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "labservices.GlobalUsersClient", "ListEnvironments", resp, "Failure sending request")
		return
	}

	result, err = client.ListEnvironmentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.GlobalUsersClient", "ListEnvironments", resp, "Failure responding to request")
	}

	return
}

// ListEnvironmentsPreparer prepares the ListEnvironments request.
func (client GlobalUsersClient) ListEnvironmentsPreparer(ctx context.Context, userName string, listEnvironmentsPayload ListEnvironmentsPayload) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"userName": autorest.Encode("path", userName),
	}

	const APIVersion = "2018-10-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.LabServices/users/{userName}/listEnvironments", pathParameters),
		autorest.WithJSON(listEnvironmentsPayload),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListEnvironmentsSender sends the ListEnvironments request. The method will close the
// http.Response Body if it receives an error.
func (client GlobalUsersClient) ListEnvironmentsSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListEnvironmentsResponder handles the response to the ListEnvironments request. The method always
// closes the http.Response Body.
func (client GlobalUsersClient) ListEnvironmentsResponder(resp *http.Response) (result ListEnvironmentsResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListLabs list labs for the user.
// Parameters:
// userName - the name of the user.
func (client GlobalUsersClient) ListLabs(ctx context.Context, userName string) (result ListLabsResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalUsersClient.ListLabs")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListLabsPreparer(ctx, userName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.GlobalUsersClient", "ListLabs", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListLabsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "labservices.GlobalUsersClient", "ListLabs", resp, "Failure sending request")
		return
	}

	result, err = client.ListLabsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.GlobalUsersClient", "ListLabs", resp, "Failure responding to request")
	}

	return
}

// ListLabsPreparer prepares the ListLabs request.
func (client GlobalUsersClient) ListLabsPreparer(ctx context.Context, userName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"userName": autorest.Encode("path", userName),
	}

	const APIVersion = "2018-10-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.LabServices/users/{userName}/listLabs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListLabsSender sends the ListLabs request. The method will close the
// http.Response Body if it receives an error.
func (client GlobalUsersClient) ListLabsSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListLabsResponder handles the response to the ListLabs request. The method always
// closes the http.Response Body.
func (client GlobalUsersClient) ListLabsResponder(resp *http.Response) (result ListLabsResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Register register a user to a managed lab
// Parameters:
// userName - the name of the user.
// registerPayload - represents payload for Register action.
func (client GlobalUsersClient) Register(ctx context.Context, userName string, registerPayload RegisterPayload) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalUsersClient.Register")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.RegisterPreparer(ctx, userName, registerPayload)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.GlobalUsersClient", "Register", nil, "Failure preparing request")
		return
	}

	resp, err := client.RegisterSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "labservices.GlobalUsersClient", "Register", resp, "Failure sending request")
		return
	}

	result, err = client.RegisterResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.GlobalUsersClient", "Register", resp, "Failure responding to request")
	}

	return
}

// RegisterPreparer prepares the Register request.
func (client GlobalUsersClient) RegisterPreparer(ctx context.Context, userName string, registerPayload RegisterPayload) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"userName": autorest.Encode("path", userName),
	}

	const APIVersion = "2018-10-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.LabServices/users/{userName}/register", pathParameters),
		autorest.WithJSON(registerPayload),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RegisterSender sends the Register request. The method will close the
// http.Response Body if it receives an error.
func (client GlobalUsersClient) RegisterSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// RegisterResponder handles the response to the Register request. The method always
// closes the http.Response Body.
func (client GlobalUsersClient) RegisterResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// ResetPassword resets the user password on an environment This operation can take a while to complete
// Parameters:
// userName - the name of the user.
// resetPasswordPayload - represents the payload for resetting passwords.
func (client GlobalUsersClient) ResetPassword(ctx context.Context, userName string, resetPasswordPayload ResetPasswordPayload) (result GlobalUsersResetPasswordFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalUsersClient.ResetPassword")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resetPasswordPayload,
			Constraints: []validation.Constraint{{Target: "resetPasswordPayload.EnvironmentID", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("labservices.GlobalUsersClient", "ResetPassword", err.Error())
	}

	req, err := client.ResetPasswordPreparer(ctx, userName, resetPasswordPayload)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.GlobalUsersClient", "ResetPassword", nil, "Failure preparing request")
		return
	}

	result, err = client.ResetPasswordSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.GlobalUsersClient", "ResetPassword", result.Response(), "Failure sending request")
		return
	}

	return
}

// ResetPasswordPreparer prepares the ResetPassword request.
func (client GlobalUsersClient) ResetPasswordPreparer(ctx context.Context, userName string, resetPasswordPayload ResetPasswordPayload) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"userName": autorest.Encode("path", userName),
	}

	const APIVersion = "2018-10-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.LabServices/users/{userName}/resetPassword", pathParameters),
		autorest.WithJSON(resetPasswordPayload),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ResetPasswordSender sends the ResetPassword request. The method will close the
// http.Response Body if it receives an error.
func (client GlobalUsersClient) ResetPasswordSender(req *http.Request) (future GlobalUsersResetPasswordFuture, err error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, req, sd...)
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// ResetPasswordResponder handles the response to the ResetPassword request. The method always
// closes the http.Response Body.
func (client GlobalUsersClient) ResetPasswordResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// StartEnvironment starts an environment by starting all resources inside the environment. This operation can take a
// while to complete
// Parameters:
// userName - the name of the user.
// environmentOperationsPayload - represents payload for any Environment operations like get, start, stop,
// connect
func (client GlobalUsersClient) StartEnvironment(ctx context.Context, userName string, environmentOperationsPayload EnvironmentOperationsPayload) (result GlobalUsersStartEnvironmentFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalUsersClient.StartEnvironment")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: environmentOperationsPayload,
			Constraints: []validation.Constraint{{Target: "environmentOperationsPayload.EnvironmentID", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("labservices.GlobalUsersClient", "StartEnvironment", err.Error())
	}

	req, err := client.StartEnvironmentPreparer(ctx, userName, environmentOperationsPayload)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.GlobalUsersClient", "StartEnvironment", nil, "Failure preparing request")
		return
	}

	result, err = client.StartEnvironmentSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.GlobalUsersClient", "StartEnvironment", result.Response(), "Failure sending request")
		return
	}

	return
}

// StartEnvironmentPreparer prepares the StartEnvironment request.
func (client GlobalUsersClient) StartEnvironmentPreparer(ctx context.Context, userName string, environmentOperationsPayload EnvironmentOperationsPayload) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"userName": autorest.Encode("path", userName),
	}

	const APIVersion = "2018-10-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.LabServices/users/{userName}/startEnvironment", pathParameters),
		autorest.WithJSON(environmentOperationsPayload),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// StartEnvironmentSender sends the StartEnvironment request. The method will close the
// http.Response Body if it receives an error.
func (client GlobalUsersClient) StartEnvironmentSender(req *http.Request) (future GlobalUsersStartEnvironmentFuture, err error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, req, sd...)
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// StartEnvironmentResponder handles the response to the StartEnvironment request. The method always
// closes the http.Response Body.
func (client GlobalUsersClient) StartEnvironmentResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// StopEnvironment stops an environment by stopping all resources inside the environment This operation can take a
// while to complete
// Parameters:
// userName - the name of the user.
// environmentOperationsPayload - represents payload for any Environment operations like get, start, stop,
// connect
func (client GlobalUsersClient) StopEnvironment(ctx context.Context, userName string, environmentOperationsPayload EnvironmentOperationsPayload) (result GlobalUsersStopEnvironmentFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalUsersClient.StopEnvironment")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: environmentOperationsPayload,
			Constraints: []validation.Constraint{{Target: "environmentOperationsPayload.EnvironmentID", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("labservices.GlobalUsersClient", "StopEnvironment", err.Error())
	}

	req, err := client.StopEnvironmentPreparer(ctx, userName, environmentOperationsPayload)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.GlobalUsersClient", "StopEnvironment", nil, "Failure preparing request")
		return
	}

	result, err = client.StopEnvironmentSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.GlobalUsersClient", "StopEnvironment", result.Response(), "Failure sending request")
		return
	}

	return
}

// StopEnvironmentPreparer prepares the StopEnvironment request.
func (client GlobalUsersClient) StopEnvironmentPreparer(ctx context.Context, userName string, environmentOperationsPayload EnvironmentOperationsPayload) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"userName": autorest.Encode("path", userName),
	}

	const APIVersion = "2018-10-15"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.LabServices/users/{userName}/stopEnvironment", pathParameters),
		autorest.WithJSON(environmentOperationsPayload),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// StopEnvironmentSender sends the StopEnvironment request. The method will close the
// http.Response Body if it receives an error.
func (client GlobalUsersClient) StopEnvironmentSender(req *http.Request) (future GlobalUsersStopEnvironmentFuture, err error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, req, sd...)
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// StopEnvironmentResponder handles the response to the StopEnvironment request. The method always
// closes the http.Response Body.
func (client GlobalUsersClient) StopEnvironmentResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}
