// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package personalizeevents

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type PutEventsInput struct {
	_ struct{} `type:"structure"`

	// A list of event data from the session.
	//
	// EventList is a required field
	EventList []Event `locationName:"eventList" min:"1" type:"list" required:"true"`

	// The session ID associated with the user's visit.
	//
	// SessionId is a required field
	SessionId *string `locationName:"sessionId" min:"1" type:"string" required:"true"`

	// The tracking ID for the event. The ID is generated by a call to the CreateEventTracker
	// (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html)
	// API.
	//
	// TrackingId is a required field
	TrackingId *string `locationName:"trackingId" min:"1" type:"string" required:"true"`

	// The user associated with the event.
	UserId *string `locationName:"userId" min:"1" type:"string"`
}

// String returns the string representation
func (s PutEventsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEventsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutEventsInput"}

	if s.EventList == nil {
		invalidParams.Add(aws.NewErrParamRequired("EventList"))
	}
	if s.EventList != nil && len(s.EventList) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("EventList", 1))
	}

	if s.SessionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SessionId", 1))
	}

	if s.TrackingId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrackingId"))
	}
	if s.TrackingId != nil && len(*s.TrackingId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TrackingId", 1))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserId", 1))
	}
	if s.EventList != nil {
		for i, v := range s.EventList {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EventList", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutEventsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.EventList != nil {
		v := s.EventList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "eventList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.SessionId != nil {
		v := *s.SessionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sessionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TrackingId != nil {
		v := *s.TrackingId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "trackingId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UserId != nil {
		v := *s.UserId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "userId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type PutEventsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutEventsOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opPutEvents = "PutEvents"

// PutEventsRequest returns a request value for making API operation for
// Amazon Personalize Events.
//
// Records user interaction event data.
//
//    // Example sending a request using PutEventsRequest.
//    req := client.PutEventsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/personalize-events-2018-03-22/PutEvents
func (c *Client) PutEventsRequest(input *PutEventsInput) PutEventsRequest {
	op := &aws.Operation{
		Name:       opPutEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/events",
	}

	if input == nil {
		input = &PutEventsInput{}
	}

	req := c.newRequest(op, input, &PutEventsOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return PutEventsRequest{Request: req, Input: input, Copy: c.PutEventsRequest}
}

// PutEventsRequest is the request type for the
// PutEvents API operation.
type PutEventsRequest struct {
	*aws.Request
	Input *PutEventsInput
	Copy  func(*PutEventsInput) PutEventsRequest
}

// Send marshals and sends the PutEvents API request.
func (r PutEventsRequest) Send(ctx context.Context) (*PutEventsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutEventsResponse{
		PutEventsOutput: r.Request.Data.(*PutEventsOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutEventsResponse is the response type for the
// PutEvents API operation.
type PutEventsResponse struct {
	*PutEventsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutEvents request.
func (r *PutEventsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
