// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// The input for the SetDefaultPolicyVersion operation.
type SetDefaultPolicyVersionInput struct {
	_ struct{} `type:"structure"`

	// The policy name.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`

	// The policy version ID.
	//
	// PolicyVersionId is a required field
	PolicyVersionId *string `location:"uri" locationName:"policyVersionId" type:"string" required:"true"`
}

// String returns the string representation
func (s SetDefaultPolicyVersionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetDefaultPolicyVersionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SetDefaultPolicyVersionInput"}

	if s.PolicyName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyName", 1))
	}

	if s.PolicyVersionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyVersionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SetDefaultPolicyVersionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.PolicyName != nil {
		v := *s.PolicyName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "policyName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PolicyVersionId != nil {
		v := *s.PolicyVersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "policyVersionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type SetDefaultPolicyVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetDefaultPolicyVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SetDefaultPolicyVersionOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opSetDefaultPolicyVersion = "SetDefaultPolicyVersion"

// SetDefaultPolicyVersionRequest returns a request value for making API operation for
// AWS IoT.
//
// Sets the specified version of the specified policy as the policy's default
// (operative) version. This action affects all certificates to which the policy
// is attached. To list the principals the policy is attached to, use the ListPrincipalPolicy
// API.
//
//    // Example sending a request using SetDefaultPolicyVersionRequest.
//    req := client.SetDefaultPolicyVersionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) SetDefaultPolicyVersionRequest(input *SetDefaultPolicyVersionInput) SetDefaultPolicyVersionRequest {
	op := &aws.Operation{
		Name:       opSetDefaultPolicyVersion,
		HTTPMethod: "PATCH",
		HTTPPath:   "/policies/{policyName}/version/{policyVersionId}",
	}

	if input == nil {
		input = &SetDefaultPolicyVersionInput{}
	}

	req := c.newRequest(op, input, &SetDefaultPolicyVersionOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return SetDefaultPolicyVersionRequest{Request: req, Input: input, Copy: c.SetDefaultPolicyVersionRequest}
}

// SetDefaultPolicyVersionRequest is the request type for the
// SetDefaultPolicyVersion API operation.
type SetDefaultPolicyVersionRequest struct {
	*aws.Request
	Input *SetDefaultPolicyVersionInput
	Copy  func(*SetDefaultPolicyVersionInput) SetDefaultPolicyVersionRequest
}

// Send marshals and sends the SetDefaultPolicyVersion API request.
func (r SetDefaultPolicyVersionRequest) Send(ctx context.Context) (*SetDefaultPolicyVersionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SetDefaultPolicyVersionResponse{
		SetDefaultPolicyVersionOutput: r.Request.Data.(*SetDefaultPolicyVersionOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SetDefaultPolicyVersionResponse is the response type for the
// SetDefaultPolicyVersion API operation.
type SetDefaultPolicyVersionResponse struct {
	*SetDefaultPolicyVersionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SetDefaultPolicyVersion request.
func (r *SetDefaultPolicyVersionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
