// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type AllocateAddressInput struct {
	_ struct{} `type:"structure"`

	// [EC2-VPC] The Elastic IP address to recover or an IPv4 address from an address
	// pool.
	Address *string `type:"string"`

	// The ID of a customer-owned address pool. Use this parameter to let Amazon
	// EC2 select an address from the address pool. Alternatively, specify a specific
	// address from the address pool.
	CustomerOwnedIpv4Pool *string `type:"string"`

	// Set to vpc to allocate the address for use with instances in a VPC.
	//
	// Default: The address is for use with instances in EC2-Classic.
	Domain DomainType `type:"string" enum:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The location from which the IP address is advertised. Use this parameter
	// to limit the address to this location.
	//
	// Use DescribeVpcs (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcs.html)
	// to view the network border groups.
	//
	// You cannot use a network border group with EC2 Classic. If you attempt this
	// operation on EC2 classic, you will receive an InvalidParameterCombination
	// error. For more information, see Error Codes (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html).
	NetworkBorderGroup *string `type:"string"`

	// The ID of an address pool that you own. Use this parameter to let Amazon
	// EC2 select an address from the address pool. To specify a specific address
	// from the address pool, use the Address parameter instead.
	PublicIpv4Pool *string `type:"string"`
}

// String returns the string representation
func (s AllocateAddressInput) String() string {
	return awsutil.Prettify(s)
}

type AllocateAddressOutput struct {
	_ struct{} `type:"structure"`

	// [EC2-VPC] The ID that AWS assigns to represent the allocation of the Elastic
	// IP address for use with instances in a VPC.
	AllocationId *string `locationName:"allocationId" type:"string"`

	// The customer-owned IP address.
	CustomerOwnedIp *string `locationName:"customerOwnedIp" type:"string"`

	// The ID of the customer-owned address pool.
	CustomerOwnedIpv4Pool *string `locationName:"customerOwnedIpv4Pool" type:"string"`

	// Indicates whether this Elastic IP address is for use with instances in EC2-Classic
	// (standard) or instances in a VPC (vpc).
	Domain DomainType `locationName:"domain" type:"string" enum:"true"`

	// The location from which the IP address is advertised.
	NetworkBorderGroup *string `locationName:"networkBorderGroup" type:"string"`

	// The Elastic IP address.
	PublicIp *string `locationName:"publicIp" type:"string"`

	// The ID of an address pool.
	PublicIpv4Pool *string `locationName:"publicIpv4Pool" type:"string"`
}

// String returns the string representation
func (s AllocateAddressOutput) String() string {
	return awsutil.Prettify(s)
}

const opAllocateAddress = "AllocateAddress"

// AllocateAddressRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Allocates an Elastic IP address to your AWS account. After you allocate the
// Elastic IP address you can associate it with an instance or network interface.
// After you release an Elastic IP address, it is released to the IP address
// pool and can be allocated to a different AWS account.
//
// You can allocate an Elastic IP address from an address pool owned by AWS
// or from an address pool created from a public IPv4 address range that you
// have brought to AWS for use with your AWS resources using bring your own
// IP addresses (BYOIP). For more information, see Bring Your Own IP Addresses
// (BYOIP) (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// [EC2-VPC] If you release an Elastic IP address, you might be able to recover
// it. You cannot recover an Elastic IP address that you released after it is
// allocated to another AWS account. You cannot recover an Elastic IP address
// for EC2-Classic. To attempt to recover an Elastic IP address that you released,
// specify it in this operation.
//
// An Elastic IP address is for use either in the EC2-Classic platform or in
// a VPC. By default, you can allocate 5 Elastic IP addresses for EC2-Classic
// per Region and 5 Elastic IP addresses for EC2-VPC per Region.
//
// For more information, see Elastic IP Addresses (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
//    // Example sending a request using AllocateAddressRequest.
//    req := client.AllocateAddressRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateAddress
func (c *Client) AllocateAddressRequest(input *AllocateAddressInput) AllocateAddressRequest {
	op := &aws.Operation{
		Name:       opAllocateAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllocateAddressInput{}
	}

	req := c.newRequest(op, input, &AllocateAddressOutput{})
	return AllocateAddressRequest{Request: req, Input: input, Copy: c.AllocateAddressRequest}
}

// AllocateAddressRequest is the request type for the
// AllocateAddress API operation.
type AllocateAddressRequest struct {
	*aws.Request
	Input *AllocateAddressInput
	Copy  func(*AllocateAddressInput) AllocateAddressRequest
}

// Send marshals and sends the AllocateAddress API request.
func (r AllocateAddressRequest) Send(ctx context.Context) (*AllocateAddressResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AllocateAddressResponse{
		AllocateAddressOutput: r.Request.Data.(*AllocateAddressOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AllocateAddressResponse is the response type for the
// AllocateAddress API operation.
type AllocateAddressResponse struct {
	*AllocateAddressOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AllocateAddress request.
func (r *AllocateAddressResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
