// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3control

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListAccessPointsInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID for owner of the bucket whose access points you want to
	// list.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the bucket whose associated access points you want to list.
	Bucket *string `location:"querystring" locationName:"bucket" min:"3" type:"string"`

	// The maximum number of access points that you want to include in the list.
	// If the specified bucket has more than this number of access points, then
	// the response will include a continuation token in the NextToken field that
	// you can use to retrieve the next page of access points.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A continuation token. If a previous call to ListAccessPoints returned a continuation
	// token in the NextToken field, then providing that value here causes Amazon
	// S3 to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAccessPointsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccessPointsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListAccessPointsInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("Bucket", 3))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListAccessPointsInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-account-id", protocol.StringValue(v), metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "bucket", protocol.StringValue(v), metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.StringValue(v), metadata)
	}
	return nil
}

type ListAccessPointsOutput struct {
	_ struct{} `type:"structure"`

	// Contains identification and configuration information for one or more access
	// points associated with the specified bucket.
	AccessPointList []AccessPoint `locationNameList:"AccessPoint" type:"list"`

	// If the specified bucket has more access points than can be returned in one
	// call to this API, then this field contains a continuation token that you
	// can provide in subsequent calls to this API to retrieve additional access
	// points.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAccessPointsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListAccessPointsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessPointList != nil {
		v := s.AccessPointList

		metadata := protocol.Metadata{ListLocationName: "AccessPoint"}
		ls0 := e.List(protocol.BodyTarget, "AccessPointList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.StringValue(v), metadata)
	}
	return nil
}

const opListAccessPoints = "ListAccessPoints"

// ListAccessPointsRequest returns a request value for making API operation for
// AWS S3 Control.
//
// Returns a list of the access points currently associated with the specified
// bucket. You can retrieve up to 1000 access points per call. If the specified
// bucket has more than 1000 access points (or the number specified in maxResults,
// whichever is less), then the response will include a continuation token that
// you can use to list the additional access points.
//
//    // Example sending a request using ListAccessPointsRequest.
//    req := client.ListAccessPointsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListAccessPoints
func (c *Client) ListAccessPointsRequest(input *ListAccessPointsInput) ListAccessPointsRequest {
	op := &aws.Operation{
		Name:       opListAccessPoints,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/accesspoint",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccessPointsInput{}
	}

	req := c.newRequest(op, input, &ListAccessPointsOutput{})
	req.Handlers.Build.PushBackNamed(buildPrefixHostHandler("AccountID", aws.StringValue(input.AccountId)))
	req.Handlers.Build.PushBackNamed(buildRemoveHeaderHandler("X-Amz-Account-Id"))
	return ListAccessPointsRequest{Request: req, Input: input, Copy: c.ListAccessPointsRequest}
}

// ListAccessPointsRequest is the request type for the
// ListAccessPoints API operation.
type ListAccessPointsRequest struct {
	*aws.Request
	Input *ListAccessPointsInput
	Copy  func(*ListAccessPointsInput) ListAccessPointsRequest
}

// Send marshals and sends the ListAccessPoints API request.
func (r ListAccessPointsRequest) Send(ctx context.Context) (*ListAccessPointsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListAccessPointsResponse{
		ListAccessPointsOutput: r.Request.Data.(*ListAccessPointsOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListAccessPointsRequestPaginator returns a paginator for ListAccessPoints.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListAccessPointsRequest(input)
//   p := s3control.NewListAccessPointsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListAccessPointsPaginator(req ListAccessPointsRequest) ListAccessPointsPaginator {
	return ListAccessPointsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListAccessPointsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListAccessPointsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListAccessPointsPaginator struct {
	aws.Pager
}

func (p *ListAccessPointsPaginator) CurrentPage() *ListAccessPointsOutput {
	return p.Pager.CurrentPage().(*ListAccessPointsOutput)
}

// ListAccessPointsResponse is the response type for the
// ListAccessPoints API operation.
type ListAccessPointsResponse struct {
	*ListAccessPointsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListAccessPoints request.
func (r *ListAccessPointsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
