// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package machinelearning

// The function used to train an MLModel. Training choices supported by Amazon
// ML include the following:
//
//    * SGD - Stochastic Gradient Descent.
//
//    * RandomForest - Random forest of decision trees.
type Algorithm string

// Enum values for Algorithm
const (
	AlgorithmSgd Algorithm = "sgd"
)

func (enum Algorithm) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Algorithm) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// A list of the variables to use in searching or filtering BatchPrediction.
//
//    * CreatedAt - Sets the search criteria to BatchPrediction creation date.
//
//    * Status - Sets the search criteria to BatchPrediction status.
//
//    * Name - Sets the search criteria to the contents of BatchPrediction Name.
//
//    * IAMUser - Sets the search criteria to the user account that invoked
//    the BatchPrediction creation.
//
//    * MLModelId - Sets the search criteria to the MLModel used in the BatchPrediction.
//
//    * DataSourceId - Sets the search criteria to the DataSource used in the
//    BatchPrediction.
//
//    * DataURI - Sets the search criteria to the data file(s) used in the BatchPrediction.
//    The URL can identify either a file or an Amazon Simple Storage Service
//    (Amazon S3) bucket or directory.
type BatchPredictionFilterVariable string

// Enum values for BatchPredictionFilterVariable
const (
	BatchPredictionFilterVariableCreatedAt     BatchPredictionFilterVariable = "CreatedAt"
	BatchPredictionFilterVariableLastUpdatedAt BatchPredictionFilterVariable = "LastUpdatedAt"
	BatchPredictionFilterVariableStatus        BatchPredictionFilterVariable = "Status"
	BatchPredictionFilterVariableName          BatchPredictionFilterVariable = "Name"
	BatchPredictionFilterVariableIamuser       BatchPredictionFilterVariable = "IAMUser"
	BatchPredictionFilterVariableMlmodelId     BatchPredictionFilterVariable = "MLModelId"
	BatchPredictionFilterVariableDataSourceId  BatchPredictionFilterVariable = "DataSourceId"
	BatchPredictionFilterVariableDataUri       BatchPredictionFilterVariable = "DataURI"
)

func (enum BatchPredictionFilterVariable) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum BatchPredictionFilterVariable) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// A list of the variables to use in searching or filtering DataSource.
//
//    * CreatedAt - Sets the search criteria to DataSource creation date.
//
//    * Status - Sets the search criteria to DataSource status.
//
//    * Name - Sets the search criteria to the contents of DataSource Name.
//
//    * DataUri - Sets the search criteria to the URI of data files used to
//    create the DataSource. The URI can identify either a file or an Amazon
//    Simple Storage Service (Amazon S3) bucket or directory.
//
//    * IAMUser - Sets the search criteria to the user account that invoked
//    the DataSource creation.
//  Note
// The variable names should match the variable names in the DataSource.
type DataSourceFilterVariable string

// Enum values for DataSourceFilterVariable
const (
	DataSourceFilterVariableCreatedAt      DataSourceFilterVariable = "CreatedAt"
	DataSourceFilterVariableLastUpdatedAt  DataSourceFilterVariable = "LastUpdatedAt"
	DataSourceFilterVariableStatus         DataSourceFilterVariable = "Status"
	DataSourceFilterVariableName           DataSourceFilterVariable = "Name"
	DataSourceFilterVariableDataLocationS3 DataSourceFilterVariable = "DataLocationS3"
	DataSourceFilterVariableIamuser        DataSourceFilterVariable = "IAMUser"
)

func (enum DataSourceFilterVariable) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum DataSourceFilterVariable) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Contains the key values of
//    DetailsMap
// :
//    PredictiveModelType
//  - Indicates the type of the
//    MLModel
// .
//    Algorithm
//  - Indicates the algorithm that was used for the
//    MLModel
// .
type DetailsAttributes string

// Enum values for DetailsAttributes
const (
	DetailsAttributesPredictiveModelType DetailsAttributes = "PredictiveModelType"
	DetailsAttributesAlgorithm           DetailsAttributes = "Algorithm"
)

func (enum DetailsAttributes) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum DetailsAttributes) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Object status with the following possible values:
//
//    * PENDING
//
//    * INPROGRESS
//
//    * FAILED
//
//    * COMPLETED
//
//    * DELETED
type EntityStatus string

// Enum values for EntityStatus
const (
	EntityStatusPending    EntityStatus = "PENDING"
	EntityStatusInprogress EntityStatus = "INPROGRESS"
	EntityStatusFailed     EntityStatus = "FAILED"
	EntityStatusCompleted  EntityStatus = "COMPLETED"
	EntityStatusDeleted    EntityStatus = "DELETED"
)

func (enum EntityStatus) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum EntityStatus) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// A list of the variables to use in searching or filtering Evaluation.
//
//    * CreatedAt - Sets the search criteria to Evaluation creation date.
//
//    * Status - Sets the search criteria to Evaluation status.
//
//    * Name - Sets the search criteria to the contents of Evaluation Name.
//
//    * IAMUser - Sets the search criteria to the user account that invoked
//    an evaluation.
//
//    * MLModelId - Sets the search criteria to the Predictor that was evaluated.
//
//    * DataSourceId - Sets the search criteria to the DataSource used in evaluation.
//
//    * DataUri - Sets the search criteria to the data file(s) used in evaluation.
//    The URL can identify either a file or an Amazon Simple Storage Service
//    (Amazon S3) bucket or directory.
type EvaluationFilterVariable string

// Enum values for EvaluationFilterVariable
const (
	EvaluationFilterVariableCreatedAt     EvaluationFilterVariable = "CreatedAt"
	EvaluationFilterVariableLastUpdatedAt EvaluationFilterVariable = "LastUpdatedAt"
	EvaluationFilterVariableStatus        EvaluationFilterVariable = "Status"
	EvaluationFilterVariableName          EvaluationFilterVariable = "Name"
	EvaluationFilterVariableIamuser       EvaluationFilterVariable = "IAMUser"
	EvaluationFilterVariableMlmodelId     EvaluationFilterVariable = "MLModelId"
	EvaluationFilterVariableDataSourceId  EvaluationFilterVariable = "DataSourceId"
	EvaluationFilterVariableDataUri       EvaluationFilterVariable = "DataURI"
)

func (enum EvaluationFilterVariable) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum EvaluationFilterVariable) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type MLModelFilterVariable string

// Enum values for MLModelFilterVariable
const (
	MLModelFilterVariableCreatedAt              MLModelFilterVariable = "CreatedAt"
	MLModelFilterVariableLastUpdatedAt          MLModelFilterVariable = "LastUpdatedAt"
	MLModelFilterVariableStatus                 MLModelFilterVariable = "Status"
	MLModelFilterVariableName                   MLModelFilterVariable = "Name"
	MLModelFilterVariableIamuser                MLModelFilterVariable = "IAMUser"
	MLModelFilterVariableTrainingDataSourceId   MLModelFilterVariable = "TrainingDataSourceId"
	MLModelFilterVariableRealtimeEndpointStatus MLModelFilterVariable = "RealtimeEndpointStatus"
	MLModelFilterVariableMlmodelType            MLModelFilterVariable = "MLModelType"
	MLModelFilterVariableAlgorithm              MLModelFilterVariable = "Algorithm"
	MLModelFilterVariableTrainingDataUri        MLModelFilterVariable = "TrainingDataURI"
)

func (enum MLModelFilterVariable) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum MLModelFilterVariable) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type MLModelType string

// Enum values for MLModelType
const (
	MLModelTypeRegression MLModelType = "REGRESSION"
	MLModelTypeBinary     MLModelType = "BINARY"
	MLModelTypeMulticlass MLModelType = "MULTICLASS"
)

func (enum MLModelType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum MLModelType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type RealtimeEndpointStatus string

// Enum values for RealtimeEndpointStatus
const (
	RealtimeEndpointStatusNone     RealtimeEndpointStatus = "NONE"
	RealtimeEndpointStatusReady    RealtimeEndpointStatus = "READY"
	RealtimeEndpointStatusUpdating RealtimeEndpointStatus = "UPDATING"
	RealtimeEndpointStatusFailed   RealtimeEndpointStatus = "FAILED"
)

func (enum RealtimeEndpointStatus) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum RealtimeEndpointStatus) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The sort order specified in a listing condition. Possible values include
// the following:
//
//    * asc - Present the information in ascending order (from A-Z).
//
//    * dsc - Present the information in descending order (from Z-A).
type SortOrder string

// Enum values for SortOrder
const (
	SortOrderAsc SortOrder = "asc"
	SortOrderDsc SortOrder = "dsc"
)

func (enum SortOrder) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum SortOrder) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type TaggableResourceType string

// Enum values for TaggableResourceType
const (
	TaggableResourceTypeBatchPrediction TaggableResourceType = "BatchPrediction"
	TaggableResourceTypeDataSource      TaggableResourceType = "DataSource"
	TaggableResourceTypeEvaluation      TaggableResourceType = "Evaluation"
	TaggableResourceTypeMlmodel         TaggableResourceType = "MLModel"
)

func (enum TaggableResourceType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum TaggableResourceType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}
