// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package forecast

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateDatasetInput struct {
	_ struct{} `type:"structure"`

	// The frequency of data collection. This parameter is required for RELATED_TIME_SERIES
	// datasets.
	//
	// Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min
	// (30 minutes), 15min (15 minutes), 10min (10 minutes), 5min (5 minutes), and
	// 1min (1 minute). For example, "D" indicates every day and "15min" indicates
	// every 15 minutes.
	DataFrequency *string `type:"string"`

	// A name for the dataset.
	//
	// DatasetName is a required field
	DatasetName *string `min:"1" type:"string" required:"true"`

	// The dataset type. Valid values depend on the chosen Domain.
	//
	// DatasetType is a required field
	DatasetType DatasetType `type:"string" required:"true" enum:"true"`

	// The domain associated with the dataset. When you add a dataset to a dataset
	// group, this value and the value specified for the Domain parameter of the
	// CreateDatasetGroup operation must match.
	//
	// The Domain and DatasetType that you choose determine the fields that must
	// be present in the training data that you import to the dataset. For example,
	// if you choose the RETAIL domain and TARGET_TIME_SERIES as the DatasetType,
	// Amazon Forecast requires item_id, timestamp, and demand fields to be present
	// in your data. For more information, see howitworks-datasets-groups.
	//
	// Domain is a required field
	Domain Domain `type:"string" required:"true" enum:"true"`

	// An AWS Key Management Service (KMS) key and the AWS Identity and Access Management
	// (IAM) role that Amazon Forecast can assume to access the key.
	EncryptionConfig *EncryptionConfig `type:"structure"`

	// The schema for the dataset. The schema attributes and their order must match
	// the fields in your data. The dataset Domain and DatasetType that you choose
	// determine the minimum required fields in your training data. For information
	// about the required fields for a specific dataset domain and type, see howitworks-domains-ds-types.
	//
	// Schema is a required field
	Schema *Schema `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatasetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateDatasetInput"}

	if s.DatasetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatasetName", 1))
	}
	if len(s.DatasetType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("DatasetType"))
	}
	if len(s.Domain) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}

	if s.Schema == nil {
		invalidParams.Add(aws.NewErrParamRequired("Schema"))
	}
	if s.EncryptionConfig != nil {
		if err := s.EncryptionConfig.Validate(); err != nil {
			invalidParams.AddNested("EncryptionConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.Schema != nil {
		if err := s.Schema.Validate(); err != nil {
			invalidParams.AddNested("Schema", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateDatasetOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset.
	DatasetArn *string `type:"string"`
}

// String returns the string representation
func (s CreateDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateDataset = "CreateDataset"

// CreateDatasetRequest returns a request value for making API operation for
// Amazon Forecast Service.
//
// Creates an Amazon Forecast dataset. The information about the dataset that
// you provide helps Forecast understand how to consume the data for model training.
// This includes the following:
//
//    * DataFrequency - How frequently your historical time-series data is collected.
//
//    * Domain and DatasetType - Each dataset has an associated dataset domain
//    and a type within the domain. Amazon Forecast provides a list of predefined
//    domains and types within each domain. For each unique dataset domain and
//    type within the domain, Amazon Forecast requires your data to include
//    a minimum set of predefined fields.
//
//    * Schema - A schema specifies the fields in the dataset, including the
//    field name and data type.
//
// After creating a dataset, you import your training data into it and add the
// dataset to a dataset group. You use the dataset group to create a predictor.
// For more information, see howitworks-datasets-groups.
//
// To get a list of all your datasets, use the ListDatasets operation.
//
// For example Forecast datasets, see the Amazon Forecast Sample GitHub repository
// (https://github.com/aws-samples/amazon-forecast-samples/tree/master/data).
//
// The Status of a dataset must be ACTIVE before you can import training data.
// Use the DescribeDataset operation to get the status.
//
//    // Example sending a request using CreateDatasetRequest.
//    req := client.CreateDatasetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateDataset
func (c *Client) CreateDatasetRequest(input *CreateDatasetInput) CreateDatasetRequest {
	op := &aws.Operation{
		Name:       opCreateDataset,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDatasetInput{}
	}

	req := c.newRequest(op, input, &CreateDatasetOutput{})
	return CreateDatasetRequest{Request: req, Input: input, Copy: c.CreateDatasetRequest}
}

// CreateDatasetRequest is the request type for the
// CreateDataset API operation.
type CreateDatasetRequest struct {
	*aws.Request
	Input *CreateDatasetInput
	Copy  func(*CreateDatasetInput) CreateDatasetRequest
}

// Send marshals and sends the CreateDataset API request.
func (r CreateDatasetRequest) Send(ctx context.Context) (*CreateDatasetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateDatasetResponse{
		CreateDatasetOutput: r.Request.Data.(*CreateDatasetOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateDatasetResponse is the response type for the
// CreateDataset API operation.
type CreateDatasetResponse struct {
	*CreateDatasetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateDataset request.
func (r *CreateDatasetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
