// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticbeanstalk

import (
	"context"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Request to update an environment.
type UpdateEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The name of the application with which the environment is associated.
	ApplicationName *string `min:"1" type:"string"`

	// If this parameter is specified, AWS Elastic Beanstalk updates the description
	// of this environment.
	Description *string `type:"string"`

	// The ID of the environment to update.
	//
	// If no environment with this ID exists, AWS Elastic Beanstalk returns an InvalidParameterValue
	// error.
	//
	// Condition: You must specify either this or an EnvironmentName, or both. If
	// you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentId *string `type:"string"`

	// The name of the environment to update. If no environment with this name exists,
	// AWS Elastic Beanstalk returns an InvalidParameterValue error.
	//
	// Condition: You must specify either this or an EnvironmentId, or both. If
	// you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentName *string `min:"4" type:"string"`

	// The name of the group to which the target environment belongs. Specify a
	// group name only if the environment's name is specified in an environment
	// manifest and not with the environment name or environment ID parameters.
	// See Environment Manifest (env.yaml) (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html)
	// for details.
	GroupName *string `min:"1" type:"string"`

	// If specified, AWS Elastic Beanstalk updates the configuration set associated
	// with the running environment and sets the specified configuration options
	// to the requested value.
	OptionSettings []ConfigurationOptionSetting `type:"list"`

	// A list of custom user-defined configuration options to remove from the configuration
	// set for this environment.
	OptionsToRemove []OptionSpecification `type:"list"`

	// The ARN of the platform, if used.
	PlatformArn *string `type:"string"`

	// This specifies the platform version that the environment will run after the
	// environment is updated.
	SolutionStackName *string `type:"string"`

	// If this parameter is specified, AWS Elastic Beanstalk deploys this configuration
	// template to the environment. If no such configuration template is found,
	// AWS Elastic Beanstalk returns an InvalidParameterValue error.
	TemplateName *string `min:"1" type:"string"`

	// This specifies the tier to use to update the environment.
	//
	// Condition: At this time, if you change the tier version, name, or type, AWS
	// Elastic Beanstalk returns InvalidParameterValue error.
	Tier *EnvironmentTier `type:"structure"`

	// If this parameter is specified, AWS Elastic Beanstalk deploys the named application
	// version to the environment. If no such application version is found, returns
	// an InvalidParameterValue error.
	VersionLabel *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEnvironmentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateEnvironmentInput"}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 4 {
		invalidParams.Add(aws.NewErrParamMinLen("EnvironmentName", 4))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GroupName", 1))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TemplateName", 1))
	}
	if s.VersionLabel != nil && len(*s.VersionLabel) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VersionLabel", 1))
	}
	if s.OptionSettings != nil {
		for i, v := range s.OptionSettings {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OptionSettings", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.OptionsToRemove != nil {
		for i, v := range s.OptionsToRemove {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OptionsToRemove", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the properties of an environment.
type UpdateEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// Indicates if there is an in-progress environment configuration update or
	// application version deployment that you can cancel.
	//
	// true: There is an update in progress.
	//
	// false: There are no updates currently in progress.
	AbortableOperationInProgress *bool `type:"boolean"`

	// The name of the application associated with this environment.
	ApplicationName *string `min:"1" type:"string"`

	// The URL to the CNAME for this environment.
	CNAME *string `min:"1" type:"string"`

	// The creation date for this environment.
	DateCreated *time.Time `type:"timestamp"`

	// The last modified date for this environment.
	DateUpdated *time.Time `type:"timestamp"`

	// Describes this environment.
	Description *string `type:"string"`

	// For load-balanced, autoscaling environments, the URL to the LoadBalancer.
	// For single-instance environments, the IP address of the instance.
	EndpointURL *string `type:"string"`

	// The environment's Amazon Resource Name (ARN), which can be used in other
	// API requests that require an ARN.
	EnvironmentArn *string `type:"string"`

	// The ID of this environment.
	EnvironmentId *string `type:"string"`

	// A list of links to other environments in the same group.
	EnvironmentLinks []EnvironmentLink `type:"list"`

	// The name of this environment.
	EnvironmentName *string `min:"4" type:"string"`

	// Describes the health status of the environment. AWS Elastic Beanstalk indicates
	// the failure levels for a running environment:
	//
	//    * Red: Indicates the environment is not responsive. Occurs when three
	//    or more consecutive failures occur for an environment.
	//
	//    * Yellow: Indicates that something is wrong. Occurs when two consecutive
	//    failures occur for an environment.
	//
	//    * Green: Indicates the environment is healthy and fully functional.
	//
	//    * Grey: Default health for a new environment. The environment is not fully
	//    launched and health checks have not started or health checks are suspended
	//    during an UpdateEnvironment or RestartEnvironment request.
	//
	// Default: Grey
	Health EnvironmentHealth `type:"string" enum:"true"`

	// Returns the health status of the application running in your environment.
	// For more information, see Health Colors and Statuses (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html).
	HealthStatus EnvironmentHealthStatus `type:"string" enum:"true"`

	// The ARN of the platform.
	PlatformArn *string `type:"string"`

	// The description of the AWS resources used by this environment.
	Resources *EnvironmentResourcesDescription `type:"structure"`

	// The name of the SolutionStack deployed with this environment.
	SolutionStackName *string `type:"string"`

	// The current operational status of the environment:
	//
	//    * Launching: Environment is in the process of initial deployment.
	//
	//    * Updating: Environment is in the process of updating its configuration
	//    settings or application version.
	//
	//    * Ready: Environment is available to have an action performed on it, such
	//    as update or terminate.
	//
	//    * Terminating: Environment is in the shut-down process.
	//
	//    * Terminated: Environment is not running.
	Status EnvironmentStatus `type:"string" enum:"true"`

	// The name of the configuration template used to originally launch this environment.
	TemplateName *string `min:"1" type:"string"`

	// Describes the current tier of this environment.
	Tier *EnvironmentTier `type:"structure"`

	// The application version deployed in this environment.
	VersionLabel *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateEnvironment = "UpdateEnvironment"

// UpdateEnvironmentRequest returns a request value for making API operation for
// AWS Elastic Beanstalk.
//
// Updates the environment description, deploys a new application version, updates
// the configuration settings to an entirely new configuration template, or
// updates select configuration option values in the running environment.
//
// Attempting to update both the release and configuration is not allowed and
// AWS Elastic Beanstalk returns an InvalidParameterCombination error.
//
// When updating the configuration settings to a new template or individual
// settings, a draft configuration is created and DescribeConfigurationSettings
// for this environment returns two setting descriptions with different DeploymentStatus
// values.
//
//    // Example sending a request using UpdateEnvironmentRequest.
//    req := client.UpdateEnvironmentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateEnvironment
func (c *Client) UpdateEnvironmentRequest(input *UpdateEnvironmentInput) UpdateEnvironmentRequest {
	op := &aws.Operation{
		Name:       opUpdateEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEnvironmentInput{}
	}

	req := c.newRequest(op, input, &UpdateEnvironmentOutput{})
	return UpdateEnvironmentRequest{Request: req, Input: input, Copy: c.UpdateEnvironmentRequest}
}

// UpdateEnvironmentRequest is the request type for the
// UpdateEnvironment API operation.
type UpdateEnvironmentRequest struct {
	*aws.Request
	Input *UpdateEnvironmentInput
	Copy  func(*UpdateEnvironmentInput) UpdateEnvironmentRequest
}

// Send marshals and sends the UpdateEnvironment API request.
func (r UpdateEnvironmentRequest) Send(ctx context.Context) (*UpdateEnvironmentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateEnvironmentResponse{
		UpdateEnvironmentOutput: r.Request.Data.(*UpdateEnvironmentOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateEnvironmentResponse is the response type for the
// UpdateEnvironment API operation.
type UpdateEnvironmentResponse struct {
	*UpdateEnvironmentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateEnvironment request.
func (r *UpdateEnvironmentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
