// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Request to describe a BasePathMapping resource.
type GetBasePathMappingInput struct {
	_ struct{} `type:"structure"`

	// [Required] The base path name that callers of the API must provide as part
	// of the URL after the domain name. This value must be unique for all of the
	// mappings across a single API. Specify '(none)' if you do not want callers
	// to specify any base path name after the domain name.
	//
	// BasePath is a required field
	BasePath *string `location:"uri" locationName:"base_path" type:"string" required:"true"`

	// [Required] The domain name of the BasePathMapping resource to be described.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"domain_name" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBasePathMappingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBasePathMappingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetBasePathMappingInput"}

	if s.BasePath == nil {
		invalidParams.Add(aws.NewErrParamRequired("BasePath"))
	}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBasePathMappingInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.BasePath != nil {
		v := *s.BasePath

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "base_path", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "domain_name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents the base path that callers of the API must provide as part of
// the URL after the domain name.
//
// A custom domain name plus a BasePathMapping specification identifies a deployed
// RestApi in a given stage of the owner Account.
//
// Use Custom Domain Names (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html)
type GetBasePathMappingOutput struct {
	_ struct{} `type:"structure"`

	// The base path name that callers of the API must provide as part of the URL
	// after the domain name.
	BasePath *string `locationName:"basePath" type:"string"`

	// The string identifier of the associated RestApi.
	RestApiId *string `locationName:"restApiId" type:"string"`

	// The name of the associated stage.
	Stage *string `locationName:"stage" type:"string"`
}

// String returns the string representation
func (s GetBasePathMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBasePathMappingOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.BasePath != nil {
		v := *s.BasePath

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "basePath", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RestApiId != nil {
		v := *s.RestApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "restApiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Stage != nil {
		v := *s.Stage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetBasePathMapping = "GetBasePathMapping"

// GetBasePathMappingRequest returns a request value for making API operation for
// Amazon API Gateway.
//
// Describe a BasePathMapping resource.
//
//    // Example sending a request using GetBasePathMappingRequest.
//    req := client.GetBasePathMappingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) GetBasePathMappingRequest(input *GetBasePathMappingInput) GetBasePathMappingRequest {
	op := &aws.Operation{
		Name:       opGetBasePathMapping,
		HTTPMethod: "GET",
		HTTPPath:   "/domainnames/{domain_name}/basepathmappings/{base_path}",
	}

	if input == nil {
		input = &GetBasePathMappingInput{}
	}

	req := c.newRequest(op, input, &GetBasePathMappingOutput{})
	return GetBasePathMappingRequest{Request: req, Input: input, Copy: c.GetBasePathMappingRequest}
}

// GetBasePathMappingRequest is the request type for the
// GetBasePathMapping API operation.
type GetBasePathMappingRequest struct {
	*aws.Request
	Input *GetBasePathMappingInput
	Copy  func(*GetBasePathMappingInput) GetBasePathMappingRequest
}

// Send marshals and sends the GetBasePathMapping API request.
func (r GetBasePathMappingRequest) Send(ctx context.Context) (*GetBasePathMappingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetBasePathMappingResponse{
		GetBasePathMappingOutput: r.Request.Data.(*GetBasePathMappingOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetBasePathMappingResponse is the response type for the
// GetBasePathMapping API operation.
type GetBasePathMappingResponse struct {
	*GetBasePathMappingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetBasePathMapping request.
func (r *GetBasePathMappingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
