// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DisassociateContactFromAddressBookInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the address from which to disassociate the contact.
	//
	// AddressBookArn is a required field
	AddressBookArn *string `type:"string" required:"true"`

	// The ARN of the contact to disassociate from an address book.
	//
	// ContactArn is a required field
	ContactArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateContactFromAddressBookInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateContactFromAddressBookInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisassociateContactFromAddressBookInput"}

	if s.AddressBookArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("AddressBookArn"))
	}

	if s.ContactArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ContactArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DisassociateContactFromAddressBookOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateContactFromAddressBookOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisassociateContactFromAddressBook = "DisassociateContactFromAddressBook"

// DisassociateContactFromAddressBookRequest returns a request value for making API operation for
// Alexa For Business.
//
// Disassociates a contact from a given address book.
//
//    // Example sending a request using DisassociateContactFromAddressBookRequest.
//    req := client.DisassociateContactFromAddressBookRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateContactFromAddressBook
func (c *Client) DisassociateContactFromAddressBookRequest(input *DisassociateContactFromAddressBookInput) DisassociateContactFromAddressBookRequest {
	op := &aws.Operation{
		Name:       opDisassociateContactFromAddressBook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateContactFromAddressBookInput{}
	}

	req := c.newRequest(op, input, &DisassociateContactFromAddressBookOutput{})
	return DisassociateContactFromAddressBookRequest{Request: req, Input: input, Copy: c.DisassociateContactFromAddressBookRequest}
}

// DisassociateContactFromAddressBookRequest is the request type for the
// DisassociateContactFromAddressBook API operation.
type DisassociateContactFromAddressBookRequest struct {
	*aws.Request
	Input *DisassociateContactFromAddressBookInput
	Copy  func(*DisassociateContactFromAddressBookInput) DisassociateContactFromAddressBookRequest
}

// Send marshals and sends the DisassociateContactFromAddressBook API request.
func (r DisassociateContactFromAddressBookRequest) Send(ctx context.Context) (*DisassociateContactFromAddressBookResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisassociateContactFromAddressBookResponse{
		DisassociateContactFromAddressBookOutput: r.Request.Data.(*DisassociateContactFromAddressBookOutput),
		response:                                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisassociateContactFromAddressBookResponse is the response type for the
// DisassociateContactFromAddressBook API operation.
type DisassociateContactFromAddressBookResponse struct {
	*DisassociateContactFromAddressBookOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisassociateContactFromAddressBook request.
func (r *DisassociateContactFromAddressBookResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
