// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot1clickprojects

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAssociateDeviceWithPlacement = "AssociateDeviceWithPlacement"

// AssociateDeviceWithPlacementRequest generates a "aws/request.Request" representing the
// client's request for the AssociateDeviceWithPlacement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateDeviceWithPlacement for more information on using the AssociateDeviceWithPlacement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateDeviceWithPlacementRequest method.
//    req, resp := client.AssociateDeviceWithPlacementRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/AssociateDeviceWithPlacement
func (c *IoT1ClickProjects) AssociateDeviceWithPlacementRequest(input *AssociateDeviceWithPlacementInput) (req *request.Request, output *AssociateDeviceWithPlacementOutput) {
	op := &request.Operation{
		Name:       opAssociateDeviceWithPlacement,
		HTTPMethod: "PUT",
		HTTPPath:   "/projects/{projectName}/placements/{placementName}/devices/{deviceTemplateName}",
	}

	if input == nil {
		input = &AssociateDeviceWithPlacementInput{}
	}

	output = &AssociateDeviceWithPlacementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateDeviceWithPlacement API operation for AWS IoT 1-Click Projects Service.
//
// Associates a physical device with a placement.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Projects Service's
// API operation AssociateDeviceWithPlacement for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/AssociateDeviceWithPlacement
func (c *IoT1ClickProjects) AssociateDeviceWithPlacement(input *AssociateDeviceWithPlacementInput) (*AssociateDeviceWithPlacementOutput, error) {
	req, out := c.AssociateDeviceWithPlacementRequest(input)
	return out, req.Send()
}

// AssociateDeviceWithPlacementWithContext is the same as AssociateDeviceWithPlacement with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateDeviceWithPlacement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickProjects) AssociateDeviceWithPlacementWithContext(ctx aws.Context, input *AssociateDeviceWithPlacementInput, opts ...request.Option) (*AssociateDeviceWithPlacementOutput, error) {
	req, out := c.AssociateDeviceWithPlacementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePlacement = "CreatePlacement"

// CreatePlacementRequest generates a "aws/request.Request" representing the
// client's request for the CreatePlacement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePlacement for more information on using the CreatePlacement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePlacementRequest method.
//    req, resp := client.CreatePlacementRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/CreatePlacement
func (c *IoT1ClickProjects) CreatePlacementRequest(input *CreatePlacementInput) (req *request.Request, output *CreatePlacementOutput) {
	op := &request.Operation{
		Name:       opCreatePlacement,
		HTTPMethod: "POST",
		HTTPPath:   "/projects/{projectName}/placements",
	}

	if input == nil {
		input = &CreatePlacementInput{}
	}

	output = &CreatePlacementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePlacement API operation for AWS IoT 1-Click Projects Service.
//
// Creates an empty placement.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Projects Service's
// API operation CreatePlacement for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/CreatePlacement
func (c *IoT1ClickProjects) CreatePlacement(input *CreatePlacementInput) (*CreatePlacementOutput, error) {
	req, out := c.CreatePlacementRequest(input)
	return out, req.Send()
}

// CreatePlacementWithContext is the same as CreatePlacement with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePlacement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickProjects) CreatePlacementWithContext(ctx aws.Context, input *CreatePlacementInput, opts ...request.Option) (*CreatePlacementOutput, error) {
	req, out := c.CreatePlacementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProject = "CreateProject"

// CreateProjectRequest generates a "aws/request.Request" representing the
// client's request for the CreateProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProject for more information on using the CreateProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateProjectRequest method.
//    req, resp := client.CreateProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/CreateProject
func (c *IoT1ClickProjects) CreateProjectRequest(input *CreateProjectInput) (req *request.Request, output *CreateProjectOutput) {
	op := &request.Operation{
		Name:       opCreateProject,
		HTTPMethod: "POST",
		HTTPPath:   "/projects",
	}

	if input == nil {
		input = &CreateProjectInput{}
	}

	output = &CreateProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProject API operation for AWS IoT 1-Click Projects Service.
//
// Creates an empty project with a placement template. A project contains zero
// or more placements that adhere to the placement template defined in the project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Projects Service's
// API operation CreateProject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/CreateProject
func (c *IoT1ClickProjects) CreateProject(input *CreateProjectInput) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	return out, req.Send()
}

// CreateProjectWithContext is the same as CreateProject with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickProjects) CreateProjectWithContext(ctx aws.Context, input *CreateProjectInput, opts ...request.Option) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePlacement = "DeletePlacement"

// DeletePlacementRequest generates a "aws/request.Request" representing the
// client's request for the DeletePlacement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePlacement for more information on using the DeletePlacement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePlacementRequest method.
//    req, resp := client.DeletePlacementRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DeletePlacement
func (c *IoT1ClickProjects) DeletePlacementRequest(input *DeletePlacementInput) (req *request.Request, output *DeletePlacementOutput) {
	op := &request.Operation{
		Name:       opDeletePlacement,
		HTTPMethod: "DELETE",
		HTTPPath:   "/projects/{projectName}/placements/{placementName}",
	}

	if input == nil {
		input = &DeletePlacementInput{}
	}

	output = &DeletePlacementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeletePlacement API operation for AWS IoT 1-Click Projects Service.
//
// Deletes a placement. To delete a placement, it must not have any devices
// associated with it.
//
// When you delete a placement, all associated data becomes irretrievable.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Projects Service's
// API operation DeletePlacement for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DeletePlacement
func (c *IoT1ClickProjects) DeletePlacement(input *DeletePlacementInput) (*DeletePlacementOutput, error) {
	req, out := c.DeletePlacementRequest(input)
	return out, req.Send()
}

// DeletePlacementWithContext is the same as DeletePlacement with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePlacement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickProjects) DeletePlacementWithContext(ctx aws.Context, input *DeletePlacementInput, opts ...request.Option) (*DeletePlacementOutput, error) {
	req, out := c.DeletePlacementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProject = "DeleteProject"

// DeleteProjectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProject for more information on using the DeleteProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteProjectRequest method.
//    req, resp := client.DeleteProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DeleteProject
func (c *IoT1ClickProjects) DeleteProjectRequest(input *DeleteProjectInput) (req *request.Request, output *DeleteProjectOutput) {
	op := &request.Operation{
		Name:       opDeleteProject,
		HTTPMethod: "DELETE",
		HTTPPath:   "/projects/{projectName}",
	}

	if input == nil {
		input = &DeleteProjectInput{}
	}

	output = &DeleteProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteProject API operation for AWS IoT 1-Click Projects Service.
//
// Deletes a project. To delete a project, it must not have any placements associated
// with it.
//
// When you delete a project, all associated data becomes irretrievable.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Projects Service's
// API operation DeleteProject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DeleteProject
func (c *IoT1ClickProjects) DeleteProject(input *DeleteProjectInput) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	return out, req.Send()
}

// DeleteProjectWithContext is the same as DeleteProject with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickProjects) DeleteProjectWithContext(ctx aws.Context, input *DeleteProjectInput, opts ...request.Option) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePlacement = "DescribePlacement"

// DescribePlacementRequest generates a "aws/request.Request" representing the
// client's request for the DescribePlacement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePlacement for more information on using the DescribePlacement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePlacementRequest method.
//    req, resp := client.DescribePlacementRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DescribePlacement
func (c *IoT1ClickProjects) DescribePlacementRequest(input *DescribePlacementInput) (req *request.Request, output *DescribePlacementOutput) {
	op := &request.Operation{
		Name:       opDescribePlacement,
		HTTPMethod: "GET",
		HTTPPath:   "/projects/{projectName}/placements/{placementName}",
	}

	if input == nil {
		input = &DescribePlacementInput{}
	}

	output = &DescribePlacementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePlacement API operation for AWS IoT 1-Click Projects Service.
//
// Describes a placement in a project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Projects Service's
// API operation DescribePlacement for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DescribePlacement
func (c *IoT1ClickProjects) DescribePlacement(input *DescribePlacementInput) (*DescribePlacementOutput, error) {
	req, out := c.DescribePlacementRequest(input)
	return out, req.Send()
}

// DescribePlacementWithContext is the same as DescribePlacement with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePlacement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickProjects) DescribePlacementWithContext(ctx aws.Context, input *DescribePlacementInput, opts ...request.Option) (*DescribePlacementOutput, error) {
	req, out := c.DescribePlacementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProject = "DescribeProject"

// DescribeProjectRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeProject for more information on using the DescribeProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeProjectRequest method.
//    req, resp := client.DescribeProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DescribeProject
func (c *IoT1ClickProjects) DescribeProjectRequest(input *DescribeProjectInput) (req *request.Request, output *DescribeProjectOutput) {
	op := &request.Operation{
		Name:       opDescribeProject,
		HTTPMethod: "GET",
		HTTPPath:   "/projects/{projectName}",
	}

	if input == nil {
		input = &DescribeProjectInput{}
	}

	output = &DescribeProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeProject API operation for AWS IoT 1-Click Projects Service.
//
// Returns an object describing a project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Projects Service's
// API operation DescribeProject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DescribeProject
func (c *IoT1ClickProjects) DescribeProject(input *DescribeProjectInput) (*DescribeProjectOutput, error) {
	req, out := c.DescribeProjectRequest(input)
	return out, req.Send()
}

// DescribeProjectWithContext is the same as DescribeProject with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickProjects) DescribeProjectWithContext(ctx aws.Context, input *DescribeProjectInput, opts ...request.Option) (*DescribeProjectOutput, error) {
	req, out := c.DescribeProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateDeviceFromPlacement = "DisassociateDeviceFromPlacement"

// DisassociateDeviceFromPlacementRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateDeviceFromPlacement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateDeviceFromPlacement for more information on using the DisassociateDeviceFromPlacement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateDeviceFromPlacementRequest method.
//    req, resp := client.DisassociateDeviceFromPlacementRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DisassociateDeviceFromPlacement
func (c *IoT1ClickProjects) DisassociateDeviceFromPlacementRequest(input *DisassociateDeviceFromPlacementInput) (req *request.Request, output *DisassociateDeviceFromPlacementOutput) {
	op := &request.Operation{
		Name:       opDisassociateDeviceFromPlacement,
		HTTPMethod: "DELETE",
		HTTPPath:   "/projects/{projectName}/placements/{placementName}/devices/{deviceTemplateName}",
	}

	if input == nil {
		input = &DisassociateDeviceFromPlacementInput{}
	}

	output = &DisassociateDeviceFromPlacementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateDeviceFromPlacement API operation for AWS IoT 1-Click Projects Service.
//
// Removes a physical device from a placement.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Projects Service's
// API operation DisassociateDeviceFromPlacement for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DisassociateDeviceFromPlacement
func (c *IoT1ClickProjects) DisassociateDeviceFromPlacement(input *DisassociateDeviceFromPlacementInput) (*DisassociateDeviceFromPlacementOutput, error) {
	req, out := c.DisassociateDeviceFromPlacementRequest(input)
	return out, req.Send()
}

// DisassociateDeviceFromPlacementWithContext is the same as DisassociateDeviceFromPlacement with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateDeviceFromPlacement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickProjects) DisassociateDeviceFromPlacementWithContext(ctx aws.Context, input *DisassociateDeviceFromPlacementInput, opts ...request.Option) (*DisassociateDeviceFromPlacementOutput, error) {
	req, out := c.DisassociateDeviceFromPlacementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDevicesInPlacement = "GetDevicesInPlacement"

// GetDevicesInPlacementRequest generates a "aws/request.Request" representing the
// client's request for the GetDevicesInPlacement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDevicesInPlacement for more information on using the GetDevicesInPlacement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDevicesInPlacementRequest method.
//    req, resp := client.GetDevicesInPlacementRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/GetDevicesInPlacement
func (c *IoT1ClickProjects) GetDevicesInPlacementRequest(input *GetDevicesInPlacementInput) (req *request.Request, output *GetDevicesInPlacementOutput) {
	op := &request.Operation{
		Name:       opGetDevicesInPlacement,
		HTTPMethod: "GET",
		HTTPPath:   "/projects/{projectName}/placements/{placementName}/devices",
	}

	if input == nil {
		input = &GetDevicesInPlacementInput{}
	}

	output = &GetDevicesInPlacementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDevicesInPlacement API operation for AWS IoT 1-Click Projects Service.
//
// Returns an object enumerating the devices in a placement.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Projects Service's
// API operation GetDevicesInPlacement for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/GetDevicesInPlacement
func (c *IoT1ClickProjects) GetDevicesInPlacement(input *GetDevicesInPlacementInput) (*GetDevicesInPlacementOutput, error) {
	req, out := c.GetDevicesInPlacementRequest(input)
	return out, req.Send()
}

// GetDevicesInPlacementWithContext is the same as GetDevicesInPlacement with the addition of
// the ability to pass a context and additional request options.
//
// See GetDevicesInPlacement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickProjects) GetDevicesInPlacementWithContext(ctx aws.Context, input *GetDevicesInPlacementInput, opts ...request.Option) (*GetDevicesInPlacementOutput, error) {
	req, out := c.GetDevicesInPlacementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPlacements = "ListPlacements"

// ListPlacementsRequest generates a "aws/request.Request" representing the
// client's request for the ListPlacements operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPlacements for more information on using the ListPlacements
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPlacementsRequest method.
//    req, resp := client.ListPlacementsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/ListPlacements
func (c *IoT1ClickProjects) ListPlacementsRequest(input *ListPlacementsInput) (req *request.Request, output *ListPlacementsOutput) {
	op := &request.Operation{
		Name:       opListPlacements,
		HTTPMethod: "GET",
		HTTPPath:   "/projects/{projectName}/placements",
	}

	if input == nil {
		input = &ListPlacementsInput{}
	}

	output = &ListPlacementsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPlacements API operation for AWS IoT 1-Click Projects Service.
//
// Lists the placement(s) of a project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Projects Service's
// API operation ListPlacements for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/ListPlacements
func (c *IoT1ClickProjects) ListPlacements(input *ListPlacementsInput) (*ListPlacementsOutput, error) {
	req, out := c.ListPlacementsRequest(input)
	return out, req.Send()
}

// ListPlacementsWithContext is the same as ListPlacements with the addition of
// the ability to pass a context and additional request options.
//
// See ListPlacements for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickProjects) ListPlacementsWithContext(ctx aws.Context, input *ListPlacementsInput, opts ...request.Option) (*ListPlacementsOutput, error) {
	req, out := c.ListPlacementsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListProjects = "ListProjects"

// ListProjectsRequest generates a "aws/request.Request" representing the
// client's request for the ListProjects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProjects for more information on using the ListProjects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListProjectsRequest method.
//    req, resp := client.ListProjectsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/ListProjects
func (c *IoT1ClickProjects) ListProjectsRequest(input *ListProjectsInput) (req *request.Request, output *ListProjectsOutput) {
	op := &request.Operation{
		Name:       opListProjects,
		HTTPMethod: "GET",
		HTTPPath:   "/projects",
	}

	if input == nil {
		input = &ListProjectsInput{}
	}

	output = &ListProjectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProjects API operation for AWS IoT 1-Click Projects Service.
//
// Lists the AWS IoT 1-Click project(s) associated with your AWS account and
// region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Projects Service's
// API operation ListProjects for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/ListProjects
func (c *IoT1ClickProjects) ListProjects(input *ListProjectsInput) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	return out, req.Send()
}

// ListProjectsWithContext is the same as ListProjects with the addition of
// the ability to pass a context and additional request options.
//
// See ListProjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickProjects) ListProjectsWithContext(ctx aws.Context, input *ListProjectsInput, opts ...request.Option) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePlacement = "UpdatePlacement"

// UpdatePlacementRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePlacement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePlacement for more information on using the UpdatePlacement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdatePlacementRequest method.
//    req, resp := client.UpdatePlacementRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/UpdatePlacement
func (c *IoT1ClickProjects) UpdatePlacementRequest(input *UpdatePlacementInput) (req *request.Request, output *UpdatePlacementOutput) {
	op := &request.Operation{
		Name:       opUpdatePlacement,
		HTTPMethod: "PUT",
		HTTPPath:   "/projects/{projectName}/placements/{placementName}",
	}

	if input == nil {
		input = &UpdatePlacementInput{}
	}

	output = &UpdatePlacementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePlacement API operation for AWS IoT 1-Click Projects Service.
//
// Updates a placement with the given attributes. To clear an attribute, pass
// an empty value (i.e., "").
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Projects Service's
// API operation UpdatePlacement for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/UpdatePlacement
func (c *IoT1ClickProjects) UpdatePlacement(input *UpdatePlacementInput) (*UpdatePlacementOutput, error) {
	req, out := c.UpdatePlacementRequest(input)
	return out, req.Send()
}

// UpdatePlacementWithContext is the same as UpdatePlacement with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePlacement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickProjects) UpdatePlacementWithContext(ctx aws.Context, input *UpdatePlacementInput, opts ...request.Option) (*UpdatePlacementOutput, error) {
	req, out := c.UpdatePlacementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProject = "UpdateProject"

// UpdateProjectRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateProject for more information on using the UpdateProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateProjectRequest method.
//    req, resp := client.UpdateProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/UpdateProject
func (c *IoT1ClickProjects) UpdateProjectRequest(input *UpdateProjectInput) (req *request.Request, output *UpdateProjectOutput) {
	op := &request.Operation{
		Name:       opUpdateProject,
		HTTPMethod: "PUT",
		HTTPPath:   "/projects/{projectName}",
	}

	if input == nil {
		input = &UpdateProjectInput{}
	}

	output = &UpdateProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateProject API operation for AWS IoT 1-Click Projects Service.
//
// Updates a project associated with your AWS account and region. With the exception
// of device template names, you can pass just the values that need to be updated
// because the update request will change only the values that are provided.
// To clear a value, pass the empty string (i.e., "").
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Projects Service's
// API operation UpdateProject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/UpdateProject
func (c *IoT1ClickProjects) UpdateProject(input *UpdateProjectInput) (*UpdateProjectOutput, error) {
	req, out := c.UpdateProjectRequest(input)
	return out, req.Send()
}

// UpdateProjectWithContext is the same as UpdateProject with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickProjects) UpdateProjectWithContext(ctx aws.Context, input *UpdateProjectInput, opts ...request.Option) (*UpdateProjectOutput, error) {
	req, out := c.UpdateProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AssociateDeviceWithPlacementInput struct {
	_ struct{} `type:"structure"`

	// The ID of the physical device to be associated with the given placement in
	// the project. Note that a mandatory 4 character prefix is required for all
	// deviceId values.
	//
	// DeviceId is a required field
	DeviceId *string `locationName:"deviceId" min:"1" type:"string" required:"true"`

	// The device template name to associate with the device ID.
	//
	// DeviceTemplateName is a required field
	DeviceTemplateName *string `location:"uri" locationName:"deviceTemplateName" min:"1" type:"string" required:"true"`

	// The name of the placement in which to associate the device.
	//
	// PlacementName is a required field
	PlacementName *string `location:"uri" locationName:"placementName" min:"1" type:"string" required:"true"`

	// The name of the project containing the placement in which to associate the
	// device.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateDeviceWithPlacementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateDeviceWithPlacementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateDeviceWithPlacementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateDeviceWithPlacementInput"}
	if s.DeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceId"))
	}
	if s.DeviceId != nil && len(*s.DeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceId", 1))
	}
	if s.DeviceTemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceTemplateName"))
	}
	if s.DeviceTemplateName != nil && len(*s.DeviceTemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceTemplateName", 1))
	}
	if s.PlacementName == nil {
		invalidParams.Add(request.NewErrParamRequired("PlacementName"))
	}
	if s.PlacementName != nil && len(*s.PlacementName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlacementName", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceId sets the DeviceId field's value.
func (s *AssociateDeviceWithPlacementInput) SetDeviceId(v string) *AssociateDeviceWithPlacementInput {
	s.DeviceId = &v
	return s
}

// SetDeviceTemplateName sets the DeviceTemplateName field's value.
func (s *AssociateDeviceWithPlacementInput) SetDeviceTemplateName(v string) *AssociateDeviceWithPlacementInput {
	s.DeviceTemplateName = &v
	return s
}

// SetPlacementName sets the PlacementName field's value.
func (s *AssociateDeviceWithPlacementInput) SetPlacementName(v string) *AssociateDeviceWithPlacementInput {
	s.PlacementName = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *AssociateDeviceWithPlacementInput) SetProjectName(v string) *AssociateDeviceWithPlacementInput {
	s.ProjectName = &v
	return s
}

type AssociateDeviceWithPlacementOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateDeviceWithPlacementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateDeviceWithPlacementOutput) GoString() string {
	return s.String()
}

type CreatePlacementInput struct {
	_ struct{} `type:"structure"`

	// Optional user-defined key/value pairs providing contextual data (such as
	// location or function) for the placement.
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// The name of the placement to be created.
	//
	// PlacementName is a required field
	PlacementName *string `locationName:"placementName" min:"1" type:"string" required:"true"`

	// The name of the project in which to create the placement.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePlacementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePlacementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePlacementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePlacementInput"}
	if s.PlacementName == nil {
		invalidParams.Add(request.NewErrParamRequired("PlacementName"))
	}
	if s.PlacementName != nil && len(*s.PlacementName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlacementName", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *CreatePlacementInput) SetAttributes(v map[string]*string) *CreatePlacementInput {
	s.Attributes = v
	return s
}

// SetPlacementName sets the PlacementName field's value.
func (s *CreatePlacementInput) SetPlacementName(v string) *CreatePlacementInput {
	s.PlacementName = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreatePlacementInput) SetProjectName(v string) *CreatePlacementInput {
	s.ProjectName = &v
	return s
}

type CreatePlacementOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreatePlacementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePlacementOutput) GoString() string {
	return s.String()
}

type CreateProjectInput struct {
	_ struct{} `type:"structure"`

	// An optional description for the project.
	Description *string `locationName:"description" type:"string"`

	// The schema defining the placement to be created. A placement template defines
	// placement default attributes and device templates. You cannot add or remove
	// device templates after the project has been created. However, you can update
	// callbackOverrides for the device templates using the UpdateProject API.
	PlacementTemplate *PlacementTemplate `locationName:"placementTemplate" type:"structure"`

	// The name of the project to create.
	//
	// ProjectName is a required field
	ProjectName *string `locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProjectInput"}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateProjectInput) SetDescription(v string) *CreateProjectInput {
	s.Description = &v
	return s
}

// SetPlacementTemplate sets the PlacementTemplate field's value.
func (s *CreateProjectInput) SetPlacementTemplate(v *PlacementTemplate) *CreateProjectInput {
	s.PlacementTemplate = v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateProjectInput) SetProjectName(v string) *CreateProjectInput {
	s.ProjectName = &v
	return s
}

type CreateProjectOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProjectOutput) GoString() string {
	return s.String()
}

type DeletePlacementInput struct {
	_ struct{} `type:"structure"`

	// The name of the empty placement to delete.
	//
	// PlacementName is a required field
	PlacementName *string `location:"uri" locationName:"placementName" min:"1" type:"string" required:"true"`

	// The project containing the empty placement to delete.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePlacementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePlacementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePlacementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePlacementInput"}
	if s.PlacementName == nil {
		invalidParams.Add(request.NewErrParamRequired("PlacementName"))
	}
	if s.PlacementName != nil && len(*s.PlacementName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlacementName", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPlacementName sets the PlacementName field's value.
func (s *DeletePlacementInput) SetPlacementName(v string) *DeletePlacementInput {
	s.PlacementName = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *DeletePlacementInput) SetProjectName(v string) *DeletePlacementInput {
	s.ProjectName = &v
	return s
}

type DeletePlacementOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePlacementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePlacementOutput) GoString() string {
	return s.String()
}

type DeleteProjectInput struct {
	_ struct{} `type:"structure"`

	// The name of the empty project to delete.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProjectInput"}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProjectName sets the ProjectName field's value.
func (s *DeleteProjectInput) SetProjectName(v string) *DeleteProjectInput {
	s.ProjectName = &v
	return s
}

type DeleteProjectOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProjectOutput) GoString() string {
	return s.String()
}

type DescribePlacementInput struct {
	_ struct{} `type:"structure"`

	// The name of the placement within a project.
	//
	// PlacementName is a required field
	PlacementName *string `location:"uri" locationName:"placementName" min:"1" type:"string" required:"true"`

	// The project containing the placement to be described.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribePlacementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePlacementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePlacementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePlacementInput"}
	if s.PlacementName == nil {
		invalidParams.Add(request.NewErrParamRequired("PlacementName"))
	}
	if s.PlacementName != nil && len(*s.PlacementName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlacementName", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPlacementName sets the PlacementName field's value.
func (s *DescribePlacementInput) SetPlacementName(v string) *DescribePlacementInput {
	s.PlacementName = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *DescribePlacementInput) SetProjectName(v string) *DescribePlacementInput {
	s.ProjectName = &v
	return s
}

type DescribePlacementOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the placement.
	//
	// Placement is a required field
	Placement *PlacementDescription `locationName:"placement" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribePlacementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePlacementOutput) GoString() string {
	return s.String()
}

// SetPlacement sets the Placement field's value.
func (s *DescribePlacementOutput) SetPlacement(v *PlacementDescription) *DescribePlacementOutput {
	s.Placement = v
	return s
}

type DescribeProjectInput struct {
	_ struct{} `type:"structure"`

	// The name of the project to be described.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeProjectInput"}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProjectName sets the ProjectName field's value.
func (s *DescribeProjectInput) SetProjectName(v string) *DescribeProjectInput {
	s.ProjectName = &v
	return s
}

type DescribeProjectOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the project.
	//
	// Project is a required field
	Project *ProjectDescription `locationName:"project" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProjectOutput) GoString() string {
	return s.String()
}

// SetProject sets the Project field's value.
func (s *DescribeProjectOutput) SetProject(v *ProjectDescription) *DescribeProjectOutput {
	s.Project = v
	return s
}

// An object representing a device for a placement template (see PlacementTemplate).
type DeviceTemplate struct {
	_ struct{} `type:"structure"`

	// An optional Lambda function to invoke instead of the default Lambda function
	// provided by the placement template.
	CallbackOverrides map[string]*string `locationName:"callbackOverrides" type:"map"`

	// The device type, which currently must be "button".
	DeviceType *string `locationName:"deviceType" type:"string"`
}

// String returns the string representation
func (s DeviceTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeviceTemplate) GoString() string {
	return s.String()
}

// SetCallbackOverrides sets the CallbackOverrides field's value.
func (s *DeviceTemplate) SetCallbackOverrides(v map[string]*string) *DeviceTemplate {
	s.CallbackOverrides = v
	return s
}

// SetDeviceType sets the DeviceType field's value.
func (s *DeviceTemplate) SetDeviceType(v string) *DeviceTemplate {
	s.DeviceType = &v
	return s
}

type DisassociateDeviceFromPlacementInput struct {
	_ struct{} `type:"structure"`

	// The device ID that should be removed from the placement.
	//
	// DeviceTemplateName is a required field
	DeviceTemplateName *string `location:"uri" locationName:"deviceTemplateName" min:"1" type:"string" required:"true"`

	// The name of the placement that the device should be removed from.
	//
	// PlacementName is a required field
	PlacementName *string `location:"uri" locationName:"placementName" min:"1" type:"string" required:"true"`

	// The name of the project that contains the placement.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateDeviceFromPlacementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateDeviceFromPlacementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateDeviceFromPlacementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateDeviceFromPlacementInput"}
	if s.DeviceTemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceTemplateName"))
	}
	if s.DeviceTemplateName != nil && len(*s.DeviceTemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceTemplateName", 1))
	}
	if s.PlacementName == nil {
		invalidParams.Add(request.NewErrParamRequired("PlacementName"))
	}
	if s.PlacementName != nil && len(*s.PlacementName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlacementName", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceTemplateName sets the DeviceTemplateName field's value.
func (s *DisassociateDeviceFromPlacementInput) SetDeviceTemplateName(v string) *DisassociateDeviceFromPlacementInput {
	s.DeviceTemplateName = &v
	return s
}

// SetPlacementName sets the PlacementName field's value.
func (s *DisassociateDeviceFromPlacementInput) SetPlacementName(v string) *DisassociateDeviceFromPlacementInput {
	s.PlacementName = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *DisassociateDeviceFromPlacementInput) SetProjectName(v string) *DisassociateDeviceFromPlacementInput {
	s.ProjectName = &v
	return s
}

type DisassociateDeviceFromPlacementOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateDeviceFromPlacementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateDeviceFromPlacementOutput) GoString() string {
	return s.String()
}

type GetDevicesInPlacementInput struct {
	_ struct{} `type:"structure"`

	// The name of the placement to get the devices from.
	//
	// PlacementName is a required field
	PlacementName *string `location:"uri" locationName:"placementName" min:"1" type:"string" required:"true"`

	// The name of the project containing the placement.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDevicesInPlacementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDevicesInPlacementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDevicesInPlacementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDevicesInPlacementInput"}
	if s.PlacementName == nil {
		invalidParams.Add(request.NewErrParamRequired("PlacementName"))
	}
	if s.PlacementName != nil && len(*s.PlacementName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlacementName", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPlacementName sets the PlacementName field's value.
func (s *GetDevicesInPlacementInput) SetPlacementName(v string) *GetDevicesInPlacementInput {
	s.PlacementName = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *GetDevicesInPlacementInput) SetProjectName(v string) *GetDevicesInPlacementInput {
	s.ProjectName = &v
	return s
}

type GetDevicesInPlacementOutput struct {
	_ struct{} `type:"structure"`

	// An object containing the devices (zero or more) within the placement.
	//
	// Devices is a required field
	Devices map[string]*string `locationName:"devices" type:"map" required:"true"`
}

// String returns the string representation
func (s GetDevicesInPlacementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDevicesInPlacementOutput) GoString() string {
	return s.String()
}

// SetDevices sets the Devices field's value.
func (s *GetDevicesInPlacementOutput) SetDevices(v map[string]*string) *GetDevicesInPlacementOutput {
	s.Devices = v
	return s
}

type ListPlacementsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return per request. If not set, a default
	// value of 100 is used.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The project containing the placements to be listed.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPlacementsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPlacementsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPlacementsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPlacementsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPlacementsInput) SetMaxResults(v int64) *ListPlacementsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPlacementsInput) SetNextToken(v string) *ListPlacementsInput {
	s.NextToken = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *ListPlacementsInput) SetProjectName(v string) *ListPlacementsInput {
	s.ProjectName = &v
	return s
}

type ListPlacementsOutput struct {
	_ struct{} `type:"structure"`

	// The token used to retrieve the next set of results - will be effectively
	// empty if there are no further results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// An object listing the requested placements.
	//
	// Placements is a required field
	Placements []*PlacementSummary `locationName:"placements" type:"list" required:"true"`
}

// String returns the string representation
func (s ListPlacementsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPlacementsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPlacementsOutput) SetNextToken(v string) *ListPlacementsOutput {
	s.NextToken = &v
	return s
}

// SetPlacements sets the Placements field's value.
func (s *ListPlacementsOutput) SetPlacements(v []*PlacementSummary) *ListPlacementsOutput {
	s.Placements = v
	return s
}

type ListProjectsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return per request. If not set, a default
	// value of 100 is used.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListProjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProjectsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProjectsInput) SetMaxResults(v int64) *ListProjectsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectsInput) SetNextToken(v string) *ListProjectsInput {
	s.NextToken = &v
	return s
}

type ListProjectsOutput struct {
	_ struct{} `type:"structure"`

	// The token used to retrieve the next set of results - will be effectively
	// empty if there are no further results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// An object containing the list of projects.
	//
	// Projects is a required field
	Projects []*ProjectSummary `locationName:"projects" type:"list" required:"true"`
}

// String returns the string representation
func (s ListProjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProjectsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectsOutput) SetNextToken(v string) *ListProjectsOutput {
	s.NextToken = &v
	return s
}

// SetProjects sets the Projects field's value.
func (s *ListProjectsOutput) SetProjects(v []*ProjectSummary) *ListProjectsOutput {
	s.Projects = v
	return s
}

// An object describing a project's placement.
type PlacementDescription struct {
	_ struct{} `type:"structure"`

	// The user-defined attributes associated with the placement.
	//
	// Attributes is a required field
	Attributes map[string]*string `locationName:"attributes" type:"map" required:"true"`

	// The date when the placement was initially created, in UNIX epoch time format.
	//
	// CreatedDate is a required field
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" required:"true"`

	// The name of the placement.
	//
	// PlacementName is a required field
	PlacementName *string `locationName:"placementName" min:"1" type:"string" required:"true"`

	// The name of the project containing the placement.
	//
	// ProjectName is a required field
	ProjectName *string `locationName:"projectName" min:"1" type:"string" required:"true"`

	// The date when the placement was last updated, in UNIX epoch time format.
	// If the placement was not updated, then createdDate and updatedDate are the
	// same.
	//
	// UpdatedDate is a required field
	UpdatedDate *time.Time `locationName:"updatedDate" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s PlacementDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PlacementDescription) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *PlacementDescription) SetAttributes(v map[string]*string) *PlacementDescription {
	s.Attributes = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *PlacementDescription) SetCreatedDate(v time.Time) *PlacementDescription {
	s.CreatedDate = &v
	return s
}

// SetPlacementName sets the PlacementName field's value.
func (s *PlacementDescription) SetPlacementName(v string) *PlacementDescription {
	s.PlacementName = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *PlacementDescription) SetProjectName(v string) *PlacementDescription {
	s.ProjectName = &v
	return s
}

// SetUpdatedDate sets the UpdatedDate field's value.
func (s *PlacementDescription) SetUpdatedDate(v time.Time) *PlacementDescription {
	s.UpdatedDate = &v
	return s
}

// An object providing summary information for a particular placement.
type PlacementSummary struct {
	_ struct{} `type:"structure"`

	// The date when the placement was originally created, in UNIX epoch time format.
	//
	// CreatedDate is a required field
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" required:"true"`

	// The name of the placement being summarized.
	//
	// PlacementName is a required field
	PlacementName *string `locationName:"placementName" min:"1" type:"string" required:"true"`

	// The name of the project containing the placement.
	//
	// ProjectName is a required field
	ProjectName *string `locationName:"projectName" min:"1" type:"string" required:"true"`

	// The date when the placement was last updated, in UNIX epoch time format.
	// If the placement was not updated, then createdDate and updatedDate are the
	// same.
	//
	// UpdatedDate is a required field
	UpdatedDate *time.Time `locationName:"updatedDate" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s PlacementSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PlacementSummary) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *PlacementSummary) SetCreatedDate(v time.Time) *PlacementSummary {
	s.CreatedDate = &v
	return s
}

// SetPlacementName sets the PlacementName field's value.
func (s *PlacementSummary) SetPlacementName(v string) *PlacementSummary {
	s.PlacementName = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *PlacementSummary) SetProjectName(v string) *PlacementSummary {
	s.ProjectName = &v
	return s
}

// SetUpdatedDate sets the UpdatedDate field's value.
func (s *PlacementSummary) SetUpdatedDate(v time.Time) *PlacementSummary {
	s.UpdatedDate = &v
	return s
}

// An object defining the template for a placement.
type PlacementTemplate struct {
	_ struct{} `type:"structure"`

	// The default attributes (key/value pairs) to be applied to all placements
	// using this template.
	DefaultAttributes map[string]*string `locationName:"defaultAttributes" type:"map"`

	// An object specifying the DeviceTemplate for all placements using this (PlacementTemplate)
	// template.
	DeviceTemplates map[string]*DeviceTemplate `locationName:"deviceTemplates" type:"map"`
}

// String returns the string representation
func (s PlacementTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PlacementTemplate) GoString() string {
	return s.String()
}

// SetDefaultAttributes sets the DefaultAttributes field's value.
func (s *PlacementTemplate) SetDefaultAttributes(v map[string]*string) *PlacementTemplate {
	s.DefaultAttributes = v
	return s
}

// SetDeviceTemplates sets the DeviceTemplates field's value.
func (s *PlacementTemplate) SetDeviceTemplates(v map[string]*DeviceTemplate) *PlacementTemplate {
	s.DeviceTemplates = v
	return s
}

// An object providing detailed information for a particular project associated
// with an AWS account and region.
type ProjectDescription struct {
	_ struct{} `type:"structure"`

	// The date when the project was originally created, in UNIX epoch time format.
	//
	// CreatedDate is a required field
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" required:"true"`

	// The description of the project.
	Description *string `locationName:"description" type:"string"`

	// An object describing the project's placement specifications.
	PlacementTemplate *PlacementTemplate `locationName:"placementTemplate" type:"structure"`

	// The name of the project for which to obtain information from.
	//
	// ProjectName is a required field
	ProjectName *string `locationName:"projectName" min:"1" type:"string" required:"true"`

	// The date when the project was last updated, in UNIX epoch time format. If
	// the project was not updated, then createdDate and updatedDate are the same.
	//
	// UpdatedDate is a required field
	UpdatedDate *time.Time `locationName:"updatedDate" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s ProjectDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProjectDescription) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *ProjectDescription) SetCreatedDate(v time.Time) *ProjectDescription {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ProjectDescription) SetDescription(v string) *ProjectDescription {
	s.Description = &v
	return s
}

// SetPlacementTemplate sets the PlacementTemplate field's value.
func (s *ProjectDescription) SetPlacementTemplate(v *PlacementTemplate) *ProjectDescription {
	s.PlacementTemplate = v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *ProjectDescription) SetProjectName(v string) *ProjectDescription {
	s.ProjectName = &v
	return s
}

// SetUpdatedDate sets the UpdatedDate field's value.
func (s *ProjectDescription) SetUpdatedDate(v time.Time) *ProjectDescription {
	s.UpdatedDate = &v
	return s
}

// An object providing summary information for a particular project for an associated
// AWS account and region.
type ProjectSummary struct {
	_ struct{} `type:"structure"`

	// The date when the project was originally created, in UNIX epoch time format.
	//
	// CreatedDate is a required field
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" required:"true"`

	// The name of the project being summarized.
	//
	// ProjectName is a required field
	ProjectName *string `locationName:"projectName" min:"1" type:"string" required:"true"`

	// The date when the project was last updated, in UNIX epoch time format. If
	// the project was not updated, then createdDate and updatedDate are the same.
	//
	// UpdatedDate is a required field
	UpdatedDate *time.Time `locationName:"updatedDate" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s ProjectSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProjectSummary) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *ProjectSummary) SetCreatedDate(v time.Time) *ProjectSummary {
	s.CreatedDate = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *ProjectSummary) SetProjectName(v string) *ProjectSummary {
	s.ProjectName = &v
	return s
}

// SetUpdatedDate sets the UpdatedDate field's value.
func (s *ProjectSummary) SetUpdatedDate(v time.Time) *ProjectSummary {
	s.UpdatedDate = &v
	return s
}

type UpdatePlacementInput struct {
	_ struct{} `type:"structure"`

	// The user-defined object of attributes used to update the placement. The maximum
	// number of key/value pairs is 50.
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// The name of the placement to update.
	//
	// PlacementName is a required field
	PlacementName *string `location:"uri" locationName:"placementName" min:"1" type:"string" required:"true"`

	// The name of the project containing the placement to be updated.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdatePlacementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePlacementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePlacementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePlacementInput"}
	if s.PlacementName == nil {
		invalidParams.Add(request.NewErrParamRequired("PlacementName"))
	}
	if s.PlacementName != nil && len(*s.PlacementName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlacementName", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *UpdatePlacementInput) SetAttributes(v map[string]*string) *UpdatePlacementInput {
	s.Attributes = v
	return s
}

// SetPlacementName sets the PlacementName field's value.
func (s *UpdatePlacementInput) SetPlacementName(v string) *UpdatePlacementInput {
	s.PlacementName = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *UpdatePlacementInput) SetProjectName(v string) *UpdatePlacementInput {
	s.ProjectName = &v
	return s
}

type UpdatePlacementOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdatePlacementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePlacementOutput) GoString() string {
	return s.String()
}

type UpdateProjectInput struct {
	_ struct{} `type:"structure"`

	// An optional user-defined description for the project.
	Description *string `locationName:"description" type:"string"`

	// An object defining the project update. Once a project has been created, you
	// cannot add device template names to the project. However, for a given placementTemplate,
	// you can update the associated callbackOverrides for the device definition
	// using this API.
	PlacementTemplate *PlacementTemplate `locationName:"placementTemplate" type:"structure"`

	// The name of the project to be updated.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProjectInput"}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateProjectInput) SetDescription(v string) *UpdateProjectInput {
	s.Description = &v
	return s
}

// SetPlacementTemplate sets the PlacementTemplate field's value.
func (s *UpdateProjectInput) SetPlacementTemplate(v *PlacementTemplate) *UpdateProjectInput {
	s.PlacementTemplate = v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *UpdateProjectInput) SetProjectName(v string) *UpdateProjectInput {
	s.ProjectName = &v
	return s
}

type UpdateProjectOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateProjectOutput) GoString() string {
	return s.String()
}
