// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesisvideo

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListSignalingChannelsInput struct {
	_ struct{} `type:"structure"`

	// Optional: Returns only the channels that satisfy a specific condition.
	ChannelNameCondition *ChannelNameCondition `type:"structure"`

	// The maximum number of channels to return in the response. The default is
	// 500.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you specify this parameter, when the result of a ListSignalingChannels
	// operation is truncated, the call returns the NextToken in the response. To
	// get another batch of channels, provide this token in your next request.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListSignalingChannelsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSignalingChannelsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListSignalingChannelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ChannelNameCondition != nil {
		if err := s.ChannelNameCondition.Validate(); err != nil {
			invalidParams.AddNested("ChannelNameCondition", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListSignalingChannelsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ChannelNameCondition != nil {
		v := s.ChannelNameCondition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ChannelNameCondition", v, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListSignalingChannelsOutput struct {
	_ struct{} `type:"structure"`

	// An array of ChannelInfo objects.
	ChannelInfoList []ChannelInfo `type:"list"`

	// If the response is truncated, the call returns this element with a token.
	// To get the next batch of streams, use this token in your next request.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListSignalingChannelsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListSignalingChannelsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ChannelInfoList != nil {
		v := s.ChannelInfoList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ChannelInfoList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListSignalingChannels = "ListSignalingChannels"

// ListSignalingChannelsRequest returns a request value for making API operation for
// Amazon Kinesis Video Streams.
//
// Returns an array of ChannelInfo objects. Each object describes a signaling
// channel. To retrieve only those channels that satisfy a specific condition,
// you can specify a ChannelNameCondition.
//
//    // Example sending a request using ListSignalingChannelsRequest.
//    req := client.ListSignalingChannelsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisvideo-2017-09-30/ListSignalingChannels
func (c *Client) ListSignalingChannelsRequest(input *ListSignalingChannelsInput) ListSignalingChannelsRequest {
	op := &aws.Operation{
		Name:       opListSignalingChannels,
		HTTPMethod: "POST",
		HTTPPath:   "/listSignalingChannels",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSignalingChannelsInput{}
	}

	req := c.newRequest(op, input, &ListSignalingChannelsOutput{})
	return ListSignalingChannelsRequest{Request: req, Input: input, Copy: c.ListSignalingChannelsRequest}
}

// ListSignalingChannelsRequest is the request type for the
// ListSignalingChannels API operation.
type ListSignalingChannelsRequest struct {
	*aws.Request
	Input *ListSignalingChannelsInput
	Copy  func(*ListSignalingChannelsInput) ListSignalingChannelsRequest
}

// Send marshals and sends the ListSignalingChannels API request.
func (r ListSignalingChannelsRequest) Send(ctx context.Context) (*ListSignalingChannelsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListSignalingChannelsResponse{
		ListSignalingChannelsOutput: r.Request.Data.(*ListSignalingChannelsOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListSignalingChannelsRequestPaginator returns a paginator for ListSignalingChannels.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListSignalingChannelsRequest(input)
//   p := kinesisvideo.NewListSignalingChannelsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListSignalingChannelsPaginator(req ListSignalingChannelsRequest) ListSignalingChannelsPaginator {
	return ListSignalingChannelsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListSignalingChannelsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListSignalingChannelsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListSignalingChannelsPaginator struct {
	aws.Pager
}

func (p *ListSignalingChannelsPaginator) CurrentPage() *ListSignalingChannelsOutput {
	return p.Pager.CurrentPage().(*ListSignalingChannelsOutput)
}

// ListSignalingChannelsResponse is the response type for the
// ListSignalingChannels API operation.
type ListSignalingChannelsResponse struct {
	*ListSignalingChannelsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListSignalingChannels request.
func (r *ListSignalingChannelsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
