// Copyright 2017 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.11.2
// source: google/bigtable/admin/table/v1/bigtable_table_service_messages.proto

package table

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

type CreateTableRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique name of the cluster in which to create the new table.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The name by which the new table should be referred to within the cluster,
	// e.g. "foobar" rather than "<cluster_name>/tables/foobar".
	TableId string `protobuf:"bytes,2,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	// The Table to create. The `name` field of the Table and all of its
	// ColumnFamilies must be left blank, and will be populated in the response.
	Table *Table `protobuf:"bytes,3,opt,name=table,proto3" json:"table,omitempty"`
	// The optional list of row keys that will be used to initially split the
	// table into several tablets (Tablets are similar to HBase regions).
	// Given two split keys, "s1" and "s2", three tablets will be created,
	// spanning the key ranges: [, s1), [s1, s2), [s2, ).
	//
	// Example:
	//  * Row keys := ["a", "apple", "custom", "customer_1", "customer_2",
	//                 "other", "zz"]
	//  * initial_split_keys := ["apple", "customer_1", "customer_2", "other"]
	//  * Key assignment:
	//    - Tablet 1 [, apple)                => {"a"}.
	//    - Tablet 2 [apple, customer_1)      => {"apple", "custom"}.
	//    - Tablet 3 [customer_1, customer_2) => {"customer_1"}.
	//    - Tablet 4 [customer_2, other)      => {"customer_2"}.
	//    - Tablet 5 [other, )                => {"other", "zz"}.
	InitialSplitKeys []string `protobuf:"bytes,4,rep,name=initial_split_keys,json=initialSplitKeys,proto3" json:"initial_split_keys,omitempty"`
}

func (x *CreateTableRequest) Reset() {
	*x = CreateTableRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTableRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTableRequest) ProtoMessage() {}

func (x *CreateTableRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTableRequest.ProtoReflect.Descriptor instead.
func (*CreateTableRequest) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_rawDescGZIP(), []int{0}
}

func (x *CreateTableRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateTableRequest) GetTableId() string {
	if x != nil {
		return x.TableId
	}
	return ""
}

func (x *CreateTableRequest) GetTable() *Table {
	if x != nil {
		return x.Table
	}
	return nil
}

func (x *CreateTableRequest) GetInitialSplitKeys() []string {
	if x != nil {
		return x.InitialSplitKeys
	}
	return nil
}

type ListTablesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique name of the cluster for which tables should be listed.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ListTablesRequest) Reset() {
	*x = ListTablesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTablesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTablesRequest) ProtoMessage() {}

func (x *ListTablesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTablesRequest.ProtoReflect.Descriptor instead.
func (*ListTablesRequest) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_rawDescGZIP(), []int{1}
}

func (x *ListTablesRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type ListTablesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The tables present in the requested cluster.
	// At present, only the names of the tables are populated.
	Tables []*Table `protobuf:"bytes,1,rep,name=tables,proto3" json:"tables,omitempty"`
}

func (x *ListTablesResponse) Reset() {
	*x = ListTablesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTablesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTablesResponse) ProtoMessage() {}

func (x *ListTablesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTablesResponse.ProtoReflect.Descriptor instead.
func (*ListTablesResponse) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_rawDescGZIP(), []int{2}
}

func (x *ListTablesResponse) GetTables() []*Table {
	if x != nil {
		return x.Tables
	}
	return nil
}

type GetTableRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique name of the requested table.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTableRequest) Reset() {
	*x = GetTableRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTableRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTableRequest) ProtoMessage() {}

func (x *GetTableRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTableRequest.ProtoReflect.Descriptor instead.
func (*GetTableRequest) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_rawDescGZIP(), []int{3}
}

func (x *GetTableRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type DeleteTableRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique name of the table to be deleted.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteTableRequest) Reset() {
	*x = DeleteTableRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteTableRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTableRequest) ProtoMessage() {}

func (x *DeleteTableRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTableRequest.ProtoReflect.Descriptor instead.
func (*DeleteTableRequest) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_rawDescGZIP(), []int{4}
}

func (x *DeleteTableRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type RenameTableRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The current unique name of the table.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The new name by which the table should be referred to within its containing
	// cluster, e.g. "foobar" rather than "<cluster_name>/tables/foobar".
	NewId string `protobuf:"bytes,2,opt,name=new_id,json=newId,proto3" json:"new_id,omitempty"`
}

func (x *RenameTableRequest) Reset() {
	*x = RenameTableRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RenameTableRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenameTableRequest) ProtoMessage() {}

func (x *RenameTableRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RenameTableRequest.ProtoReflect.Descriptor instead.
func (*RenameTableRequest) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_rawDescGZIP(), []int{5}
}

func (x *RenameTableRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RenameTableRequest) GetNewId() string {
	if x != nil {
		return x.NewId
	}
	return ""
}

type CreateColumnFamilyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique name of the table in which to create the new column family.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The name by which the new column family should be referred to within the
	// table, e.g. "foobar" rather than "<table_name>/columnFamilies/foobar".
	ColumnFamilyId string `protobuf:"bytes,2,opt,name=column_family_id,json=columnFamilyId,proto3" json:"column_family_id,omitempty"`
	// The column family to create. The `name` field must be left blank.
	ColumnFamily *ColumnFamily `protobuf:"bytes,3,opt,name=column_family,json=columnFamily,proto3" json:"column_family,omitempty"`
}

func (x *CreateColumnFamilyRequest) Reset() {
	*x = CreateColumnFamilyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateColumnFamilyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateColumnFamilyRequest) ProtoMessage() {}

func (x *CreateColumnFamilyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateColumnFamilyRequest.ProtoReflect.Descriptor instead.
func (*CreateColumnFamilyRequest) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_rawDescGZIP(), []int{6}
}

func (x *CreateColumnFamilyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateColumnFamilyRequest) GetColumnFamilyId() string {
	if x != nil {
		return x.ColumnFamilyId
	}
	return ""
}

func (x *CreateColumnFamilyRequest) GetColumnFamily() *ColumnFamily {
	if x != nil {
		return x.ColumnFamily
	}
	return nil
}

type DeleteColumnFamilyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique name of the column family to be deleted.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteColumnFamilyRequest) Reset() {
	*x = DeleteColumnFamilyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteColumnFamilyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteColumnFamilyRequest) ProtoMessage() {}

func (x *DeleteColumnFamilyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteColumnFamilyRequest.ProtoReflect.Descriptor instead.
func (*DeleteColumnFamilyRequest) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteColumnFamilyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type BulkDeleteRowsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique name of the table on which to perform the bulk delete
	TableName string `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	// Types that are assignable to Target:
	//	*BulkDeleteRowsRequest_RowKeyPrefix
	//	*BulkDeleteRowsRequest_DeleteAllDataFromTable
	Target isBulkDeleteRowsRequest_Target `protobuf_oneof:"target"`
}

func (x *BulkDeleteRowsRequest) Reset() {
	*x = BulkDeleteRowsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BulkDeleteRowsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkDeleteRowsRequest) ProtoMessage() {}

func (x *BulkDeleteRowsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkDeleteRowsRequest.ProtoReflect.Descriptor instead.
func (*BulkDeleteRowsRequest) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_rawDescGZIP(), []int{8}
}

func (x *BulkDeleteRowsRequest) GetTableName() string {
	if x != nil {
		return x.TableName
	}
	return ""
}

func (m *BulkDeleteRowsRequest) GetTarget() isBulkDeleteRowsRequest_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (x *BulkDeleteRowsRequest) GetRowKeyPrefix() []byte {
	if x, ok := x.GetTarget().(*BulkDeleteRowsRequest_RowKeyPrefix); ok {
		return x.RowKeyPrefix
	}
	return nil
}

func (x *BulkDeleteRowsRequest) GetDeleteAllDataFromTable() bool {
	if x, ok := x.GetTarget().(*BulkDeleteRowsRequest_DeleteAllDataFromTable); ok {
		return x.DeleteAllDataFromTable
	}
	return false
}

type isBulkDeleteRowsRequest_Target interface {
	isBulkDeleteRowsRequest_Target()
}

type BulkDeleteRowsRequest_RowKeyPrefix struct {
	// Delete all rows that start with this row key prefix. Prefix cannot be
	// zero length.
	RowKeyPrefix []byte `protobuf:"bytes,2,opt,name=row_key_prefix,json=rowKeyPrefix,proto3,oneof"`
}

type BulkDeleteRowsRequest_DeleteAllDataFromTable struct {
	// Delete all rows in the table. Setting this to false is a no-op.
	DeleteAllDataFromTable bool `protobuf:"varint,3,opt,name=delete_all_data_from_table,json=deleteAllDataFromTable,proto3,oneof"`
}

func (*BulkDeleteRowsRequest_RowKeyPrefix) isBulkDeleteRowsRequest_Target() {}

func (*BulkDeleteRowsRequest_DeleteAllDataFromTable) isBulkDeleteRowsRequest_Target() {}

var File_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto protoreflect.FileDescriptor

var file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_rawDesc = []byte{
	0x0a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2f, 0x76, 0x31,
	0x2f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62,
	0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x62,
	0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xae, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x3b, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62,
	0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x05, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x73,
	0x70, 0x6c, 0x69, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x10, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x4b, 0x65, 0x79,
	0x73, 0x22, 0x27, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x53, 0x0a, 0x12, 0x4c, 0x69,
	0x73, 0x74, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x3d, 0x0a, 0x06, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x06, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x22,
	0x25, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x28, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x3f, 0x0a, 0x12, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a, 0x06, 0x6e, 0x65,
	0x77, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6e, 0x65, 0x77, 0x49,
	0x64, 0x22, 0xac, 0x01, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6c, 0x75,
	0x6d, 0x6e, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x66, 0x61,
	0x6d, 0x69, 0x6c, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x49, 0x64, 0x12, 0x51, 0x0a,
	0x0d, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69,
	0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x46, 0x61, 0x6d, 0x69,
	0x6c, 0x79, 0x52, 0x0c, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79,
	0x22, 0x2f, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
	0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xa6, 0x01, 0x0a, 0x15, 0x42, 0x75, 0x6c, 0x6b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x52, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0e, 0x72, 0x6f,
	0x77, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0c, 0x48, 0x00, 0x52, 0x0c, 0x72, 0x6f, 0x77, 0x4b, 0x65, 0x79, 0x50, 0x72, 0x65, 0x66,
	0x69, 0x78, 0x12, 0x3c, 0x0a, 0x1a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x61, 0x6c, 0x6c,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x16, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x41, 0x6c, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x46, 0x72, 0x6f, 0x6d, 0x54, 0x61, 0x62, 0x6c, 0x65,
	0x42, 0x08, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x42, 0x8e, 0x01, 0x0a, 0x22, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76,
	0x31, 0x42, 0x21, 0x42, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x62, 0x69,
	0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x2f, 0x76, 0x31, 0x3b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_rawDescOnce sync.Once
	file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_rawDescData = file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_rawDesc
)

func file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_rawDescGZIP() []byte {
	file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_rawDescOnce.Do(func() {
		file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_rawDescData)
	})
	return file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_rawDescData
}

var file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_goTypes = []interface{}{
	(*CreateTableRequest)(nil),        // 0: google.bigtable.admin.table.v1.CreateTableRequest
	(*ListTablesRequest)(nil),         // 1: google.bigtable.admin.table.v1.ListTablesRequest
	(*ListTablesResponse)(nil),        // 2: google.bigtable.admin.table.v1.ListTablesResponse
	(*GetTableRequest)(nil),           // 3: google.bigtable.admin.table.v1.GetTableRequest
	(*DeleteTableRequest)(nil),        // 4: google.bigtable.admin.table.v1.DeleteTableRequest
	(*RenameTableRequest)(nil),        // 5: google.bigtable.admin.table.v1.RenameTableRequest
	(*CreateColumnFamilyRequest)(nil), // 6: google.bigtable.admin.table.v1.CreateColumnFamilyRequest
	(*DeleteColumnFamilyRequest)(nil), // 7: google.bigtable.admin.table.v1.DeleteColumnFamilyRequest
	(*BulkDeleteRowsRequest)(nil),     // 8: google.bigtable.admin.table.v1.BulkDeleteRowsRequest
	(*Table)(nil),                     // 9: google.bigtable.admin.table.v1.Table
	(*ColumnFamily)(nil),              // 10: google.bigtable.admin.table.v1.ColumnFamily
}
var file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_depIdxs = []int32{
	9,  // 0: google.bigtable.admin.table.v1.CreateTableRequest.table:type_name -> google.bigtable.admin.table.v1.Table
	9,  // 1: google.bigtable.admin.table.v1.ListTablesResponse.tables:type_name -> google.bigtable.admin.table.v1.Table
	10, // 2: google.bigtable.admin.table.v1.CreateColumnFamilyRequest.column_family:type_name -> google.bigtable.admin.table.v1.ColumnFamily
	3,  // [3:3] is the sub-list for method output_type
	3,  // [3:3] is the sub-list for method input_type
	3,  // [3:3] is the sub-list for extension type_name
	3,  // [3:3] is the sub-list for extension extendee
	0,  // [0:3] is the sub-list for field type_name
}

func init() { file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_init() }
func file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_init() {
	if File_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto != nil {
		return
	}
	file_google_bigtable_admin_table_v1_bigtable_table_data_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTableRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTablesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTablesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTableRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteTableRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RenameTableRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateColumnFamilyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteColumnFamilyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BulkDeleteRowsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*BulkDeleteRowsRequest_RowKeyPrefix)(nil),
		(*BulkDeleteRowsRequest_DeleteAllDataFromTable)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_goTypes,
		DependencyIndexes: file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_depIdxs,
		MessageInfos:      file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_msgTypes,
	}.Build()
	File_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto = out.File
	file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_rawDesc = nil
	file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_goTypes = nil
	file_google_bigtable_admin_table_v1_bigtable_table_service_messages_proto_depIdxs = nil
}
