/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2017. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
'use strict'

var request = require('request'),
    cookieUtil = require('./cookie-util'),
    log4js = require('log4js'),
    logger = log4js.getLogger('pdp-client')

exports.pdp_check = (req, token, cb) => {
  var reqBody = {
    'access_token': token
  }
  var path = req.originalUrl || req.path;
  var uri = req.method + ' ' + path
  logger.debug('body:'+uri)
  var reqBody = {
    'action': uri,
    'subject': {
      'id': '',
      'type': ''
    },
    'resource': {
      'crn': '',
      'attributes': {
        'serviceName': '',
        'accountId': ''
      }
    }
  }
  var Url;	
  if (process.env.NODE_ENV === 'development') {
    Url = process.env.IAM_PDP_URL;	  
  } else {
    Url = 'https://iam-pdp:7998/v1/authz';	  
  }	  
  var options = {
    method: 'POST',
    url: Url,
    rejectUnauthorized: false,
    headers: {'Authorization': 'Bearer '+token},
    json: reqBody
  }
  request(options, (err, res, body) => {
    if (err) {
      return cb(err, null)
    }
    cb(null, body || {})
  })
}
