/** *****************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 ****************************************************************************** */
/* Copyright (c) 2020 Red Hat, Inc. */
const HOURS = 1000 * 60 * 60;
const DAYS = HOURS * 24;

const getDemoData = () => {
  const clusters = [
    {
      c: 'AWS', e: 'Prod', r: 'US', v: 'RHOL', s: 'ok', cu: '12', uu: '9299m', n: '6', cm: '24029Mi', um: '7029Mi', ct: '80Gi', ut: '60Gi', p: '89', i: '9.42.77.237',
    },
    {
      c: 'AWS', e: 'Test', r: 'AP', v: 'IKE', s: 'ok', cu: '8', uu: '5299m', n: '2', cm: '24029Mi', um: '19029Mi', ct: '180Gi', ut: '100Gi', p: '189', i: '9.43.81.37',
    },
    {
      c: 'AWS', e: 'Dev', r: 'AP', v: 'ICP', s: 'ok', cu: '22', uu: '17299m', n: '14', cm: '84029Mi', um: '5029Mi', ct: '100Gi', ut: '100Gi', p: '59', i: '9.42.51.137',
    },
    {
      c: 'Azure', e: 'Prod', r: 'US', v: 'AKS', s: 'offline', cu: '8', uu: '7299m', n: '9', cm: '34029Mi', um: '17029Mi', ct: '60Gi', ut: '20Gi', p: '39', i: '9.42.1.137',
    },
    {
      c: 'Azure', e: 'Dev', r: 'AP', v: 'RKE', s: 'ok', cu: '32', uu: '27299m', n: '2', cm: '24029Mi', um: '12029Mi', ct: '80Gi', ut: '60Gi', p: '149', i: '9.4.81.13',
    },
    {
      c: 'Google', e: 'Prod', r: 'AP', v: 'ICP', s: 'ok', cu: '12', uu: '7299m', n: '3', cm: '24029Mi', um: '9029Mi', ct: '100Gi', ut: '80Gi', p: '289', i: '9.42.81.122',
    },
    {
      c: 'IBM', e: 'Prod', r: 'US', v: 'ICP', s: 'ok', cu: '8', uu: '3299m', n: '2', cm: '24029Mi', um: '6029Mi', ct: '80Gi', ut: '80Gi', p: '139', i: '9.55.81.136',
    },
    {
      c: 'IBM', e: 'Test', r: 'AP', v: 'ICP', s: 'ok', cu: '24', uu: '16299m', n: '1', cm: '14029Mi', um: '17029Mi', ct: '120Gi', ut: '100Gi', p: '179', i: '9.47.81.33',
    },
    {
      c: 'IBM', e: 'Dev', r: 'AP', v: 'ICP', s: 'ok', cu: '12', uu: '7299m', n: '4', cm: '24029Mi', um: '17029Mi', ct: '60Gi', ut: '40Gi', p: '199', i: '9.88.81.97',
    },
    {
      c: 'IBM', e: 'Prod', r: 'US', v: 'IKE', s: 'ok', cu: '8', uu: '2299m', n: '2', cm: '24029Mi', um: '17029Mi', ct: '20Gi', ut: '10Gi', p: '39', i: '9.34.81.7',
    },
    {
      c: 'Burroughs', e: 'Prod', r: 'AP', v: 'ICP', s: 'ok', cu: '12', uu: '7299m', n: '8', cm: '24029Mi', um: '17029Mi', ct: '280Gi', ut: '10Gi', p: '189', i: '9.9.81.66',
    },
  ].map(({
    c, e, r, v, s, cu, uu, n, cm, um, ct, ut, p, i,
  }, idx) => {
    const name = `cluster-${idx}`;
    const now = new Date().getTime();
    const creationTimestamp = new Date(now - ((idx === 2 ? HOURS : DAYS) * 7));

    // return clusters
    return {
      metadata: {
        name,
        namespace: name,
        creationTimestamp,
        labels: {
          cloud: c,
          environment: e,
          name,
          region: r,
          vendor: v,
        },
      },
      clusterip: i,
      status: s,
      capacity: {
        cpu: cu,
        memory: cm,
        nodes: n,
        storage: ct,
      },
      usage: {
        cpu: uu,
        memory: um,
        pods: p,
        storage: ut,
      },
    };
  });
  return {
    clusters,
  };
};

export default getDemoData;
