/// <reference types="zen-observable" />
import { DocumentNode } from 'graphql';
import { ApolloLink, FetchResult } from '../link/core';
import { ApolloCache } from '../cache';
import { Observable, Concast } from '../utilities';
import { MutationStore } from './MutationStore';
import { QueryOptions, WatchQueryOptions, SubscriptionOptions, MutationOptions } from './watchQueryOptions';
import { ObservableQuery } from './ObservableQuery';
import { NetworkStatus } from './networkStatus';
import { ApolloQueryResult, OperationVariables } from './types';
import { LocalState } from './LocalState';
import { QueryInfo } from './QueryInfo';
export declare class QueryManager<TStore> {
    cache: ApolloCache<TStore>;
    link: ApolloLink;
    mutationStore: MutationStore;
    readonly assumeImmutableResults: boolean;
    readonly ssrMode: boolean;
    private queryDeduplication;
    private clientAwareness;
    private localState;
    private onBroadcast;
    private queries;
    private fetchCancelFns;
    constructor({ cache, link, queryDeduplication, onBroadcast, ssrMode, clientAwareness, localState, assumeImmutableResults, }: {
        cache: ApolloCache<TStore>;
        link: ApolloLink;
        queryDeduplication?: boolean;
        onBroadcast?: () => void;
        ssrMode?: boolean;
        clientAwareness?: Record<string, string>;
        localState?: LocalState<TStore>;
        assumeImmutableResults?: boolean;
    });
    stop(): void;
    private cancelPendingFetches;
    mutate<T>({ mutation, variables, optimisticResponse, updateQueries: updateQueriesByName, refetchQueries, awaitRefetchQueries, update: updateWithProxyFn, errorPolicy, fetchPolicy, context, }: MutationOptions): Promise<FetchResult<T>>;
    fetchQuery<TData, TVars>(queryId: string, options: WatchQueryOptions<TVars>, networkStatus?: NetworkStatus): Promise<ApolloQueryResult<TData>>;
    getQueryStore(): Record<string, Pick<QueryInfo, "variables" | "graphQLErrors" | "networkError" | "networkStatus">>;
    resetErrors(queryId: string): void;
    private transformCache;
    transform(document: DocumentNode): Readonly<{
        document: Readonly<DocumentNode>;
        hasClientExports: boolean;
        hasForcedResolvers: boolean;
        clientQuery: Readonly<DocumentNode> | null;
        serverQuery: Readonly<DocumentNode> | null;
        defaultVars: Readonly<Record<string, any>>;
    }>;
    private getVariables;
    watchQuery<T, TVariables = OperationVariables>(options: WatchQueryOptions<TVariables>): ObservableQuery<T, TVariables>;
    query<TData, TVars = OperationVariables>(options: QueryOptions<TVars>): Promise<ApolloQueryResult<TData>>;
    private queryIdCounter;
    generateQueryId(): string;
    private requestIdCounter;
    generateRequestId(): number;
    private mutationIdCounter;
    generateMutationId(): string;
    stopQueryInStore(queryId: string): void;
    private stopQueryInStoreNoBroadcast;
    clearStore(): Promise<void>;
    resetStore(): Promise<ApolloQueryResult<any>[]>;
    reFetchObservableQueries(includeStandby?: boolean): Promise<ApolloQueryResult<any>[]>;
    setObservableQuery(observableQuery: ObservableQuery<any, any>): void;
    startGraphQLSubscription<T = any>({ query, fetchPolicy, variables, context, }: SubscriptionOptions): Observable<FetchResult<T>>;
    stopQuery(queryId: string): void;
    private stopQueryNoBroadcast;
    removeQuery(queryId: string): void;
    broadcastQueries(): void;
    getLocalState(): LocalState<TStore>;
    private inFlightLinkObservables;
    private getObservableFromLink;
    private getResultsFromLink;
    fetchQueryObservable<TData, TVars>(queryId: string, options: WatchQueryOptions<TVars>, networkStatus?: NetworkStatus): Concast<ApolloQueryResult<TData>>;
    private fetchQueryByPolicy;
    private getQuery;
    private prepareContext;
}
//# sourceMappingURL=QueryManager.d.ts.map