/*
 * Copyright 2021 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import PromisePool from '@supercharge/promise-pool';
import { i18n, encodeComponent } from '@kui-shell/core';
const strings = i18n('plugin-core-support');
/**
 * grammy command usage
 */
const usage = {
    command: 'grammy',
    strict: 'grammy',
    example: 'grammy filepath',
    docs: 'Grammy',
    optional: [{ name: '--color', alias: '-c', boolean: true }]
};
function doHistogram(args) {
    return __awaiter(this, void 0, void 0, function* () {
        const { REPL, argvNoOptions } = args;
        const filepath = argvNoOptions[1];
        if (filepath) {
            const histo = {};
            const files = (yield REPL.rexec(`vfs ls -l ${REPL.encodeComponent(filepath)}`)).content;
            const pushToHistogram = (content) => {
                if (content) {
                    content
                        .split('\n')
                        .map(_ => {
                        const line = _.trim();
                        const separator = line.indexOf(' ');
                        if (separator !== -1) {
                            const countPart = line.slice(0, separator);
                            const occurence = line.replace(countPart, '').trim();
                            const count = parseInt(countPart);
                            if (countPart && !isNaN(count) && occurence) {
                                if (histo[occurence]) {
                                    histo[occurence] += count;
                                }
                                else {
                                    histo[occurence] = count;
                                }
                            }
                        }
                    })
                        .filter(_ => _);
                }
            };
            const accumulatorKey = (path, mtimeMs) => `${path}-${mtimeMs}`;
            const fetchFile = (path) => __awaiter(this, void 0, void 0, function* () {
                return (yield REPL.rexec(`vfs fslice ${encodeComponent(path)} 0`)).content;
            });
            const fetchAndCache = (path, mtimeMs) => __awaiter(this, void 0, void 0, function* () {
                const data = yield fetchFile(path);
                if (args.execOptions.watch) {
                    args.execOptions.watch.accumulator[accumulatorKey(path, mtimeMs)] = { data };
                }
                return data;
            });
            const getOrCreate = (path, mtimeMs) => __awaiter(this, void 0, void 0, function* () {
                return args.execOptions.watch && args.execOptions.watch.accumulator[accumulatorKey(path, mtimeMs)]
                    ? args.execOptions.watch.accumulator[accumulatorKey(path, mtimeMs)].data
                    : yield fetchAndCache(path, mtimeMs);
            });
            yield PromisePool.withConcurrency(1024)
                .for(files)
                .process(({ path, stats }) => __awaiter(this, void 0, void 0, function* () {
                pushToHistogram(yield getOrCreate(path, stats.mtimeMs));
            }));
            const body = Object.entries(histo).map(([occurence, count]) => {
                return {
                    rowKey: occurence,
                    name: occurence,
                    attributes: [
                        {
                            key: 'Count',
                            value: count.toString() // FIXME: cell value could be number
                        }
                    ]
                };
            });
            const header = {
                name: 'Name',
                attributes: [{ key: 'Count', value: 'Count' }]
            };
            return {
                body,
                header,
                title: strings('Histogram'),
                defaultPresentation: 'histogram',
                colorBy: args.parsedOptions.color ? 'default' : undefined
            };
        }
        else {
            throw new Error('grammy: file not provided');
        }
    });
}
/**
 * This plugin introduces the /grammy command
 *
 */
export default (commandTree) => __awaiter(void 0, void 0, void 0, function* () {
    commandTree.listen('/grammy', doHistogram, { usage, flags: { boolean: ['color', 'c'] } });
});
//# sourceMappingURL=grammy.js.map