"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _debug = _interopRequireDefault(require("debug"));

var _core = require("@kui-shell/core");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const debug = (0, _debug.default)('plugins/plugin-core-support/watch');

class TableWatcher {
  // eslint-disable-next-line no-useless-constructor
  constructor(args, command, interval, watchState, until) {
    this.args = args;
    this.command = command;
    this.interval = interval;
    this.watchState = watchState;
    this.until = until;
  }

  poll() {
    return __awaiter(this, void 0, void 0, function* () {
      const table = yield this.args.REPL.qexec(this.command, undefined, undefined, {
        watch: {
          iteration: this.watchState.iteration++,
          accumulator: this.watchState.accumulator
        }
      });

      if ((0, _core.isTable)(table)) {
        this.pusher.header(table.header);
        this.pusher.setBody(table.body);
      } else {
        this.abort();
      }
    });
  }

  init(pusher) {
    return __awaiter(this, void 0, void 0, function* () {
      let inProgress = false;
      this.pusher = pusher;
      this.timeout = setInterval(() => __awaiter(this, void 0, void 0, function* () {
        if (inProgress) {
          return;
        }

        inProgress = true;
        yield this.poll();

        if (this.until) {
          try {
            if (yield this.args.REPL.qexec(this.until)) {
              // poll one more time after the until condition is reached
              // to pick up any leftover information that appeared
              // between the last poll and the time the condition was met
              yield this.poll();
              this.abort();
            }
          } catch (err) {
            debug(`watch-until failed exeuting ${this.until}`, err);
          }
        }

        inProgress = false;
      }), this.interval);
    });
  }

  abort() {
    return __awaiter(this, void 0, void 0, function* () {
      clearInterval(this.timeout);
      this.pusher.done();
    });
  }

}

function _default(registrar) {
  registrar.listen('/watch', args => __awaiter(this, void 0, void 0, function* () {
    const until = args.parsedOptions.until;
    const endOfCmd = !until ? args.command.length : args.command.indexOf('--until');
    const cmdline = args.command.slice(args.argvNoOptions[0].length + 1, endOfCmd);
    const watchState = {
      accumulator: {},
      iteration: 1
    };
    const response = yield args.REPL.qexec(cmdline, undefined, undefined, {
      watch: watchState
    });
    const interval = args.parsedOptions.n || args.parsedOptions.interval || 2000;

    if ((0, _core.isTable)(response)) {
      return Object.assign(response, {
        watch: new TableWatcher(args, cmdline, interval, watchState, until)
      });
    } else {
      const poll = () => args.REPL.reexec(args.command, {
        execUUID: args.execOptions.execUUID
      });

      const timeout = setTimeout(() => __awaiter(this, void 0, void 0, function* () {
        yield poll();

        if (until) {
          try {
            if (yield args.REPL.qexec(until)) {
              yield poll();
              clearTimeout(timeout);
            }
          } catch (err) {
            debug(`watch-until failed exeuting ${until}`, err);
          }
        }
      }), interval);
      return {
        response: response,
        abort: () => {
          clearTimeout(timeout);
        }
      };
    }
  }), {
    flags: {
      boolean: ['t', 'no-title']
    }
  });
}