/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
export class Row {
    constructor(row) {
        Object.assign(this, row);
    }
}
export class Cell {
    constructor(cell) {
        Object.assign(this, cell);
    }
}
export var TableStyle;
(function (TableStyle) {
    TableStyle[TableStyle["Light"] = 0] = "Light";
    TableStyle[TableStyle["Medium"] = 1] = "Medium";
    TableStyle[TableStyle["Heavy"] = 2] = "Heavy";
})(TableStyle || (TableStyle = {}));
export class Table {
    constructor(table) {
        Object.assign(this, table);
    }
}
export function isTableWithTimestamp(table) {
    return table.startColumnIdx >= 0 && table.completeColumnIdx >= 0;
}
export function isTableWithCount(table) {
    return (table.body.length >= 1 &&
        table.body.findIndex(row => row.attributes && row.attributes.findIndex(_ => _.key && /^count$/i.test(_.key)) !== -1) !== -1);
}
export function isTable(model) {
    return (model !== undefined &&
        (model instanceof Table || (model.body !== undefined && Array.isArray(model.body))));
}
/** Are the two Rows the same? */
export function sameRow(A, B) {
    if (!A || !B) {
        // if either one or the other is not defined, then they are different
        return false;
    }
    return (A.key === B.key &&
        A.rowKey === B.rowKey &&
        A.name === B.name &&
        A.attributes.length === B.attributes.length &&
        A.attributes.every((a, cidx) => {
            const b = B.attributes[cidx];
            return a.key === b.key && a.value === b.value && a.css === b.css && a.outerCSS === b.outerCSS && a.tag === b.tag;
        }));
}
export class Icon {
    constructor(icon) {
        Object.assign(this, icon);
    }
}
//# sourceMappingURL=table.js.map