declare type FilterFunction = (line: HistoryLine) => boolean;
/** One History entry */
export interface HistoryLine {
    /** The raw command line */
    raw: string;
}
/** A tuple of History entries, one per Tab (as specified by its given uuid) */
export declare class HistoryModel {
    private readonly uuid;
    private _lines;
    private _cursor;
    /** Facilitate copying master history to new Tabs */
    private static masterUUID;
    constructor(uuid: string);
    /** The persistence key for this tab */
    private key;
    /** return the given line of history */
    line(idx: number): HistoryLine;
    slice(start: number, end?: number): HistoryLine[];
    get cursor(): number;
    /** change the cursor, protecting against under- and overflow */
    private guardedChange;
    /** Low-level save to persistent storage */
    private save;
    /** Low-level restore from persistent storage */
    private restore;
    /**
     * Clear out all history
     *
     */
    wipe(): boolean;
    /** add a line of repl history */
    add(line: Pick<HistoryLine, 'raw'>): number;
    /** update a line of repl history -- for async operations */
    update(cursor: number, updateFn: (line: HistoryLine) => void | Promise<void>): Promise<void>;
    lineByIncr(incr: number): HistoryLine;
    /** go back one entry */
    previous(): HistoryLine;
    /** go forward one entry */
    next(): HistoryLine;
    /** return to the oldest entry */
    first(): HistoryLine;
    /** return to the newest entry */
    last(): HistoryLine;
    /**
     * Search the history model
     *
     * @param filter a search string, search regexp, or search function
     * @param startIdx if undefined or negative, start from the end, otherwise,
     * search backwards from the given index
     *
     */
    findIndex(filter: string | RegExp | FilterFunction, startIdx?: number): number;
    /**
     * Search the history model
     *
     * @param filter a search string, search regexp, or search function
     *
     */
    find(filter: FilterFunction): HistoryLine;
}
/** @return the HistoryModel for the given Tab, as identified by `uuid` */
export declare function getHistoryForTab(uuid: string): HistoryModel;
export default HistoryModel;
