/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { cellShouldHaveBadge as shouldHaveBadge } from './CellShould';
export function radioTableHintsAsCss(cell) {
    if (typeof cell !== 'string' && cell.hints) {
        if (Array.isArray(cell.hints)) {
            return cell.hints.map(_ => _.toString()).join(' ');
        }
        else {
            return cell.hints.toString();
        }
    }
}
/** Project the string value of the given `cell` */
export function radioTableCellToString(cell, useTitle = false) {
    return typeof cell === 'string' ? cell : useTitle ? cell.title || cell.value : cell.value;
}
/** Should the cell be rendered with a traffic light badge? */
export function cellShouldHaveBadge(cell) {
    return typeof cell !== 'string' && shouldHaveBadge(cell.hints);
}
/** Add the hint to the given RadioTableCell */
export function radioTableAddHint(row, cidx, newHints) {
    const cell = row.cells[cidx];
    if (typeof cell !== 'string') {
        if (Array.isArray(cell.hints)) {
            cell.hints = cell.hints.concat(newHints);
        }
        else if (!cell.hints) {
            cell.hints = newHints;
        }
        else {
            cell.hints = [cell.hints, ...newHints];
        }
    }
    else {
        row.cells[cidx] = {
            value: cell,
            hints: newHints
        };
    }
}
export function isRadioTable(response) {
    if (typeof response === 'object') {
        const table = response;
        return table.apiVersion === 'kui-shell/v1' && table.kind === 'RadioTable';
    }
    else {
        return false;
    }
}
//# sourceMappingURL=RadioTable.js.map