import { Screen } from 'electron';
import ISubwindowPrefs from '../models/SubwindowPrefs';
declare type BW = {
    getAllWindows: () => any[];
};
/** Open a new Electron window */
export declare function createWindow(noHeadless?: boolean, executeThisArgvPlease?: string[], subwindowPlease?: boolean, subwindowPrefs?: ISubwindowPrefs, secondary?: boolean, isForPopup?: boolean): void;
/**
 * Strip off the command to be executed from the given argv
 *
 */
interface Command {
    argv: string[];
    subwindowPlease: boolean;
    subwindowPrefs: ISubwindowPrefs;
}
export declare const getCommand: (argv: string[], screen: () => Promise<{
    screen: Screen;
    BrowserWindow: BW;
}>) => Command;
/**
 * Spawn electron
 *
 */
export declare function initElectron(command?: string[], { isRunningHeadless }?: {
    isRunningHeadless?: boolean;
}, subwindowPlease?: boolean, subwindowPrefs?: ISubwindowPrefs, isForPopup?: boolean): Promise<void>;
export {};
