/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Capabilities
export { hasProxy, getValidCredentials, inBrowser, inElectron, isHeadless, inSandbox, inProxy, assertInSandbox, assertLocalAccess, assertHasProxy, setHasAuth, getAuthValue } from './core/capabilities';
// Commands
export { default as typeahead } from './commands/typeahead';
export { ExecType } from './models/command';
export { optionsToString as unparse } from './core/utility';
export { isScalarResponse, isMixedResponse, hasSourceReferences, isMetadataBearingByReference as isResourceByReference } from './models/entity';
export { isCommandHandlerWithEvents } from './models/command';
export { withLanguage } from './models/execOptions';
// Errors
export { isCodedError, is404, is409, is404or409 } from './models/errors';
export { isUsageError, UsageError } from './core/usage-error';
// TODO remove these soon; see plugin-client-common/src/components/Scalar/index.ts
export { isMessageWithUsageModel, isMessageWithCode } from './core/usage-error';
// ascii usage
export { default as renderUsage } from './core/usage/render-usage';
import * as pc from './core/usage/pretty-code';
export { pc };
// eventChannelUnsafe
export { default as eventChannelUnsafe, wireToTabEvents, wireToStandardEvents, unwireToTabEvents, unwireToStandardEvents, eventBus } from './core/events';
// i18n
export { fromMap as i18nFromMap, default as i18n } from './util/i18n';
// models
export { hasDisplayName, isAbortableResponse, isMarkdownResponse, isReactResponse, isRandomErrorResponse1, isRandomErrorResponse2, isMetadataBearing as isResourceWithMetadata } from './models/entity';
export { isWatchable } from './core/jobs/watchable';
export { isResizable, isSuspendable } from './core/jobs/job';
// eslint-disable-next-line @typescript-eslint/no-unused-vars
import { getHistoryForTab } from './models/history';
export function History(tab) {
    return getHistoryForTab(typeof tab === 'string' ? tab : tab.uuid);
}
export { HistoryModel } from './models/history';
// pretty printing
export { prettyPrintTime } from './webapp/util/time';
export { default as prettyPrintBytes } from './webapp/util/bytes';
// registrars
export { registerModeWhen, registerSidecarMode as registerMode, apply as addRelevantModes } from './webapp/views/registrar/modes';
export { registerSidecarBadge as registerBadge, registrar as badgeRegistrar } from './webapp/views/registrar/badges';
export { split, _split } from './repl/split';
export { splitIntoPipeStages } from './repl/pipe-stages';
export { DirectReplEval } from './repl/types';
export { default as encodeComponent } from './repl/encode';
export { exec as internalBeCarefulExec, pexec as internalBeCarefulPExec, setEvaluatorImpl, doEval } from './repl/exec';
export { isNotebook } from './repl/events';
// Tabs
export { getTab, getCurrentTab, pexecInCurrentTab, getTabId, getPrimaryTabId, sameTab, splitFor, isTopLevelTab } from './webapp/tab';
export { default as TabState, registerTabState } from './models/tab-state';
export { findByName as findThemeByName } from './webapp/themes/find';
export { getDefault as getDefaultTheme } from './webapp/themes/default';
export { switchTo as switchToTheme, getPersistedThemeChoice, resetToDefault as resetToDefaultTheme } from './webapp/themes/persistence';
export { disableInputQueueing } from './webapp/queueing';
// generic UI
export { isPopup } from './webapp/popup-core';
export { removeAllDomChildren as empty } from './webapp/util/dom';
export { default as Presentation } from './webapp/views/presentation';
export { isCommentaryResponse } from './models/CommentaryResponse';
export { isTabLayoutModificationResponse, isNewSplitRequest } from './models/TabLayoutModificationResponse';
export { isButton, isViewButton } from './models/mmr/types';
export { isNavResponse, isLink, isLinkWithHref, isLinkWithCommand } from './models/NavResponse';
export { isXtermResponse, isXtermErrorResponse } from './models/XtermResponse';
export { isMultiModalResponse } from './models/mmr/is';
export { hasContent, isScalarContent, isReactProvider, isCommandStringContent, isStringWithOptionalContentType, isSupportedContentType, isStringDiffContent, isFunctionContent } from './models/mmr/content-types';
export { isSupportedToolbarTextType } from './webapp/views/toolbar-text';
// low-level UI
export { default as doCancel } from './webapp/cancel';
export { default as ElementMimic } from './util/element-mimic';
export { keys as KeyCodes, isCursorMovement } from './webapp/keys';
// Plugins
export { commandsOffered as commandsOfferedByPlugin, userHome as pluginUserHome } from './api/plugins';
// Settings
export { userDataDir, uiThemes } from './core/settings';
// Storage for user data
export { default as Store } from './models/store';
// SymbolTable
export { default as SymbolTable } from './core/symbol-table';
export { Icon, TableStyle, Table, Row, Cell, sameRow, isTable, isTableWithTimestamp, isTableWithCount } from './webapp/models/table';
export { isRadioTable, radioTableHintsAsCss, radioTableCellToString, radioTableAddHint, cellShouldHaveBadge } from './models/RadioTable';
// Util
export { findFileWithViewer, findFile, isSpecialDirectory } from './core/find-file';
export { expandHomeDir, cwd } from './util/home';
export { flatten } from './core/utility';
export { promiseEach } from './util/async';
export { isHTML, isPromise } from './util/types';
// Electron
export { tellMain } from './webapp/electron-events';
// main
export { main } from './main/main';
export { default as boot, bootIntoSandbox } from './webapp/bootstrap/boot';
// Sessions
export { initializeSession } from './session/init';
// Tab Completion
export { registerEnumerator as registerTabCompletionEnumerator, isStringResponse, applyEnumerator as findCompletions } from './repl/tab-completion';
export { default as teeToFile } from './util/tee';
// Client API
export { isOfflineClient } from './api/client';
export * from './api/window-events';
//# sourceMappingURL=index.js.map