import { CatchAllHandler, Command, CommandTree, CommandTreeResolution, Disambiguator, KResponse, ParsedOptions } from '../models/command';
import { ExecOptions } from '../models/execOptions';
/**
 * The exported interface around the internal command model
 * implementation.
 *
 */
interface CommandModel {
    catchalls: CatchAllHandler<KResponse, ParsedOptions>[];
    /**
     * Look up a command handler for the given `argv`. This is the main
     * Read part of a REPL.
     *
     */
    read<T extends KResponse, O extends ParsedOptions>(argv: string[], execOptions: ExecOptions, tryCatchalls?: boolean): Promise<CommandTreeResolution<T, O>>;
    /**
     * Call the given callback function `fn` for each node in the command tree
     *
     */
    forEachNode(fn: (command: Command<KResponse, ParsedOptions>) => void): void;
}
/**
 * The internal implementation of the command tree
 *
 */
export declare class CommandModelImpl implements CommandModel {
    /** root of the tree model */
    private readonly _root;
    get root(): CommandTree;
    /** map from command name to disambiguations */
    private readonly _disambiguator;
    get disambiguator(): Disambiguator;
    /** handlers for command not found */
    private readonly _catchalls;
    get catchalls(): CatchAllHandler<KResponse, ParsedOptions>[];
    /**
     * Look up a command handler for the given `argv`. This is the main
     * Read part of a REPL.
     *
     */
    read<T extends KResponse, O extends ParsedOptions>(argv: string[], execOptions: ExecOptions, tryCatchalls?: boolean): Promise<CommandTreeResolution<T, O>>;
    /**
     * Call the given callback function `fn` for each node in the command tree
     *
     */
    forEachNode(fn: (command: Command<KResponse, ParsedOptions>) => void): void;
    private newTree;
}
/**
 * @return the command tree model for internal consumption within this
 * file
 *
 */
export declare function getModelInternal(): CommandModelImpl;
/**
 * @return the command tree model for public consumption within the
 * rest of @kui-shell/core. For the model we present to plugins, see
 * `ImplForPlugins` in command-tree.ts
 *
 */
export declare function getModel(): CommandModel;
export declare function init(): void;
export declare function initIfNeeded(): void;
export {};
