"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isMessageBearingEntity = isMessageBearingEntity;
exports.isMetadataBearing = isMetadataBearing;
exports.hasDisplayName = hasDisplayName;
exports.isMetadataBearingByReference = isMetadataBearingByReference;
exports.isMarkdownResponse = isMarkdownResponse;
exports.isReactResponse = isReactResponse;
exports.isMixedResponse = isMixedResponse;
exports.isRawResponse = isRawResponse;
exports.isRandomErrorResponse1 = isRandomErrorResponse1;
exports.isRandomErrorResponse2 = isRandomErrorResponse2;
exports.isScalarResponse = isScalarResponse;
exports.hasSourceReferences = hasSourceReferences;
exports.isAbortableResponse = isAbortableResponse;

var _types = require("../util/types");

var _capabilities = require("../core/capabilities");

var _table = require("../webapp/models/table");

var _is = _interopRequireDefault(require("./mmr/is"));

var _NavResponse = require("./NavResponse");

var _XtermResponse = require("./XtermResponse");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function isMessageBearingEntity(entity) {
  return entity.message !== undefined;
}

function isMetadataBearing(spec) {
  const meta = spec;
  return meta !== undefined && meta.metadata !== undefined && meta.metadata.name !== undefined;
}

function hasDisplayName(resource) {
  const res = resource;
  return isMetadataBearing(resource) && res.spec !== undefined && typeof res.spec.displayName === 'string';
}

function isMetadataBearingByReference(spec) {
  const ref = spec;
  return ref !== undefined && ref.resource !== undefined && isMetadataBearing(ref.resource);
}

function isMarkdownResponse(entity) {
  const md = entity;
  return md && typeof md.content === 'string' && md.contentType === 'text/markdown';
}

function isReactResponse(entity) {
  if ((0, _capabilities.isHeadless)()) {
    return false;
  } else {
    const {
      isValidElement
    } = require('react');

    const response = entity;
    return response && response.react && isValidElement(response.react);
  }
}

function isMixedResponse(response) {
  return Array.isArray(response) && response.length > 0 && (typeof response[0] === 'string' || (0, _table.isTable)(response[0]) || (0, _types.isHTML)(response[0]) || (0, _XtermResponse.isXtermResponse)(response[0]));
}

function isRawResponse(entity) {
  const raw = entity;
  return raw.mode === 'raw' && raw.content !== undefined;
}

function isRandomErrorResponse1(response) {
  return typeof response.code === 'string';
}

function isRandomErrorResponse2(response) {
  const {
    errno
  } = response;
  return typeof errno === 'string' && typeof errno === 'number';
}

function isScalarResponse(response) {
  return !(0, _is.default)(response) && !(0, _NavResponse.isNavResponse)(response);
}

function hasSourceReferences(response) {
  const trait = response;
  return trait && trait.kuiSourceRef !== undefined;
}

function isAbortableResponse(entity) {
  return typeof entity.abort === 'function';
}