"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uiThemes = uiThemes;
Object.defineProperty(exports, "clearPreference", {
  enumerable: true,
  get: function () {
    return _userdata.clearPreference;
  }
});
Object.defineProperty(exports, "getPreference", {
  enumerable: true,
  get: function () {
    return _userdata.getPreference;
  }
});
Object.defineProperty(exports, "setPreference", {
  enumerable: true,
  get: function () {
    return _userdata.setPreference;
  }
});
Object.defineProperty(exports, "userDataDir", {
  enumerable: true,
  get: function () {
    return _userdata.userDataDir;
  }
});

var _userdata = require("./userdata");

/*
 * Copyright 2018 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

function uiThemes() {
  return __awaiter(this, void 0, void 0, function* () {
    // it is ipmortant to delay the loading here. otherwise,
    // plugins/plugins will load command-tree, which will load
    // context.ts, which will establish the context prior to settings --
    // dependence cycle
    const {
      prescanModel
    } = yield Promise.resolve().then(() => require('../plugins/plugins')); // the filter part is there only to be overly defensive

    return prescanModel().themeSets.filter(_ => _);
  });
}