"use strict";
/*
 * Copyright 2021 IBM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
var util_1 = require("../util");
/** Attribution: https://github.com/patternfly/patternfly-org/blob/master/packages/v4/src/content/design-guidelines/styles/colors-for-charts/colors-for-charts.css */
var blue = [
    '#002f5d',
    '#004b95',
    '#06c',
    '#519de9',
    '#8bc1f7'
];
var red = [
    '#2c0000',
    '#470000',
    '#7d1007',
    '#a30000',
    '#c9190b'
];
var purple = [
    '#2a265f',
    '#3c3d99',
    '#5752d1',
    '#8481dd',
    '#b2b0ea'
];
var green = [
    '#23511e',
    '#38812f',
    '#4cb140',
    '#7cc674',
    '#bfe2bb' // hsl(114, 41%, 81%)
];
var gray = [
    '4d5258',
    '#72767b',
    '#8b8d8f',
    '#bbb',
    '#d2d2d2'
];
var cyan = [
    '#003737',
    '#005f60',
    '#009596',
    '#73c5c5',
    '#a2d9d9'
];
var gold = [
    '#c58c00',
    '#f0ab00',
    '#f4c145',
    '#f6d173',
    '#f9e0a2'
];
var orange = [
    '#8f4700',
    '#c46100',
    '#ec7a08',
    '#ef9234',
    '#f4b678'
];
/** Indexed by number of colors */
var colorSet = [
    orange.map(util_1.hsl),
    blue.map(util_1.hsl),
    red.map(util_1.hsl),
    gold.map(util_1.hsl),
    cyan.map(util_1.hsl),
    purple.map(util_1.hsl),
    gray.map(util_1.hsl),
    green.map(util_1.hsl)
];
exports.default = colorSet;
//# sourceMappingURL=patternfly4.js.map