var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import jsYaml from 'js-yaml';
import { doEval, getCurrentTab } from '@kui-shell/core';
import strings from '../../util/i18n';
import HTTPClient from '../../controller/HTTPClient';
import { UPDATE_RESOURCE } from '../../definitions/search-queries';
export function editSpec(cmd, resource, data) {
    return {
        readOnly: false,
        clearable: false,
        save: {
            label: strings('sidecar.yaml.edit.apply'),
            onSave: (updated) => __awaiter(this, void 0, void 0, function* () {
                HTTPClient('post', 'console', UPDATE_RESOURCE(jsYaml.load(updated), data))
                    .then(() => {
                    doEval(getCurrentTab(), undefined, cmd);
                })
                    .catch(err => {
                    console.debug(err);
                });
                return {
                    noToolbarUpdate: true
                };
            })
        },
        revert: {
            label: strings('validation.revert'),
            onRevert: () => jsYaml.dump(resource)
        }
    };
}
export const yamlTab = (resource, data, cmd) => {
    const spec = editSpec(cmd, resource, data.items[0]);
    return {
        mode: 'yaml',
        label: 'YAML',
        order: 2,
        content: jsYaml.dump(resource),
        contentType: 'yaml',
        spec
    };
};
//# sourceMappingURL=yaml.js.map