import strings from '../../util/i18n';
export const deleteSavedSearch = {
    breadcrumb: 'deleteSavedSearch',
    command: 'deleteSavedSearch',
    title: strings('delete.savedsearchhelp.title'),
    header: strings('delete.savedsearchhelp.header'),
    example: 'deleteSavedSearch <saved-search-name>',
    available: [{
            docs: strings('delete.savedsearchhelp.title'),
            dir: true,
            commandSuffix: '-h'
        }],
    related: ['search', 'savedsearches', 'deleteResource'],
};
export const deleteResource = {
    breadcrumb: 'deleteResource',
    command: 'deleteResource',
    title: strings('delete.resourcehelp.title'),
    header: strings('delete.resourcehelp.header'),
    example: 'deleteResource <resource-name> <resource-namespace> <resource-kind> <resource-cluster> <resource-apiVersion>',
    available: [{
            docs: strings('delete.resourcehelp.title'),
            dir: true,
            commandSuffix: '-h'
        }],
    related: ['search', 'savedsearches', 'deleteSavedSearch'],
};
//# sourceMappingURL=deletehelp.js.map