"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logTab = exports.buildLog = void 0;

var _lodash = _interopRequireDefault(require("lodash"));

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _i18n = _interopRequireDefault(require("../../util/i18n"));

var _Logger = _interopRequireDefault(require("../../components/Logger"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const buildLog = data => {
  const node = document.createElement('div');
  node.classList.add('scrollable');
  node.classList.add('bx--structured-list--summary');

  const containers = _lodash.default.get(data, 'container', '').replace(/,/g, '').split(' ');

  const logger = () => {
    return /*#__PURE__*/_react.default.createElement(_Logger.default, {
      data: data,
      items: containers
    });
  };

  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(logger), node);

  return node;
};

exports.buildLog = buildLog;

const logTab = data => {
  return {
    mode: 'logging',
    label: (0, _i18n.default)('search.label.logs'),
    order: 3,
    content: buildLog(data)
  };
};

exports.logTab = logTab;