"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStatusIcon = exports.status = void 0;

var _react = _interopRequireDefault(require("react"));

var _lodash = _interopRequireDefault(require("lodash"));

var _iconsReact = require("@carbon/icons-react");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const status = [{
  type: 'success',
  icon: /*#__PURE__*/_react.default.createElement(_iconsReact.CheckmarkFilled16, {
    className: `status-success`
  }),
  values: ['Running', 'DEPLOYED', 'Active', 'OK', 'Available', 'Ready']
}, {
  type: 'warning',
  icon: /*#__PURE__*/_react.default.createElement(_iconsReact.WarningFilled16, {
    className: `status-warning`
  }),
  values: ['Pending', 'Terminating', 'ContainerCreating']
}, {
  type: 'failed',
  icon: /*#__PURE__*/_react.default.createElement(_iconsReact.ErrorFilled16, {
    className: `status-failed`
  }),
  values: ['Failed', 'CrashLoopBackOff', 'ImagePullBackOff', 'ErrImagePull', 'Error', 'OOMKilled', 'Init:OOMKilled']
}, {
  type: 'completed',
  icon: /*#__PURE__*/_react.default.createElement(_iconsReact.CheckmarkFilled16, {
    className: `status-completed`
  }),
  values: ['Completed', 'Succeeded']
}, {
  type: 'unknown',
  icon: /*#__PURE__*/_react.default.createElement(_iconsReact.Unknown16, {
    className: 'status-unknown'
  }),
  values: ['Unknown']
}];
exports.status = status;

const getStatusIcon = data => {
  const _ = status.filter(stat => stat.values.includes(data));

  return _lodash.default.get(_, '[0].icon', '');
};

exports.getStatusIcon = getStatusIcon;