/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import React from 'react';
import { Spinner } from '@patternfly/react-core';
export default class PatternFlyLoading extends React.PureComponent {
    render() {
        return (React.createElement("div", { className: "flex-layout flex-align-center flex-align-top big-top-pad" },
            React.createElement(Spinner, { size: "lg", className: "fade-in left-pad" }),
            React.createElement("span", { className: this.props.className + ' left-pad' }, this.props.description)));
    }
}
//# sourceMappingURL=PatternFly.js.map