/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import React from 'react';
import { EraserIcon as Clear, CameraIcon as Screenshot, CameraRetroIcon as ScreenshotInProgress, CheckCircleIcon as Checkmark, ChartBarIcon as ChartBar, CopyIcon as Copy, PlusIcon as Add, OutlinedWindowMaximizeIcon /* TerminalIcon */ as TerminalOnly, ColumnsIcon as TerminalPlusSidecar, TimesIcon /* WindowCloseIcon */ as WindowClose, EditIcon as Edit, ExpandIcon as WindowMaximize, CompressIcon as WindowMinimize, QuestionCircleIcon /* ToolsIcon */ as Help, SlidersHIcon as Settings, TrashAltIcon as Trash, LevelUpAltIcon as Up, ArrowUpIcon as MoveUp, ArrowDownIcon as MoveDown, MapMarkerAltIcon as Location, ServerIcon as Server, EyeIcon as Eye, EyeSlashIcon as EyeSlash, AtIcon as At, CodeBranchIcon as CodeBranch, ArrowLeftIcon as Back, ArrowRightIcon as Forward, InfoCircleIcon as Info, ExclamationTriangleIcon as Warning, BombIcon as Oops, ListIcon as List, ThIcon as Grid, PaletteIcon as Theme, GithubIcon as Github, CaretLeftIcon as PreviousPage, CaretRightIcon as NextPage, NetworkWiredIcon as Network, PauseCircleIcon as Pause, RebootingIcon as Retry, HistoryIcon as Revert, SaveIcon as Save, SlidersHIcon as Sequence, SearchIcon as Search, BellIcon as Notification, PlayCircleIcon as Play } from '@patternfly/react-icons';
const size20 = { fontSize: '1rem' };
const size32 = { fontSize: '32px', padding: '3px' };
const Sidecar = { fontSize: '1.125em' };
const StatusStripe = Sidecar;
const Pagination = { fontSize: '1.5em' };
/** helper to ensure exhaustiveness of the switch statement below */
// eslint-disable-next-line @typescript-eslint/no-unused-vars
function assertUnreachable(x) {
    throw new Error('Did not expect to get here');
}
export default function PatternFly4Icons(props) {
    switch (props.icon) {
        case 'At':
            return React.createElement(At, Object.assign({ style: StatusStripe }, props));
        case 'Add':
            return React.createElement(Add, Object.assign({ style: size20 }, props));
        case 'Back':
            return React.createElement(Back, Object.assign({ style: Sidecar }, props));
        case 'ChartBar':
            return React.createElement(ChartBar, Object.assign({}, props));
        case 'Checkmark':
            return React.createElement(Checkmark, Object.assign({}, props));
        case 'CodeBranch':
            return React.createElement(CodeBranch, Object.assign({ style: StatusStripe }, props));
        case 'Copy':
            return React.createElement(Copy, Object.assign({}, props));
        case 'Edit':
            return React.createElement(Edit, Object.assign({}, props));
        case 'Clear':
            return React.createElement(Clear, Object.assign({}, props));
        case 'Error':
            return React.createElement(Oops, Object.assign({}, props));
        case 'Eye':
            return React.createElement(Eye, Object.assign({}, props));
        case 'EyeSlash':
            return React.createElement(EyeSlash, Object.assign({}, props));
        case 'Forward':
            return React.createElement(Forward, Object.assign({ style: Sidecar }, props));
        case 'Grid':
            return React.createElement(Grid, Object.assign({}, props));
        case 'Github':
            return React.createElement(Github, Object.assign({}, props));
        case 'Help':
            return React.createElement(Help, Object.assign({ style: size20 }, props));
        case 'Info':
            return React.createElement(Info, Object.assign({}, props));
        case 'List':
            return React.createElement(List, Object.assign({}, props));
        case 'Location':
            return React.createElement(Location, Object.assign({}, props));
        case 'MoveUp':
            return React.createElement(MoveUp, Object.assign({}, props));
        case 'MoveDown':
            return React.createElement(MoveDown, Object.assign({}, props));
        case 'Pause':
            return React.createElement(Pause, Object.assign({}, props));
        case 'Play':
            return React.createElement(Play, Object.assign({}, props));
        case 'PreviousPage':
            return React.createElement(PreviousPage, Object.assign({ style: Pagination }, props));
        case 'Retry':
            return React.createElement(Retry, Object.assign({}, props));
        case 'Revert':
            return React.createElement(Revert, Object.assign({}, props));
        case 'Save':
            return React.createElement(Save, Object.assign({}, props));
        case 'Network':
            return React.createElement(Network, Object.assign({}, props));
        case 'NextPage':
            return React.createElement(NextPage, Object.assign({ style: Pagination }, props));
        case 'Notification':
            return React.createElement(Notification, Object.assign({}, props));
        case 'Server':
            return React.createElement(Server, Object.assign({}, props));
        case 'Settings':
            return React.createElement(Settings, Object.assign({ style: size20 }, props));
        case 'Sequence':
            return React.createElement(Sequence, Object.assign({}, props));
        case 'Screenshot':
            return React.createElement(Screenshot, Object.assign({}, props));
        case 'ScreenshotInProgress':
            return React.createElement(ScreenshotInProgress, Object.assign({}, props));
        case 'Split':
            return React.createElement(TerminalPlusSidecar, Object.assign({ style: size20 }, props));
        case 'Search':
            return React.createElement(Search, Object.assign({ style: size20 }, props));
        case 'Trash':
            return React.createElement(Trash, Object.assign({}, props));
        case 'TerminalOnly':
            return React.createElement(TerminalOnly, Object.assign({ style: size32 }, props));
        case 'Theme':
            return React.createElement(Theme, Object.assign({}, props));
        case 'Warning':
            return React.createElement(Warning, Object.assign({}, props));
        case 'Up':
            return React.createElement(Up, Object.assign({}, props));
        case 'WindowClose':
            return React.createElement(WindowClose, Object.assign({ style: Sidecar }, props));
        case 'WindowMaximize':
            return React.createElement(WindowMaximize, Object.assign({ style: Sidecar }, props));
        case 'WindowMinimize':
            return React.createElement(WindowMinimize, Object.assign({ style: Sidecar }, props));
    }
    // this bit of magic ensures exhaustiveness of the switch;
    // reference: https://stackoverflow.com/a/39419171
    return assertUnreachable(props.icon);
}
//# sourceMappingURL=PatternFly.js.map