/// <reference types="react" />
export interface Action {
    label: string;
    handler: () => void;
    isSelected?: boolean;
    hasDivider?: boolean;
}
export interface Props {
    /** Tooltip */
    title?: string;
    /** Render more plain/inline style? */
    isPlain?: boolean;
    /** Should the Dropdown roll up or down? Default is down */
    direction?: 'up' | 'down';
    /** Should the Dropdown "pointer" be positioned on the left or on the right? Default is left */
    position?: 'left' | 'right';
    /** Icon to include in the dropdown toggler */
    icon?: React.ReactNode;
    /** Use kebab or regular caret-style dropdown toggler? Default is kebab */
    toggle?: 'kebab' | 'caret';
    /** Actions to be rendered in an overflow menu associated with the Card */
    actions: Action[];
    /** [Optional] CSS class to associate with the outermost Card element */
    className?: string;
    /** [Optional] Handler called when the DropDown is closed */
    onClose?: () => void;
}
export default Props;
