import React from 'react';
import { Tab as KuiTab, ToolbarText, MultiModalMode, MultiModalResponse, Button } from '@kui-shell/core';
import BaseSidecar, { Props, State } from './BaseSidecarV2';
import '../../../../web/css/static/ToolbarButton.scss';
import '../../../../web/scss/components/Sidecar/PatternFly.scss';
/**
 * One history entry, which is a `MultiModalResponse`, further parsed
 * out into buttons and tabs, and a pointer to the `currentTabIndex`.
 *
 */
interface HistoryEntry {
    currentTabIndex: number;
    viewButtons: Button[];
    drilldownButtons: Button[];
    tabs: Readonly<MultiModalMode[]>;
    toolbarText: ToolbarText;
    defaultMode: number;
}
export declare function getStateFromMMR(tab: KuiTab, response: MultiModalResponse): HistoryEntry;
declare type TopNavState = HistoryEntry & State & {
    response: MultiModalResponse;
    toolbarText: MultiModalResponse['toolbarText'];
    args: {
        argsForMode: MultiModalResponse['argsForMode'];
        argvNoOptions: Props<MultiModalResponse>['argvNoOptions'];
        parsedOptions: Props<MultiModalResponse>['parsedOptions'];
    };
};
/**
 *
 * TopNavSidecar
 * -----------------------
 * | <TitleBar/>         |
 * -----------------------
 * | nameHash?           |
 * | name                |
 * |---------------------|
 * | Tab | Tab |  ...    | <Tab/> from here down
 * |---------------------|
 * | <Toolbar/>          |   <ToolbarContainer/> from here down
 * |---------------------|
 * | <KuiContent/>       |
 * |                     |
 * -----------------------
 *
 */
export default class TopNavSidecar extends BaseSidecar<MultiModalResponse, TopNavState> {
    static contextType: React.Context<import("../../Client/KuiConfiguration").default>;
    constructor(props: Props<MultiModalResponse>);
    /** @return a `HistoryEntry` for the given `Response` */
    static getDerivedStateFromProps(props: Props<MultiModalResponse>, state?: TopNavState): TopNavState;
    protected headerBodyStyle(): {
        'flex-direction': string;
    };
    /** return the pretty name or unadulterated name from the response */
    private prettyName;
    /** display the unadulterated name from the response as sidecar header */
    private namePart;
    /** ToolbarContainer updated the toolbar */
    private didUpdateToolbar;
    private readonly _didUpdateToolbar;
    /** Special case with no hero name, but badges... we need a filler element */
    private fillerNamePart;
    /** Tell the world that we have changed the focused mode */
    private broadcastFocusChange;
    /** eventKey property for a Tab */
    private eventKey;
    /** idx from the encoded eventKey */
    private idxFromEventKey;
    /** User has changed selected Tab */
    private onSelect;
    private readonly _onSelect;
    private tabs;
    protected bodyContent(idx: number): JSX.Element;
    private tabContent;
    /** Return a collection of badge elements */
    private badges;
    private header;
    private footer;
    private kindBreadcrumb;
    /** show name as breadcrumb when not showing context as hero text in sidecar header  */
    private nameBreadcrumb;
    private versionBreadcrumb;
    private nameHashBreadcrumb;
    private namespaceBreadcrumb;
    render(): JSX.Element;
}
export {};
