import React from 'react';
import { REPL, Row, Tab, Table } from '@kui-shell/core';
import '../../../../web/scss/components/Table/SequenceDiagram/_index.scss';
interface Props {
    response: Table;
    tab: Tab;
    repl: REPL;
    /**
     * Threshold in millis below which two rows will be considered to be
     * part of the same dense region of time. Default: 120s
     *
     */
    denseThreshold?: number;
    /** whether the table is currently "live", and responding to updates from the controller */
    isWatching: boolean;
}
/**
 * An "Interval" is a maximal contiguous sequence of Tasks that are
 * both a) from the same Job; and b) not too far away in time from the
 * start of the Interval
 *
 */
interface DenseInterval {
    startMillis: number;
    endMillis: number;
    jobName: string;
    rows: Row[];
}
interface State {
    /** The intervals! */
    intervals: DenseInterval[];
    /** To help normalize the width of bars, we stash the max, across
     * `this.intervals` of `endMills-startMillis` */
    maxIntervalTimeSpan: number;
    /** To help render in-progress tasks, where we don't have a task
     * completion time, we can at least use the maximum completion time
     * across the tasks that *have* completed */
    maxEndMillis: number;
    /** force a refresh, for the poller */
    iter: number;
}
export default class SequenceDiagram extends React.PureComponent<Props, State> {
    /**
     * @see Props.denseThreshold
     *
     */
    private static readonly DEFAULT_DENSE_THRESHOLD;
    /** If state.isWatching, we may have pollers to refresh the durations */
    private poller;
    constructor(props: Props);
    componentDidCatch(error: Error, errorInfo: React.ErrorInfo): void;
    static getDerivedStateFromProps(props: Props, state?: State): {
        iter: number;
    } & Omit<State, "iter">;
    componentDidUpdate(): void;
    /** @return numerator/interval formatted */
    private getFraction;
    private static sorter;
    /**
     * This computes the `State` for this component from the given
     * `response` Table model.
     *
     */
    private static computeGapModel;
    private header;
    private nSpanCols;
    private overheads;
    private gapRow;
    private blankRow;
    private colorByStatus;
    private findAttrIdx;
    private rows;
    /** To help with adjusting row height, a data-size attribute */
    private size;
    render(): JSX.Element;
}
export {};
