import React from 'react';
import { REPL, Tab as KuiTab } from '@kui-shell/core';
interface Props {
    source: string;
    contentType?: 'text/html' | 'application/markdown';
    tab?: KuiTab;
    repl?: REPL;
    /** if we have the full path to the source file */
    fullpath?: string;
    /** css class for top-level element */
    className?: string;
    /** Do not linkify external links */
    noExternalLinks?: boolean;
    /** If true, don't provide scrollability */
    nested?: boolean;
    /** Base HTTP Url? */
    baseUrl?: string;
    onRender?: () => void;
}
export default class Markdown extends React.PureComponent<Props> {
    private readonly _uuid;
    private onCopy;
    private allContentIsRemote;
    private anchorFrom;
    /** @return markdown source, as string in application/markdown format */
    private source;
    private handleImage;
    render(): JSX.Element;
}
export {};
